/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.asynchbeans.pool.PoolableObject;
import com.ibm.ws.asynchbeans.WorkManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import commonj.work.Work;

public class WorkTimeoutListener
implements PoolableObject,
AlarmListener {
    static TraceComponent tc = Tr.register(WorkTimeoutListener.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    private boolean isTimedOut = false;
    private long workTimeout = 0L;
    private com.ibm.websphere.asynchbeans.Work abWork = null;
    private Work cjWork = null;
    private Alarm alarm = null;

    public void init(com.ibm.websphere.asynchbeans.Work work, long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "init", new Object[]{this, work, new Long(l)});
        }
        this.abWork = work;
        this.workTimeout = l;
    }

    public void init(Work work, long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "init", new Object[]{this, work, new Long(l)});
        }
        this.cjWork = work;
        this.workTimeout = l;
    }

    public void init() {
        this.isTimedOut = false;
    }

    public void returned() {
    }

    public synchronized void alarm(Object object) {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "alarm", object);
        }
        try {
            this.isTimedOut = true;
            if (this.abWork == null) {
                this.cjWork.release();
                if (bl) {
                    Tr.debug(tc, "alarm", "release CommonJ work: " + this.cjWork);
                }
            } else {
                this.abWork.release();
                if (bl) {
                    Tr.debug(tc, "alarm", "release AsynchBean work: " + this.abWork);
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.asynchbeans.WorkTimeoutListener.alarm", "133", this);
            Tr.error(tc, "METHOD_THROW_THROWABLE", new Object[]{throwable.getMessage()});
        }
        this.cleanup();
        WorkManagerImpl.returnPooledWorkTimeoutListener(this);
    }

    public void cancelAlarm() {
        this.alarm.cancel();
        this.cleanup();
    }

    private void cleanup() {
        this.alarm = null;
        this.abWork = null;
        this.cjWork = null;
        this.isTimedOut = false;
        this.workTimeout = 0L;
    }

    public boolean isTimedOut() {
        return this.isTimedOut;
    }

    public Alarm getAlarm() {
        return this.alarm;
    }

    public void setAlarm(Alarm alarm) {
        this.alarm = alarm;
    }

    public long getWorkTimeout() {
        return this.workTimeout;
    }

    public void setWorkTimeout(long l) {
        this.workTimeout = l;
    }
}

