/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans.am;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.WorkItem;
import com.ibm.websphere.asynchbeans.pool.ObjectPool;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.asynchbeans.AsynchBeanManager;
import com.ibm.ws.asynchbeans.J2EEServiceManager;
import com.ibm.ws.asynchbeans.WorkManagerImpl;
import com.ibm.ws.asynchbeans.am.Alarm;
import com.ibm.ws.asynchbeans.am.AlarmManagerThread;
import com.ibm.ws.asynchbeans.am._Alarm;
import com.ibm.ws.asynchbeans.pmi.AlarmManagerPerf;
import com.ibm.ws.asynchbeans.pmi.AlarmManagerPmiModule;
import com.ibm.ws.asynchbeans.timer.GenericTimer;
import com.ibm.ws.asynchbeans.util.AsynchBeanUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.util.BinaryHeap;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public class AlarmManager {
    private static final String PMI_STATS_CLASS_NAME = "com.ibm.ws.pmi.preprocess.asynchbeans_impl_StatsTemplateLookup";
    private static boolean arePMIStatsRegistered;
    int numAlarmsExecuted = 0;
    WorkItem alarmThreadWorkItem;
    static final TraceComponent tc;
    BinaryHeap alarmQ = new BinaryHeap(new _Alarm());
    AsynchBeanManager abManager;
    boolean initialized;
    ObjectPool alarmPool;
    ThreadPool threadPool;
    AlarmManagerPerf pmi;
    Thread pmiAlarmsPerSecondThread;

    public AlarmManager(AsynchBeanManager asynchBeanManager) {
        this.abManager = asynchBeanManager;
        try {
            this.alarmPool = WorkManagerImpl.getObjectPoolManager().getPool(_Alarm.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.asynchbeans.am.AlarmManager.AlarmManager", "71", this);
            Tr.fatal(tc, "MSG_KEY_36");
        }
        this.alarmQ = new BinaryHeap(new _Alarm());
        this.initialized = false;
        this.pmi = null;
        if (!PmiRegistry.isDisabled()) {
            try {
                Serializable serializable;
                if (!arePMIStatsRegistered) {
                    arePMIStatsRegistered = true;
                    serializable = Class.forName(PMI_STATS_CLASS_NAME);
                    StatsFactory.registerStatsTemplateLookup((StatsTemplateLookup)((Class)serializable).newInstance());
                }
                serializable = new Properties();
                ((Properties)serializable).put("asynchbeanmanager", AsynchBeanManager.getMBeanValue(this.abManager.getName()));
                String string = "AsynchBeanManager_" + AsynchBeanManager.getMBeanValue(this.abManager.getName()) + "_AlarmManager";
                AccessController.doPrivileged(new ActivateMBeanPA("AB_AlarmManager", new DefaultRuntimeCollaborator(this), string, null, (Properties)serializable));
                this.pmi = new AlarmManagerPmiModule(string);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.fatal(tc, "PMI_INIT_ERROR");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, this.getClass().getName() + ".<init>", "176", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Generated PMI class not found:", PMI_STATS_CLASS_NAME);
                }
                Tr.warning(tc, "MSG_KEY_UNEX_EXCEPT", classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException((Throwable)instantiationException, this.getClass().getName() + ".<init>", "186", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to instantiate generated PMI class:", PMI_STATS_CLASS_NAME);
                }
                Tr.warning(tc, "MSG_KEY_UNEX_EXCEPT", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, this.getClass().getName() + ".<init>", "196", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to access the default constructor for the generated PMI class:", PMI_STATS_CLASS_NAME);
                }
                Tr.warning(tc, "MSG_KEY_UNEX_EXCEPT", illegalAccessException);
            }
        }
    }

    AsynchBeanManager getAsycnBeanManager() {
        return this.abManager;
    }

    public void init() {
        Object object;
        if (this.initialized) {
            return;
        }
        this.threadPool = (ThreadPool)AccessController.doPrivileged(new GetThreadPool(WorkManagerImpl.getMBeanValue(this.abManager.getName() + ".Alarm Pool")));
        this.threadPool.setGrowAsNeeded(false);
        this.threadPool.setKeepAliveTime(60000L);
        this.threadPool.setMinimumPoolSize(this.abManager.getMaxAlarmThreads());
        this.threadPool.setMaximumPoolSize(this.abManager.getMaxAlarmThreads());
        this.threadPool.setThreadPriority(this.abManager.getThreadPriority());
        this.numAlarmsExecuted = 0;
        if (this.pmi != null) {
            object = new Runnable(){

                public void run() {
                    while (true) {
                        int n = AlarmManager.this.numAlarmsExecuted;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                        int n2 = AlarmManager.this.numAlarmsExecuted - n;
                        AlarmManager.this.pmi.alarmsPerSecond(n2);
                    }
                }
            };
            ThreadExecuteProxy threadExecuteProxy = new ThreadExecuteProxy((Runnable)object, "Alarms per second thread for " + this.abManager.getName());
            this.pmiAlarmsPerSecondThread = (Thread)AccessController.doPrivileged(threadExecuteProxy);
            this.pmiAlarmsPerSecondThread.start();
        }
        object = new AMThreadExecuteProxy(this.threadPool);
        AccessController.doPrivileged(object);
        this.initialized = true;
    }

    ThreadPool getThreadPool() {
        return this.threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public _Alarm create(GenericTimer genericTimer, Object object, long l, long l2, boolean bl, boolean bl2) {
        boolean bl3 = tc.isEntryEnabled();
        boolean bl4 = tc.isDebugEnabled();
        this.init();
        if (bl3) {
            Tr.entry(tc, "create(GenericTimer, Object, long, long, boolean, boolean)", new Object[]{this, genericTimer, object, AsynchBeanUtil.getLongAsDateTime(l), new Long(l2), new Boolean(bl), new Boolean(bl2)});
        }
        _Alarm _Alarm2 = (_Alarm)this.alarmPool.getObject();
        _Alarm2.init(this, l, l2, bl, genericTimer, object);
        if (bl2) {
            BinaryHeap binaryHeap = this.alarmQ;
            synchronized (binaryHeap) {
                this.alarmQ.insert(_Alarm2);
                if (this.pmi != null) {
                    this.pmi.alarmCreated(this.alarmQ.size());
                }
                if (bl4) {
                    Tr.debug(tc, "create(GenericTimer, Object, long, long, boolean, boolean)", new Object[]{"Expiration Time : " + AsynchBeanUtil.getLongAsDateTime(_Alarm2.expirationTime), "Alarm on top expires : " + AsynchBeanUtil.getLongAsDateTime(((_Alarm)this.alarmQ.minimum()).expirationTime), "_Alarm : " + _Alarm2});
                }
                if (_Alarm2 == this.alarmQ.minimum()) {
                    if (bl4) {
                        Tr.debug(tc, "create(GenericTimer, Object, long, long, boolean, boolean)", "Notifying alarmQ");
                    }
                    this.alarmQ.notifyAll();
                }
            }
        }
        if (bl3) {
            Tr.exit(tc, "create(GenericTimer, Object, long, long, boolean, boolean)", _Alarm2);
        }
        return _Alarm2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlarmToQueue(_Alarm _Alarm2) {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "addAlarmToQueue(_Alarm)", new Object[]{this, _Alarm2});
        }
        BinaryHeap binaryHeap = this.alarmQ;
        synchronized (binaryHeap) {
            this.alarmQ.insert(_Alarm2);
            if (this.pmi != null) {
                this.pmi.alarmCreated(this.alarmQ.size());
            }
            if (bl2) {
                Tr.debug(tc, "addAlarmToQueue(_Alarm)", new Object[]{"Expiration Time : " + _Alarm2.expirationTime, "Alarm on top expires : " + ((_Alarm)this.alarmQ.minimum()).expirationTime, "_Alarm : " + _Alarm2});
            }
            if (_Alarm2 == this.alarmQ.minimum()) {
                if (bl2) {
                    Tr.debug(tc, "addAlarmToQueue(_Alarm)", "Notifying alarmQ");
                }
                this.alarmQ.notifyAll();
            }
        }
        if (bl) {
            Tr.exit(tc, "addAlarmToQueue(_Alarm)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(Alarm alarm) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "cancel", alarm);
        }
        BinaryHeap binaryHeap = this.alarmQ;
        synchronized (binaryHeap) {
            if (!((_Alarm)alarm).fired) {
                this.alarmQ.delete((_Alarm)alarm);
                this.returnAlarm(alarm);
            }
            if (this.pmi != null) {
                this.pmi.alarmCancelled(this.alarmQ.size());
            }
        }
        if (bl) {
            Tr.exit(tc, "cancel");
        }
    }

    void returnAlarm(Alarm alarm) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "returnAlarm", alarm);
        }
        if (bl) {
            Tr.exit(tc, "returnAlarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlarmFromAlarmQ(_Alarm _Alarm2) {
        BinaryHeap binaryHeap = this.alarmQ;
        synchronized (binaryHeap) {
            if (!_Alarm2.fired) {
                this.alarmQ.delete(_Alarm2);
                this.returnAlarm(_Alarm2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removeAlarmFromAlarmQ", new Object[]{"Alarm is removed: ", _Alarm2});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeAlarmFromAlarmQ", new Object[]{"Alarm is not shceduled in period and has been expired, no-op", _Alarm2});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlarmToAlarmQAtResume(_Alarm _Alarm2) {
        BinaryHeap binaryHeap = this.alarmQ;
        synchronized (binaryHeap) {
            if (!_Alarm2.fired || _Alarm2.period != 0L) {
                boolean bl = tc.isDebugEnabled();
                this.alarmQ.insert(_Alarm2);
                if (bl) {
                    Tr.debug(tc, "addAlarmToAlarmQAtResume", new Object[]{"Alarm is added: ", _Alarm2});
                }
                if (_Alarm2 == this.alarmQ.minimum()) {
                    if (bl) {
                        Tr.debug(tc, "addAlarmToAlarmQAtResume", "Notifying alarmQ");
                    }
                    this.alarmQ.notifyAll();
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addAlarmToAlarmQAtResume", new Object[]{"Alarm is not shceduled in period and has been expired, no-op", _Alarm2});
            }
        }
    }

    static {
        tc = Tr.register(AlarmManager.class, "AsynchBeans_Alarms", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    }

    private class ThreadExecuteProxy
    implements PrivilegedAction {
        Runnable r;
        String name;

        ThreadExecuteProxy(Runnable runnable, String string) {
            this.r = runnable;
            this.name = string;
        }

        public Object run() {
            return new Thread(this.r, this.name);
        }
    }

    private class AMThreadExecuteProxy
    implements PrivilegedAction {
        private ThreadPool pool;

        AMThreadExecuteProxy(ThreadPool threadPool) {
            this.pool = threadPool;
        }

        public Object run() {
            AlarmManagerThread alarmManagerThread = new AlarmManagerThread(AlarmManager.this);
            alarmManagerThread.setDaemon(true);
            alarmManagerThread.start();
            return null;
        }
    }

    private class ActivateMBeanPA
    implements PrivilegedExceptionAction {
        private String name;
        private RuntimeCollaborator runtimeCollaborator;
        private String mbeanID;
        private String arg;
        private Properties props;

        ActivateMBeanPA(String string, RuntimeCollaborator runtimeCollaborator, String string2, String string3, Properties properties) {
            this.name = string;
            this.runtimeCollaborator = runtimeCollaborator;
            this.mbeanID = string2;
            this.arg = string3;
            this.props = properties;
        }

        public Object run() throws AdminException {
            return AdminServiceFactory.getMBeanFactory().activateMBean(this.name, this.runtimeCollaborator, this.mbeanID, this.arg, this.props);
        }
    }

    class GetThreadPool
    implements PrivilegedAction {
        private String name;

        GetThreadPool(String string) {
            this.name = string;
        }

        public Object run() {
            return J2EEServiceManager.getSelf().getThreadPool(this.name);
        }
    }
}

