/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans.am;

import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.Work;
import com.ibm.ws.asynchbeans.am.AlarmManager;
import com.ibm.ws.asynchbeans.am._Alarm;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.BinaryHeap;
import com.ibm.ws.util.ThreadPool;

final class AlarmManagerThread
extends Thread
implements Dumpable,
Work {
    ThreadPool threadPool;
    private static final TraceComponent tc = Tr.register(AlarmManagerThread.class, "AsynchBeans_Alarms", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    boolean released = false;
    AlarmManager alarmManager;
    protected boolean dumped = false;

    AlarmManagerThread(AlarmManager alarmManager) {
        super(alarmManager.getAsycnBeanManager().getName() + ":AlarmManager");
        this.alarmManager = alarmManager;
        Tr.registerDumpable(tc, this);
        this.setReleased(false);
        this.threadPool = alarmManager.getThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = tc.isDebugEnabled();
        BinaryHeap binaryHeap = this.alarmManager.alarmQ;
        while (!this.isReleased()) {
            try {
                _Alarm _Alarm2 = null;
                int n = 0;
                BinaryHeap binaryHeap2 = binaryHeap;
                synchronized (binaryHeap2) {
                    if (binaryHeap.isEmpty()) {
                        if (bl) {
                            Tr.debug(tc, "AlarmQ empty, waiting");
                        }
                        binaryHeap.wait(5000L);
                        if (bl) {
                            Tr.debug(tc, "AlarmQ woken");
                        }
                        continue;
                    }
                    _Alarm2 = (_Alarm)binaryHeap.minimum();
                    if (_Alarm2 != null) {
                        if (bl) {
                            Tr.debug(tc, "Found alarm", new Object[]{_Alarm2, new Long(_Alarm2.expirationTime)});
                        }
                        if (_Alarm2.getCancelled()) {
                            if (bl) {
                                Tr.debug(tc, "Alarm was cancelled at: " + _Alarm2.getTimeCancelled());
                            }
                            binaryHeap.deleteMin();
                            this.alarmManager.returnAlarm(_Alarm2);
                            _Alarm2 = null;
                        } else {
                            long l = _Alarm2.expirationTime - System.currentTimeMillis();
                            if (l <= 0L) {
                                binaryHeap.deleteMin();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "alarm fired set to true", _Alarm2);
                                }
                                _Alarm2.fired = true;
                            } else {
                                long l2;
                                long l3 = l2 = l > 5000L ? 5000L : l + 10L;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, l + " ms remaining until next alarm. " + "Alarm manager thread waiting " + l2 + " ms.");
                                }
                                binaryHeap.wait(l2);
                                _Alarm2 = null;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Alarm manager thread woken");
                                }
                            }
                        }
                    }
                    if (this.alarmManager.pmi != null) {
                        n = binaryHeap.size();
                        ++this.alarmManager.numAlarmsExecuted;
                    }
                }
                if (_Alarm2 == null) continue;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AlarmManagerThread executing next alarm");
                    }
                    this.threadPool.execute(_Alarm2);
                    if (this.alarmManager.pmi != null) {
                        this.alarmManager.pmi.alarmDispatched(n);
                    }
                    _Alarm2 = null;
                }
                catch (InterruptedException interruptedException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AlarmManagerThread Interrupted");
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                }
            }
            catch (InterruptedException interruptedException) {
                try {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.asynchbeans.am.AlarmManagerThread.run", "161", this);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Alarm manager thread received an exception: ", noClassDefFoundError);
                    }
                    this.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        if (this.dumped) {
            return;
        }
        try {
            Tr.dump(tc, "-- Alarm Manager Dump --");
            Tr.dump(tc, this.alarmManager.alarmQ.size() + " scheduled alarms");
            BinaryHeap binaryHeap = this.alarmManager.alarmQ;
            synchronized (binaryHeap) {
                Tr.dump(tc, "alarm queue contents", this.alarmManager.alarmQ.elements());
            }
        }
        finally {
            this.dumped = true;
        }
    }

    public void resetDump() {
        this.dumped = false;
    }

    public synchronized void release() {
        this.released = true;
    }

    public synchronized boolean isReleased() {
        return this.released;
    }

    public synchronized void setReleased(boolean bl) {
        this.released = bl;
    }
}

