/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans.am;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.asynchbeans.pool.PoolableObject;
import com.ibm.ws.asynchbeans.am.Alarm;
import com.ibm.ws.asynchbeans.am.AlarmManager;
import com.ibm.ws.asynchbeans.timer.GenericTimer;
import com.ibm.ws.asynchbeans.timer.TimerImpl;
import com.ibm.ws.asynchbeans.util.AsynchBeanUtil;
import com.ibm.ws.ffdc.FFDCFilter;

public final class _Alarm
extends Alarm
implements Comparable,
Runnable,
PoolableObject {
    static final TraceComponent tc = Tr.register(_Alarm.class, "AsynchBeans_Alarms", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    long expirationTime = -1L;
    AlarmManager alarmManager;
    Object context;
    GenericTimer listener;
    boolean fired = false;
    boolean cancelled = false;
    long timeAlarmCancelled = 0L;
    long dateTime;
    long period;
    boolean isFixedRate;
    boolean isAlarm;
    private boolean isFirstTimeRunAfterResume;

    public _Alarm() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_Alarm.<init>", this);
        }
    }

    public synchronized void init() {
        this.cleanup();
        this.timeAlarmCancelled = 0L;
    }

    public void returned() {
        this.cleanup();
    }

    public synchronized void cleanup() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cleanup", this);
        }
        this.expirationTime = -1L;
        this.context = null;
        this.listener = null;
        this.alarmManager = null;
        this.timeAlarmCancelled = -1L;
        this.cancelled = false;
    }

    public synchronized void init(AlarmManager alarmManager, long l, long l2, boolean bl, GenericTimer genericTimer, Object object) {
        this.alarmManager = alarmManager;
        this.listener = genericTimer;
        this.context = object;
        this.cancelled = false;
        this.timeAlarmCancelled = 0L;
        this.dateTime = l;
        this.period = l2;
        this.isFixedRate = bl;
        this.isAlarm = genericTimer.isAlarm();
        this.expirationTime = l;
        if (!this.isAlarm) {
            ((TimerImpl)this.listener).setScheduledExecutionTime(l);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "init", new Object[]{this, "expirationTime = " + AsynchBeanUtil.getLongAsDateTime(this.expirationTime)});
        }
    }

    public synchronized void cancel() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cancelling alarm: " + this.toString());
        }
        this.timeAlarmCancelled = System.currentTimeMillis();
        this.cancelled = true;
    }

    public synchronized boolean getCancelled() {
        return this.cancelled;
    }

    public synchronized long getTimeCancelled() {
        return this.timeAlarmCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "run", this);
        }
        TimerImpl timerImpl = null;
        if (!this.isAlarm) {
            timerImpl = (TimerImpl)this.listener;
        }
        try {
            this.fireAlarm();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            long l = System.currentTimeMillis();
            if (this.isAlarm || this.period == 0L) {
                this.alarmManager.returnAlarm(this);
            } else {
                long l2 = 0L;
                Object object = timerImpl.getTimerLock();
                synchronized (object) {
                    if (timerImpl.isCancelled()) {
                        if (bl) {
                            Tr.exit(tc, "run", "Timer was cancelled. Do not reset alarm.");
                        }
                        return;
                    }
                    if (timerImpl.getTimerManagerState() != 0) {
                        if (bl) {
                            Tr.exit(tc, "run", "TimerManager is not in working state, return without resetting the timer");
                        }
                        return;
                    }
                    long l3 = System.currentTimeMillis();
                    if (this.isFixedRate) {
                        l2 = l3 - timerImpl.getScheduledExecutionTime() > this.period && !this.isFirstTimeRunAfterResume ? this.adjust(this.dateTime, this.period) - this.period : this.adjust(this.dateTime, this.period);
                        if (this.isFirstTimeRunAfterResume) {
                            this.isFirstTimeRunAfterResume = false;
                        }
                        timerImpl.reset(l2);
                    } else {
                        l2 = l + this.period;
                        timerImpl.reset(l2);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "run", "The next execution time is " + AsynchBeanUtil.getLongAsDateTime(l2));
                }
                timerImpl.setScheduledExecutionTime(l2);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
            }
            throw throwable;
        }
        long l = System.currentTimeMillis();
        if (this.isAlarm || this.period == 0L) {
            this.alarmManager.returnAlarm(this);
        } else {
            long l4 = 0L;
            Object object = timerImpl.getTimerLock();
            synchronized (object) {
                if (timerImpl.isCancelled()) {
                    if (bl) {
                        Tr.exit(tc, "run", "Timer was cancelled. Do not reset alarm.");
                    }
                    return;
                }
                if (timerImpl.getTimerManagerState() != 0) {
                    if (bl) {
                        Tr.exit(tc, "run", "TimerManager is not in working state, return without resetting the timer");
                    }
                    return;
                }
                long l5 = System.currentTimeMillis();
                if (this.isFixedRate) {
                    l4 = l5 - timerImpl.getScheduledExecutionTime() > this.period && !this.isFirstTimeRunAfterResume ? this.adjust(this.dateTime, this.period) - this.period : this.adjust(this.dateTime, this.period);
                    if (this.isFirstTimeRunAfterResume) {
                        this.isFirstTimeRunAfterResume = false;
                    }
                    timerImpl.reset(l4);
                } else {
                    l4 = l + this.period;
                    timerImpl.reset(l4);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "run", "The next execution time is " + AsynchBeanUtil.getLongAsDateTime(l4));
            }
            timerImpl.setScheduledExecutionTime(l4);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAlarm() {
        try {
            boolean bl = false;
            _Alarm _Alarm2 = this;
            synchronized (_Alarm2) {
                bl = this.cancelled;
            }
            if (!bl && this.listener != null) {
                if (this.alarmManager.pmi != null) {
                    this.alarmManager.pmi.alarmFired(this.expirationTime);
                }
                this.listener.runListenerAsCJWork();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.asynchbeans.am._Alarm.fireAlarm", "157", this);
            Tr.debug(tc, "Unexpected exception firing alarm ", throwable);
        }
    }

    long adjust(long l, long l2) {
        long l3 = System.currentTimeMillis();
        if (l3 < l) {
            Tr.error(tc, "MSG_KEY_UNEX_EXCEPT", new Object[]{"currentTime is less than the baseTime."});
            return l3;
        }
        return ((l3 - l) / l2 + 1L) * l2 + l;
    }

    public final int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        long l = ((_Alarm)object).expirationTime;
        if (this.expirationTime < l) {
            return -1;
        }
        if (this.expirationTime > l) {
            return 1;
        }
        return 0;
    }

    public final boolean lessThan(Comparable comparable) {
        return this.expirationTime < ((_Alarm)comparable).expirationTime;
    }

    public String toString() {
        return "_Alarm(" + this.expirationTime + "," + Util.identity(this.listener) + "," + this.listener + "," + Util.identity(this.context) + "," + this.context + ")";
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isFixedRate() {
        return this.isFixedRate;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setExpirationTime(long l) {
        this.expirationTime = l;
    }

    public boolean isFirstTimeRunAfterResume() {
        return this.isFirstTimeRunAfterResume;
    }

    public void setFirstTimeRunAfterResume(boolean bl) {
        this.isFirstTimeRunAfterResume = bl;
    }

    public boolean isFired() {
        return this.fired;
    }

    public void setFired(boolean bl) {
        this.fired = bl;
    }
}

