/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans.pmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.asynchbeans.pmi.AlarmManagerPerf;

public final class AlarmManagerPmiModule
extends PmiAbstractModule
implements AlarmManagerPerf {
    private static final long serialVersionUID = 6676543041401524359L;
    private static final TraceComponent tc = Tr.register(AlarmManagerPmiModule.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    public static final String moduleID = "alarmManagerModule";
    private static final int defaultLevel = 0;
    private SpdLong numCreates = null;
    private SpdLong numCancelled = null;
    private SpdLong numFired = null;
    private SpdLoad latency = null;
    private SpdLoad alarmsPending = null;
    private SpdLoad alarmsPerSecond = null;
    public static final int NUM_CREATES = 1;
    public static final int NUM_CANCELLED = 2;
    public static final int NUM_FIRED = 3;
    public static final int LATENCY = 4;
    public static final int ALARMS_PENDING = 5;
    public static final int ALARMS_PER_SECOND = 6;

    public AlarmManagerPmiModule(String string) {
        super(moduleID, string);
        this.registerModule(this);
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.numCreates = spdLong;
                return true;
            }
            case 2: {
                this.numCancelled = spdLong;
                return true;
            }
            case 3: {
                this.numFired = spdLong;
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            default: 
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 4: {
                this.latency = spdLoad;
                return true;
            }
            case 5: {
                this.alarmsPending = spdLoad;
                return true;
            }
            case 6: {
                this.alarmsPerSecond = spdLoad;
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public void alarmCreated(int n) {
        if (this.numCreates != null) {
            this.numCreates.increment();
        }
        if (this.alarmsPending != null) {
            this.alarmsPending.add(n);
        }
    }

    public void alarmCancelled(int n) {
        if (this.numCancelled != null) {
            this.numCancelled.increment();
        }
        if (this.alarmsPending != null) {
            this.alarmsPending.add(n);
        }
    }

    public void alarmsPerSecond(int n) {
        if (this.alarmsPerSecond != null) {
            this.alarmsPerSecond.add(n);
        }
    }

    public void alarmFired(long l) {
        if (this.numFired != null) {
            this.numFired.increment();
        }
        if (this.latency != null) {
            long l2 = System.currentTimeMillis();
            this.latency.add(l2 - l);
        }
    }

    public void alarmDispatched(int n) {
        if (this.alarmsPending != null) {
            this.alarmsPending.add(n);
        }
    }
}

