/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans.services.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.WorkCompletedException;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.asynchbeans.ServiceContext;
import com.ibm.ws.asynchbeans.ServiceContextInvalid;
import com.ibm.ws.asynchbeans.ServiceWithContext;
import com.ibm.ws.asynchbeans.WorkRolledBackException;
import com.ibm.ws.asynchbeans.services.tx.JTAServiceContext;
import com.ibm.ws.asynchbeans.services.tx.JTAStackElement;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.uow.SystemException;
import com.ibm.ws.uow.UOWManager;
import com.ibm.ws.uow.UOWManagerFactory;
import com.ibm.ws.util.WSThreadLocal;
import java.util.ArrayList;

public final class JTAServiceWithContext
implements ServiceWithContext {
    private static TraceComponent tc = Tr.register(JTAServiceWithContext.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    private static final String _serviceName = "JTA";
    private static final WebSphereTransactionManager _tm = TransactionManagerFactory.getTransactionManager();
    private static final LocalTransactionCurrent _ltCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
    private static final UOWCurrent _uowCurrent = TransactionManagerFactory.getUOWCurrent();
    private static ThreadLocal _threadStacks = new WSThreadLocal(){

        protected synchronized Object initialValue() {
            return new ArrayList();
        }
    };
    private static UOWManager _uowManager = UOWManagerFactory.getUOWManager();

    public String getServiceName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceName", _serviceName);
        }
        return _serviceName;
    }

    public String getServiceDescription() {
        return this.getServiceName();
    }

    public ServiceContext peek() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "peek");
        }
        JTAServiceContext jTAServiceContext = new JTAServiceContext();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "peek", jTAServiceContext);
        }
        return jTAServiceContext;
    }

    public void push(ServiceContext serviceContext) throws ServiceContextInvalid {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "push", serviceContext);
        }
        if (serviceContext != null && !(serviceContext instanceof JTAServiceContext)) {
            throw new ServiceContextInvalid(_serviceName);
        }
        JTAStackElement jTAStackElement = new JTAStackElement();
        ArrayList arrayList = (ArrayList)_threadStacks.get();
        arrayList.add(jTAStackElement);
        try {
            jTAStackElement.suspendedUOW = _uowManager.suspend();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException(systemException, "com.ibm.ws.asynchbeans.services.tx.JTAServiceWithContext.push", "148");
            Tr.error(tc, "Problem suspending original UOW on thread", systemException);
        }
        _ltCurrent.begin();
    }

    public void pop(ServiceContext serviceContext) throws ServiceContextInvalid, WorkCompletedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pop", serviceContext);
        }
        WorkCompletedException workCompletedException = null;
        ArrayList arrayList = (ArrayList)_threadStacks.get();
        if (arrayList.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JTA stack is unexpectedly empty.");
            }
            throw new ServiceContextInvalid(_serviceName);
        }
        JTAStackElement jTAStackElement = (JTAStackElement)arrayList.remove(arrayList.size() - 1);
        switch (_uowCurrent.getUOWType()) {
            case 2: {
                try {
                    _tm.rollback();
                    workCompletedException = new WorkRolledBackException();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.asynchbeans.services.tx.JTAServiceWithContext.pop", "220");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pop: Global transaction failed to rollback.", new Object[]{exception});
                    }
                    workCompletedException = new WorkCompletedException(exception);
                }
                break;
            }
            case 1: {
                try {
                    _ltCurrent.end(0);
                }
                catch (RolledbackException rolledbackException) {
                    workCompletedException = new WorkRolledBackException(rolledbackException);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.asynchbeans.services.tx.JTAServiceWithContext.pop", "245");
                    workCompletedException = new WorkCompletedException(exception);
                }
                break;
            }
        }
        try {
            if (jTAStackElement.suspendedUOW != null) {
                _uowManager.resume(jTAStackElement.suspendedUOW);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.asynchbeans.services.tx.JTAServiceWithContext.pop", "256");
            Tr.error(tc, "Problem resuming original UOW context on thread", throwable);
            workCompletedException = new WorkCompletedException(throwable);
        }
        if (workCompletedException != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Raising WorkCompletedException", workCompletedException);
            }
            throw workCompletedException;
        }
    }
}

