/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans.services.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.WorkCompletedException;
import com.ibm.ws.asynchbeans.AsynchBeanManager;
import com.ibm.ws.asynchbeans.ServiceContext;
import com.ibm.ws.asynchbeans.ServiceContextInvalid;
import com.ibm.ws.asynchbeans.ServiceWithContext;
import com.ibm.ws.asynchbeans.services.wlm.AlreadyClassifiedException;
import com.ibm.ws.asynchbeans.services.wlm.ClassificationInfo;
import com.ibm.ws.asynchbeans.services.wlm.Enclave;
import com.ibm.ws.asynchbeans.services.wlm.EnclaveManager;
import com.ibm.ws.asynchbeans.services.wlm.WLMServiceContext;
import com.ibm.ws.util.WSThreadLocal;
import java.util.ArrayList;
import java.util.List;

public final class ClassificationService
implements ServiceWithContext {
    private static final TraceComponent tc = Tr.register(ClassificationService.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    public static final String DEFAULT_TRANSACTION_CLASS_VALUE = "ASYNCBN";
    public static final String DAEMON_TRANSACTION_CLASS_VALUE = "ASYNCDMN";
    private final ThreadLocal _currentStack = new WSThreadLocal(){

        protected Object initialValue() {
            return new ArrayList();
        }
    };
    private final ThreadLocal _currentWM = new WSThreadLocal();
    private final ThreadLocal _threadingCall = new WSThreadLocal();
    private final ThreadLocal _daemonWork = new WSThreadLocal();
    private static boolean _enabled = false;
    private static final Object _placeholder = new Object();
    private static final EnclaveManager _enclaveManager = EnclaveManager.instance();
    private static final ClassificationService _instance = new ClassificationService();

    public static ClassificationService instance() {
        return _instance;
    }

    private ClassificationService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        _enabled = _enclaveManager.loadNativeCode();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void setExecutingWorkManager(AsynchBeanManager asynchBeanManager) {
        this._currentWM.set(asynchBeanManager);
    }

    public void setThreading(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setThreading", new Boolean(bl));
        }
        if (bl) {
            this._threadingCall.set(new Boolean(bl));
        } else {
            this._threadingCall.set(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setThreading");
        }
    }

    public void setDaemon(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDaemon", new Boolean(bl));
        }
        if (bl) {
            this._daemonWork.set(new Boolean(bl));
        } else {
            this._daemonWork.set(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDaemon");
        }
    }

    public String getServiceName() {
        return "zos.wlm";
    }

    public String getServiceDescription() {
        return this.getServiceName();
    }

    public ServiceContext peek() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "peek");
        }
        WLMServiceContext wLMServiceContext = null;
        Enclave enclave = _enclaveManager.getCurrentEnclave();
        if (enclave != null) {
            ClassificationInfo classificationInfo = null;
            if (this._threadingCall.get() == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Threading call == null/false");
                }
                classificationInfo = _enclaveManager.getClassificationInfo(enclave);
                wLMServiceContext = new WLMServiceContext(null, classificationInfo);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Threading call == true");
                }
                enclave = _enclaveManager.registerEnclave(enclave);
                wLMServiceContext = new WLMServiceContext(enclave, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "peek", wLMServiceContext);
        }
        return wLMServiceContext;
    }

    public void push(ServiceContext serviceContext) throws ServiceContextInvalid {
        WLMServiceContext wLMServiceContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "push", serviceContext);
        }
        if ((wLMServiceContext = (WLMServiceContext)serviceContext) == null) {
            this.pushClassification(null);
        } else if (this._daemonWork.get() != null) {
            if (wLMServiceContext.getEnclave() != null) {
                _enclaveManager.unpinEnclave(wLMServiceContext.getEnclave());
            }
            this.pushClassification(null);
        } else if (wLMServiceContext.getEnclave() == null) {
            this.pushClassification(wLMServiceContext.getClassificationInfo());
        } else {
            this.pushEnclave(wLMServiceContext.getEnclave());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "push");
        }
    }

    private void pushClassification(ClassificationInfo classificationInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pushClassification", classificationInfo);
        }
        if (_enclaveManager.getCurrentEnclave() == null) {
            Object object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Current enclave is NULL.");
            }
            if (classificationInfo == null) {
                object = (AsynchBeanManager)this._currentWM.get();
                classificationInfo = this.getClassificationInfo((AsynchBeanManager)object);
            }
            object = _enclaveManager.create(classificationInfo);
            this.pushEnclave((Enclave)object);
        } else {
            List list = (List)this._currentStack.get();
            list.add(_placeholder);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pushClassification");
        }
    }

    private void pushEnclave(Enclave enclave) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pushEnclave", enclave);
        }
        List list = (List)this._currentStack.get();
        try {
            if (enclave != null) {
                _enclaveManager.joinEnclave(enclave);
                list.add(enclave);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No enclave to join.  Pushing placeholder");
                }
                list.add(_placeholder);
            }
        }
        catch (AlreadyClassifiedException alreadyClassifiedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Join failed.  Pushing placeholder");
            }
            list.add(_placeholder);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pushEnclave");
        }
    }

    public void pop(ServiceContext serviceContext) throws ServiceContextInvalid, WorkCompletedException {
        List list;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pop", serviceContext);
        }
        if ((n = (list = (List)this._currentStack.get()).size()) == 0) {
            throw new ServiceContextInvalid("No WLM classification information to pop.");
        }
        Object e2 = list.remove(n - 1);
        if (e2 != _placeholder) {
            Enclave enclave = (Enclave)e2;
            _enclaveManager.leaveEnclave(enclave);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Current service context is placeholder.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pop");
        }
    }

    private ClassificationInfo getClassificationInfo(AsynchBeanManager asynchBeanManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassificationInfo", asynchBeanManager);
        }
        String string = null;
        string = asynchBeanManager == null ? (this._daemonWork.get() != null ? DAEMON_TRANSACTION_CLASS_VALUE : DEFAULT_TRANSACTION_CLASS_VALUE) : (this._daemonWork.get() != null ? asynchBeanManager.getDaemonTransactionClass() : asynchBeanManager.getDefaultTransactionClass());
        ClassificationInfo classificationInfo = new ClassificationInfo(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassificationInfo", classificationInfo);
        }
        return classificationInfo;
    }

    public static boolean isEnabled() {
        return _enabled;
    }
}

