/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans.services.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.asynchbeans.services.wlm.AlreadyClassifiedException;
import com.ibm.ws.asynchbeans.services.wlm.ClassificationInfo;
import com.ibm.ws.asynchbeans.services.wlm.Enclave;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.util.WSThreadLocal;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class EnclaveManager {
    private static final TraceComponent tc = Tr.register(EnclaveManager.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    private static EnclaveManager _instance = new EnclaveManager();
    private Map _registeredEnclaves = new HashMap();
    private WeakHashMap _classificationInfo = new WeakHashMap();
    private ThreadLocal _currentEnclave = new WSThreadLocal();
    private Boolean _loadedNative = null;

    static EnclaveManager instance() {
        return _instance;
    }

    private EnclaveManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    boolean loadNativeCode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadNativeCode");
        }
        if (this._loadedNative == null) {
            if (AdminHelper.getPlatformHelper().isZOS()) {
                try {
                    String string = System.getProperty("com.ibm.vm.bitmode");
                    int n = Integer.parseInt(string);
                    if (n == 64) {
                        System.loadLibrary("bbgoereg");
                    } else {
                        System.loadLibrary("bbooereg");
                    }
                    this._loadedNative = new Boolean(true);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this._loadedNative = new Boolean(false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "loadNativeCode", unsatisfiedLinkError);
                    }
                }
            } else {
                this._loadedNative = Boolean.FALSE;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadNativeCode", this._loadedNative);
        }
        return this._loadedNative;
    }

    public Enclave getCurrentEnclave() {
        Enclave enclave;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentEnclave");
        }
        if ((enclave = (Enclave)this._currentEnclave.get()) == null) {
            byte[] byArray = EnclaveManager.extractWorkUnit();
            if (byArray != null) {
                enclave = new Enclave(byArray);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning cached java view of the Enclave");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentEnclave", enclave);
        }
        return enclave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enclave registerEnclave(Enclave enclave) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerEnclave", enclave);
        }
        Enclave enclave2 = null;
        Object object = enclave;
        synchronized (object) {
            if (enclave.isRegistered()) {
                enclave.incrementPendingUseCount();
                enclave2 = enclave;
            }
        }
        if (enclave2 == null) {
            object = this._registeredEnclaves;
            synchronized (object) {
                enclave2 = (Enclave)this._registeredEnclaves.get(enclave);
                if (enclave2 == null) {
                    enclave2 = enclave;
                    this._registeredEnclaves.put(enclave2, enclave2);
                }
                Enclave enclave3 = enclave2;
                synchronized (enclave3) {
                    if (!enclave2.isRegistered()) {
                        byte[] byArray = EnclaveManager.registerWorkUnit(enclave2.getToken());
                        if (byArray == null) {
                            this._registeredEnclaves.remove(enclave2);
                        } else {
                            enclave2.setRegistrationToken(byArray);
                        }
                    }
                    enclave2.incrementPendingUseCount();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerEnclave", enclave2);
        }
        return enclave2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterEnclave(Enclave enclave) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterEnclave", enclave);
        }
        Map map = this._registeredEnclaves;
        synchronized (map) {
            Enclave enclave2 = (Enclave)this._registeredEnclaves.remove(enclave);
            if (enclave2 == null && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to find registered enclave", enclave);
                throw new IllegalArgumentException();
            }
            Enclave enclave3 = enclave2;
            synchronized (enclave3) {
                byte[] byArray = enclave2.getRegistrationToken();
                enclave2.setRegistrationToken(null);
                EnclaveManager.deregisterWorkUnit(enclave2.getToken(), byArray);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterEnclave");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void joinEnclave(Enclave enclave) throws AlreadyClassifiedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "joinEnclave", enclave);
        }
        Enclave enclave2 = enclave;
        synchronized (enclave2) {
            enclave.joining();
        }
        if (this.getCurrentEnclave() != null || !EnclaveManager.joinWorkUnit(enclave.getToken())) {
            this.leaveEnclave(enclave, true);
            throw new AlreadyClassifiedException();
        }
        this._currentEnclave.set(enclave);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "joinEnclave");
        }
    }

    void leaveEnclave(Enclave enclave) {
        this.leaveEnclave(enclave, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveEnclave(Enclave enclave, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "leaveEnclave", enclave);
        }
        boolean bl2 = true;
        Enclave enclave2 = enclave;
        synchronized (enclave2) {
            enclave.leaving();
            bl2 = enclave.isInUse();
            if (!bl && EnclaveManager.leaveWorkUnit(enclave.getToken())) {
                this._currentEnclave.set(null);
            }
        }
        if (!bl2 && enclave.isRegistered()) {
            this.deregisterEnclave(enclave);
        } else if (!bl2 && enclave.getCreatedByEnclaveManager()) {
            this.delete(enclave);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "leaveEnclave");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unpinEnclave(Enclave enclave) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unpinEnclave", enclave);
        }
        Enclave enclave2 = enclave;
        synchronized (enclave2) {
            enclave.joining();
            this.leaveEnclave(enclave, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unpinEnclave");
        }
    }

    Enclave create(ClassificationInfo classificationInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create", classificationInfo);
        }
        byte[] byArray = EnclaveManager.createWorkUnit(classificationInfo.getRawClassificationData());
        Enclave enclave = null;
        if (byArray != null) {
            enclave = new Enclave(byArray);
            enclave.incrementPendingUseCount();
            enclave.setCreatedByEnclaveManager(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create", enclave);
        }
        return enclave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(Enclave enclave) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete", enclave);
        }
        Enclave enclave2 = enclave;
        synchronized (enclave2) {
            enclave.setCreatedByEnclaveManager(false);
            EnclaveManager.deleteWorkUnit(enclave.getToken());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassificationInfo getClassificationInfo(Enclave enclave) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassificationInfo", enclave);
        }
        ClassificationInfo classificationInfo = null;
        byte[] byArray = null;
        WeakHashMap weakHashMap = this._classificationInfo;
        synchronized (weakHashMap) {
            byArray = (byte[])this._classificationInfo.get(enclave);
            if (byArray == null) {
                byArray = EnclaveManager.queryWorkUnitClassification(enclave.getToken());
                this._classificationInfo.put(enclave, byArray);
            }
        }
        if (byArray != null) {
            classificationInfo = new ClassificationInfo(byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassificationInfo", classificationInfo);
        }
        return classificationInfo;
    }

    private static native byte[] registerWorkUnit(byte[] var0);

    private static native void deregisterWorkUnit(byte[] var0, byte[] var1);

    private static native boolean joinWorkUnit(byte[] var0);

    private static native boolean leaveWorkUnit(byte[] var0);

    private static native byte[] createWorkUnit(byte[] var0);

    private static native void deleteWorkUnit(byte[] var0);

    private static native byte[] extractWorkUnit();

    private static native byte[] queryWorkUnitClassification(byte[] var0);
}

