/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans.timer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.asynchbeans.AsynchBeanManager;
import com.ibm.ws.asynchbeans.JMXBroadcasterHelper;
import com.ibm.ws.asynchbeans.am.AlarmManager;
import com.ibm.ws.asynchbeans.timer.GenericTimer;
import java.util.Iterator;
import java.util.Set;

public abstract class GenericTimerManager
extends JMXBroadcasterHelper {
    static final TraceComponent tc = Tr.register(GenericTimerManager.class, "AsynchBeans_Alarms", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    protected Set timers;
    protected AlarmManager alarmManager;

    protected abstract boolean getDestroyed();

    protected abstract void setDestroyed(boolean var1);

    public GenericTimerManager(AsynchBeanManager asynchBeanManager) {
        this.setAsynchBeanManager(asynchBeanManager);
        this.alarmManager = asynchBeanManager.getRawAlarmManager();
    }

    protected void sendDestroyedEvent() {
    }

    public synchronized void destroyAlarm(GenericTimer genericTimer) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "destroyAlarm", genericTimer);
        }
        if (this.timers != null) {
            this.timers.remove(genericTimer);
        }
        if (bl) {
            Tr.exit(tc, "destroyAlarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "destroy", this);
        }
        boolean bl2 = false;
        GenericTimerManager genericTimerManager = this;
        synchronized (genericTimerManager) {
            Tr.debug(tc, "destroy - Begin synchronization block");
            GenericTimer[] genericTimerArray = new GenericTimer[this.timers.size()];
            int n = 0;
            Iterator iterator = this.timers.iterator();
            while (iterator.hasNext()) {
                genericTimerArray[n++] = (GenericTimer)iterator.next();
            }
            for (int i = 0; i < n; ++i) {
                genericTimerArray[i].destroy();
            }
            this.timers.clear();
            this.setDestroyed(true);
            bl2 = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "destroy - End synchronization block");
            }
        }
        if (bl2) {
            this.sendDestroyedEvent();
        }
        if (bl) {
            Tr.exit(tc, "destroy");
        }
    }

    protected void cleanup() {
        this.timers.clear();
        this.timers = null;
        this.alarmManager = null;
    }
}

