/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans.timer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.asynchbeans.AsynchBeanManager;
import com.ibm.ws.asynchbeans.Messages;
import com.ibm.ws.asynchbeans.services.wlm.ClassificationService;
import com.ibm.ws.asynchbeans.timer.CancelTimerListenerRunnable;
import com.ibm.ws.asynchbeans.timer.GenericTimer;
import com.ibm.ws.asynchbeans.timer.StopTimerListenerRunnable;
import com.ibm.ws.asynchbeans.timer.TimerManagerImpl;
import com.ibm.ws.asynchbeans.util.AsynchBeanUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import commonj.timers.CancelTimerListener;
import commonj.timers.StopTimerListener;
import commonj.timers.Timer;
import commonj.timers.TimerListener;
import commonj.work.WorkException;

public class TimerImpl
extends GenericTimer
implements Timer {
    static TraceComponent tc = Tr.register(TimerImpl.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    private static final ClassificationService classSvc = ClassificationService.instance();
    private TimerListener userListener;
    private long period;
    private long scheduledExecutionTime;
    private int timerManagerState;
    private TimerManagerImpl tm = null;
    private boolean isAlarmInQ = false;
    private boolean isTimerStopCalled = false;
    boolean isListenerRunning = false;
    private Object timerManagerStateLock = new Object();

    public TimerImpl(TimerManagerImpl timerManagerImpl, TimerListener timerListener, long l, long l2, boolean bl, boolean bl2) {
        this.tm = timerManagerImpl;
        this.userListener = timerListener;
        this.period = l2;
        this.setAlarm(false);
        this.isAlarmInQ = bl2;
        this.init(timerManagerImpl, l, l2, bl, timerListener, bl2, 4096);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TimerImpl.<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        boolean bl;
        boolean bl2 = tc.isEntryEnabled();
        if (bl2) {
            Tr.entry(tc, "cancel", this);
        }
        Object object = this.timerLock;
        synchronized (object) {
            if (this.cancelled || this.timerManagerState == 2 || this.timerManagerState == 4) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The timer is already cancelled or stopped.");
                }
                bl = false;
            } else if (this.period == 0L && this.hasTimerExpiredAtLeastOnce) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The timer is a one-shot timer and has already expired.");
                }
                bl = false;
            } else {
                this.cancelled = true;
                this.wasAlarm.cancel();
                bl = true;
                this.sendCancelTimerEvent();
            }
            if (this.tm != null && this.timerManagerState != 2) {
                this.tm.destroyAlarm(this);
            }
        }
        if (bl2) {
            Tr.exit(tc, "cancel", new Boolean(bl));
        }
        return bl;
    }

    public long getPeriod() {
        return this.period;
    }

    public TimerListener getTimerListener() throws IllegalStateException {
        if (this.timerManagerState == 2 || this.timerManagerState == 4) {
            throw new IllegalStateException(Messages.getMsg("INVALID_TIMERMANAGER_STATE", new Object[]{"TimerManager", "Stopped"}));
        }
        return this.userListener;
    }

    public long getScheduledExecutionTime() throws IllegalStateException {
        if (this.timerManagerState == 2 || this.timerManagerState == 4) {
            throw new IllegalStateException(Messages.getMsg("INVALID_TIMERMANAGER_STATE", new Object[]{"TimerManager", "Stopped state"}));
        }
        return this.scheduledExecutionTime;
    }

    protected void callListenerMethod() {
        this.userListener.timerExpired(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reset", new Object[]{this, AsynchBeanUtil.getLongAsDateTime(l)});
        }
        try {
            Object object = this.timerLock;
            synchronized (object) {
                this.checkDestroyed();
                this.wasAlarm.setFired(false);
                this.wasAlarm.setExpirationTime(l);
                this.asynchBeanManager.getRawAlarmManager().addAlarmToQueue(this.wasAlarm);
            }
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.asynchbeans.timer.TimerImpl.reset", "194", this);
            Tr.error(tc, "MSG_KEY_39", new Object[]{runtimeException});
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runListenerAsCJWork() {
        Object object;
        WorkException workException;
        boolean bl;
        block38: {
            bl = tc.isEntryEnabled();
            boolean bl2 = tc.isEntryEnabled();
            if (bl) {
                Tr.entry(tc, "runListenerAsCJWork", this);
            }
            workException = null;
            object = this.timerLock;
            synchronized (object) {
                Object object2 = this.timerManagerStateLock;
                synchronized (object2) {
                    if (this.timerManagerState == 4 || this.timerManagerState == 2) {
                        if (bl) {
                            Tr.exit(tc, "runListenerAsCJWork", "The timer is stopped- return");
                        }
                        return;
                    }
                    if (this.cancelled) {
                        if (bl) {
                            Tr.exit(tc, "runListenerAsCJWork", "The timer is cancelled- return");
                        }
                        return;
                    }
                    if (this.timerManagerState == 3 || this.timerManagerState == 1) {
                        if (bl2) {
                            Tr.debug(tc, "runListenerAsCJWork", "The timer is suspended. Set wasAlarm.fired and isAlarmInQ false.");
                        }
                        this.wasAlarm.setFired(false);
                        this.isAlarmInQ = false;
                        return;
                    }
                    this.isListenerRunning = true;
                    this.tm.incrementNumOfRunningListener();
                }
                if (this.period == 0L && this.setWASAlarmAndCheckCancelled(null)) {
                    if (bl) {
                        Tr.exit(tc, "runListenerAsCJWork", "Timer cancelled");
                    }
                    return;
                }
            }
            try {
                if (this.callerContext != null) {
                    if (classSvc.isEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Classification Service is enabled");
                        }
                        classSvc.setExecutingWorkManager(this.asynchBeanManager);
                    }
                    try {
                        workException = this.callerContext.run(this.asynchBeanManager, this.asynchBeanManager.getContextDescriptor(), this, null, this.callerContext, null, null, null, 32, 1);
                        break block38;
                    }
                    finally {
                        if (classSvc.isEnabled()) {
                            classSvc.setExecutingWorkManager(null);
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "runListenerAsCJWork", "callerContext is null");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.asynchbeans.timer.TimerImpl.runListenerAsCJWork", "160", this);
                Tr.error(tc, "MSG_KEY_38", new Object[]{throwable});
                if (bl) {
                    Tr.exit(tc, "runListenerAsCJWork", "Throwable");
                }
                return;
            }
            finally {
                if (this.period == 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "One-shot timer completed");
                    }
                    if (this.tm != null && this.timerManagerState != 2) {
                        this.tm.destroyAlarm(this);
                    }
                }
            }
        }
        object = this.timerLock;
        synchronized (object) {
            this.tm.decrementNumOfRunningListener();
            this.isListenerRunning = false;
        }
        if (workException != null) {
            FFDCFilter.processException((Throwable)workException, "com.ibm.ws.asynchbeans.timer.TimerImpl.runListenerAsCJWork", "347", this);
            Tr.error(tc, "MSG_KEY_38", new Object[]{workException});
            if (bl) {
                Tr.exit(tc, "runListenerAsCJWork", "commonj.work.WorkException");
            }
            return;
        }
        if (bl) {
            Tr.exit(tc, "runListenerAsCJWork");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setScheduledExecutionTime(long l) {
        Object object = this.timerLock;
        synchronized (object) {
            this.scheduledExecutionTime = l;
        }
    }

    public void sendStopTimerEvent() {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "sendStopTimerEvent", this);
        }
        if (!(this.userListener instanceof StopTimerListener)) {
            if (bl) {
                Tr.exit(tc, "sendStopTimerEvent", "UserListener is not a StopTimerListener, exit");
            }
            return;
        }
        StopTimerListenerRunnable stopTimerListenerRunnable = null;
        try {
            stopTimerListenerRunnable = AsynchBeanManager.getPooledStopTimerListenerRunnable();
            stopTimerListenerRunnable.init((StopTimerListener)this.userListener, this);
            if (this.callerContext != null) {
                WorkException workException = this.callerContext.run(this.asynchBeanManager, this.asynchBeanManager.getContextDescriptor(), stopTimerListenerRunnable, null, this.callerContext, null, null, null, 32, 2);
                if (workException != null) {
                    if (bl) {
                        Tr.exit(tc, "sendStopTimerEvent", workException);
                    }
                    throw workException;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sendStopTimerEvent", "callerContext is null");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.asynchbeans.timer.TimerImpl.sendStopTimerEvent", "397", this);
            Tr.error(tc, "MSG_KEY_38", new Object[]{throwable});
        }
        if (stopTimerListenerRunnable != null) {
            AsynchBeanManager.returnPooledStopTimerListenerRunnable(stopTimerListenerRunnable);
        }
        if (bl) {
            Tr.exit(tc, "sendStopTimerEvent");
        }
    }

    public void sendCancelTimerEvent() {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "sendCancelTimerEvent", this);
        }
        if (!(this.userListener instanceof CancelTimerListener)) {
            if (bl) {
                Tr.exit(tc, "sendCancelTimerEvent", "UserListener is not a CancelTimerListener, exit");
            }
            return;
        }
        CancelTimerListenerRunnable cancelTimerListenerRunnable = null;
        try {
            cancelTimerListenerRunnable = AsynchBeanManager.getPooledCancelTimerListenerRunnable();
            cancelTimerListenerRunnable.init((CancelTimerListener)this.userListener, this);
            if (this.callerContext != null) {
                WorkException workException = this.callerContext.run(this.asynchBeanManager, this.asynchBeanManager.getContextDescriptor(), cancelTimerListenerRunnable, null, this.callerContext, null, null, null, 32, 3);
                if (workException != null) {
                    throw workException;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sendCancelTimerEvent", "callerContext is null");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.asynchbeans.timer.TimerImpl.sendCancelTimerEvent", "481", this);
            Tr.error(tc, "MSG_KEY_38", new Object[]{throwable});
            if (bl) {
                Tr.exit(tc, "sendCancelTimerEvent", "Throwable");
            }
            return;
        }
        if (cancelTimerListenerRunnable != null) {
            AsynchBeanManager.returnPooledCancelTimerListenerRunnable(cancelTimerListenerRunnable);
        }
        if (bl) {
            Tr.exit(tc, "sendCancelTimerEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimerManagerState() {
        Object object = this.timerManagerStateLock;
        synchronized (object) {
            return this.timerManagerState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimerManagerState(int n) {
        Object object = this.timerManagerStateLock;
        synchronized (object) {
            this.timerManagerState = n;
        }
    }

    public boolean isAlarmInQ() {
        return this.isAlarmInQ;
    }

    void setAlarmInQ(boolean bl) {
        this.isAlarmInQ = bl;
    }

    public boolean isTimerStopCalled() {
        return this.isTimerStopCalled;
    }

    void setTimerStopCalled(boolean bl) {
        this.isTimerStopCalled = bl;
    }

    void cleanup() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cleanup", this);
        }
        super.cleanup();
        this.userListener = null;
        this.tm = null;
    }

    public void destroy() {
        throw new RuntimeException(Messages.getMsg("MSG_KEY_UNEX_EXCEPT", new Object[]{"TimerImpl.destroy() is called."}));
    }
}

