/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans.timer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.asynchbeans.AsynchBeanManager;
import com.ibm.ws.asynchbeans.J2EEServiceManager;
import com.ibm.ws.asynchbeans.Messages;
import com.ibm.ws.asynchbeans.timer.GenericTimerManager;
import com.ibm.ws.asynchbeans.timer.TimerImpl;
import com.ibm.ws.asynchbeans.timer.TimerListenerWaiter;
import com.ibm.ws.asynchbeans.util.AsynchBeanUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ThreadPool;
import commonj.timers.Timer;
import commonj.timers.TimerListener;
import commonj.timers.TimerManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;

public class TimerManagerImpl
extends GenericTimerManager
implements TimerManager {
    static final TraceComponent tc = Tr.register(TimerManagerImpl.class, "AsynchBeans_Alarms", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    private int state = 0;
    public static final int WORKING = 0;
    public static final int SUSPENDED = 1;
    public static final int STOPPED = 2;
    public static final int SUSPENDING = 3;
    public static final int STOPPING = 4;
    public static final String[] TIMERMANAGER_STATE_STRINGS = new String[]{"Working", "Suspended", "Stopped", "Suspending", "Stopping"};
    private int numOfRunningListener = 0;
    private Object numOfRunningListenerLock = new Object();
    protected Object stateLock = new Object();
    private String appName;
    TimerListenerWaiter waiter = null;
    private boolean wasSuspendInterrupted;
    static ThreadPool systemThreadPool;

    public TimerManagerImpl(AsynchBeanManager asynchBeanManager, String string) {
        super(asynchBeanManager);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{asynchBeanManager, string});
        }
        this.appName = string;
        this.timers = new HashSet(asynchBeanManager.initialAlarmCapacity);
        this.waiter = new TimerListenerWaiter(this);
        if (systemThreadPool == null) {
            systemThreadPool = (ThreadPool)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return J2EEServiceManager.getSelf().getThreadPool("default");
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    protected final synchronized boolean getDestroyed() {
        return this.isStopping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isStopped() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isStopping() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 4 || this.state == 2;
        }
    }

    public boolean isSuspended() {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case 1: {
                    return true;
                }
                case 0: 
                case 3: {
                    return false;
                }
            }
            IllegalStateException illegalStateException = new IllegalStateException(Messages.getMsg("INVALID_TIMERMANAGER_STATE", new Object[]{"TimerManager", TIMERMANAGER_STATE_STRINGS[this.state]}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isSuspended", illegalStateException);
            }
            throw illegalStateException;
        }
    }

    public boolean isSuspending() {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case 1: 
                case 3: {
                    return true;
                }
                case 0: {
                    return false;
                }
            }
            IllegalStateException illegalStateException = new IllegalStateException(Messages.getMsg("INVALID_TIMERMANAGER_STATE", new Object[]{"TimerManager", TIMERMANAGER_STATE_STRINGS[this.state]}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isSuspending", illegalStateException);
            }
            throw illegalStateException;
        }
    }

    public Timer schedule(TimerListener timerListener, Date date, long l) throws IllegalArgumentException, IllegalStateException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "schedule(TimerListener, long, long)", new Object[]{timerListener, date, new Long(l)});
        }
        if (date == null) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{null, "firstTime"}));
        }
        return this.commonSchedule(timerListener, date.getTime(), l, false);
    }

    public Timer schedule(TimerListener timerListener, Date date) throws IllegalArgumentException, IllegalStateException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "schedule(TimerListener, Date)", new Object[]{this, timerListener, date});
        }
        if (date == null) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{null, "time"}));
        }
        return this.commonSchedule(timerListener, date.getTime(), 0L, false);
    }

    public Timer schedule(TimerListener timerListener, long l) throws IllegalArgumentException, IllegalStateException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "schedule(TimerListener, long)", new Object[]{timerListener, new Long(l)});
        }
        if (l < 0L) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Long(l), "delay", "0..Long.MAX_VALUE"}));
        }
        long l2 = l + System.currentTimeMillis();
        l2 = l2 < 0L ? Long.MAX_VALUE : l2;
        return this.commonSchedule(timerListener, l2, 0L, false);
    }

    public Timer schedule(TimerListener timerListener, long l, long l2) throws IllegalArgumentException, IllegalStateException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "schedule(TimerListener, long, long)", new Object[]{timerListener, new Long(l), new Long(l2)});
        }
        if (l < 0L) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Long(l), "delay", "0..Long.MAX_VALUE"}));
        }
        long l3 = l + System.currentTimeMillis();
        l3 = l3 < 0L ? Long.MAX_VALUE : l3;
        return this.commonSchedule(timerListener, l3, l2, false);
    }

    public Timer scheduleAtFixedRate(TimerListener timerListener, Date date, long l) throws IllegalArgumentException, IllegalStateException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scheduleAtFixedRate(TimerListener, Date, long)", new Object[]{timerListener, date, new Long(l)});
        }
        if (date == null) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{null, "firstTime"}));
        }
        return this.commonSchedule(timerListener, date.getTime(), l, true);
    }

    public Timer scheduleAtFixedRate(TimerListener timerListener, long l, long l2) throws IllegalArgumentException, IllegalStateException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scheduleAtFixedRate(TimerListener, long, long)", new Object[]{timerListener, new Long(l), new Long(l2)});
        }
        if (l < 0L) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Long(l), "delay", "0..Long.MAX_VALUE"}));
        }
        long l3 = l + System.currentTimeMillis();
        l3 = l3 < 0L ? Long.MAX_VALUE : l3;
        return this.commonSchedule(timerListener, l3, l2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop", new Object[]{this, "TimerManager state: " + TimerManagerImpl.getStateAsString(this.state) + " --> " + TimerManagerImpl.getStateAsString(4)});
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 4 || this.state == 2) {
                IllegalStateException illegalStateException = new IllegalStateException(Messages.getMsg("INVALID_TIMERMANAGER_STATE", new Object[]{"TimerManager", TIMERMANAGER_STATE_STRINGS[this.state]}));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "stop", illegalStateException);
                }
                throw illegalStateException;
            }
            this.state = 4;
            this.setTimersInState(2);
            Iterator iterator = this.timers.iterator();
            while (iterator.hasNext()) {
                TimerImpl timerImpl = (TimerImpl)iterator.next();
                if (timerImpl.getWasAlarm() == null) continue;
                this.alarmManager.removeAlarmFromAlarmQ(timerImpl.getWasAlarm());
            }
        }
        try {
            systemThreadPool.execute(new Runnable(){

                public void run() {
                    TimerManagerImpl.this.stopTimers();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, this.getClass().getName() + ".stop", "551", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stop was interrupted.");
            }
            this.stopCompletely();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stop", interruptedException);
            }
            throw new RuntimeException(interruptedException.getMessage(), interruptedException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopCompletely() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopCompletely", new Object[]{this, "TimerManager state: " + TimerManagerImpl.getStateAsString(this.state) + " --> " + TimerManagerImpl.getStateAsString(2)});
        }
        this.timers.clear();
        this.getAsynchBeanManager().removeTimerManager(this);
        Object object = this.stateLock;
        synchronized (object) {
            this.state = 2;
            this.stateLock.notifyAll();
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopCompletely");
        }
    }

    private void stopTimers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopTimers");
        }
        this.blockUntilNoListenerRunning();
        Iterator iterator = this.timers.iterator();
        while (iterator.hasNext()) {
            ((TimerImpl)iterator.next()).sendStopTimerEvent();
        }
        this.stopCompletely();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopTimers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer commonSchedule(TimerListener timerListener, long l, long l2, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (timerListener == null) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{null, "commonj.timer.TimerListener"}));
        }
        J2EEServiceManager.checkValidAsyncBean(timerListener);
        if (l2 < 0L) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Long(l2), "period", "0..Long.MAX_VALUE"}));
        }
        if (this.isStopping()) {
            throw new IllegalStateException(Messages.getMsg("INVALID_TIMERMANAGER_STATE", new Object[]{"TimerManager", "Stopped"}));
        }
        boolean bl2 = tc.isEntryEnabled();
        if (bl2) {
            Tr.entry(tc, "commonSchedule(TimerListener, long, long, boolean)", new Object[]{this, timerListener, AsynchBeanUtil.getLongAsDateTime(l), new Long(l2), new Boolean(bl)});
        }
        TimerImpl timerImpl = null;
        try {
            timerImpl = new TimerImpl(this, timerListener, l, l2, bl, false);
            Object object = this.stateLock;
            synchronized (object) {
                if (this.isStopping()) {
                    Object object2 = timerImpl.timerLock;
                    synchronized (object2) {
                        timerImpl.cancelled = true;
                        timerImpl.getWasAlarm().cancel();
                    }
                    timerImpl.cleanup();
                    throw new IllegalStateException(Messages.getMsg("INVALID_TIMERMANAGER_STATE", new Object[]{"TimerManager", "Stopped"}));
                }
                if (this.state == 0) {
                    this.alarmManager.addAlarmToQueue(timerImpl.getWasAlarm());
                } else if (this.isSuspending() && timerImpl.getTimerManagerState() != 1) {
                    timerImpl.setTimerManagerState(1);
                }
                this.timers.add(timerImpl);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            FFDCFilter.processException((Throwable)outOfMemoryError, "com.ibm.ws.asynchbeans.timer.TimerManagerImpl.commonSchedule", "111", this);
            Tr.error(tc, "MSG_KEY_43", new Object[]{outOfMemoryError});
            if (bl2) {
                Tr.exit(tc, "commonSchedule(TimerListener, long, long, boolean)", "OutOfMemoryError");
            }
            throw outOfMemoryError;
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.asynchbeans.timer.TimerManagerImpl.commonSchedule", "114", this);
            Tr.error(tc, "MSG_KEY_43", new Object[]{illegalStateException});
            if (bl2) {
                Tr.exit(tc, "commonSchedule(TimerListener, long, long, boolean)", "IllegalStateException");
            }
            throw illegalStateException;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.asynchbeans.timer.TimerManagerImpl.commonSchedule", "117", this);
            Tr.error(tc, "MSG_KEY_43", new Object[]{runtimeException});
            if (bl2) {
                Tr.exit(tc, "commonSchedule(TimerListener, long, long, boolean)", "RuntimeException");
            }
            throw runtimeException;
        }
        if (bl2) {
            Tr.exit(tc, "commonSchedule(TimerListener, long, long, boolean)", timerImpl);
        }
        return timerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", this);
        }
        boolean bl = tc.isDebugEnabled();
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case 3: {
                    this.wasSuspendInterrupted = true;
                    this.stateLock.notifyAll();
                    this.waiter.notifyIt();
                }
                case 1: {
                    this.state = 0;
                    this.setTimersInState(0);
                    this.resumeTimers();
                    break;
                }
                case 0: {
                    if (!bl) break;
                    Tr.debug(tc, "resume", new Object[]{this, "TimerManager is in working state. no-op"});
                    break;
                }
                default: {
                    IllegalStateException illegalStateException = new IllegalStateException(Messages.getMsg("INVALID_TIMERMANAGER_STATE", new Object[]{"TimerManager", TIMERMANAGER_STATE_STRINGS[this.state]}));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resume", illegalStateException);
                    }
                    throw illegalStateException;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend", new Object[]{this, "TimerManager state: " + TimerManagerImpl.getStateAsString(this.state) + " --> " + TimerManagerImpl.getStateAsString(3)});
        }
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    this.state = 3;
                    this.wasSuspendInterrupted = false;
                    this.setTimersInState(1);
                    break;
                }
                case 1: 
                case 3: {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "suspend", "TimerManager is already " + TimerManagerImpl.getStateAsString(this.state));
                    }
                    return;
                }
                default: {
                    IllegalStateException illegalStateException = new IllegalStateException(Messages.getMsg("INVALID_TIMERMANAGER_STATE", new Object[]{"TimerManager", TIMERMANAGER_STATE_STRINGS[this.state]}));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "suspend", illegalStateException);
                    }
                    throw illegalStateException;
                }
            }
        }
        try {
            systemThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "suspend.run");
                    }
                    TimerManagerImpl.this.blockUntilNoListenerRunning();
                    Object object = TimerManagerImpl.this.stateLock;
                    synchronized (object) {
                        if (TimerManagerImpl.this.state == 3) {
                            TimerManagerImpl.this.state = 1;
                        }
                        TimerManagerImpl.this.stateLock.notifyAll();
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "suspend.run");
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, this.getClass().getName() + ".suspend", "919", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Suspend was interrupted; will resume and throw an exception.");
            }
            Object object2 = this.stateLock;
            synchronized (object2) {
                this.resume();
                this.stateLock.notifyAll();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspend", interruptedException);
            }
            throw new RuntimeException(interruptedException.getMessage(), interruptedException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend");
        }
    }

    public int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = n;
        }
    }

    protected final void setDestroyed(boolean bl) {
        this.setState(2);
    }

    public String getAppName() {
        return this.appName;
    }

    public static final String getStateAsString(int n) {
        return n < 0 || n >= TIMERMANAGER_STATE_STRINGS.length ? "Unknown" : TIMERMANAGER_STATE_STRINGS[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getNumOfRunningListener() {
        Object object = this.numOfRunningListenerLock;
        synchronized (object) {
            return this.numOfRunningListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementNumOfRunningListener() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "incrementNumOfRunningListener");
        }
        Object object = this.numOfRunningListenerLock;
        synchronized (object) {
            ++this.numOfRunningListener;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.numOfRunningListener + " timerExpired listeners are running.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrementNumOfRunningListener() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "decrementNumOfRunningListener");
        }
        Object object = this.numOfRunningListenerLock;
        synchronized (object) {
            --this.numOfRunningListener;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.numOfRunningListener + " timerExpired listeners are running.");
            }
        }
        if (this.waiter.isWaiting() && this.numOfRunningListener == 0) {
            this.waiter.notifyIt();
        }
    }

    private void blockUntilNoListenerRunning() {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "blockUntilNoListenerRunning", this);
        }
        this.waiter.init();
        this.waiter.setWaiting(true);
        if (this.numOfRunningListener == 0) {
            if (bl) {
                Tr.exit(tc, "blockUntilNoListenerRunning", "No Listener is running - return");
            }
            this.waiter.setWaiting(false);
            return;
        }
        this.waiter.waitForFinish();
        if (bl) {
            Tr.exit(tc, "blockUntilNoListenerRunning");
        }
    }

    private void setTimersInState(int n) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "setTimersInState", new Object[]{this, TIMERMANAGER_STATE_STRINGS[n]});
        }
        Iterator iterator = this.timers.iterator();
        while (iterator.hasNext()) {
            ((TimerImpl)iterator.next()).setTimerManagerState(n);
        }
        if (bl) {
            Tr.exit(tc, "setTimersInState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeTimers() {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "resumeTimers", this);
        }
        Iterator iterator = this.timers.iterator();
        while (iterator.hasNext()) {
            TimerImpl timerImpl = (TimerImpl)iterator.next();
            Object object = timerImpl.timerLock;
            synchronized (object) {
                if (!timerImpl.isAlarmInQ() && timerImpl.getWasAlarm() != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resuming: " + timerImpl);
                    }
                    timerImpl.getWasAlarm().setFirstTimeRunAfterResume(true);
                    this.alarmManager.addAlarmToAlarmQAtResume(timerImpl.getWasAlarm());
                    timerImpl.setAlarmInQ(true);
                }
            }
        }
        if (bl) {
            Tr.exit(tc, "resumeTimers");
        }
    }

    protected final void cleanup() {
        super.cleanup();
        this.appName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForStop(long l) throws InterruptedException, IllegalArgumentException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForStop", new Object[]{this, new Long(l)});
        }
        if (l < 0L) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Long(l), "TimerManager.waitForStop", ">= 0"}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForStop", illegalArgumentException);
            }
            throw illegalArgumentException;
        }
        Object object = this.stateLock;
        synchronized (object) {
            long l2 = System.currentTimeMillis();
            while (l > 0L && this.state != 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Wait for " + l + " milliseconds.");
                }
                this.stateLock.wait(l);
                long l3 = System.currentTimeMillis();
                l -= l3 - l2;
                l2 = l3;
            }
            bl = this.state == 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForStop", bl ? "STOPPED" : "TimerManager is not STOPPED");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSuspend(long l) throws InterruptedException, IllegalStateException, IllegalArgumentException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForSuspend", new Object[]{this, new Long(l)});
        }
        Object object = this.stateLock;
        synchronized (object) {
            block2 : switch (this.state) {
                case 1: {
                    bl = true;
                    break;
                }
                case 0: 
                case 3: {
                    if (l > 0L) {
                        this.stateLock.wait(l);
                    } else if (l < 0L) {
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Long(l), "TimerManager.waitForSuspend", ">= 0"}));
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "waitForSuspend", illegalArgumentException);
                        }
                        throw illegalArgumentException;
                    }
                    switch (this.state) {
                        case 1: {
                            bl = true;
                            break block2;
                        }
                        case 3: {
                            bl = false;
                            break block2;
                        }
                        case 0: {
                            if (this.wasSuspendInterrupted) break;
                            bl = false;
                            break block2;
                        }
                    }
                    InterruptedException interruptedException = new InterruptedException(Messages.getMsg("INVALID_TIMERMANAGER_STATE", new Object[]{"TimerManager", TIMERMANAGER_STATE_STRINGS[this.state]}));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "waitForSuspend", interruptedException);
                    }
                    throw interruptedException;
                }
                default: {
                    IllegalStateException illegalStateException = new IllegalStateException(Messages.getMsg("INVALID_TIMERMANAGER_STATE", new Object[]{"TimerManager", TIMERMANAGER_STATE_STRINGS[this.state]}));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "waitForSuspend", illegalStateException);
                    }
                    throw illegalStateException;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForSuspend", bl ? "SUSPENDED" : "TimerManager is not SUSPENDED");
        }
        return bl;
    }
}

