/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.asynchbeans.timer;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.workmanager.TimerManagerInfo;
import com.ibm.ws.asynchbeans.Messages;
import com.ibm.wsspi.asynchbeans.TimerManagerConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TimerManagerProperties
implements TimerManagerConfiguration {
    static final TraceComponent tc = Tr.register(TimerManagerProperties.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    private static final long serialVersionUID = 7947670603889813547L;
    public Map customProperties;
    private int initialAlarmCapacity;
    private String name;
    private int numAlarmThreads;
    private ArrayList enabledServices;
    private boolean isExcluded;
    private String defTranClass;
    private String jNDIName;

    public TimerManagerProperties() {
        this.name = "";
        this.numAlarmThreads = 5;
        this.enabledServices = new ArrayList();
        this.initialAlarmCapacity = 20;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>", this);
        }
    }

    public TimerManagerProperties(String string, String string2, int n, int n2, String[] stringArray) throws IllegalArgumentException {
        if (string == null || string.trim().length() == 0) {
            Tr.error(tc, "INVALID_VALUE_2", new Object[]{string, "name"});
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{string, "name"}));
        }
        if (string2 == null || string2.trim().length() == 0) {
            Tr.error(tc, "INVALID_VALUE_2", new Object[]{string2, "JNDIName"});
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE_2", new Object[]{string2, "JNDIName"}));
        }
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(n), "numAlarmThreads", "0..Integer.MAX_VALUE"}));
        }
        this.name = string;
        this.jNDIName = string2;
        this.numAlarmThreads = n;
        if (n2 < 0) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(n2), "INITIAL_ALARM_CAPACITY", "0..Integer.MAX_VALUE"}));
        }
        this.initialAlarmCapacity = n2;
        this.enabledServices = stringArray == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(stringArray));
    }

    public TimerManagerProperties(TimerManagerInfo timerManagerInfo) {
        this();
        String string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init> Apply TimerManagerInfo", timerManagerInfo);
        }
        this.name = timerManagerInfo.getName();
        this.numAlarmThreads = timerManagerInfo.getNumAlarmThreads();
        Iterator iterator = timerManagerInfo.getServiceNames().iterator();
        this.enabledServices = new ArrayList();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.enabledServices.add(string);
        }
        this.defTranClass = timerManagerInfo.getDefTranClass();
        this.customProperties = new HashMap();
        string = timerManagerInfo.getPropertySet();
        if (string != null) {
            Iterator iterator2 = string.getResourceProperties().iterator();
            while (iterator2.hasNext()) {
                J2EEResourceProperty j2EEResourceProperty = (J2EEResourceProperty)iterator2.next();
                String string2 = j2EEResourceProperty.getName().trim();
                String string3 = j2EEResourceProperty.getValue();
                this.customProperties.put(string2, string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " = " + string3);
                }
                if (!string2.equals("INITIAL_ALARM_CAPACITY")) continue;
                int n = Integer.parseInt(string3);
                if (n < 0) {
                    throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(n), "INITIAL_ALARM_CAPACITY", "0..Integer.MAX_VALUE"}));
                }
                this.initialAlarmCapacity = n;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>", this);
        }
    }

    public Map getCustomProperties() {
        return this.customProperties;
    }

    public String[] getEnabledServices() {
        String[] stringArray = new String[this.enabledServices.size()];
        return this.enabledServices.toArray(stringArray);
    }

    public int getInitialAlarmCapacity() {
        return this.initialAlarmCapacity;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public String getName() {
        return this.name;
    }

    public int getNumAlarmThreads() {
        return this.numAlarmThreads;
    }

    public void setCustomProperties(Map map) {
        this.customProperties = map;
    }

    public void setEnabledServices(String[] stringArray) {
        this.enabledServices = stringArray == null || stringArray.length == 0 ? new ArrayList() : new ArrayList<String>(Arrays.asList(stringArray));
    }

    public void setEnabledServices(ArrayList arrayList) {
        this.enabledServices = arrayList;
    }

    public void setExcluded(boolean bl) {
        this.isExcluded = bl;
    }

    public void setInitialAlarmCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getMsg("INVALID_VALUE", new Object[]{new Integer(n), "INITIAL_ALARM_CAPACITY", "0..Integer.MAX_VALUE"}));
        }
        this.initialAlarmCapacity = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNumAlarmThreads(int n) {
        this.numAlarmThreads = n;
    }

    public String getDefTranClass() {
        return this.defTranClass;
    }

    public void setDefTranClass(String string) {
        this.defTranClass = string;
    }

    private String propsToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.customProperties != null) {
            Iterator iterator = this.customProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stringBuffer.append("[");
                stringBuffer.append(entry.getKey());
                stringBuffer.append(",");
                stringBuffer.append(entry.getValue());
                stringBuffer.append("]");
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(255).append("TimerManagerProperties:[").append("name=").append(this.getName()).append(", isExcluded=").append(this.isExcluded()).append(", enabledServices=").append(this.servicesToString()).append(", defaultTransactionClass=").append(this.defTranClass).append(", initialAlarmCapacity=").append(this.initialAlarmCapacity).append(", props=").append(this.propsToString()).append("]");
        return stringBuffer.toString();
    }

    protected String servicesToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.enabledServices != null) {
            stringBuffer.append("[");
            Iterator iterator = this.enabledServices.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public String getJNDIName() {
        return this.jNDIName;
    }

    public void setJNDIName(String string) {
        this.jNDIName = string;
    }
}

