/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.AliasEntry;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.ExternalCacheFragment;
import com.ibm.ws.cache.ExternalCacheServices;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.InvalidationAuditDaemon;
import com.ibm.ws.cache.RealTimeDaemon;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.intf.DCache;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BatchUpdateDaemon
extends RealTimeDaemon {
    private static TraceComponent tc = Trace.register(BatchUpdateDaemon.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private ExternalCacheServices externalCacheServices = null;
    private InvalidationAuditDaemon invalidationAuditDaemon = null;
    private static final ArrayList EMPTY_ARRAYLIST = new ArrayList();
    private HashMap updates = new HashMap();
    private HashMap drsBuffer = new HashMap();
    private int drsCongestionThreshold = 5;

    public BatchUpdateDaemon(int n) {
        super(n);
    }

    public void setExternalCacheServices(ExternalCacheServices externalCacheServices) {
        this.externalCacheServices = externalCacheServices;
    }

    public void setInvalidationAuditDaemon(InvalidationAuditDaemon invalidationAuditDaemon) {
        this.invalidationAuditDaemon = invalidationAuditDaemon;
    }

    public void start() {
        if (this.externalCacheServices == null || this.invalidationAuditDaemon == null) {
            throw new IllegalStateException("externalCacheServices and invalidationAuditDaemon must be set before start()");
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateByTemplate(String string, boolean bl, DCache dCache) {
        BatchUpdateDaemon batchUpdateDaemon = this;
        synchronized (batchUpdateDaemon) {
            BatchUpdateList batchUpdateList = this.getUpdateList(dCache);
            batchUpdateList.invalidateByTemplateEvents.put(string, new InvalidateByTemplateEvent(string, 5));
        }
        if (bl) {
            this.wakeUp(0L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheCommand_Clear(boolean bl, DCache dCache) {
        String string = dCache.getCacheName();
        BatchUpdateDaemon batchUpdateDaemon = this;
        synchronized (batchUpdateDaemon) {
            BatchUpdateList batchUpdateList = this.getUpdateList(dCache);
            batchUpdateList.invalidateByIdEvents.clear();
            batchUpdateList.invalidateByTemplateEvents.clear();
            batchUpdateList.pushCacheEntryEvents.clear();
            batchUpdateList.pushECFEvents.clear();
            InvalidateByTemplateEvent invalidateByTemplateEvent = new InvalidateByTemplateEvent(string, 5);
            invalidateByTemplateEvent.setCacheCommand_Clear();
            batchUpdateList.invalidateByTemplateEvents.put(string, invalidateByTemplateEvent);
        }
        if (bl) {
            this.wakeUp(0L, 0L);
        }
    }

    public void invalidateById(Object object, int n, boolean bl, DCache dCache, boolean bl2) {
        this.invalidateById(object, n, 5, bl, true, true, dCache, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateById(Object object, int n, int n2, boolean bl, boolean bl2, boolean bl3, DCache dCache, boolean bl4) {
        if (bl4 && dCache.isEnableListener() && dCache.getEventSource().getPreInvalidationListenerCount() > 0 && n != 2 && n != 8 && !dCache.getEventSource().shouldInvalidate(object, n2, n)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalidateById() cacheName=" + dCache.getCacheName() + " skip invalidation of id=" + object + " because PreInvalidationListener.shouldInvalidate() returns false.");
            }
            return;
        }
        BatchUpdateDaemon batchUpdateDaemon = this;
        synchronized (batchUpdateDaemon) {
            BatchUpdateList batchUpdateList = this.getUpdateList(dCache);
            InvalidateByIdEvent invalidateByIdEvent = new InvalidateByIdEvent(object, n, n2, bl2, bl3);
            invalidateByIdEvent.setClassLoaderType(dCache.getCacheConfig().isUseServerClassLoader());
            batchUpdateList.invalidateByIdEvents.put(object, invalidateByIdEvent);
        }
        if (bl) {
            this.wakeUp(0L, 0L);
        }
    }

    public void invalidateById(Object object, boolean bl, DCache dCache) {
        this.invalidateById(object, 1, bl, dCache, true);
    }

    public synchronized void pushCacheEntry(com.ibm.websphere.cache.CacheEntry cacheEntry, DCache dCache) {
        BatchUpdateList batchUpdateList = this.getUpdateList(dCache);
        batchUpdateList.pushCacheEntryEvents.add(cacheEntry);
    }

    public synchronized void pushExternalCacheFragment(ExternalCacheFragment externalCacheFragment, DCache dCache) {
        BatchUpdateList batchUpdateList = this.getUpdateList(dCache);
        batchUpdateList.pushECFEvents.add(externalCacheFragment);
    }

    public synchronized void pushAliasEntry(AliasEntry aliasEntry, DCache dCache) {
        BatchUpdateList batchUpdateList = this.getUpdateList(dCache);
        batchUpdateList.aliasEntryEvents.add(aliasEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void wakeUp(long l, long l2) {
        try {
            BatchUpdateList[] batchUpdateListArray;
            int n;
            Iterator iterator = this;
            synchronized (iterator) {
                n = this.updates.size();
                if (n <= 0) return;
                batchUpdateListArray = new BatchUpdateList[n];
                this.updates.values().toArray(batchUpdateListArray);
                this.updates.clear();
            }
            iterator = new ArrayList();
            n = 0;
            while (n < batchUpdateListArray.length) {
                Object object;
                Object object2 = null;
                try {
                    object2 = batchUpdateListArray[n];
                    ((ArrayList)((Object)iterator)).addAll(((BatchUpdateList)object2).pushCacheEntryEvents);
                    this.cleanUpEventLists(((BatchUpdateList)object2).cache, ((BatchUpdateList)object2).invalidateByIdEvents, ((BatchUpdateList)object2).invalidateByTemplateEvents, ((BatchUpdateList)object2).pushCacheEntryEvents, ((BatchUpdateList)object2).pushECFEvents, ((BatchUpdateList)object2).aliasEntryEvents);
                    if (((BatchUpdateList)object2).invalidateByIdEvents.size() > 0) {
                        this.invalidationAuditDaemon.registerInvalidations(((BatchUpdateList)object2).cache.getCacheName(), ((BatchUpdateList)object2).invalidateByIdEvents.values().iterator());
                    }
                    if (((BatchUpdateList)object2).invalidateByTemplateEvents.size() > 0) {
                        this.invalidationAuditDaemon.registerInvalidations(((BatchUpdateList)object2).cache.getCacheName(), ((BatchUpdateList)object2).invalidateByTemplateEvents.values().iterator());
                    }
                    if (((BatchUpdateList)object2).pushCacheEntryEvents.size() > 0) {
                        ((BatchUpdateList)object2).pushCacheEntryEvents = this.invalidationAuditDaemon.filterEntryList(((BatchUpdateList)object2).cache.getCacheName(), ((BatchUpdateList)object2).pushCacheEntryEvents);
                    }
                    if (((BatchUpdateList)object2).pushECFEvents.size() > 0) {
                        ((BatchUpdateList)object2).pushECFEvents = this.invalidationAuditDaemon.filterExternalCacheFragmentList(((BatchUpdateList)object2).cache.getCacheName(), ((BatchUpdateList)object2).pushECFEvents);
                    }
                    if (((BatchUpdateList)object2).invalidateByIdEvents.size() > 0 || ((BatchUpdateList)object2).invalidateByTemplateEvents.size() > 0 || ((BatchUpdateList)object2).pushCacheEntryEvents.size() > 0) {
                        BatchUpdateList batchUpdateList;
                        Object object3;
                        object = ((BatchUpdateList)object2).cache.getRemoteServices();
                        if (object.isDRSReady() && object.isDRSCongested()) {
                            object3 = this.drsBuffer;
                            synchronized (object3) {
                                this.addToDRSBuffer((BatchUpdateList)object2);
                                batchUpdateList = (BatchUpdateList)this.drsBuffer.get(((BatchUpdateList)object2).cache);
                                if (null != batchUpdateList) {
                                    for (com.ibm.websphere.cache.CacheEntry cacheEntry : batchUpdateList.pushCacheEntryEvents) {
                                        int n2 = ((ArrayList)((Object)iterator)).indexOf(cacheEntry);
                                        if (n2 < 0) continue;
                                        ((ArrayList)((Object)iterator)).remove(n2);
                                    }
                                }
                            }
                        } else if (object.isDRSReady() && !object.isDRSCongested()) {
                            object3 = (BatchUpdateList)this.drsBuffer.get(((BatchUpdateList)object2).cache);
                            batchUpdateList = null;
                            if (object3 != null) {
                                Iterator iterator2;
                                try {
                                    iterator2 = this.drsBuffer;
                                    synchronized (iterator2) {
                                        batchUpdateList = this.mergeLists((BatchUpdateList)object3, (BatchUpdateList)object2);
                                        this.drsBuffer.remove(((BatchUpdateList)object2).cache);
                                    }
                                    this.cleanUpEventLists(batchUpdateList.cache, batchUpdateList.invalidateByIdEvents, batchUpdateList.invalidateByTemplateEvents, batchUpdateList.pushCacheEntryEvents, batchUpdateList.pushECFEvents, batchUpdateList.aliasEntryEvents);
                                    object.batchUpdate(batchUpdateList.invalidateByIdEvents, batchUpdateList.invalidateByTemplateEvents, batchUpdateList.pushCacheEntryEvents, batchUpdateList.aliasEntryEvents);
                                }
                                finally {
                                    if (batchUpdateList != null) {
                                        iterator2 = batchUpdateList.pushCacheEntryEvents.iterator();
                                        while (iterator2.hasNext()) {
                                            ((com.ibm.websphere.cache.CacheEntry)iterator2.next()).finish();
                                        }
                                    }
                                }
                            } else {
                                object.batchUpdate(((BatchUpdateList)object2).invalidateByIdEvents, ((BatchUpdateList)object2).invalidateByTemplateEvents, ((BatchUpdateList)object2).pushCacheEntryEvents, ((BatchUpdateList)object2).aliasEntryEvents);
                            }
                        }
                    }
                    if (((BatchUpdateList)object2).invalidateByIdEvents.size() > 0 || ((BatchUpdateList)object2).invalidateByTemplateEvents.size() > 0) {
                        ((BatchUpdateList)object2).cache.batchUpdate(((BatchUpdateList)object2).invalidateByIdEvents, ((BatchUpdateList)object2).invalidateByTemplateEvents, EMPTY_ARRAYLIST);
                    }
                    if ((((BatchUpdateList)object2).invalidateByIdEvents.size() > 0 || ((BatchUpdateList)object2).invalidateByTemplateEvents.size() > 0 || ((BatchUpdateList)object2).pushECFEvents.size() > 0) && ((BatchUpdateList)object2).cache.getCacheConfig().enableServletSupport) {
                        this.externalCacheServices.batchUpdate(((BatchUpdateList)object2).invalidateByIdEvents, ((BatchUpdateList)object2).invalidateByTemplateEvents, ((BatchUpdateList)object2).pushECFEvents);
                    }
                }
                finally {
                    object = ((ArrayList)((Object)iterator)).iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            ((ArrayList)((Object)iterator)).clear();
                        }
                        ((com.ibm.websphere.cache.CacheEntry)object.next()).finish();
                    }
                }
                ++n;
            }
            return;
        }
        finally {
            Map map = ServerCache.getCacheInstances();
            for (DCache dCache : map.values()) {
                dCache.refreshCachePerf();
            }
            if (ServerCache.cache != null) {
                ServerCache.cache.refreshCachePerf();
            }
        }
    }

    private void cleanUpEventLists(DCache dCache, HashMap hashMap, HashMap hashMap2, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        Object object;
        Iterator<Object> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            InvalidateByIdEvent invalidateByIdEvent = (InvalidateByIdEvent)iterator.next();
            object = invalidateByIdEvent.getId();
            com.ibm.websphere.cache.CacheEntry cacheEntry = dCache.getEntryFromMemory(object);
            if (cacheEntry == null || invalidateByIdEvent.getTimeStamp() >= cacheEntry.getTimeStamp()) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing from Batch Update List: " + invalidateByIdEvent.getId() + " ts: " + invalidateByIdEvent.getTimeStamp() + " CE.ts: " + cacheEntry.getTimeStamp());
            }
            iterator.remove();
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n;
            boolean bl = false;
            object = (CacheEntry)iterator.next();
            if (hashMap.containsKey(((CacheEntry)object).id)) {
                bl = true;
            }
            for (n = 0; !bl && n < ((CacheEntry)object)._dataIds.length; ++n) {
                if (!hashMap.containsKey(((CacheEntry)object)._dataIds[n])) continue;
                bl = true;
            }
            for (n = 0; !bl && n < ((CacheEntry)object)._templates.length; ++n) {
                if (!hashMap2.containsKey(((CacheEntry)object)._templates[n])) continue;
                bl = true;
            }
            if (!bl && !((CacheEntry)object).prepareForSerialization()) {
                bl = true;
            }
            if (!bl) continue;
            iterator.remove();
        }
        iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            object = (AliasEntry)iterator.next();
            if (hashMap.containsKey(((AliasEntry)object).id)) {
                bl = true;
            } else {
                for (Object object2 : arrayList) {
                    if (!((CacheEntry)object2).id.equals(((AliasEntry)object).id) || ((CacheEntry)object2).getTimeStamp() <= ((CacheEntry)object).getTimeStamp()) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            iterator.remove();
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Object object2;
            boolean bl = false;
            object = (ExternalCacheFragment)iterator.next();
            Enumeration enumeration = ((ExternalCacheFragment)object).getTemplates();
            while (!bl && enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                if (!hashMap2.containsKey(object2)) continue;
                bl = true;
            }
            enumeration = ((ExternalCacheFragment)object).getInvalidationIds();
            while (!bl && enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                if (!hashMap.containsKey(object2)) continue;
                bl = true;
            }
            if (!bl) continue;
            iterator.remove();
        }
    }

    private final BatchUpdateList getUpdateList(DCache dCache) {
        BatchUpdateList batchUpdateList = (BatchUpdateList)this.updates.get(dCache);
        if (batchUpdateList == null) {
            batchUpdateList = new BatchUpdateList();
            batchUpdateList.cache = dCache;
            if (dCache.getCacheConfig().isDefaultCacheProvider()) {
                this.updates.put(dCache, batchUpdateList);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING getUpdateList called for " + dCache.getCacheName());
            }
        }
        return batchUpdateList;
    }

    private void addToDRSBuffer(BatchUpdateList batchUpdateList) {
        if (batchUpdateList != null) {
            BatchUpdateList batchUpdateList2 = (BatchUpdateList)this.drsBuffer.get(batchUpdateList.cache);
            if (batchUpdateList2 != null) {
                DCache dCache = batchUpdateList.cache;
                BatchUpdateList batchUpdateList3 = this.mergeLists(batchUpdateList2, batchUpdateList);
                int n = dCache.getCacheConfig().cacheSize / 20;
                int n2 = batchUpdateList3.aliasEntryEvents.size() + batchUpdateList3.invalidateByIdEvents.size() + batchUpdateList3.invalidateByTemplateEvents.size() + batchUpdateList3.pushCacheEntryEvents.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "list.congestionCount: " + batchUpdateList3.congestionCount);
                    Tr.debug(tc, "drsCongestionThreshold: " + this.drsCongestionThreshold);
                    Tr.debug(tc, "size: " + n2);
                    Tr.debug(tc, "thresholdSize: " + n);
                }
                if (batchUpdateList3.congestionCount++ > this.drsCongestionThreshold && n2 > n) {
                    Tr.event(tc, "Disabling replication due to DRS congestion for cache instance: " + batchUpdateList3.cache.getCacheName() + ", invalidatedByIdEvents:" + batchUpdateList3.invalidateByIdEvents.size() + " invalidateByTemplateEvents:" + batchUpdateList3.invalidateByTemplateEvents.size() + " pushCacheEntryEvents:" + batchUpdateList3.pushCacheEntryEvents.size() + " aliasEntryEvents:" + batchUpdateList3.aliasEntryEvents.size());
                    batchUpdateList3.cache.getCacheConfig().setDrsDisabled(true);
                    this.drsBuffer.remove(batchUpdateList3.cache);
                } else {
                    this.drsBuffer.put(batchUpdateList3.cache, batchUpdateList3);
                }
            } else {
                this.drsBuffer.put(batchUpdateList.cache, batchUpdateList);
            }
        }
    }

    private BatchUpdateList mergeLists(BatchUpdateList batchUpdateList, BatchUpdateList batchUpdateList2) {
        BatchUpdateList batchUpdateList3 = new BatchUpdateList();
        batchUpdateList3.cache = batchUpdateList.cache;
        batchUpdateList3.congestionCount = batchUpdateList.congestionCount;
        if (batchUpdateList.invalidateByIdEvents.size() > 0) {
            batchUpdateList3.invalidateByIdEvents.putAll(batchUpdateList.invalidateByIdEvents);
        }
        if (batchUpdateList2.invalidateByIdEvents.size() > 0) {
            batchUpdateList3.invalidateByIdEvents.putAll(batchUpdateList2.invalidateByIdEvents);
        }
        batchUpdateList.invalidateByIdEvents.clear();
        if (batchUpdateList.invalidateByTemplateEvents.size() > 0) {
            batchUpdateList3.invalidateByTemplateEvents.putAll(batchUpdateList.invalidateByTemplateEvents);
        }
        if (batchUpdateList2.invalidateByTemplateEvents.size() > 0) {
            batchUpdateList3.invalidateByTemplateEvents.putAll(batchUpdateList2.invalidateByTemplateEvents);
        }
        batchUpdateList.invalidateByTemplateEvents.clear();
        ArrayList<com.ibm.websphere.cache.CacheEntry> arrayList = new ArrayList<com.ibm.websphere.cache.CacheEntry>();
        for (com.ibm.websphere.cache.CacheEntry cacheEntry : batchUpdateList2.pushCacheEntryEvents) {
            for (com.ibm.websphere.cache.CacheEntry cacheEntry2 : batchUpdateList.pushCacheEntryEvents) {
                if (cacheEntry2 == null || !cacheEntry2.getIdObject().equals(cacheEntry.getIdObject())) continue;
                arrayList.add(cacheEntry2);
            }
        }
        batchUpdateList.pushCacheEntryEvents.removeAll(arrayList);
        arrayList.clear();
        batchUpdateList3.pushCacheEntryEvents.addAll(batchUpdateList.pushCacheEntryEvents);
        batchUpdateList3.pushCacheEntryEvents.addAll(batchUpdateList2.pushCacheEntryEvents);
        batchUpdateList.pushCacheEntryEvents.clear();
        for (com.ibm.websphere.cache.CacheEntry cacheEntry : batchUpdateList2.aliasEntryEvents) {
            for (com.ibm.websphere.cache.CacheEntry cacheEntry2 : batchUpdateList.aliasEntryEvents) {
                if (cacheEntry2 == null || !((AliasEntry)cacheEntry2).id.equals(((AliasEntry)cacheEntry).id)) continue;
                arrayList.add(cacheEntry2);
            }
        }
        batchUpdateList.aliasEntryEvents.removeAll(arrayList);
        arrayList.clear();
        batchUpdateList3.aliasEntryEvents.addAll(batchUpdateList.aliasEntryEvents);
        batchUpdateList3.aliasEntryEvents.addAll(batchUpdateList2.aliasEntryEvents);
        batchUpdateList.aliasEntryEvents.clear();
        return batchUpdateList3;
    }

    static class BatchUpdateList {
        public DCache cache;
        public int congestionCount = 0;
        public HashMap invalidateByIdEvents = new HashMap();
        public HashMap invalidateByTemplateEvents = new HashMap();
        public ArrayList pushCacheEntryEvents = new ArrayList();
        public ArrayList pushECFEvents = new ArrayList();
        public ArrayList aliasEntryEvents = new ArrayList();

        BatchUpdateList() {
        }
    }
}

