/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.ChangeEvent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.websphere.cache.PreInvalidationListener;
import com.ibm.ws.cache.AliasEntry;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheOnDisk;
import com.ibm.ws.cache.CacheStatisticsImpl;
import com.ibm.ws.cache.DCacheBase;
import com.ibm.ws.cache.DependencyTable;
import com.ibm.ws.cache.DynacacheOnDisk;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.FastHashtable;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.NullCachePerfModule;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.TimeLimitDaemon;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.intf.CacheStatisticsListener;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.stat.CacheStatsModule;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.CacheStatistics;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class Cache
extends DCacheBase
implements DCache {
    private static TraceComponent tc = Trace.register(Cache.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static final ArrayList EMPTY_ARRAY_LIST = new ArrayList();
    public static final int LOGGING_WINDOW = 1000;
    private static final int STATISTICS_WINDOW = 1000;
    private long lastCachePerf_maxNumberCacheEntries = 0L;
    private long lastCachePerf_entryHashtableSize = 0L;
    private long lastCachePerf_objectsOnDisk = 0L;
    private long lastCachePerf_pendingRemovalFromDisk = 0L;
    private long lastCachePerf_dependencyIdsOnDisk = 0L;
    private long lastCachePerf_dependencyIdsBufferedForDisk = 0L;
    private long lastCachePerf_dependencyIdsOffloadedToDisk = 0L;
    private long lastCachePerf_dependencyIdBasedInvalidationsFromDisk = 0L;
    private long lastCachePerf_templatesOnDisk = 0L;
    private long lastCachePerf_templatesBufferedForDisk = 0L;
    private long lastCachePerf_templatesOffloadedToDisk = 0L;
    private long lastCachePerf_templateBasedInvalidationsFromDisk = 0L;
    private long lastTimeForStatistics = 0L;
    private BatchUpdateDaemon batchUpdateDaemon = null;
    private RemoteServices remoteServices = null;
    private TimeLimitDaemon timeLimitDaemon = null;
    private CacheEntry.CacheEntryPool cacheEntryPool = null;
    private DependencyTable dataDependencyTable = null;
    private DependencyTable templateDependencyTable = null;
    private FastHashtable entryHashtable = null;
    private int defaultPriority = CacheEntry.DEFAULT_PRIORITY;
    private DynacacheOnDisk diskCache = null;
    private boolean flushToDiskComplete = false;
    private boolean enableDiskCacheSizeInBytesChecking = false;
    private int entriesInMemoryRemoved = 0;
    private int entriesInDiskRemoved = 0;
    private long diskCacheEntrySizeInMBEvictedCount = 0L;
    private long diskCacheSizeInGBEvictedCount = 0L;
    private long diskCacheSizeEvictedCount = 0L;
    private long diskCacheEntrySizeInMBEvictedLimit = 1L;
    private long diskCacheSizeInGBEvictedLimit = 1L;
    private long diskCacheSizeEvictedLimit = 1L;
    CacheEntry.LRUHead[] lruBuckets = null;
    int lruTop = 0;
    private int cacheSizeLimit = 0;

    protected Cache(String string, CacheConfig cacheConfig) {
        super(string, cacheConfig);
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Cache() CTOR cacheName:" + string);
        }
        this.swapToDisk = cacheConfig.enableDiskOffload;
        this.ignoreValueInInvalidationEvent = cacheConfig.ignoreValueInInvalidationEvent;
        this.defaultPriority = cacheConfig.cachePriority;
        this.setStoreCookies(string, cacheConfig);
        int n2 = Math.min(1000, cacheConfig.cacheSize / 10);
        this.cacheEntryPool = CacheEntry.createCacheEntryPool(this, n2);
        this.lruBuckets = new CacheEntry.LRUHead[CacheEntry.MAX_PRIORITY + 1];
        for (n = 0; n < this.lruBuckets.length; ++n) {
            this.lruBuckets[n] = new CacheEntry.LRUHead();
            this.lruBuckets[n].priority = n;
        }
        this.entryHashtable = new FastHashtable(cacheConfig.cacheSize);
        if (!cacheConfig.disableDependencyId) {
            this.dataDependencyTable = new DependencyTable(0, cacheConfig.cacheSize / 3);
        }
        if (!cacheConfig.disableTemplatesSupport) {
            this.templateDependencyTable = new DependencyTable(0, cacheConfig.cacheSize / 10);
        }
        n = cacheConfig.lruToDiskTriggerPercent;
        this.cacheSizeLimit = cacheConfig.cacheSize;
        if (this.swapToDisk) {
            this.diskCache = new CacheOnDisk(cacheConfig, this);
            if (!this.swapToDisk) {
                this.diskCache = null;
                n = 0;
            } else {
                n = 0;
                if (cacheConfig.lruToDiskTriggerPercent > 100 || cacheConfig.lruToDiskTriggerPercent < 0) {
                    Tr.warning(tc, "DYNA0069W", new Object[]{new Integer(cacheConfig.lruToDiskTriggerPercent), "lruToDiskTriggerPercent", string, new Integer(0), new Integer(100), new Integer(0)});
                } else {
                    n = cacheConfig.lruToDiskTriggerPercent;
                }
                if (cacheConfig.lruToDiskTriggerPercent > 0) {
                    this.cacheSizeLimit = cacheConfig.cacheSize + cacheConfig.cacheSize * cacheConfig.lruToDiskTriggerPercent / 100;
                }
            }
        } else {
            n = 0;
        }
        cacheConfig.lruToDiskTriggerPercent = n;
        this.createCachePerf();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Cache() CTOR cacheName=" + string + " cache=" + this + " useServerClassLoader:" + cacheConfig.useServerClassLoader + " filterTimeOutInvalidation:" + cacheConfig.filterTimeOutInvalidation + " filterLRUInvalidation:" + cacheConfig.filterLRUInvalidation + " lruToDiskTriggerPercent=" + cacheConfig.lruToDiskTriggerPercent + " cacheSizeLimit=" + this.cacheSizeLimit + " cascadeCachespecProperties=" + cacheConfig.cascadeCachespecProperties);
        }
    }

    private void setStoreCookies(String string, CacheConfig cacheConfig) {
        boolean bl = true;
        if (cacheConfig.disableStoreCookies.equalsIgnoreCase("All")) {
            bl = false;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(cacheConfig.disableStoreCookies, ":");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (!string2.equals(string) && !string2.equalsIgnoreCase("All")) continue;
                bl = false;
                break;
            }
        }
        cacheConfig.setCacheInstanceStoreCookies(bl);
        if (!bl && tc.isDebugEnabled()) {
            Tr.debug(tc, " Store_Cookies property disabled for cacheName:" + string);
        }
    }

    public void finalize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finalize() cacheName=" + this.cacheName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finalize() cache=" + this);
        }
    }

    public CacheStatistics getCacheStatistics() {
        CacheStatisticsImpl cacheStatisticsImpl = new CacheStatisticsImpl();
        cacheStatisticsImpl.setCacheHitsCount(this.cacheStatisticsListener.getCacheHitsCount());
        cacheStatisticsImpl.setCacheLruRemovesCount(this.cacheStatisticsListener.getCacheLruRemovesCount());
        cacheStatisticsImpl.setCacheMissesCount(this.cacheStatisticsListener.getCacheMissesCount());
        cacheStatisticsImpl.setCacheRemovesCount(this.cacheStatisticsListener.getCacheRemovesCount());
        cacheStatisticsImpl.setExplicitInvalidationsFromMemoryCount(this.cacheStatisticsListener.getExplicitInvalidationsFromMemoryCount());
        cacheStatisticsImpl.setMemoryCacheEntriesCount(this.getNumberCacheEntries());
        cacheStatisticsImpl.setMemoryCacheSizeInMBCount(-1.0f);
        cacheStatisticsImpl.setTimeoutInvalidationsFromMemoryCount(this.cacheStatisticsListener.getTimeoutInvalidationsFromMemoryCount());
        TreeMap<String, Number> treeMap = new TreeMap<String, Number>();
        treeMap.put("OverflowEntriesFromMemory", this.cacheStatisticsListener.getOverflowEntriesFromMemoryCount());
        treeMap.put("ExplicitInvalidationsFromDisk", this.cacheStatisticsListener.getExplicitInvalidationsFromDiskCount());
        treeMap.put("ExplicitInvalidationsLocal", this.cacheStatisticsListener.getExplicitInvalidationsLocalCount());
        treeMap.put("ExplicitInvalidationsRemote", this.cacheStatisticsListener.getExplicitInvalidationsRemoteCount());
        treeMap.put("TimeoutInvalidationsFromDisk", this.cacheStatisticsListener.getTimeoutInvalidationsFromDiskCount());
        treeMap.put("GarbageCollectorInvalidationsFromDisk", this.cacheStatisticsListener.getGarbageCollectorInvalidationsFromDiskCount());
        treeMap.put("DependencyIdsOffloadedToDisk", this.cacheStatisticsListener.getDepIdsOffloadedToDiskCount());
        treeMap.put("DependencyIdBasedInvalidationsFromDisk", this.cacheStatisticsListener.getDepIdBasedInvalidationsFromDiskCount());
        treeMap.put("TemplatesOffloadedToDisk", this.cacheStatisticsListener.getTemplatesOffloadedToDiskCount());
        treeMap.put("TemplateBasedInvalidationsFromDisk", this.cacheStatisticsListener.getTemplateBasedInvalidationsFromDiskCount());
        treeMap.put("OverflowInvalidationsFromDisk", this.cacheStatisticsListener.getOverflowInvalidationsFromDiskCount());
        treeMap.put("ObjectsReadFromDisk", this.cacheStatisticsListener.getObjectsReadFromDiskCount());
        treeMap.put("ObjectsReadFromDisk4K", this.cacheStatisticsListener.getObjectsReadFromDisk4KCount());
        treeMap.put("ObjectsReadFromDisk40K", this.cacheStatisticsListener.getObjectsReadFromDisk40KCount());
        treeMap.put("ObjectsReadFromDisk400K", this.cacheStatisticsListener.getObjectsReadFromDisk400KCount());
        treeMap.put("ObjectsReadFromDisk4000K", this.cacheStatisticsListener.getObjectsReadFromDisk4000KCount());
        treeMap.put("ObjectsReadFromDiskSize", this.cacheStatisticsListener.getObjectsReadFromDiskSizeCount());
        treeMap.put("ObjectsWriteToDisk", this.cacheStatisticsListener.getObjectsWriteToDiskCount());
        treeMap.put("ObjectsWriteToDisk4K", this.cacheStatisticsListener.getObjectsWriteToDisk4KCount());
        treeMap.put("ObjectsWriteToDisk40K", this.cacheStatisticsListener.getObjectsWriteToDisk40KCount());
        treeMap.put("ObjectsWriteToDisk400K", this.cacheStatisticsListener.getObjectsWriteToDisk400KCount());
        treeMap.put("ObjectsWriteToDisk4000K", this.cacheStatisticsListener.getObjectsWriteToDisk4000KCount());
        treeMap.put("ObjectsWriteToDiskSize", this.cacheStatisticsListener.getObjectsWriteToDiskSizeCount());
        treeMap.put("ObjectsDeleteFromDisk", this.cacheStatisticsListener.getObjectsDeleteFromDiskCount());
        treeMap.put("ObjectsDeleteFromDisk4K", this.cacheStatisticsListener.getObjectsDeleteFromDisk4KCount());
        treeMap.put("ObjectsDeleteFromDisk40K", this.cacheStatisticsListener.getObjectsDeleteFromDisk40KCount());
        treeMap.put("ObjectsDeleteFromDisk400K", this.cacheStatisticsListener.getObjectsDeleteFromDisk400KCount());
        treeMap.put("ObjectsDeleteFromDisk4000K", this.cacheStatisticsListener.getObjectsDeleteFromDisk4000KCount());
        treeMap.put("ObjectsDeleteFromDiskSize", this.cacheStatisticsListener.getObjectsDeleteFromDiskSizeCount());
        treeMap.put("RemoteInvalidationNotifications", this.cacheStatisticsListener.getRemoteInvalidationNotificationsCount());
        treeMap.put("RemoteUpdateNotifications", this.cacheStatisticsListener.getRemoteUpdateNotificationsCount());
        treeMap.put("RemoteObjectUpdates", this.cacheStatisticsListener.getRemoteObjectUpdatesCount());
        treeMap.put("RemoteObjectUpdateSize", this.cacheStatisticsListener.getRemoteObjectUpdateSizeCount());
        treeMap.put("RemoteObjectHits", this.cacheStatisticsListener.getRemoteObjectHitsCount());
        treeMap.put("RemoteObjectFetchSize", this.cacheStatisticsListener.getRemoteObjectFetchSizeCount());
        treeMap.put("RemoteObjectMisses", this.cacheStatisticsListener.getRemoteObjectMissesCount());
        treeMap.put("ObjectsAsyncLruToDisk", this.cacheStatisticsListener.getObjectsAsyncLruToDiskCount());
        treeMap.put("ObjectsOnDisk", Long.valueOf(this.getIdsSizeDisk()));
        treeMap.put("DiskCacheSizeInMB", Float.valueOf(this.getDiskCacheSizeInMBs()));
        treeMap.put("DependencyIdsOnDisk", Long.valueOf(this.getDepIdsSizeDisk()));
        treeMap.put("TemplatesOnDisk", Long.valueOf(this.getTemplatesSizeDisk()));
        treeMap.put("PendingRemovalFromDisk", Long.valueOf(this.getPendingRemovalSizeDisk()));
        treeMap.put("DependencyIdsBufferedForDisk", Long.valueOf(this.getDepIdsBufferedSizeDisk()));
        treeMap.put("TemplatesBufferedForDisk", Long.valueOf(this.getTemplatesBufferedSizeDisk()));
        treeMap.put("PushPullTableSize", Long.valueOf(this.getPushPullTableSize()));
        cacheStatisticsImpl.setExtendedStats(treeMap);
        return cacheStatisticsImpl;
    }

    public void setBatchUpdateDaemon(BatchUpdateDaemon batchUpdateDaemon) {
        assert (this.batchUpdateDaemon == null);
        assert (batchUpdateDaemon != null);
        this.batchUpdateDaemon = batchUpdateDaemon;
    }

    protected void setCacheStatisticsListener(CacheStatisticsListener cacheStatisticsListener) {
        assert (this.cacheStatisticsListener == null);
        assert (cacheStatisticsListener != null);
        this.cacheStatisticsListener = cacheStatisticsListener;
    }

    public void setTimeLimitDaemon(TimeLimitDaemon timeLimitDaemon) {
        assert (this.timeLimitDaemon == null);
        assert (timeLimitDaemon != null);
        this.timeLimitDaemon = timeLimitDaemon;
    }

    public void setRemoteServices(RemoteServices remoteServices) {
        assert (this.remoteServices == null);
        assert (remoteServices != null);
        this.remoteServices = remoteServices;
    }

    public RemoteServices getRemoteServices() {
        assert (this.remoteServices != null);
        return this.remoteServices;
    }

    protected void setDefaultPriority(int n) {
        assert (n >= 0);
        if (n < 0) {
            n = CacheEntry.DEFAULT_PRIORITY;
        }
        this.defaultPriority = n;
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public void start() {
        if (this.timeLimitDaemon == null || this.batchUpdateDaemon == null || this.cacheStatisticsListener == null || this.remoteServices == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TLD: " + this.timeLimitDaemon);
                Tr.debug(tc, "BUD: " + this.batchUpdateDaemon);
                Tr.debug(tc, "CSL: " + this.cacheStatisticsListener);
                Tr.debug(tc, "RS: " + this.remoteServices);
            }
            throw new IllegalStateException("batchUpdateDaemon, cacheStatisticsListener, remoteServices, and timeLimitDaemon must all be set before start()");
        }
        this.timeLimitDaemon.createExpirationMetaData(this);
        this.flushToDiskComplete = false;
        if (this.swapToDisk) {
            if (this.diskCache.getStartState() == 1 || this.diskCache.shouldPopulateEvictionTable()) {
                this.diskCache.invokeDiskCleanup(true);
            } else if (this.diskCache.getStartState() == 2) {
                this.diskCache.invokeDiskCleanup(false);
            }
        }
    }

    public com.ibm.websphere.cache.CacheEntry setEntry(CacheEntry cacheEntry, int n, boolean bl, boolean bl2, boolean bl3) {
        CacheEntry cacheEntry2 = null;
        if (!bl && this.cachePerf.isPMIEnabled() && n == 5) {
            this.cachePerf.onRequest(cacheEntry.getTemplate(), n);
        }
        Object object = cacheEntry.getIdObject();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setEntry() cacheName=" + this.cacheName + " id=" + object + " sharing policy=" + cacheEntry.getSharingPolicy() + " timeToLive=" + cacheEntry.getTimeLimit());
        }
        cacheEntry2 = this._syncSetEntry(cacheEntry, n, bl, bl3);
        if (!(cacheEntry2.skipMemoryAndWriteToDisk || cacheEntry2.timeLimit <= 0 && cacheEntry2.inactivity <= 0)) {
            this.timeLimitDaemon.valueHasChanged(this, cacheEntry2.id, cacheEntry2.expirationTime, cacheEntry2.inactivity);
        }
        if (cacheEntry2.getSharingPolicy() == 1 || cacheEntry2.skipMemoryAndWriteToDiskErrorCode != 0) {
            cacheEntry2.finish();
            return cacheEntry2;
        }
        if (n == 2 && cacheEntry.getSharingPolicy() == 2) {
            byte[] byArray = cacheEntry.getSerializedValue();
            int n2 = 0;
            if (byArray != null) {
                n2 = byArray.length;
            }
            this.cacheStatisticsListener.remoteObjectUpdates(object, n2);
        }
        if (bl2) {
            this.updatePeerCaches(cacheEntry2);
        } else {
            cacheEntry2.finish();
        }
        return cacheEntry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry getCacheEntry(Object object, boolean bl, boolean bl2, String string, boolean bl3) {
        CacheEntry cacheEntry;
        if (bl3) {
            if (this.cacheConfig.alwaysSynchronizeOnGets) {
                Cache cache = this;
                synchronized (cache) {
                    cacheEntry = (CacheEntry)this.entryHashtable.get(object, bl3);
                    if (cacheEntry != null && !cacheEntry.invalid && !cacheEntry.removeWhenUnpinned) {
                        this.updateLruLocation(cacheEntry);
                        if (cacheEntry.inactivity > 0) {
                            this.timeLimitDaemon.valueWasAccessed(this, cacheEntry.id, cacheEntry.expirationTime, cacheEntry.inactivity);
                        }
                    }
                }
            } else {
                cacheEntry = (CacheEntry)this.entryHashtable.get(object, bl3);
                if (cacheEntry != null && !cacheEntry.invalid && !cacheEntry.removeWhenUnpinned) {
                    this.updateLruLocation(cacheEntry);
                    if (cacheEntry.inactivity > 0) {
                        this.timeLimitDaemon.valueWasAccessed(this, cacheEntry.id, cacheEntry.expirationTime, cacheEntry.inactivity);
                    }
                }
            }
        } else {
            cacheEntry = (CacheEntry)this.entryHashtable.get(object, bl3);
        }
        if (cacheEntry != null) {
            if (!bl2) {
                this.cacheStatisticsListener.localCacheHit(object, 1);
                if (this.cachePerf.isPMIEnabled() && cacheEntry != null && (cacheEntry.value != null || cacheEntry.serializedValue != null)) {
                    this.cachePerf.onCacheHit(cacheEntry.getTemplate(), 1);
                }
            }
            return cacheEntry;
        }
        if (cacheEntry == null && this.swapToDisk && (cacheEntry = this.diskCache.readCacheEntry(object)) != null) {
            if (bl3) {
                ++cacheEntry.refCount;
            }
            cacheEntry.loadedFromDisk = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCacheEntry() cacheName=" + this.cacheName + " found on disk for id " + object + ", monitor = " + bl2 + " skipMemoryAndWriteToDisk=" + cacheEntry.skipMemoryAndWriteToDisk);
            }
            if (!bl2) {
                this.cacheStatisticsListener.localCacheHit(object, 3);
            }
            if (this.cachePerf.isPMIEnabled() && !bl2) {
                this.cachePerf.onCacheHit(cacheEntry.getTemplate(), 3);
            }
            if (cacheEntry.skipMemoryAndWriteToDisk) {
                return cacheEntry;
            }
            cacheEntry = (CacheEntry)this.setEntry(cacheEntry, 3, bl2, false, false);
            return cacheEntry;
        }
        if (cacheEntry == null && bl) {
            cacheEntry = this.remoteServices.getEntry(object);
            if (cacheEntry != null) {
                if (bl3) {
                    ++cacheEntry.refCount;
                }
                if (!bl2) {
                    int n = 0;
                    byte[] byArray = cacheEntry.getSerializedValue();
                    if (byArray != null) {
                        n = byArray.length;
                    }
                    this.cacheStatisticsListener.remoteObjectHits(cacheEntry.id, n);
                }
                if (this.cachePerf.isPMIEnabled() && !bl2) {
                    this.cachePerf.onCacheHit(cacheEntry.getTemplate(), 2);
                }
                cacheEntry = (CacheEntry)this.setEntry(cacheEntry, 2, bl2, false, false);
            } else {
                if (!bl2) {
                    this.cacheStatisticsListener.remoteObjectMisses(object);
                }
                if (this.cachePerf.isPMIEnabled() && !bl2) {
                    this.cachePerf.onCacheMiss(string, 5);
                }
            }
        } else {
            if (!bl2) {
                this.cacheStatisticsListener.cacheMiss(object);
            }
            if (this.cachePerf.isPMIEnabled() && !bl2) {
                this.cachePerf.onCacheMiss(string, 5);
            }
        }
        return cacheEntry;
    }

    private synchronized CacheEntry _syncSetEntry(CacheEntry cacheEntry, int n, boolean bl, boolean bl2) {
        Object e2;
        Enumeration enumeration;
        int n2 = -1;
        if (!(this.hasPushPullEntries || cacheEntry.sharingPolicy != 4 && cacheEntry.sharingPolicy != 3)) {
            this.hasPushPullEntries = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_syncSetEntry() Entry uses Push-Pull or Pull mode cacheName=" + this.cacheName + " id=" + cacheEntry.id);
            }
        }
        CacheEntry cacheEntry2 = (CacheEntry)this.entryHashtable.get(cacheEntry.id);
        if (!bl && this.cachePerf.isPMIEnabled() && n != 3 && (cacheEntry.getSharingPolicy() != 3 && cacheEntry.getSharingPolicy() != 4 || n != 2) && cacheEntry2 == null) {
            this.cachePerf.onEntryCreation(cacheEntry.getTemplate(), n);
        }
        CacheEntry cacheEntry3 = null;
        if (cacheEntry2 == null) {
            n2 = 2;
            if (this.swapToDisk && cacheEntry.skipMemoryAndWriteToDisk) {
                this.writeToDiskDirectly(cacheEntry, n2, n);
                return cacheEntry;
            }
            cacheEntry3 = this.getFreeLruEntry();
            this.entryHashtable.put(cacheEntry.id, cacheEntry3);
            if (this.swapToDisk && !cacheEntry.loadedFromDisk && this.diskCache.containsKey(cacheEntry.id)) {
                this.diskCache.delCacheEntry(cacheEntry, 1, n, false);
                n2 = 1;
            }
        } else {
            n2 = 1;
            if (this.swapToDisk && cacheEntry.skipMemoryAndWriteToDisk) {
                this.entryHashtable.remove(cacheEntry2.id);
                if (cacheEntry2.timeLimit > 0 || cacheEntry2.inactivity > 0) {
                    this.timeLimitDaemon.valueWasRemoved(this, cacheEntry2.id);
                }
                this.removeInvalidationInfo(cacheEntry2);
                for (int i = 0; i < cacheEntry.aliasList.length; ++i) {
                    this.entryHashtable.remove(cacheEntry2.aliasList[i]);
                }
                if (cacheEntry2.refCount <= 0) {
                    cacheEntry2.returnToPool();
                } else {
                    cacheEntry2.removeWhenUnpinned = true;
                    cacheEntry2.lruHead.remove(cacheEntry2);
                }
                this.writeToDiskDirectly(cacheEntry, n2, n);
                return cacheEntry;
            }
            if (cacheEntry.loadedFromDisk && cacheEntry2.loadedFromDisk) {
                if (cacheEntry.refCount > 0 && cacheEntry2 != cacheEntry) {
                    cacheEntry2.refCount += 2;
                }
                return cacheEntry2;
            }
            if (cacheEntry2.timeStamp > cacheEntry.timeStamp) {
                Tr.debug(tc, "_syncSetEntry() cacheName=" + this.cacheName + " ERROR: attempting to overwrite " + "cacheEntry with older cacheEntry: " + cacheEntry.id);
            }
            if (this.swapToDisk && cacheEntry2.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry2, 1, n, false);
            }
            if (cacheEntry2.refCount == 0) {
                cacheEntry3 = cacheEntry2;
            } else {
                cacheEntry3 = this.getFreeLruEntry();
                this.entryHashtable.put(cacheEntry.id, cacheEntry3);
                cacheEntry2.removeWhenUnpinned = true;
                cacheEntry2.lruHead.remove(cacheEntry2);
            }
            this.removeInvalidationInfo(cacheEntry2);
            enumeration = cacheEntry2.getAliasList();
            while (enumeration.hasMoreElements()) {
                e2 = enumeration.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_syncSetEntry() cacheName=" + this.cacheName + " removing alias from EHT id=" + cacheEntry.id + " alias=" + e2);
                }
                this.entryHashtable.remove(e2);
            }
        }
        this.updateInvalidationHashtable(cacheEntry);
        cacheEntry3.copy(cacheEntry);
        this.updateLruLocation(cacheEntry3);
        enumeration = cacheEntry3.getAliasList();
        while (enumeration.hasMoreElements()) {
            e2 = enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_syncSetEntry() cacheName=" + this.cacheName + " adding alias to EHT id=" + cacheEntry.id + " alias=" + e2);
            }
            this.entryHashtable.put(e2, cacheEntry3);
        }
        ++cacheEntry3.refCount;
        if (bl2) {
            ++cacheEntry3.refCount;
        }
        if (this.bEnableListener && this.eventSource.getChangeListenerCount() > 0 && n != 3) {
            int n3 = 1;
            if (n == 2) {
                n3 = 2;
            }
            Object object = null;
            object = cacheEntry3.serializedValue != null ? cacheEntry3.serializedValue : (Object)cacheEntry3.getValue();
            ChangeEvent changeEvent = new ChangeEvent(cacheEntry3.id, object, n2, n3, this.cacheNameNonPrefixed);
            this.eventSource.cacheEntryChanged(changeEvent);
        }
        return cacheEntry3;
    }

    private void writeToDiskDirectly(CacheEntry cacheEntry, int n, int n2) {
        ++cacheEntry.refCount;
        if (this.lruToDisk(cacheEntry)) {
            n = 1;
        }
        if (cacheEntry.skipMemoryAndWriteToDiskErrorCode == 0 && this.bEnableListener && this.eventSource.getChangeListenerCount() > 0) {
            int n3 = 1;
            if (n2 == 2) {
                n3 = 2;
            }
            Object object = null;
            object = cacheEntry.serializedValue != null ? cacheEntry.serializedValue : (Object)cacheEntry.getValue();
            ChangeEvent changeEvent = new ChangeEvent(cacheEntry.id, object, n, n3, this.cacheNameNonPrefixed);
            this.eventSource.cacheEntryChanged(changeEvent);
        }
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo entryInfo, boolean bl) {
        CacheEntry cacheEntry;
        Object object = entryInfo.getIdObject();
        if (object == null) {
            return null;
        }
        boolean bl2 = false;
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onRequest(entryInfo.getTemplate(), 5);
        }
        if (bl) {
            bl2 = this.shouldPull(entryInfo.getSharingPolicy(), object);
        }
        if ((cacheEntry = this.getCacheEntry(object, bl2, false, entryInfo.getTemplate(), true)) != null && cacheEntry.getExpirationTime() > 0L && cacheEntry.getExpirationTime() < System.currentTimeMillis()) {
            cacheEntry.finish();
            cacheEntry = null;
        }
        return cacheEntry;
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo entryInfo) {
        Object object = entryInfo.getIdObject();
        if (object == null) {
            return null;
        }
        return this.getEntry(entryInfo, true);
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(Object object, int n, boolean bl, boolean bl2) {
        if (object == null) {
            return null;
        }
        CacheEntry cacheEntry = this.getCacheEntry(object, false, bl, null, bl2);
        if (this.cachePerf.isPMIEnabled() && !bl && cacheEntry != null && n == 2) {
            this.cachePerf.onRequest(cacheEntry.getTemplate(), 2);
        }
        return cacheEntry;
    }

    public synchronized void refreshEntry(com.ibm.websphere.cache.CacheEntry cacheEntry) {
        this.updateLruLocation((CacheEntry)cacheEntry);
    }

    private final synchronized void updateLruLocation(CacheEntry cacheEntry) {
        if (cacheEntry.lruHead == null) {
            int n = (this.lruTop + cacheEntry.priority) % this.lruBuckets.length;
            cacheEntry.lruHead = this.lruBuckets[n];
            cacheEntry.lruHead.addLast(cacheEntry);
        } else if (cacheEntry.lruHead.priority != cacheEntry.priority || cacheEntry.lruHead.priority == cacheEntry.priority && !cacheEntry.lruHead.isLast(cacheEntry)) {
            cacheEntry.lruHead.remove(cacheEntry);
            int n = (this.lruTop + cacheEntry.priority) % this.lruBuckets.length;
            cacheEntry.lruHead = this.lruBuckets[n];
            cacheEntry.lruHead.addLast(cacheEntry);
        }
    }

    public void setValue(EntryInfo entryInfo, Object object, boolean bl) {
        if (entryInfo == null) {
            throw new NullPointerException("input parameter entryInfo is null.");
        }
        if (entryInfo.getIdObject() == null) {
            throw new NullPointerException("entryInfo.getIdObject() is null.");
        }
        if (!entryInfo.wasPrioritySet()) {
            entryInfo.setPriority(this.defaultPriority);
        }
        CacheEntry cacheEntry = this._syncSetValue(entryInfo, object);
        if (cacheEntry.timeLimit > 0 || cacheEntry.inactivity > 0) {
            this.timeLimitDaemon.valueHasChanged(this, cacheEntry.id, cacheEntry.expirationTime, cacheEntry.inactivity);
        }
        if (entryInfo.isNotShared()) {
            cacheEntry.finish();
            return;
        }
        if (bl) {
            this.updatePeerCaches(cacheEntry);
        } else {
            cacheEntry.finish();
        }
    }

    private synchronized CacheEntry _syncSetValue(EntryInfo entryInfo, Object object) {
        Object object2;
        Enumeration enumeration;
        CacheEntry cacheEntry;
        int n = -1;
        if (!(this.hasPushPullEntries || entryInfo.sharingPolicy != 4 && entryInfo.sharingPolicy != 3)) {
            this.hasPushPullEntries = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_syncSetValue() Entry uses Push-Pull or Pull mode cacheName=" + this.cacheName + " id=" + entryInfo.id);
            }
        }
        if ((cacheEntry = (CacheEntry)this.entryHashtable.get(entryInfo.getIdObject())) == null) {
            n = 2;
            cacheEntry = this.getFreeLruEntry();
            this.entryHashtable.put(entryInfo.getIdObject(), cacheEntry);
            if (this.swapToDisk && this.diskCache.containsKey(entryInfo.getIdObject())) {
                cacheEntry.id = entryInfo.getIdObject();
                this.diskCache.delCacheEntry(cacheEntry, 1, 5, false);
                n = 1;
            }
        } else {
            n = 1;
            if (this.swapToDisk && cacheEntry.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry, 1, 5, false);
            }
            this.removeInvalidationInfo(cacheEntry);
        }
        if (this.cachePerf.isPMIEnabled() && cacheEntry.getValue() == null) {
            this.cachePerf.onEntryCreation(entryInfo.getTemplate(), 5);
        }
        if ((enumeration = cacheEntry.getAliasList()) != null) {
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_syncSetValue() adding alias=" + object2);
                }
                entryInfo.addAlias(object2);
            }
        }
        cacheEntry.copyMetaData(entryInfo);
        this.updateInvalidationHashtable(cacheEntry);
        cacheEntry.setValue(object);
        this.updateLruLocation(cacheEntry);
        cacheEntry.timeStamp = System.currentTimeMillis();
        ++cacheEntry.refCount;
        if (this.bEnableListener && this.eventSource.getChangeListenerCount() > 0) {
            object2 = new ChangeEvent(cacheEntry.id, cacheEntry.getValue(), n, 1, this.cacheNameNonPrefixed);
            this.eventSource.cacheEntryChanged((ChangeEvent)object2);
        }
        return cacheEntry;
    }

    private void updateInvalidationHashtable(CacheEntry cacheEntry) {
        int n;
        Object object = cacheEntry.id;
        if (!this.cacheConfig.disableDependencyId) {
            for (n = 0; n < cacheEntry._dataIds.length; ++n) {
                this.dataDependencyTable.add(cacheEntry._dataIds[n], object);
            }
        }
        if (!this.cacheConfig.disableTemplatesSupport) {
            for (n = 0; n < cacheEntry._templates.length; ++n) {
                this.templateDependencyTable.add((Object)cacheEntry._templates[n], object);
            }
        }
    }

    private void removeInvalidationInfo(CacheEntry cacheEntry) {
        int n;
        Object object = cacheEntry.id;
        if (!this.cacheConfig.disableDependencyId) {
            for (n = 0; n < cacheEntry._dataIds.length; ++n) {
                this.dataDependencyTable.removeEntry(cacheEntry._dataIds[n], object);
            }
        }
        if (!this.cacheConfig.disableTemplatesSupport) {
            for (n = 0; n < cacheEntry._templates.length; ++n) {
                this.templateDependencyTable.removeEntry(cacheEntry._templates[n], object);
            }
        }
    }

    public boolean isValid(String string) {
        CacheEntry cacheEntry = this.getCacheEntry(string, false, true, null, false);
        if (cacheEntry == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isValid() cacheName=" + this.cacheName + " id=" + string + " cacheEntry == null");
            }
            return false;
        }
        if (cacheEntry.invalid) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isValid() cacheName=" + this.cacheName + " id=" + string + " cacheEntry.invalid");
            }
            return false;
        }
        return !cacheEntry.removeWhenUnpinned;
    }

    public Object invalidateAndSet(EntryInfo entryInfo, Object object, boolean bl) {
        CacheEntry cacheEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invalidateAndSet() cacheName=" + this.cacheName + " idObject=" + entryInfo.getIdObject() + " coordinate=" + bl);
        }
        Object object2 = null;
        if (entryInfo == null) {
            return null;
        }
        Object object3 = entryInfo.getIdObject();
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onRequest(entryInfo.getTemplate(), 5);
        }
        if ((cacheEntry = this.getCacheEntry(object3, false, true, null, true)) != null) {
            object2 = cacheEntry.getValue();
            cacheEntry.finish();
        } else {
            object2 = null;
        }
        if (entryInfo.getSharingPolicy() == 4 || entryInfo.getSharingPolicy() == 3) {
            this.invalidateById(object3, 1, 5, true, false, false);
        }
        if (this.cacheConfig.isPropogateInvalidationsNotShared() && entryInfo.isNotShared()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalidateAndSet() cacheName=" + this.cacheName + " propogating invalidation for a NOT SHARED cache because of a content update");
            }
            this.invalidateById(object3, 1, 5, true, false, false);
        }
        if (!entryInfo.wasPrioritySet()) {
            entryInfo.setPriority(this.defaultPriority);
        }
        CacheEntry cacheEntry2 = this._syncSetValue(entryInfo, object);
        if (cacheEntry2.timeLimit > 0 || cacheEntry2.inactivity > 0) {
            this.timeLimitDaemon.valueHasChanged(this, cacheEntry2.id, cacheEntry2.expirationTime, cacheEntry2.inactivity);
        }
        if (entryInfo.isNotShared()) {
            cacheEntry2.finish();
            return object2;
        }
        if (bl) {
            this.updatePeerCaches(cacheEntry2);
        } else {
            cacheEntry2.finish();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invalidateAndSet() id=" + object3);
        }
        return object2;
    }

    public Object getValue(Object object, String string, boolean bl, boolean bl2) {
        CacheEntry cacheEntry;
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onRequest(string, 5);
        }
        Object object2 = null;
        if (object != null && (cacheEntry = this.getCacheEntry(object, bl, bl2, string, true)) != null) {
            if (cacheEntry.getExpirationTime() <= 0L || cacheEntry.getExpirationTime() > System.currentTimeMillis()) {
                object2 = cacheEntry.getValue();
            }
            cacheEntry.finish();
        }
        return object2;
    }

    public Object getValue(Object object, boolean bl) {
        CacheEntry cacheEntry;
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onRequest(null, 5);
        }
        Object object2 = null;
        if (object != null && (cacheEntry = this.getCacheEntry(object, bl, false, null, true)) != null) {
            object2 = cacheEntry.getValue();
            cacheEntry.finish();
        }
        return object2;
    }

    public void invalidateById(String string, boolean bl) {
        this.invalidateById(string, 1, bl, true);
    }

    public void invalidateById(Object object, boolean bl) {
        this.invalidateById(object, 1, bl, true);
    }

    public void invalidateById(Object object, boolean bl, boolean bl2) {
        this.invalidateById(object, 1, bl, bl2);
    }

    public void invalidateById(Object object, int n, boolean bl) {
        this.invalidateById(object, n, bl, true);
    }

    public void invalidateById(Object object, int n, boolean bl, boolean bl2) {
        if (object != null) {
            this.batchUpdateDaemon.invalidateById(object, n, bl, this, bl2);
        }
    }

    public void invalidateById(Object object, int n, int n2, boolean bl, boolean bl2) {
        if (object != null) {
            this.batchUpdateDaemon.invalidateById(object, n, n2, bl, bl2, true, this, true);
        }
    }

    public void invalidateById(Object object, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (object != null) {
            this.batchUpdateDaemon.invalidateById(object, n, n2, bl, bl2, bl3, this, true);
        }
    }

    public void invalidateByTemplate(String string, boolean bl) {
        if (string != null) {
            this.batchUpdateDaemon.invalidateByTemplate(string, bl, this);
        }
    }

    public void batchUpdate(HashMap hashMap, HashMap hashMap2, ArrayList arrayList) {
        for (Externalizable externalizable : hashMap.values()) {
            if (!((InvalidateByIdEvent)externalizable).isInvokeInternalInvalidateById()) continue;
            this.internalInvalidateById(((InvalidateByIdEvent)externalizable).getId(), ((InvalidateByIdEvent)externalizable).causeOfInvalidation, ((InvalidateByIdEvent)externalizable).source, true);
        }
        for (Externalizable externalizable : hashMap2.values()) {
            if (((InvalidateByTemplateEvent)externalizable).isCacheCommand_Clear()) {
                this.clearLocal(((InvalidateByTemplateEvent)externalizable).source);
                continue;
            }
            if (((InvalidateByTemplateEvent)externalizable).isCacheCommand_InvalidateByTemplate()) {
                this.internalInvalidateByTemplate((InvalidateByTemplateEvent)externalizable);
                continue;
            }
            throw new IllegalStateException("Program check - cache command unknown.");
        }
        for (Externalizable externalizable : arrayList) {
            this.setEntry((CacheEntry)externalizable, 2);
        }
    }

    public synchronized void internalInvalidateByTemplate(InvalidateByTemplateEvent invalidateByTemplateEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "internalInvalidateByTemplate() cacheName=" + this.cacheName + " template=[" + invalidateByTemplateEvent.getTemplate() + "]");
        }
        long l = System.currentTimeMillis();
        String string = invalidateByTemplateEvent.getTemplate().trim();
        int n = invalidateByTemplateEvent.source;
        if (!this.cacheConfig.disableTemplatesSupport) {
            ValueSet valueSet = this.templateDependencyTable.removeDependency(string);
            if (this.swapToDisk) {
                ValueSet valueSet2 = this.diskCache.readTemplate(string, true);
                if (valueSet == null) {
                    valueSet = valueSet2;
                } else {
                    valueSet.union(valueSet2);
                    valueSet2.clear();
                }
            }
            if (valueSet != null && valueSet.size() > 0) {
                invalidateByTemplateEvent.addRemovedIds(valueSet);
                this.entriesInMemoryRemoved = 0;
                this.entriesInDiskRemoved = 0;
                this.loopRemove(valueSet, 1, n, true);
                if (this.entriesInDiskRemoved > 0) {
                    this.cacheStatisticsListener.templateBasedInvalidationsFromDisk(string);
                }
                valueSet.clear();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "internalInvalidateByTemplate() cacheName=" + this.cacheName + " template=" + string + " numOfMemoryEntries=" + this.entriesInMemoryRemoved + " numOfDiskEntries=" + this.entriesInDiskRemoved + " cause=" + 1 + " source=" + n + " elapsed=" + (System.currentTimeMillis() - l) + " listenerEnabled=" + this.bEnableListener);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "internalInvalidateByTemplate() template=" + string);
        }
    }

    protected synchronized boolean internalInvalidateById(Object object, int n, int n2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "internalInvalidateById() cacheName=" + this.cacheName + " id=" + object);
        }
        boolean bl2 = this.remove(object, n, n2, bl, false);
        this.internalInvalidateByDepId(object, n, n2, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "internalInvalidateById: cacheName=" + this.cacheName + " id=" + object + " rc=" + bl2);
        }
        return bl2;
    }

    public synchronized void internalInvalidateByDepId(Object object, int n, int n2, boolean bl) {
        if (!this.cacheConfig.disableDependencyId) {
            long l = System.currentTimeMillis();
            this.entriesInMemoryRemoved = 0;
            this.entriesInDiskRemoved = 0;
            ValueSet valueSet = this.dataDependencyTable.removeDependency(object);
            if (this.swapToDisk) {
                if (valueSet == null) {
                    valueSet = this.diskCache.readDependency(object, true);
                } else {
                    valueSet.union(this.diskCache.readDependency(object, true));
                }
            }
            if (valueSet != null && valueSet.size() > 0) {
                this.loopRemove(valueSet, n, n2, bl);
                valueSet.clear();
                valueSet = null;
                if (this.entriesInDiskRemoved > 0) {
                    this.cacheStatisticsListener.depIdBasedInvalidationsFromDisk(object);
                }
                String string = "internalInvalidateByDepId() cacheName=" + this.cacheName + " dep-id=" + object + " numOfMemoryEntries=" + this.entriesInMemoryRemoved + " numOfDiskEntries=" + this.entriesInDiskRemoved + " cause=" + n + " source=" + n2 + " elapsed=" + (System.currentTimeMillis() - l) + " listenerEnabled=" + this.bEnableListener + " PMIEnabled=" + this.cachePerf.isPMIEnabled();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string);
                } else if (tc.isEventEnabled()) {
                    Tr.event(tc, string);
                }
            }
        }
    }

    private void loopRemove(ValueSet valueSet, int n, int n2, boolean bl) {
        if (valueSet != null && !valueSet.isEmpty()) {
            for (Object e2 : valueSet) {
                this.remove(e2, n, n2, bl, true);
            }
        }
    }

    protected final boolean remove(Object object, int n, int n2) {
        return this.remove(object, n, n2, true, false);
    }

    protected final synchronized boolean remove(Object object, int n, int n2, boolean bl, boolean bl2) {
        int n3;
        if (object == null) {
            throw new NullPointerException("input parameter id is null.");
        }
        boolean bl3 = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cache.remove() cacheName=" + this.cacheName + " id=" + object + " cause=" + n + " source=" + n2);
        }
        CacheEntry cacheEntry = (CacheEntry)this.entryHashtable.get(object);
        boolean bl4 = false;
        if (cacheEntry == null && this.swapToDisk) {
            if (!bl2) {
                cacheEntry = this.diskCache.readCacheEntry(object, true);
            } else {
                if (this.bEnableListener && bl && this.eventSource.getInvalidationListenerCount() > 0 && !this.ignoreValueInInvalidationEvent) {
                    cacheEntry = this.diskCache.readCacheEntry(object, true);
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    cacheEntry = this.cacheEntryPool.allocate();
                    cacheEntry.id = object;
                }
            }
            if (cacheEntry != null) {
                bl3 = true;
            }
        }
        if (!bl3) {
            if (cacheEntry != null && cacheEntry.timeLimit > 0) {
                this.timeLimitDaemon.valueWasRemoved(this, cacheEntry.id);
            }
        } else if (bl4 && this.cacheConfig.diskCachePerformanceLevel == 3) {
            this.timeLimitDaemon.valueWasRemoved(this, object);
        } else if (cacheEntry != null && this.cacheConfig.diskCachePerformanceLevel == 3 && cacheEntry.timeLimit > 0) {
            this.timeLimitDaemon.valueWasRemoved(this, cacheEntry.id);
        }
        if (cacheEntry == null || cacheEntry.invalid || cacheEntry.removeWhenUnpinned) {
            return false;
        }
        if (this.cachePerf.isPMIEnabled() && !bl3 && n != -1 && !cacheEntry.loadedFromDisk) {
            this.cachePerf.onInvalidate(cacheEntry.getTemplate(), n, 1, n2);
        }
        if (!bl3) {
            this.cacheStatisticsListener.remove(object, n, 1, n2);
        }
        cacheEntry.invalid = true;
        Object object2 = null;
        object2 = cacheEntry.serializedValue != null ? cacheEntry.serializedValue : (Object)cacheEntry.getValue();
        if (!bl3 && !this.cacheConfig.disableDependencyId) {
            for (n3 = 0; n3 < cacheEntry._dataIds.length; ++n3) {
                boolean bl5 = this.dataDependencyTable.removeEntry(cacheEntry._dataIds[n3], object);
                if (bl5 || !this.swapToDisk || cacheEntry.loadedFromDisk) continue;
                this.diskCache.delDependencyEntry(cacheEntry._dataIds[n3], object);
            }
        }
        if (!bl3 && !this.cacheConfig.disableTemplatesSupport) {
            for (n3 = 0; n3 < cacheEntry._templates.length; ++n3) {
                this.templateDependencyTable.removeEntry(cacheEntry._templates[n3], object);
            }
        }
        if (!bl3) {
            this.entryHashtable.remove(cacheEntry.id);
            ++this.entriesInMemoryRemoved;
            if (bl2 && n2 != 2 && (cacheEntry.sharingPolicy == 4 || cacheEntry.sharingPolicy == 3)) {
                this.invalidateById(cacheEntry.id, n, n2, false, false);
            }
            if (cacheEntry.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry, n, n2, bl2);
            }
        } else {
            this.diskCache.delCacheEntry(cacheEntry, n, n2, bl2);
            ++this.entriesInDiskRemoved;
        }
        if (this.bEnableListener && bl && this.eventSource.getInvalidationListenerCount() > 0 && n > 0) {
            n3 = 1;
            if (n2 == 2) {
                n3 = 2;
            }
            if (this.ignoreValueInInvalidationEvent) {
                object2 = null;
            }
            InvalidationEvent invalidationEvent = new InvalidationEvent(cacheEntry.id, object2, n, n3, this.cacheNameNonPrefixed);
            this.eventSource.fireEvent(invalidationEvent);
        }
        if (!bl3) {
            for (n3 = 0; n3 < cacheEntry.aliasList.length; ++n3) {
                this.entryHashtable.remove(cacheEntry.aliasList[n3]);
            }
            if (cacheEntry.refCount <= 0) {
                cacheEntry.returnToPool();
            } else {
                cacheEntry.removeWhenUnpinned = true;
                cacheEntry.lruHead.remove(cacheEntry);
            }
        }
        if (bl4) {
            cacheEntry.returnToPool();
        }
        return true;
    }

    public void clear(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clear() cacheName=" + this.cacheName + " waitOnInvalidation=" + bl);
        }
        if (this.bEnableListener && this.eventSource.getPreInvalidationListenerCount() > 0 && !this.eventSource.shouldInvalidate("*", 1, 5)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clear() cacheName=" + this.cacheName + " skip clearing cache because PreInvalidationListener.shouldInvalidate() returns false.");
            }
            return;
        }
        this.batchUpdateDaemon.cacheCommand_Clear(bl, this);
    }

    private synchronized void clearLocal(int n) {
        int n2 = 1;
        if (this.swapToDisk) {
            this.diskCache.clearDiskCache();
        }
        boolean bl = this.swapToDisk;
        this.swapToDisk = false;
        Enumeration enumeration = this.entryHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            this.internalInvalidateById(e2, n2, n, false);
        }
        this.swapToDisk = bl;
        if (this.swapToDisk) {
            this.diskCache.clearInvalidationBuffers();
        }
        if (this.bEnableListener) {
            int n3 = 1;
            if (n == 2) {
                n3 = 2;
            }
            InvalidationEvent invalidationEvent = new InvalidationEvent("*", null, 5, n3, this.cacheNameNonPrefixed);
            this.eventSource.fireEvent(invalidationEvent);
        }
        if (this.swapToDisk && this.cacheConfig.diskCachePerformanceLevel == 3) {
            this.timeLimitDaemon.cacheCleared(this);
        }
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onCacheClear(true, this.swapToDisk);
        }
    }

    public void clear() {
        boolean bl = true;
        this.clear(bl);
    }

    public synchronized Enumeration getAllIds() {
        return this.entryHashtable.keys();
    }

    public Set getCacheIds() {
        ValueSet valueSet = null;
        Enumeration enumeration = this.getAllIds();
        valueSet = enumeration != null ? new ValueSet(enumeration) : new ValueSet(0);
        return valueSet;
    }

    public synchronized boolean containsCacheId(Object object) {
        return this.entryHashtable.contains(object);
    }

    public boolean containsKeyDisk(Object object) {
        if (this.swapToDisk) {
            return this.diskCache.containsKey(object);
        }
        return false;
    }

    public synchronized Collection getAllDependencyIds() {
        ArrayList<Object> arrayList = EMPTY_ARRAY_LIST;
        if (!this.cacheConfig.disableDependencyId) {
            Iterator<Object> iterator = this.dataDependencyTable.getKeys();
            arrayList = new ArrayList<Object>();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    public synchronized Collection getCacheIdsByDependency(String string) {
        return this.getCacheIdsByDependency((Object)string);
    }

    public synchronized Collection getCacheIdsByDependency(Object object) {
        ValueSet valueSet;
        ArrayList arrayList = null;
        if (!this.cacheConfig.disableDependencyId && (valueSet = this.dataDependencyTable.getEntries(object)) != null) {
            arrayList = new ArrayList();
            arrayList.addAll(valueSet);
        }
        return arrayList;
    }

    public synchronized Collection getCacheIdsByTemplate(String string) {
        ValueSet valueSet;
        ArrayList arrayList = null;
        if (!this.cacheConfig.disableTemplatesSupport && (valueSet = this.templateDependencyTable.getEntries(string)) != null) {
            arrayList = new ArrayList();
            arrayList.addAll(valueSet);
        }
        return arrayList;
    }

    private synchronized CacheEntry getFreeLruEntry() {
        CacheEntry cacheEntry = null;
        if (this.getNumberCacheEntries() < this.cacheSizeLimit) {
            cacheEntry = this.cacheEntryPool.allocate();
            return cacheEntry;
        }
        try {
            if (this.freeLruEntry()) {
                return this.getFreeLruEntry();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Last resort - create overflow entry");
            }
            this.cacheStatisticsListener.overflowEntriesFromMemory();
            cacheEntry = this.cacheEntryPool.allocate();
            return cacheEntry;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.Cache.getFreeLruEntry", "1181", this);
            throwable.printStackTrace();
            return null;
        }
    }

    public void trimCache() {
        int n = this.getNumberCacheEntries() - this.cacheConfig.cacheSize;
        if (n > 0) {
            for (int i = 0; i < n && this.freeLruEntry(); ++i) {
                this.cacheStatisticsListener.objectsAsyncLruToDisk();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "trimCache(): cacheName=" + this.cacheName + " size=" + n + " ObjectsAsyncLruToDisk=" + this.cacheStatisticsListener.getObjectsAsyncLruToDiskCount());
            }
        }
    }

    public synchronized boolean freeLruEntry() {
        CacheEntry cacheEntry = null;
        int n = (this.lruTop + this.lruBuckets.length - 1) % this.lruBuckets.length;
        while (cacheEntry == null && this.lruTop != n) {
            int n2;
            Object object;
            if (!this.lruBuckets[this.lruTop].isEmpty()) {
                Iterator iterator = this.lruBuckets[this.lruTop].iterator();
                while (iterator.hasNext()) {
                    cacheEntry = (CacheEntry)iterator.next();
                    if (cacheEntry.refCount != 0 || (object = cacheEntry.id) == null) continue;
                    n2 = 1;
                    if (this.swapToDisk && cacheEntry.persistToDisk) {
                        this.lruToDisk(cacheEntry);
                    } else {
                        n2 = this.internalInvalidateById(object, 2, 5, true) ? 1 : 0;
                        if (!this.cacheConfig.filterLRUInvalidation && 1 == n2) {
                            this.invalidateById(object, 2, 5, false, false);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "return freeLruEntry() true");
                        }
                    }
                    return true;
                }
            }
            if (tc.isDebugEnabled()) {
                if (this.lruBuckets[this.lruTop].isEmpty()) {
                    Tr.debug(tc, "LRU Empty");
                } else {
                    Tr.debug(tc, "LRU not empty - all CEs  pinned");
                }
            }
            int n3 = (this.lruTop + 1) % this.lruBuckets.length;
            object = this.lruBuckets[this.lruTop];
            while (!((CacheEntry.LRUHead)object).isEmpty()) {
                CacheEntry cacheEntry2 = ((CacheEntry.LRUHead)object).removeFirst();
                cacheEntry2.lruHead = this.lruBuckets[n3];
                this.lruBuckets[n3].addFirst(cacheEntry2);
            }
            this.lruTop = n3;
            for (n2 = 0; n2 < this.lruBuckets.length; ++n2) {
                this.lruBuckets[(this.lruTop + n2) % this.lruBuckets.length].priority = n2;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "return freeLruEntry() false");
        }
        return false;
    }

    protected synchronized boolean lruToDisk(CacheEntry cacheEntry) {
        int n;
        boolean bl = false;
        if (cacheEntry.id == null) {
            Tr.debug(tc, "CATASTROPHIC1 cacheEntry is null");
            return bl;
        }
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        if (!cacheEntry.loadedFromDisk) {
            ((CacheOnDisk)this.diskCache).htod.diskCacheException = null;
            if (!cacheEntry.prepareForSerialization()) {
                bl2 = true;
                n3 = 4;
            }
            if (!bl2 && cacheEntry.serializedValue == null) {
                bl2 = true;
                n3 = 4;
            }
            n = this.diskCache.getDiskCacheSizeLimit();
            if (!bl2 && n > 0 && this.getIdsSizeDisk() >= n) {
                ++this.diskCacheSizeEvictedCount;
                if (this.diskCacheSizeEvictedCount == this.diskCacheSizeEvictedLimit) {
                    Tr.error(tc, "DYNA0065W", new Object[]{new Integer(n), this.cacheName, new Long(this.diskCacheSizeEvictedCount)});
                    this.diskCacheSizeEvictedLimit = this.diskCacheSizeEvictedLimit == 1L ? 1000L : (this.diskCacheSizeEvictedLimit += 1000L);
                }
                n2 = 1;
                bl2 = true;
                n3 = 5;
            }
            long l = this.diskCache.getDiskCacheEntrySizeInBytesLimit();
            if (!bl2 && l > 0L && (long)cacheEntry.serializedValue.length >= l) {
                ++this.diskCacheEntrySizeInMBEvictedCount;
                if (this.diskCacheEntrySizeInMBEvictedCount == this.diskCacheEntrySizeInMBEvictedLimit) {
                    Tr.error(tc, "DYNA0064W", new Object[]{new Long(l / 0x100000L), this.cacheName, new Long(this.diskCacheEntrySizeInMBEvictedCount)});
                    this.diskCacheEntrySizeInMBEvictedLimit = this.diskCacheEntrySizeInMBEvictedLimit == 1L ? 1000L : (this.diskCacheEntrySizeInMBEvictedLimit += 1000L);
                }
                bl2 = true;
                n3 = 6;
            }
            if (this.enableDiskCacheSizeInBytesChecking && !bl2) {
                long l2;
                int n4 = cacheEntry.serializedId.length;
                if (cacheEntry._templates != null && cacheEntry._templates.length > 0) {
                    n4 += cacheEntry._templates[0].length();
                }
                if (cacheEntry._serializedDataIds != null) {
                    n4 += cacheEntry._serializedDataIds.length;
                }
                if ((l2 = this.diskCache.getDiskCacheSizeInBytesLimit()) > 0L && this.diskCache.getCacheSizeInBytes() + (long)(n4 += cacheEntry.serializedValue.length) >= l2) {
                    ++this.diskCacheSizeInGBEvictedCount;
                    if (this.diskCacheSizeInGBEvictedCount == this.diskCacheSizeInGBEvictedLimit) {
                        Tr.error(tc, "DYNA0063W", new Object[]{new Integer(this.diskCache.getDiskCacheSizeInGBLimit()), this.cacheName, new Long(this.diskCacheSizeInGBEvictedCount)});
                        this.diskCacheSizeInGBEvictedLimit = this.diskCacheSizeInGBEvictedLimit == 1L ? 1000L : (this.diskCacheSizeInGBEvictedLimit += 1000L);
                    }
                    n2 = 2;
                    bl2 = true;
                    n3 = 2;
                }
            }
        }
        if (bl2) {
            if (n2 > 0 && this.cacheConfig.getDiskCacheEvictionPolicy() != 0) {
                this.diskCache.invokeDiskCacheGarbageCollector(n2);
            }
            n = 2;
            if (n2 > 0) {
                n = 8;
            }
            this.cleanup(cacheEntry, n3, n);
            return bl;
        }
        if (!(cacheEntry.skipMemoryAndWriteToDisk || this.cacheConfig.diskCachePerformanceLevel == 3 || cacheEntry.timeLimit <= 0 && cacheEntry.inactivity <= 0)) {
            this.timeLimitDaemon.valueWasRemoved(this, cacheEntry.id);
        }
        if (cacheEntry.loadedFromDisk) {
            this.removeInvalidationInfo(cacheEntry);
        } else {
            n = 0;
            if (this.cacheConfig.getDiskCacheEvictionPolicy() != 0) {
                n = 0;
                if (this.diskCache.getDiskCacheSizeLimit() > 0 && this.getIdsSizeDisk() > this.diskCache.getDiskCacheSizeHighLimit()) {
                    n = 1;
                    this.diskCache.invokeDiskCacheGarbageCollector(1);
                }
                if (n == 0 && this.diskCache.getDiskCacheSizeInBytesLimit() > 0L && this.getCacheSizeInBytesDisk() > this.diskCache.getDiskCacheSizeInBytesHighLimit()) {
                    this.diskCache.invokeDiskCacheGarbageCollector(2);
                }
            }
            if ((n3 = this.diskCache.writeCacheEntry(cacheEntry)) == 7) {
                bl = true;
                n3 = 0;
            }
            if (n3 != 0) {
                int n5 = 2;
                if (n3 == 2) {
                    n5 = 8;
                }
                this.cleanup(cacheEntry, n3, n5);
                return bl;
            }
            if (!this.cacheConfig.disableDependencyId) {
                for (int i = 0; i < cacheEntry._dataIds.length; ++i) {
                    if (n3 != 0 || (n3 = this.diskCache.writeDependencyEntry(cacheEntry._dataIds[i], cacheEntry.id)) != 0 || cacheEntry.skipMemoryAndWriteToDisk) continue;
                    this.dataDependencyTable.removeEntry(cacheEntry._dataIds[i], cacheEntry.id);
                }
            }
            if (!this.cacheConfig.disableTemplatesSupport) {
                for (int i = 0; i < cacheEntry._templates.length; ++i) {
                    if (n3 != 0 || (n3 = this.diskCache.writeTemplateEntry(cacheEntry._templates[i], cacheEntry.id)) != 0 || cacheEntry.skipMemoryAndWriteToDisk) continue;
                    this.templateDependencyTable.removeEntry(cacheEntry._templates[i], cacheEntry.id);
                }
            }
            if (n3 != 0) {
                int n6 = 2;
                if (n3 == 2) {
                    n6 = 8;
                }
                if (n3 != 1) {
                    ValueSet valueSet = new ValueSet(1);
                    valueSet.add(cacheEntry.id);
                    this.diskCache.delCacheEntry(valueSet, n6, 5, false, false);
                }
                this.cleanup(cacheEntry, n3, n6);
                return bl;
            }
        }
        if (!cacheEntry.skipMemoryAndWriteToDisk) {
            this.entryHashtable.remove(cacheEntry.id);
            for (n = 0; n < cacheEntry.aliasList.length; ++n) {
                this.entryHashtable.remove(cacheEntry.aliasList[n]);
            }
        }
        if (!this.cacheConfig.disableDependencyId) {
            ValueSet valueSet = this.dataDependencyTable.removeDependency(cacheEntry.id);
            if (valueSet != null && !cacheEntry.loadedFromDisk) {
                ValueSet valueSet2 = (ValueSet)valueSet.clone();
                n3 = this.diskCache.writeDependency(cacheEntry.id, valueSet2);
            }
            if (n3 != 0) {
                this.dataDependencyTable.add(cacheEntry.id, valueSet);
                int n7 = 2;
                if (n3 == 2) {
                    n7 = 8;
                }
                if (n3 != 1) {
                    ValueSet valueSet3 = new ValueSet(1);
                    valueSet3.add(cacheEntry.id);
                    this.diskCache.delCacheEntry(valueSet3, n7, 5, false, false);
                }
                this.internalInvalidateById(cacheEntry.id, n7, 5, true);
                this.invalidateById(cacheEntry.id, n7, 5, false, false);
                if (cacheEntry.skipMemoryAndWriteToDisk) {
                    cacheEntry.skipMemoryAndWriteToDiskErrorCode = n3;
                    if (this.cachePerf.isPMIEnabled() && !cacheEntry.loadedFromDisk) {
                        this.cachePerf.onInvalidate(cacheEntry.getTemplate(), n7, 1, 5);
                    }
                    this.cacheStatisticsListener.remove(cacheEntry.id, n7, 1, 5);
                } else {
                    cacheEntry.returnToPool();
                }
                return bl;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lruToDisk id: " + cacheEntry.getId() + " timeLimit: " + cacheEntry.timeLimit + " inactivity: " + cacheEntry.inactivity + " loadedFromDisk: " + cacheEntry.loadedFromDisk + " skipMemory " + cacheEntry.skipMemoryAndWriteToDisk + " discard: " + bl2 + "rc[" + bl + "]");
        }
        if (cacheEntry.skipMemoryAndWriteToDisk) {
            if (this.cacheConfig.diskCachePerformanceLevel == 3 && (cacheEntry.timeLimit > 0 || cacheEntry.inactivity > 0)) {
                this.timeLimitDaemon.valueHasChanged(this, cacheEntry.id, cacheEntry.expirationTime, cacheEntry.inactivity);
            }
        } else {
            if (this.cachePerf.isPMIEnabled() && !cacheEntry.loadedFromDisk) {
                this.cachePerf.onInvalidate(cacheEntry.getTemplate(), 2, 3, 5);
            }
            this.cacheStatisticsListener.remove(cacheEntry.id, 2, 3, 5);
            cacheEntry.returnToPool();
        }
        return bl;
    }

    private void cleanup(CacheEntry cacheEntry, int n, int n2) {
        if (cacheEntry.skipMemoryAndWriteToDisk) {
            cacheEntry.skipMemoryAndWriteToDiskErrorCode = n;
            if (this.cachePerf.isPMIEnabled() && !cacheEntry.loadedFromDisk) {
                this.cachePerf.onInvalidate(cacheEntry.getTemplate(), n2, 1, 5);
            }
            this.cacheStatisticsListener.remove(cacheEntry.id, n2, 1, 5);
        } else {
            this.internalInvalidateById(cacheEntry.id, n2, 5, true);
            this.invalidateById(cacheEntry.id, n2, 5, false, false);
        }
    }

    public synchronized void stop() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " Stopping cache: " + this.cacheName);
        }
        if (this.swapToDisk && !this.flushToDiskComplete) {
            this.flushToDisk();
        }
    }

    public synchronized void stopOnDebug() {
        if (this.swapToDisk) {
            this.flushToDisk();
        }
    }

    private void flushToDisk() {
        boolean bl = this.cacheConfig.flushToDiskOnStop;
        if (this.cacheName != null) {
            Object object;
            if (this.cacheName.equals("baseCache") && (object = System.getProperty("com.ibm.ws.cache.flushToDiskOnStop")) != null && ((String)object).equalsIgnoreCase("true")) {
                bl = true;
            }
            if (bl) {
                Tr.info(tc, "DYNA0060I", new Object[]{this.cacheName});
                this.swapToDisk = false;
                this.diskCache.stop(false);
                object = this.entryHashtable.elements();
                int n = this.entryHashtable.size();
                long l = 120000L;
                boolean bl2 = false;
                int n2 = 0;
                long l2 = this.cacheStatisticsListener.getObjectsWriteToDiskCount();
                long l3 = System.currentTimeMillis();
                while (object.hasMoreElements()) {
                    CacheEntry cacheEntry = (CacheEntry)object.nextElement();
                    if (!cacheEntry.persistToDisk || cacheEntry.timeLimit > 0 && (cacheEntry.timeLimit <= 0 || System.currentTimeMillis() + l >= cacheEntry.expirationTime)) continue;
                    ++n2;
                    this.lruToDisk(cacheEntry);
                }
                long l4 = System.currentTimeMillis();
                if (this.diskCache.writeAuxiliaryDepTables() == 1) {
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                CacheOnDisk cacheOnDisk = (CacheOnDisk)this.diskCache;
                stringBuffer.append(" numOfEntriesFlushToDisk=");
                stringBuffer.append(n2);
                stringBuffer.append(" numOfBytesFlushToDisk=");
                stringBuffer.append(this.cacheStatisticsListener.getObjectsWriteToDiskSizeCount() - l2);
                stringBuffer.append(" timeElapsedEntriesFlushToDisk=");
                stringBuffer.append(l4 - l3);
                stringBuffer.append(" numDepIdsInAuxTable=");
                stringBuffer.append(cacheOnDisk.htod.numDepIdsInAuxTable);
                stringBuffer.append(" numCacheIdsInDepIdAuxTable=");
                stringBuffer.append(cacheOnDisk.htod.numCacheIdsInDepIdAuxTable);
                stringBuffer.append(" numTemplatesInAuxTable=");
                stringBuffer.append(cacheOnDisk.htod.numTemplatesInAuxTable);
                stringBuffer.append(" numCacheIdsInTemplateAuxTable=");
                stringBuffer.append(cacheOnDisk.htod.numCacheIdsInTemplateAuxTable);
                stringBuffer.append(" timeElapsedWriteAuxTables=");
                stringBuffer.append(cacheOnDisk.htod.timeElapsedWriteAuxTables);
                int n3 = cacheOnDisk.htod.numExplicitBufferLimitOnStop;
                if (n3 > 0) {
                    stringBuffer.append(" numExplicitBufferFlushToDisk=");
                    stringBuffer.append(n3);
                    stringBuffer.append(" explicitBufferLimitOnStop=");
                    stringBuffer.append(cacheOnDisk.explicitBufferLimitOnStop);
                }
                Tr.info(tc, "DYNA0073I", new Object[]{this.cacheName, stringBuffer.toString()});
                this.diskCache.close(true);
            } else {
                Tr.info(tc, "DYNA0061I", new Object[]{this.cacheName});
                this.swapToDisk = false;
                this.diskCache.stop(true);
                this.diskCache.close(true);
                this.diskCache.deleteDiskCacheFiles();
            }
            this.flushToDiskComplete = true;
        }
    }

    public synchronized int getMaxNumberCacheEntries() {
        return this.cacheConfig.cacheSize;
    }

    public synchronized int getNumberCacheEntries() {
        return this.entryHashtable.size();
    }

    public int getNumberCacheEntriesUnsynchronized() {
        return this.entryHashtable.size();
    }

    public boolean shouldPull(int n, Object object) {
        return this.remoteServices.shouldPull(n, object);
    }

    public boolean getSwapToDisk() {
        return this.swapToDisk;
    }

    public void setSwapToDisk(boolean bl) {
        this.swapToDisk = bl;
        this.cacheConfig.enableDiskOffload = bl;
    }

    public com.ibm.websphere.cache.CacheEntry getEntryFromMemory(Object object) {
        return (com.ibm.websphere.cache.CacheEntry)this.entryHashtable.get(object);
    }

    public void addAlias(Object object, Object[] objectArray, boolean bl, boolean bl2) {
        CacheEntry cacheEntry = this._syncAddAlias(object, objectArray, bl);
        if (cacheEntry == null) {
            throw new IllegalArgumentException("The cache id is not found in the cache's mapping table when adding alias");
        }
        cacheEntry.finish();
        if (cacheEntry.sharingPolicy != 1 && bl2) {
            AliasEntry aliasEntry = new AliasEntry(object, "AddAlias", cacheEntry.sharingPolicy, objectArray);
            if (!cacheEntry.isBatchEnabled()) {
                this.remoteServices.setEntry(aliasEntry);
            } else {
                this.batchUpdateDaemon.pushAliasEntry(aliasEntry, this);
            }
        }
    }

    private synchronized CacheEntry _syncAddAlias(Object object, Object[] objectArray, boolean bl) {
        CacheEntry cacheEntry = this.getCacheEntry(object, bl, true, null, true);
        if (cacheEntry == null) {
            return null;
        }
        if (cacheEntry.loadedFromDisk) {
            this.diskCache.delCacheEntry(cacheEntry, 1, 5, false);
            cacheEntry.loadedFromDisk = false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            CacheEntry cacheEntry2;
            if (objectArray[i] == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_syncAddAlias() cacheName=" + this.cacheName + " adding alias to EHT key=" + object + " alias=" + objectArray[i]);
            }
            if ((cacheEntry2 = (CacheEntry)this.entryHashtable.get(objectArray[i])) != null) {
                this.removeAlias(objectArray[i], bl, false);
            }
            cacheEntry.addAlias(objectArray[i]);
            this.entryHashtable.put(objectArray[i], cacheEntry);
        }
        return cacheEntry;
    }

    public void removeAlias(Object object, boolean bl, boolean bl2) {
        CacheEntry cacheEntry = this._syncRemoveAlias(object, bl);
        if (cacheEntry == null) {
            throw new IllegalArgumentException("The alias is not found in the cache's mapping table when removing alias");
        }
        cacheEntry.finish();
        if (cacheEntry.sharingPolicy == 1) {
            return;
        }
        if (cacheEntry != null && bl2) {
            AliasEntry aliasEntry = new AliasEntry(cacheEntry.getIdObject(), "RemoveAlias", cacheEntry.sharingPolicy, CacheEntry.EMPTY_OBJECT_ARRAY);
            aliasEntry.addAlias(object);
            if (!cacheEntry.isBatchEnabled()) {
                this.remoteServices.setEntry(aliasEntry);
            } else {
                this.batchUpdateDaemon.pushAliasEntry(aliasEntry, this);
            }
        }
    }

    private synchronized CacheEntry _syncRemoveAlias(Object object, boolean bl) {
        CacheEntry cacheEntry = this.getCacheEntry(object, bl, true, null, true);
        if (cacheEntry != null) {
            if (cacheEntry.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry, 1, 5, false);
                cacheEntry.loadedFromDisk = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_syncRemoveAlias() cacheName=" + this.cacheName + " removing alias from EHT " + object);
            }
            cacheEntry.removeAlias(object);
            this.entryHashtable.remove(object);
        }
        return cacheEntry;
    }

    public synchronized Collection getIdsByRangeDisk(int n, int n2) {
        ValueSet valueSet = null;
        if (this.swapToDisk) {
            valueSet = this.diskCache.readCacheIdsByRange(n, n2);
        }
        return valueSet;
    }

    public synchronized Collection getDepIdsByRangeDisk(int n, int n2) {
        ValueSet valueSet = null;
        if (this.swapToDisk) {
            valueSet = this.diskCache.readDependencyByRange(n, n2);
        }
        return valueSet;
    }

    public synchronized Collection getTemplatesByRangeDisk(int n, int n2) {
        ValueSet valueSet = null;
        if (this.swapToDisk) {
            valueSet = this.diskCache.readTemplatesByRange(n, n2);
        }
        return valueSet;
    }

    public synchronized com.ibm.websphere.cache.CacheEntry getEntryDisk(Object object) {
        CacheEntry cacheEntry = null;
        if (this.swapToDisk) {
            cacheEntry = this.diskCache.readCacheEntry(object);
        }
        return cacheEntry;
    }

    public synchronized Collection getDepIdValueDisk(Object object) {
        ValueSet valueSet = null;
        if (this.swapToDisk) {
            valueSet = this.diskCache.readDependency(object, false);
        }
        return valueSet;
    }

    public synchronized Collection getTemplateValueDisk(String string) {
        ValueSet valueSet = null;
        if (this.swapToDisk) {
            valueSet = this.diskCache.readTemplate(string, false);
        }
        return valueSet;
    }

    public synchronized Set getCacheIdsByDependencyDisk(Object object) {
        ValueSet valueSet = null;
        if (this.swapToDisk) {
            valueSet = this.diskCache.readDependency(object, false);
        }
        if (valueSet == null) {
            valueSet = new ValueSet(0);
        }
        return valueSet;
    }

    public synchronized Set getCacheIdsByTemplateDisk(String string) {
        ValueSet valueSet = null;
        if (this.swapToDisk) {
            valueSet = this.diskCache.readTemplate(string, false);
        }
        if (valueSet == null) {
            valueSet = new ValueSet(0);
        }
        return valueSet;
    }

    public int getIdsSizeDisk() {
        if (this.swapToDisk) {
            int n = this.diskCache.getCacheIdsSize(true);
            return n > 0 ? n : 0;
        }
        return 0;
    }

    public int getActualIdsSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getCacheIdsSize(false);
        }
        return 0;
    }

    public int getDepIdsSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getDepIdsSize();
        }
        return 0;
    }

    public int getTemplatesSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getTemplatesSize();
        }
        return 0;
    }

    public int getPendingRemovalSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getPendingRemovalSize();
        }
        return 0;
    }

    public int getDepIdsBufferedSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getDepIdsBufferedSize();
        }
        return 0;
    }

    public int getTemplatesBufferedSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getTemplatesBufferedSize();
        }
        return 0;
    }

    public synchronized void clearDisk() {
        if (this.swapToDisk) {
            if (this.bEnableListener && this.eventSource.getPreInvalidationListenerCount() > 0 && !this.eventSource.shouldInvalidate("*", 1, 5)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "clearDisk() cacheName=" + this.cacheName + " skip clearing cache because PreInvalidationListener.shouldInvalidate() returns false.");
                }
                return;
            }
            this.diskCache.clearDiskCache();
            if (this.cachePerf.isPMIEnabled()) {
                this.cachePerf.onCacheClear(false, true);
            }
        }
    }

    public void invokeDiskCleanup(boolean bl) {
        if (this.swapToDisk) {
            this.diskCache.invokeDiskCleanup(bl);
        }
    }

    public boolean isDiskCleanupRunning() {
        if (this.swapToDisk) {
            return this.diskCache.isCleanupRunning();
        }
        return false;
    }

    public boolean isDiskInvalidationBufferFull() {
        if (this.swapToDisk) {
            return this.diskCache.isInvalidationBuffersFull();
        }
        return false;
    }

    public Exception getDiskCacheException() {
        return this.diskCache.getDiskCacheException();
    }

    public float getDiskCacheSizeInMBs() {
        if (this.swapToDisk) {
            float f = (float)this.diskCache.getCacheSizeInBytes() / 1048576.0f;
            return f > 0.0f ? f : 0.0f;
        }
        return 0.0f;
    }

    public void releaseDiskCacheUnusedPools() {
        if (this.swapToDisk && this.diskCache != null) {
            this.diskCache.releaseUnusedPools();
        }
    }

    public int getPushPullTableSize() {
        return this.remoteServices.getPushPullTableSize();
    }

    public synchronized boolean addInvalidationListener(InvalidationListener invalidationListener) {
        if (this.bEnableListener && invalidationListener != null) {
            this.eventSource.addListener(invalidationListener);
            return true;
        }
        return false;
    }

    public synchronized boolean removeInvalidationListener(InvalidationListener invalidationListener) {
        if (this.bEnableListener && invalidationListener != null) {
            this.eventSource.removeListener(invalidationListener);
            return true;
        }
        return false;
    }

    public synchronized boolean addPreInvalidationListener(PreInvalidationListener preInvalidationListener) {
        if (this.bEnableListener && preInvalidationListener != null) {
            if (this.eventSource.getPreInvalidationListenerCount() > 0 && tc.isDebugEnabled()) {
                Tr.debug(tc, "addPreInvalidationListener() cacheName=" + this.cacheName + " one already exists. Overwriting old listener.");
            }
            this.eventSource.addListener(preInvalidationListener);
            return true;
        }
        return false;
    }

    public synchronized boolean removePreInvalidationListener(PreInvalidationListener preInvalidationListener) {
        if (this.bEnableListener && preInvalidationListener != null) {
            this.eventSource.removeListener(preInvalidationListener);
            return true;
        }
        return false;
    }

    public synchronized boolean addChangeListener(ChangeListener changeListener) {
        if (this.bEnableListener && changeListener != null) {
            this.eventSource.addListener(changeListener);
            return true;
        }
        return false;
    }

    public synchronized boolean removeChangeListener(ChangeListener changeListener) {
        if (this.bEnableListener && changeListener != null) {
            this.eventSource.removeListener(changeListener);
            return true;
        }
        return false;
    }

    public void addToTimeLimitDaemon(Object object, long l, int n) {
        this.timeLimitDaemon.valueHasChanged(this, object, l, n);
    }

    public void refreshCachePerf() {
        if (this.cachePerf.isPMIEnabled() && System.currentTimeMillis() - this.lastTimeForStatistics > 1000L) {
            int n = this.entryHashtable.size();
            if (this.lastCachePerf_maxNumberCacheEntries != (long)this.cacheConfig.cacheSize || this.lastCachePerf_entryHashtableSize != (long)n) {
                this.cachePerf.updateCacheSizes(this.cacheConfig.cacheSize, n);
                this.lastCachePerf_maxNumberCacheEntries = this.cacheConfig.cacheSize;
                this.lastCachePerf_entryHashtableSize = n;
            }
            if (this.swapToDisk) {
                long l = this.getActualIdsSizeDisk();
                long l2 = this.getPendingRemovalSizeDisk();
                long l3 = this.getDepIdsSizeDisk();
                long l4 = this.getDepIdsBufferedSizeDisk();
                long l5 = this.cacheStatisticsListener.getDepIdsOffloadedToDiskCount();
                long l6 = this.cacheStatisticsListener.getDepIdBasedInvalidationsFromDiskCount();
                long l7 = this.cacheStatisticsListener.getTemplatesOffloadedToDiskCount();
                long l8 = this.cacheStatisticsListener.getTemplateBasedInvalidationsFromDiskCount();
                long l9 = this.getTemplatesSizeDisk();
                long l10 = this.getTemplatesBufferedSizeDisk();
                if (this.lastCachePerf_objectsOnDisk != l || this.lastCachePerf_pendingRemovalFromDisk != l2 || this.lastCachePerf_dependencyIdsOnDisk != l3 || this.lastCachePerf_dependencyIdsBufferedForDisk != l4 || this.lastCachePerf_dependencyIdsOffloadedToDisk != l5 || this.lastCachePerf_dependencyIdBasedInvalidationsFromDisk != l6 || this.lastCachePerf_templatesOnDisk != l9 || this.lastCachePerf_templatesBufferedForDisk != l10 || this.lastCachePerf_templatesOffloadedToDisk != l7 || this.lastCachePerf_templateBasedInvalidationsFromDisk != l8) {
                    this.cachePerf.updateDiskCacheStatistics(l, l2, l3, l4, l5, l6, l9, l10, l7, l8);
                    this.lastCachePerf_objectsOnDisk = l;
                    this.lastCachePerf_pendingRemovalFromDisk = l2;
                    this.lastCachePerf_dependencyIdsOnDisk = l3;
                    this.lastCachePerf_dependencyIdsBufferedForDisk = l4;
                    this.lastCachePerf_dependencyIdsOffloadedToDisk = l5;
                    this.lastCachePerf_dependencyIdBasedInvalidationsFromDisk = l6;
                    this.lastCachePerf_templatesOnDisk = l9;
                    this.lastCachePerf_templatesBufferedForDisk = l10;
                    this.lastCachePerf_templatesOffloadedToDisk = l7;
                    this.lastCachePerf_templateBasedInvalidationsFromDisk = l8;
                }
            }
            this.lastTimeForStatistics = System.currentTimeMillis();
        }
    }

    private void createCachePerf() {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createCachePerf() cacheName=" + this.cacheName);
            }
            assert (this.cachePerf == null);
            int n = 2;
            if (this.cacheConfig.enableServletSupport) {
                n = 1;
            }
            if (StatsFactory.isPMIEnabled()) {
                try {
                    this.cachePerf = new CacheStatsModule(n, this.cacheName, this.swapToDisk);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.Cache", "2116", this);
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "createCachePerf() Exception while creating PMI cacheModule: " + ExceptionUtility.getStackTrace(throwable));
                }
            }
        }
        if (this.cachePerf == null) {
            this.cachePerf = NullCachePerfModule.getInstance();
        }
        this.refreshCachePerf();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCachePerf() " + (this.cacheConfig.enableServletSupport ? "Servlet" : "Object") + " CachePerf for " + this.cacheName + " created. cachePerf=" + this.cachePerf);
        }
    }

    public void resetPMICounters() {
        if (this.cachePerf.isPMIEnabled()) {
            this.cacheStatisticsListener.reset();
            this.cachePerf.resetPMICounters();
            this.lastCachePerf_maxNumberCacheEntries = 0L;
            this.lastCachePerf_entryHashtableSize = 0L;
            this.lastCachePerf_objectsOnDisk = 0L;
            this.lastCachePerf_pendingRemovalFromDisk = 0L;
            this.lastCachePerf_dependencyIdsOnDisk = 0L;
            this.lastCachePerf_dependencyIdsBufferedForDisk = 0L;
            this.lastCachePerf_dependencyIdsOffloadedToDisk = 0L;
            this.lastCachePerf_dependencyIdBasedInvalidationsFromDisk = 0L;
            this.lastCachePerf_templatesOnDisk = 0L;
            this.lastCachePerf_templatesBufferedForDisk = 0L;
            this.lastCachePerf_templatesOffloadedToDisk = 0L;
            this.lastCachePerf_templateBasedInvalidationsFromDisk = 0L;
        }
    }

    private void updatePeerCaches(CacheEntry cacheEntry) {
        assert (cacheEntry != null);
        assert (cacheEntry.getSharingPolicy() != 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updatePeerCaches() Entry cacheName=" + this.cacheName + " isBatchEnabled=" + cacheEntry.isBatchEnabled() + " isDRSReady=" + this.remoteServices.isDRSReady() + " id=" + cacheEntry.id + " refCount=" + cacheEntry.refCount);
        }
        if (this.remoteServices.isDRSReady() && !this.cacheConfig.isDrsDisabled()) {
            if (!cacheEntry.isBatchEnabled()) {
                this.remoteServices.setEntry(cacheEntry);
                cacheEntry.finish();
            } else {
                this.batchUpdateDaemon.pushCacheEntry(cacheEntry, this);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updatePeerCaches() DRS is not ready!! - CE will be sent during bootstrap CE=" + cacheEntry);
            }
            cacheEntry.finish();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updatePeerCaches() Exit cacheName=" + this.cacheName + " id=" + cacheEntry.id + " refCount=" + cacheEntry.refCount);
        }
    }

    public void setEnableDiskCacheSizeInBytesChecking(boolean bl) {
        this.enableDiskCacheSizeInBytesChecking = bl;
    }

    public boolean hasPushPullEntries() {
        return this.hasPushPullEntries;
    }

    public long getCacheSizeInBytesDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getCacheSizeInBytes();
        }
        return 0L;
    }
}

