/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheServiceImpl;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.FieldInitializer;
import com.ibm.wsspi.cache.CacheConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CacheConfig
implements Cloneable,
com.ibm.wsspi.cache.CacheConfig {
    private static TraceComponent tc = Trace.register(CacheConfig.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final String CACHE_NAME = "com.ibm.ws.cache.CacheConfig.cacheName";
    public static final String CACHE_SIZE = "com.ibm.ws.cache.CacheConfig.cacheSize";
    public static final String USE_LISTENER_CONTEXT = "com.ibm.ws.cache.CacheConfig.useListenerContext";
    public static final String ENABLE_LOCKING_SUPPORT = "com.ibm.ws.cache.CacheConfig.enableLockingSupport";
    public static final String DISABLE_DEPENDENCY_ID = "com.ibm.ws.cache.CacheConfig.disableDependencyId";
    public static final String DISABLE_TEMPLATES_SUPPORT = "com.ibm.ws.cache.CacheConfig.disableTemplatesSupport";
    public static final String ENABLE_NIO_SUPPORT = "com.ibm.ws.cache.CacheConfig.enableNioSupport";
    public static final String ENABLE_DISK_OFFLOAD = "com.ibm.ws.cache.CacheConfig.enableDiskOffload";
    public static final String FLUSH_TO_DISK_ON_STOP = "com.ibm.ws.cache.CacheConfig.flushToDiskOnStop";
    public static final String DISK_OFFLOAD_LOCATION = "com.ibm.ws.cache.CacheConfig.diskOffloadLocation";
    public static final String DISK_CLEANUP_FREQUENCY = "com.ibm.ws.cache.CacheConfig.htodCleanupFrequency";
    public static final String DISK_DELAY_OFFLOAD = "com.ibm.ws.cache.CacheConfig.htodDelayOffload";
    public static final String DISK_DELAY_OFFLOAD_ENTRIES_LIMIT = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadEntriesLimit";
    public static final String DISK_DELAY_OFFLOAD_DEPID_BUCKETS = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadDepIdBuckets";
    public static final String DISK_DELAY_OFFLOAD_TEMPLATE_BUCKETS = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadTemplateBuckets";
    public static final String DISKCACHE_PERFORMANCE_LEVEL = "com.ibm.ws.cache.CacheConfig.diskCachePerformanceLevel";
    public static final String DISKCACHE_EVICTION_POLICY = "com.ibm.ws.cache.CacheConfig.diskCacheEvictionPolicy";
    public static final String DISKCACHE_HIGH_THRESHOLD = "com.ibm.ws.cache.CacheConfig.diskCacheHighThreshold";
    public static final String DISKCACHE_LOW_THRESHOLD = "com.ibm.ws.cache.CacheConfig.diskCacheLowThreshold";
    public static final String DISKCACHE_SIZE = "com.ibm.ws.cache.CacheConfig.diskCacheSize";
    public static final String DISKCACHE_SIZE_GB = "com.ibm.ws.cache.CacheConfig.diskCacheSizeInGB";
    public static final String DISKCACHE_ENTRY_SIZE_MB = "com.ibm.ws.cache.CacheConfig.diskCacheEntrySizeInMB";
    public static final String DISKCACHE_EXPLICIT_BUFFER_LIMIT_ON_STOP = "com.ibm.ws.cache.CacheConfig.explicitBufferLimitOnStop";
    public static final String USE_SERVER_CLASSLOADER = "com.ibm.ws.cache.CacheConfig.useServerClassLoader";
    public static final String FILTER_TIMEOUT_INVALIDATION = "com.ibm.ws.cache.CacheConfig.filterTimeOutInvalidation";
    public static final String FILTER_LRU_INVALIDATION = "com.ibm.ws.cache.CacheConfig.filterLRUInvalidation";
    public static final String IGNORE_VALUE_IN_INVALIDATION_EVENT = "com.ibm.ws.cache.CacheConfig.ignoreValueInInvalidationEvent";
    public static final String LRU_TO_DISK_TRIGGER_TIME = "com.ibm.ws.cache.CacheConfig.lruToDiskTriggerTime";
    public static final String LRU_TO_DISK_TRIGGER_PERCENT = "com.ibm.ws.cache.CacheConfig.lruToDiskTriggerPercent";
    public static final String ENABLE_REPLICATION_ACKS = "com.ibm.ws.cache.CacheConfig.enableReplicationAcks";
    public static final String ENABLE_CACHE_REPLICATION = "com.ibm.ws.cache.CacheConfig.enableCacheReplication";
    public static final String REPLICATION_DOMAIN = "com.ibm.ws.cache.CacheConfig.replicationDomain";
    public static final String CACHE_ENTRY_WINDOW = "com.ibm.ws.cache.CacheConfig.cacheEntryWindow";
    public static final String CACHE_PERCENTAGE_WINDOW = "com.ibm.ws.cache.CacheConfig.cachePercentageWindow";
    public static final String CACHE_INVALIDATE_ENTRY_WINDOW = "com.ibm.ws.cache.CacheConfig.cacheInvalidateEntryWindow";
    public static final String CACHE_INVALIDATE_PERCENT_WINDOW = "com.ibm.ws.cache.CacheConfig.cacheInvalidatePercentWindow";
    public static final String PROPOGATE_INVALIDATIONS_NOT_SHARED = "com.ibm.ws.cache.CacheConfig.propogateInvalidationsNotShared";
    public static final String DYNACACHE_BASE_REPLICATION_TYPE = "DynacacheUnmanagedServerReplicationType";
    public static final String DYNACACHE_ENABLE_BASE_REPLICATION = "DynacacheEnableUnmanagedServerReplication";
    public static final String DYNACACHE_BASE_SERVER_DOMAIN = "Dynacache_Base_Server_Domain";
    public static final String BATCH_UPDATE_MILLISECONDS = "com.ibm.ws.cache.CacheConfig.batchUpdateMilliseconds";
    public static final String CASCADE_CACHESPEC_PROPERTIES = "com.ibm.ws.cache.CacheConfig.cascadeCachespecProperties";
    public static final String ALWAYS_SET_SURROGATE_CONTROL_HDR = "com.ibm.ws.cache.CacheConfig.alwaysSetSurrogateControlHdr";
    public static final String CACHE_PROVIDER_RESTORE_DYNACACHE_DEFAULTS = "com.ibm.ws.cache.CacheConfig.restoreDynacacheDefaults";
    public static final String CACHE_PROVIDER_NAME = "com.ibm.ws.cache.CacheConfig.cacheProviderName";
    public static final String CACHE_PROVIDER_OBJECT_GRID = "com.ibm.ws.objectgrid.dynacache.CacheProviderImpl";
    public static final String CACHE_PROVIDER_DYNACACHE = "default";
    public static final String USE_602_REQUIRED_ATTR_COMPATIBILITY = "com.ibm.ws.use602RequiredAttrCompatibility";
    public static final String ALWAYS_SYNCHRONIZE_ON_GETS = "com.ibm.ws.cache.CacheConfig.alwaysSynchronizeOnGets";
    public static final String CACHE_NAME_NON_PREFIXED = "com.ibm.ws.cache.CacheConfig.cacheNameNonPrefixed";
    public static final int CACHE_UNITS_ENTRIES = 1;
    public static final int CACHE_UNITS_KILOBYTES = 2;
    static final int UNKNOWN_SOURCE = -1;
    static final int WCCM_DYNAMIC_CACHE = 1;
    static final int WCCM_CACHE_INSTANCE = 2;
    static final int WCCM_SERVLET_CACHE_INSTANCE = 3;
    static final int WCCM_OBJECT_CACHE_INSTANCE = 4;
    static final int FILE_SERVLET_CACHE_INSTANCE = 5;
    static final int FILE_OBJECT_CACHE_INSTANCE = 6;
    static final int FACTORY_SERVLET_CACHE_INSTANCE = 7;
    static final int FACTORY_OBJECT_CACHE_INSTANCE = 8;
    static final int INTERNAL_BASE_CACHE = 254;
    static final int INTERNAL_DMAP_CACHE = 255;
    public static final int HIGH = 3;
    public static final int CUSTOM = 2;
    public static final int BALANCED = 1;
    public static final int LOW = 0;
    public static final int EVICTION_NONE = 0;
    public static final int EVICTION_RANDOM = 1;
    public static final int EVICTION_SIZE_BASED = 2;
    boolean filterTimeOutInvalidation = false;
    boolean filterLRUInvalidation = false;
    public static final int DEFAULT_DISKCACHE_PERFORMANCE_LEVEL = 1;
    public static final int DEFAULT_DISKCACHE_EVICTION_POLICY = 0;
    public static final boolean DEFAULT_DISKCACHE_DELAY_OFFLOAD = true;
    public static final int DEFAULT_DISKCACHE_CLEANUP_FREQUENCY = 0;
    public static final int DEFAULT_MAX_BUFFERED_CACHE_IDS_PER_METADATA = 1000;
    public static final int DEFAULT_MAX_BUFFERED_DEPENDENCY_IDS = 1000;
    public static final int DEFAULT_MAX_BUFFERED_TEMPLATES = 100;
    public static final int DEFAULT_HIGH_THRESHOLD = 80;
    public static final int DEFAULT_LOW_THRESHOLD = 70;
    public static final int DEFAULT_DISKCACHE_SIZE = 0;
    public static final int DEFAULT_DISKCACHE_SIZE_GB = 0;
    public static final int DEFAULT_DISKCACHE_ENTRY_SIZE_MB = 0;
    public static final int DEFAULT_DISKCACHE_POOL_ENTRY_LIFE = 300000;
    public static final int DEFAULT_EXPLICIT_BUFFER_LIMIT_ON_STOP = 0;
    public static final int DEFAULT_ENTRY_WINDOW = 50;
    public static final int DEFAULT_PERCENTAGE_WINDOW = 2;
    public static final int DEFAULT_TLD_TIME_GRANULARITY = 5;
    public static final int DEFAULT_LRU_TO_DISK_TRIGGER_TIME = 5000;
    public static final int DEFAULT_LRU_TO_DISK_TRIGGER_PERCENT = 0;
    public static final int MAX_DISKCACHE_PERFORMANCE_LEVEL = 3;
    public static final int MIN_DISKCACHE_PERFORMANCE_LEVEL = 0;
    public static final int MAX_CLEANUP_FREQUENCY = 1440;
    public static final int MIN_CLEANUP_FREQUENCY = 0;
    public static final int MAX_DISKCACHE_BUFFERED_CACHE_IDS_PER_METADATA = Integer.MAX_VALUE;
    public static final int MIN_DISKCACHE_BUFFERED_CACHE_IDS_PER_METADATA = 100;
    public static final int MAX_DISKCACHE_BUFFERED_DEPENDENCY_IDS = Integer.MAX_VALUE;
    public static final int MIN_DISKCACHE_BUFFERED_DEPENDENCY_IDS = 100;
    public static final int MAX_DISKCACHE_BUFFERED_TEMPLATES = Integer.MAX_VALUE;
    public static final int MIN_DISKCACHE_BUFFERED_TEMPLATES = 10;
    public static final int MAX_DISKCACHE_EVICTION_POLICY = 2;
    public static final int MIN_DISKCACHE_EVICTION_POLICY = 0;
    public static final int MAX_DISKCACHE_SIZE = Integer.MAX_VALUE;
    public static final int MIN_DISKCACHE_SIZE = 20;
    public static final int MAX_DISKCACHE_SIZE_GB = Integer.MAX_VALUE;
    public static final int MIN_DISKCACHE_SIZE_GB = 3;
    public static final int MAX_DISKCACHE_ENTRY_SIZE_MB = Integer.MAX_VALUE;
    public static final int MIN_DISKCACHE_ENTRY_SIZE_MB = 0;
    public static final int MAX_HIGH_THRESHOLD = 100;
    public static final int MIN_HIGH_THRESHOLD = 1;
    public static final int MAX_LOW_THRESHOLD = 100;
    public static final int MIN_LOW_THRESHOLD = 1;
    public static final int MAX_LRU_TO_DISK_TRIGGER_TIME = 5000;
    public static final int MIN_LRU_TO_DISK_TRIGGER_TIME = 1;
    public static final int MAX_LRU_TO_DISK_TRIGGER_PERCENT = 100;
    public static final int MIN_LRU_TO_DISK_TRIGGER_PERCENT = 0;
    public static int DEFAULT_PRIORITY = 1;
    public static int MAX_PRIORITY = 16;
    String cacheProviderName = "default";
    boolean restoreDynacacheDefaults = true;
    boolean defaultProvider = true;
    int configSource = -1;
    String cacheName = null;
    String cacheNameNonPrefixed = null;
    String tempDir = null;
    String propertiesDir = null;
    String dtdDir = null;
    String serverCellName = null;
    String serverNodeName = null;
    String serverServerName = null;
    String serverNameFQ = null;
    int cachePriority = CacheEntry.DEFAULT_PRIORITY;
    int jspCachePriority = CacheEntry.DEFAULT_PRIORITY;
    int commandCachePriority = CacheEntry.DEFAULT_PRIORITY;
    int diskHashBuckets = 1024;
    String topology = "";
    int cacheUnits = 1;
    int cacheSize = 2000;
    String replicationDomain = null;
    boolean enableCacheReplication = false;
    int replicationType = 0;
    int defaultShareType = 1;
    String notificationType = "unicast";
    String cacheSprayerName = "com.ibm.ws.cache.CacheSprayerImpl";
    DRSSettings drss = null;
    int pushFrequency = 1;
    int batchUpdateInterval = 1000;
    boolean enableDiskOffload = false;
    String diskOffloadLocation = null;
    boolean flushToDiskOnStop = false;
    int htodCleanupFrequency = 0;
    int diskCachePerformanceLevel = 1;
    int diskCacheEntrySizeInMB = 0;
    int diskCacheSizeInGB = 0;
    int diskCacheSize = 0;
    int diskCacheEvictionPolicy = 0;
    int diskCacheHighThreshold = 80;
    int diskCacheLowThreshold = 70;
    List externalGroups = new ArrayList();
    boolean useListenerContext = false;
    boolean disableDependencyId = false;
    boolean enableLockingSupport = false;
    boolean disableTemplatesSupport = false;
    boolean enableReplicationAcks = false;
    boolean enableNioSupport = false;
    boolean enableServletSupport = false;
    boolean propogateInvalidationsNotShared = false;
    boolean alwaysSetSurrogateControlHdr = false;
    int maxTimeLimitInSeconds = 86400;
    int configReloadInterval = 5000;
    int timeGranularityInSeconds = 5;
    int lruToDiskTriggerTime = 5000;
    int lruToDiskTriggerPercent = 0;
    int timeHoldingInvalidations = 300000;
    int htodCleanupHour = 0;
    long htodInvalInterval = 86400000L;
    boolean htodDelayOffload = true;
    int htodDelayOffloadDepIdBuckets = 1000;
    int htodDelayOffloadTemplateBuckets = 100;
    int htodDelayOffloadEntriesLimit = 1000;
    int htodDataHashtableSize = 477551;
    int htodDepIdHashtableSize = 47743;
    int htodTemplateHashtableSize = 1031;
    int htodNumberOfPools = 20;
    int htodPoolSize = 2;
    int htodPoolEntryLife = 300000;
    int htodInvalidationBufferSize = 1000;
    int htodInvalidationBufferLife = 10000;
    int explicitBufferLimitOnStop = 0;
    int cacheEntryWindow = 50;
    int cachePercentageWindow = 2;
    int cacheInvalidateEntryWindow = 50;
    int cacheInvalidatePercentWindow = 2;
    int batchUpdateMilliseconds = -1;
    boolean drsDisabled = false;
    boolean drsBootstrapEnabled = true;
    public boolean disableTemplateInvalidation = false;
    boolean ignoreValueInInvalidationEvent = false;
    boolean useServerClassLoader = false;
    boolean cascadeCachespecProperties = false;
    boolean use602RequiredAttrCompatibility = false;
    boolean alwaysSynchronizeOnGets = false;
    String disableStoreCookies = "none";
    boolean cacheInstanceStoreCookies = true;
    String commandStoragePolicyClassName = "com.ibm.ws.cache.command.SerializedPutCommandStorage";
    DistributedObjectCache distributedObjectCache = null;
    DCache cache = null;
    Map _passedInProperties = new HashMap();

    public CacheConfig() {
        FieldInitializer.initFromSystemProperties(this);
    }

    protected void reset() {
        this.configSource = -1;
        this.tempDir = null;
        this.propertiesDir = null;
        this.dtdDir = null;
        this.diskOffloadLocation = null;
        this.drss = null;
        this.cacheName = null;
        this.distributedObjectCache = null;
        this.cache = null;
        this.serverCellName = null;
        this.serverNodeName = null;
        this.serverServerName = null;
        this.serverNameFQ = null;
        if (this.externalGroups != null) {
            this.externalGroups.clear();
        }
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public void setEnableDiskOffload(boolean bl) {
        this.enableDiskOffload = bl;
        this.processOffloadDirectory();
    }

    public void setEnableNioSupport(boolean bl) {
        this.enableNioSupport = bl;
    }

    public void setDiskOffloadLocation(String string) {
        this.diskOffloadLocation = string;
    }

    public void setOffloadOffloadLocationAndProcess(String string) {
        this.diskOffloadLocation = string;
        this.processOffloadDirectory();
    }

    private void processOffloadDirectory() {
        if (this.enableDiskOffload) {
            String string;
            String string2 = "";
            String string3 = this.tempDir + this.serverNodeName + File.separator + this.serverServerName + File.separator + "_dynacache";
            string3 = File.separatorChar == '\\' ? string3.replace('/', File.separatorChar) : string3.replace('\\', File.separatorChar);
            if (this.diskOffloadLocation != null && this.diskOffloadLocation.trim().length() != 0) {
                if (this.diskOffloadLocation.indexOf("##") > 0) {
                    return;
                }
                if (this.diskOffloadLocation.equals(string3)) {
                    return;
                }
                string2 = this.diskOffloadLocation.endsWith("/") || this.diskOffloadLocation.endsWith("\\") ? this.diskOffloadLocation + this.serverNodeName + File.separator + this.serverServerName : this.diskOffloadLocation + File.separator + this.serverNodeName + File.separator + this.serverServerName;
            }
            this.diskOffloadLocation = string2.equals("") ? string3 : string2 + "##" + string3;
            this.diskOffloadLocation = File.separatorChar == '\\' ? this.diskOffloadLocation.replace('/', File.separatorChar) : this.diskOffloadLocation.replace('\\', File.separatorChar);
            CacheServiceImpl cacheServiceImpl = (CacheServiceImpl)CacheServiceImpl.getCacheService();
            if (cacheServiceImpl != null && this.diskOffloadLocation != null && (string = cacheServiceImpl.expandWebSphereVariable(this.diskOffloadLocation)) != null && !string.equals("")) {
                this.diskOffloadLocation = string;
            }
        }
    }

    public void overrideCacheConfig(Properties properties) {
        if (properties != null) {
            FieldInitializer.initFromSystemProperties(this, properties);
        }
        this.processOffloadDirectory();
        if (!this.enableServletSupport) {
            this.disableTemplatesSupport = true;
        }
    }

    protected String fixPath(String string) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public boolean verifyConfig() {
        assert (new File(this.tempDir).isDirectory());
        assert (new File(this.propertiesDir).isDirectory());
        assert (new File(this.dtdDir).isDirectory());
        assert (this.cacheName != null);
        assert (!this.cacheName.trim().equals(""));
        assert (this.configSource == 3 || this.configSource == 4 || this.configSource == 2 || this.configSource == 1 || this.configSource == 6 || this.configSource == 5 || this.configSource == 8 || this.configSource == 7);
        assert (this.serverNodeName != null);
        assert (this.serverServerName != null);
        return true;
    }

    public Object getDrsSettings() {
        return this.drss;
    }

    public void setDrsSettings(Object object) {
        this.drss = (DRSSettings)object;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.cache.CacheConfig", "314");
            exception.printStackTrace();
        }
        ((CacheConfig)object).cache = null;
        ((CacheConfig)object).distributedObjectCache = null;
        ((CacheConfig)object).enableServletSupport = false;
        ((CacheConfig)object).enableDiskOffload = false;
        ((CacheConfig)object).flushToDiskOnStop = false;
        ((CacheConfig)object).disableDependencyId = false;
        ((CacheConfig)object).disableTemplatesSupport = false;
        return object;
    }

    public int getBatchUpdateInterval() {
        return this.batchUpdateInterval;
    }

    public int getCachePriority() {
        return this.cachePriority;
    }

    public int getEntryWindow() {
        return this.cacheEntryWindow;
    }

    public int getPercentageWindow() {
        return this.cachePercentageWindow;
    }

    public int getInvalidateEntryWindow() {
        return this.cacheInvalidateEntryWindow;
    }

    public int getInvalidatePercentageWindow() {
        return this.cacheInvalidatePercentWindow;
    }

    public boolean isCascadeCachespecProperties() {
        return this.cascadeCachespecProperties;
    }

    public void setCacheInstanceStoreCookies(boolean bl) {
        this.cacheInstanceStoreCookies = bl;
    }

    public boolean isDrsDisabled() {
        return this.drsDisabled;
    }

    public void setDRSDisabled(boolean bl) {
        this.drsDisabled = bl;
    }

    public void setDrsBootstrapEnabled(boolean bl) {
        this.drsBootstrapEnabled = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDRSBootstrap() cacheName=" + this.cacheName + " drsBootstrap=" + bl);
        }
    }

    public boolean isUseServerClassLoader() {
        return this.useServerClassLoader;
    }

    public int getLruToDiskTriggerPercent() {
        return this.lruToDiskTriggerPercent;
    }

    public int getLruToDiskTriggerTime() {
        return this.lruToDiskTriggerTime;
    }

    public boolean isCacheInstanceStoreCookies() {
        return this.cacheInstanceStoreCookies;
    }

    public boolean alwaysSetSurrogateControlHdr() {
        return this.alwaysSetSurrogateControlHdr;
    }

    public boolean isDRSBootstrapEnabled() {
        return this.drsBootstrapEnabled;
    }

    public void setDrsDisabled(boolean bl) {
        this.drsDisabled = bl;
    }

    public int getCleanupFrequency() {
        return this.htodCleanupFrequency;
    }

    public int getDelayOffloadDepIdBuckets() {
        return this.htodDelayOffloadDepIdBuckets;
    }

    public int getDelayOffloadEntriesLimit() {
        return this.htodDelayOffloadEntriesLimit;
    }

    public int getDelayOffloadTemplateBuckets() {
        return this.htodDelayOffloadTemplateBuckets;
    }

    public int getDiskCacheEntrySizeInMB() {
        return this.diskCacheEntrySizeInMB;
    }

    public int getDiskCacheEvictionPolicy() {
        return this.diskCacheEvictionPolicy;
    }

    public int getDiskCacheHighThreshold() {
        return this.diskCacheHighThreshold;
    }

    public int getDiskCacheLowThreshold() {
        return this.diskCacheLowThreshold;
    }

    public int getDiskCachePerformanceLevel() {
        return this.diskCachePerformanceLevel;
    }

    public int getDiskCacheSize() {
        return this.diskCacheSize;
    }

    public int getDiskCacheSizeInGB() {
        return this.diskCacheSizeInGB;
    }

    public boolean isFlushToDiskOnStop() {
        return this.flushToDiskOnStop;
    }

    public boolean isDelayOffload() {
        return this.htodDelayOffload;
    }

    public boolean isFilterLRUInvalidation() {
        return this.filterLRUInvalidation;
    }

    public boolean isFilterTimeOutInvalidation() {
        return this.filterTimeOutInvalidation;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public CacheConfig.EvictorAlgorithmType getEvictorAlgorithmType() {
        return CacheConfig.EvictorAlgorithmType.LRUEvictor;
    }

    public int getHighThresholdCacheSizeInMB() {
        return -1;
    }

    public int getLowThresholdCacheSizeInMB() {
        return -1;
    }

    public long getMaxCacheSize() {
        return this.cacheSize;
    }

    public long getMaxCacheSizeInMB() {
        return -1L;
    }

    public boolean isDistributed() {
        return this.enableCacheReplication;
    }

    public String getCacheProviderName() {
        return this.cacheProviderName;
    }

    public void setCachePriority(int n) {
        if (n < 0) {
            n = DEFAULT_PRIORITY;
        }
        this.cachePriority = n;
    }

    public boolean isPropogateInvalidationsNotShared() {
        return this.propogateInvalidationsNotShared;
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this._passedInProperties);
    }

    public void determineCacheProvider() {
        this.defaultProvider = true;
        if (!this.cacheProviderName.equals(CACHE_PROVIDER_DYNACACHE)) {
            this.defaultProvider = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Alternate CacheProvider " + this.cacheProviderName + " set for " + this.cacheName);
            }
        }
    }

    public boolean isDefaultCacheProvider() {
        return this.defaultProvider;
    }

    public boolean isUse602RequiredAttrCompatibility() {
        return this.use602RequiredAttrCompatibility;
    }

    public void resetProvider() {
        if (tc.isDebugEnabled()) {
            Tr.warning(tc, "ENGLISH ONLY MESSAGE: Reverting to the default Dynacache cache provider for " + this.cacheName);
        }
        this.cacheProviderName = CACHE_PROVIDER_DYNACACHE;
        this.enableCacheReplication = false;
        this.defaultProvider = true;
    }

    static class Environment {
        String tmpDir = null;
        String propDir = null;
        String dtdDir = null;
        String serverCellName = null;
        String serverNodeName = null;
        String serverServerName = null;
        boolean isZOS = false;

        Environment() {
        }
    }

    static class ExternalCacheGroupMember {
        String address;
        String beanName;

        ExternalCacheGroupMember() {
        }
    }

    static class ExternalCacheGroup {
        String name;
        int type;
        List members;

        ExternalCacheGroup() {
        }
    }
}

