/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedNioMapObject;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.InvalidationEvent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.drs.ws390.DynacachePlatformHelper;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.cache.webservices.client.JAXRPCEntryInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;

public class CacheEntry
implements com.ibm.websphere.cache.CacheEntry,
InvalidationEvent,
Externalizable {
    private static final long serialVersionUID = -3194658354293955553L;
    private static TraceComponent tc = Trace.register(CacheEntry.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static boolean assertRanOnce = false;
    protected transient CacheEntryPool cacheEntryPool = null;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final int CACHE_TYPE_JAXRPC = 1;
    public static int DEFAULT_PRIORITY = 1;
    public static int MAX_PRIORITY = 16;
    public Object id = null;
    protected byte[] serializedId = null;
    protected Object value = null;
    protected byte[] serializedValue = null;
    protected Object userMetaData = null;
    protected byte[] serializedUserMetaData = null;
    protected int priority = DEFAULT_PRIORITY;
    protected int timeLimit = -1;
    protected int inactivity = -1;
    public long expirationTime = -1L;
    protected long drsClock = -1L;
    public long timeStamp = -1L;
    protected String[] _templates = EMPTY_STRING_ARRAY;
    protected Object[] _dataIds = EMPTY_OBJECT_ARRAY;
    protected Object[] _serializedDataIds = null;
    protected boolean invalid = false;
    protected int sharingPolicy = 1;
    protected boolean persistToDisk = true;
    protected boolean useBatch = false;
    public int cacheType = 0;
    protected boolean useByteBuffer = false;
    protected boolean skipMemoryAndWriteToDisk = false;
    protected transient int clock = DEFAULT_PRIORITY;
    protected transient int refCount = 0;
    protected transient boolean removeWhenUnpinned = false;
    protected transient boolean isOverflowEntry = false;
    protected transient boolean lruEvicted = false;
    protected Object[] aliasList = EMPTY_OBJECT_ARRAY;
    protected Object[] serializedAliasList = null;
    protected transient LRUHead lruHead;
    protected transient CacheEntry _previous = null;
    protected transient CacheEntry _next = null;
    protected transient boolean loadedFromDisk = false;
    protected transient boolean skipValueSerialized = false;
    protected transient int skipMemoryAndWriteToDiskErrorCode = 0;
    private static boolean errorAlreadyDisplayed = false;

    public CacheEntry() {
        assert (assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this));
    }

    public synchronized boolean prepareForSerialization() {
        boolean bl = true;
        String string = null;
        if (this.value != null) {
            try {
                this.serializedValue = SerializationUtility.serialize((Serializable)this.value);
                if (this.useByteBuffer && this.value instanceof DistributedNioMapObject) {
                    ((DistributedNioMapObject)this.value).release();
                }
                this.value = null;
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (this.value != null) {
                Tr.error(tc, "DYNA0052E", new Object[]{this.id, this.value.getClass().getName(), string});
                bl = false;
            }
        }
        if (this.serializedId == null && bl) {
            try {
                this.serializedId = SerializationUtility.serialize((Serializable)this.id);
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (this.serializedId == null) {
                Tr.error(tc, "DYNA0052E", new Object[]{this.id == null ? "null" : this.id.getClass().getName(), this.value == null ? "null" : this.value.getClass().getName(), string});
                bl = false;
            }
        }
        if (this._serializedDataIds == null && this._dataIds.length > 0 && bl) {
            this._serializedDataIds = new Object[this._dataIds.length];
            int n = 0;
            try {
                for (n = 0; n < this._dataIds.length; ++n) {
                    this._serializedDataIds[n] = SerializationUtility.serialize((Serializable)this._dataIds[n]);
                }
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (string != null) {
                if (this._dataIds[n] != null) {
                    Tr.error(tc, "DYNA0052E", new Object[]{this.id, this.value.getClass().getName(), string});
                }
                bl = false;
                this._serializedDataIds = null;
            }
        }
        if (this.serializedAliasList == null && this.aliasList.length > 0 && bl) {
            this.serializedAliasList = new Object[this.aliasList.length];
            int n = 0;
            try {
                for (n = 0; n < this.aliasList.length; ++n) {
                    this.serializedAliasList[n] = SerializationUtility.serialize((Serializable)this.aliasList[n]);
                }
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (string != null) {
                if (this.aliasList[n] != null) {
                    Tr.error(tc, "dynacache.error", new Object[]{"OBJECT_NOT_REPLICATED_OR_SAVED_TO_DISK for alias class name=" + this.aliasList[n].getClass().getName() + " exception=" + string});
                }
                bl = false;
                this.serializedAliasList = null;
            }
        }
        if (this.userMetaData != null) {
            try {
                this.serializedUserMetaData = SerializationUtility.serialize((Serializable)this.userMetaData);
                this.userMetaData = null;
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (this.userMetaData != null) {
                Tr.error(tc, "dynacache.error", new Object[]{"OBJECT_NOT_REPLICATED_OR_SAVED_TO_DISK for user metadata class name=" + this.userMetaData.getClass().getName() + " exception=" + string});
                bl = false;
            }
        }
        return bl;
    }

    public void processDrsInbound(long l) {
        if (this.drsClock <= 0L) {
            return;
        }
        long l2 = l - this.drsClock;
        if (this.expirationTime > 0L) {
            this.expirationTime += l2;
        }
        if (this.timeStamp > 0L) {
            this.timeStamp += l2;
        }
        this.drsClock = -1L;
    }

    public void processDrsOutbound() {
        this.drsClock = System.currentTimeMillis();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        byte[] byArray;
        int n;
        if (!this.prepareForSerialization()) {
            throw new IOException("Object not serializable: " + this.value == null ? "null object" : this.value.getClass().getName());
        }
        if (this.serializedId != null) {
            objectOutput.writeInt(this.serializedId.length);
            objectOutput.write(this.serializedId);
        } else {
            objectOutput.writeInt(-1);
        }
        if (this.skipValueSerialized) {
            objectOutput.writeInt(-1);
        } else if (this.serializedValue != null) {
            objectOutput.writeInt(this.serializedValue.length);
            objectOutput.write(this.serializedValue);
        } else {
            objectOutput.writeInt(-1);
        }
        objectOutput.writeInt(this.priority);
        objectOutput.writeInt(this.timeLimit);
        objectOutput.writeInt(this.inactivity);
        objectOutput.writeLong(this.expirationTime);
        objectOutput.writeLong(this.timeStamp);
        objectOutput.writeLong(this.drsClock);
        objectOutput.writeInt(this.cacheType);
        objectOutput.writeObject(this._templates);
        if (this._serializedDataIds != null) {
            objectOutput.writeInt(this._serializedDataIds.length);
            for (n = 0; n < this._serializedDataIds.length; ++n) {
                byArray = (byte[])this._serializedDataIds[n];
                objectOutput.writeInt(byArray.length);
                objectOutput.write(byArray);
            }
        } else {
            objectOutput.writeInt(-1);
        }
        objectOutput.writeBoolean(this.invalid);
        objectOutput.writeInt(this.sharingPolicy);
        objectOutput.writeBoolean(this.persistToDisk);
        objectOutput.writeBoolean(this.useBatch);
        objectOutput.writeBoolean(this.useByteBuffer);
        if (this.serializedAliasList != null) {
            objectOutput.writeInt(this.serializedAliasList.length);
            for (n = 0; n < this.serializedAliasList.length; ++n) {
                byArray = (byte[])this.serializedAliasList[n];
                objectOutput.writeInt(byArray.length);
                objectOutput.write(byArray);
            }
        } else {
            objectOutput.writeInt(-1);
        }
        if (this.serializedUserMetaData != null) {
            objectOutput.writeInt(this.serializedUserMetaData.length);
            objectOutput.write(this.serializedUserMetaData);
        } else {
            objectOutput.writeInt(-1);
        }
        objectOutput.writeBoolean(this.skipMemoryAndWriteToDisk);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        block36: {
            try {
                int n;
                int n2;
                int n3 = objectInput.readInt();
                if (n3 > 0) {
                    this.serializedId = new byte[n3];
                    objectInput.readFully(this.serializedId);
                } else {
                    this.serializedId = null;
                }
                if (this.serializedId != null) {
                    try {
                        if (!DynacachePlatformHelper.isZOS_Controller()) {
                            this.id = SerializationUtility.deserialize(this.serializedId);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.readExternal", "366", this);
                        exception.printStackTrace();
                    }
                } else {
                    this.id = null;
                }
                if ((n2 = objectInput.readInt()) > 0) {
                    this.serializedValue = new byte[n2];
                    objectInput.readFully(this.serializedValue);
                } else {
                    this.serializedValue = null;
                }
                this.value = null;
                this.priority = objectInput.readInt();
                this.timeLimit = objectInput.readInt();
                this.inactivity = objectInput.readInt();
                this.expirationTime = objectInput.readLong();
                this.timeStamp = objectInput.readLong();
                this.drsClock = objectInput.readLong();
                this.cacheType = objectInput.readInt();
                this._templates = (String[])objectInput.readObject();
                int n4 = objectInput.readInt();
                if (n4 > 0) {
                    this._serializedDataIds = new Object[n4];
                    for (n = 0; n < n4; ++n) {
                        n2 = objectInput.readInt();
                        this._serializedDataIds[n] = new byte[n2];
                        objectInput.readFully((byte[])this._serializedDataIds[n]);
                    }
                } else {
                    this._serializedDataIds = null;
                }
                if (this._serializedDataIds != null) {
                    this._dataIds = new Object[this._serializedDataIds.length];
                    try {
                        if (!DynacachePlatformHelper.isZOS_Controller()) {
                            for (n = 0; n < this._serializedDataIds.length; ++n) {
                                this._dataIds[n] = SerializationUtility.deserialize((byte[])this._serializedDataIds[n]);
                            }
                            this._serializedDataIds = null;
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.readExternal", "388", this);
                        exception.printStackTrace();
                        this._dataIds = EMPTY_OBJECT_ARRAY;
                    }
                } else {
                    this._dataIds = EMPTY_OBJECT_ARRAY;
                }
                this.invalid = objectInput.readBoolean();
                this.sharingPolicy = objectInput.readInt();
                this.persistToDisk = objectInput.readBoolean();
                this.useBatch = objectInput.readBoolean();
                this.useByteBuffer = objectInput.readBoolean();
                n4 = objectInput.readInt();
                if (n4 > 0) {
                    this.serializedAliasList = new Object[n4];
                    for (int i = 0; i < n4; ++i) {
                        n2 = objectInput.readInt();
                        this.serializedAliasList[i] = new byte[n2];
                        objectInput.readFully((byte[])this.serializedAliasList[i]);
                    }
                } else {
                    this.serializedAliasList = null;
                }
                if (this.serializedAliasList != null) {
                    this.aliasList = new Object[this.serializedAliasList.length];
                    try {
                        if (!DynacachePlatformHelper.isZOS_Controller()) {
                            for (int i = 0; i < this.serializedAliasList.length; ++i) {
                                this.aliasList[i] = SerializationUtility.deserialize((byte[])this.serializedAliasList[i]);
                            }
                            this.serializedAliasList = null;
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.readExternal", "428", this);
                        exception.printStackTrace();
                        this.aliasList = EMPTY_OBJECT_ARRAY;
                    }
                } else {
                    this.aliasList = EMPTY_OBJECT_ARRAY;
                }
                if ((n2 = objectInput.readInt()) > 0) {
                    this.serializedUserMetaData = new byte[n2];
                    objectInput.readFully(this.serializedUserMetaData);
                } else {
                    this.serializedUserMetaData = null;
                }
                this.userMetaData = null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.readExternal", "468", this);
                exception.printStackTrace();
                return;
            }
            try {
                this.skipMemoryAndWriteToDisk = objectInput.readBoolean();
            }
            catch (Exception exception) {
                this.skipMemoryAndWriteToDisk = false;
                if (errorAlreadyDisplayed || !tc.isDebugEnabled()) break block36;
                Tr.debug(tc, "Old format: missing skipMemoryAndWriteToDisk boolean during deserialization of cache entry.");
                errorAlreadyDisplayed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        if (this.id != null) {
            Object object = this.id;
            synchronized (object) {
                if (this.serializedValue != null) {
                    try {
                        this.value = SerializationUtility.deserialize(this.serializedValue);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.getValue", "200", this);
                        exception.printStackTrace();
                    }
                    if (this.value != null) {
                        this.serializedValue = null;
                    }
                }
            }
        }
        return this.value;
    }

    public byte[] getSerializedValue() {
        return this.serializedValue;
    }

    protected void setValue(Object object) {
        this.value = object;
        this.serializedValue = null;
        this.timeStamp = System.currentTimeMillis();
    }

    public Enumeration getTemplates() {
        return new ArrayEnumerator(this._templates);
    }

    public String getTemplate() {
        if (this._templates.length > 0) {
            return this._templates[0];
        }
        return null;
    }

    public Enumeration getDataIds() {
        return new ArrayEnumerator(this._dataIds);
    }

    public void refreshEntry() {
        this.clock = this.priority;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void reset() {
        this.drsClock = -1L;
        this.timeStamp = -1L;
        this.serializedId = null;
        this.id = null;
        if (this.useByteBuffer && this.value != null && this.value instanceof DistributedNioMapObject) {
            ((DistributedNioMapObject)this.value).release();
        }
        this.serializedValue = null;
        this.value = null;
        this.clock = DEFAULT_PRIORITY;
        this.refCount = 0;
        this.priority = DEFAULT_PRIORITY;
        this.timeLimit = -1;
        this.inactivity = -1;
        this.expirationTime = -1L;
        this.removeWhenUnpinned = false;
        this._templates = EMPTY_STRING_ARRAY;
        this._dataIds = EMPTY_OBJECT_ARRAY;
        this._serializedDataIds = null;
        this.invalid = false;
        this.sharingPolicy = 1;
        this.persistToDisk = true;
        this.isOverflowEntry = false;
        this.lruEvicted = false;
        this.lruHead = null;
        this.useByteBuffer = false;
        this.aliasList = EMPTY_OBJECT_ARRAY;
        this.serializedAliasList = null;
        this.userMetaData = null;
        this.serializedUserMetaData = null;
        this.loadedFromDisk = false;
        this.cacheType = 0;
        this.skipValueSerialized = false;
        this.skipMemoryAndWriteToDisk = false;
        this.skipMemoryAndWriteToDiskErrorCode = 0;
    }

    public void copy(CacheEntry cacheEntry) {
        if (cacheEntry == this) {
            return;
        }
        if (this.useByteBuffer && this.value != null && this.value instanceof DistributedNioMapObject) {
            ((DistributedNioMapObject)this.value).release();
        }
        this.value = cacheEntry.value;
        this.serializedValue = cacheEntry.serializedValue;
        this.serializedId = cacheEntry.serializedId;
        this.timeStamp = cacheEntry.timeStamp;
        this.expirationTime = cacheEntry.expirationTime;
        this.timeLimit = cacheEntry.timeLimit;
        this.inactivity = cacheEntry.inactivity;
        this.drsClock = cacheEntry.drsClock;
        this.id = cacheEntry.id;
        this.priority = cacheEntry.priority;
        if (this.priority < 0) {
            this.priority = 0;
        }
        if (this.priority > MAX_PRIORITY) {
            this.priority = MAX_PRIORITY;
        }
        this._templates = cacheEntry._templates;
        this._dataIds = cacheEntry._dataIds;
        this._serializedDataIds = cacheEntry._serializedDataIds;
        this.sharingPolicy = cacheEntry.sharingPolicy;
        this.persistToDisk = cacheEntry.persistToDisk;
        this.useBatch = cacheEntry.useBatch;
        this.refCount = cacheEntry.refCount;
        this.aliasList = cacheEntry.aliasList;
        this.serializedAliasList = cacheEntry.serializedAliasList;
        this.useByteBuffer = cacheEntry.useByteBuffer;
        this.userMetaData = cacheEntry.userMetaData;
        this.serializedUserMetaData = cacheEntry.serializedUserMetaData;
        this.loadedFromDisk = cacheEntry.loadedFromDisk;
        this.cacheType = cacheEntry.cacheType;
        this.skipValueSerialized = cacheEntry.skipValueSerialized;
        this.skipMemoryAndWriteToDisk = cacheEntry.skipMemoryAndWriteToDisk;
        this.skipMemoryAndWriteToDiskErrorCode = cacheEntry.skipMemoryAndWriteToDiskErrorCode;
    }

    public void copyMetaData(EntryInfo entryInfo) {
        entryInfo.lock();
        if (!entryInfo.wasIdSet()) {
            throw new IllegalStateException("id was not set on entryInfo");
        }
        this.id = entryInfo.id;
        this.timeLimit = entryInfo.timeLimit;
        this.inactivity = entryInfo.inactivity;
        this.expirationTime = entryInfo.expirationTime;
        this.priority = entryInfo.priority;
        if (this.priority < 0) {
            this.priority = 0;
        }
        if (this.priority > MAX_PRIORITY) {
            this.priority = MAX_PRIORITY;
        }
        this._templates = entryInfo.templates.toArray(new String[entryInfo.templates.size()]);
        this._dataIds = entryInfo.dataIds.toArray(new Object[entryInfo.dataIds.size()]);
        this._serializedDataIds = null;
        this.sharingPolicy = entryInfo.sharingPolicy;
        this.persistToDisk = entryInfo.persistToDisk;
        this.useBatch = entryInfo.isBatchEnabled();
        this.aliasList = entryInfo.aliasList.toArray(new Object[entryInfo.aliasList.size()]);
        this.serializedAliasList = null;
        this.userMetaData = entryInfo.userMetaData;
        this.serializedUserMetaData = null;
        this.loadedFromDisk = false;
        if (entryInfo instanceof JAXRPCEntryInfo) {
            this.cacheType = 1;
        }
        this.skipValueSerialized = false;
        this.skipMemoryAndWriteToDisk = false;
        this.skipMemoryAndWriteToDiskErrorCode = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CacheEntry)) {
            return false;
        }
        CacheEntry cacheEntry = (CacheEntry)object;
        if (this.id == null || cacheEntry.id == null) {
            return super.equals(object);
        }
        return this.id.equals(cacheEntry.id);
    }

    public int hashCode() {
        if (this.id == null) {
            return CacheEntry.class.hashCode();
        }
        return this.id.hashCode();
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public int getInactivity() {
        return this.inactivity;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getSharingPolicy() {
        return this.sharingPolicy;
    }

    public boolean isBatchEnabled() {
        return this.useBatch;
    }

    public String getId() {
        if (this.id != null) {
            return this.id.toString();
        }
        return null;
    }

    public Object getIdObject() {
        return this.id;
    }

    public byte[] getSerializedId() {
        return this.serializedId;
    }

    public byte[] getDisplayValue() {
        byte[] byArray;
        block9: {
            this.getValue();
            if (this.value == null) {
                return new byte[0];
            }
            if (this.value.getClass().getName().equals("com.ibm.ws.cache.servlet.FragmentComposerMemento")) {
                try {
                    Class<?> clazz = Class.forName("com.ibm.ws.cache.servlet.FragmentComposerMemento");
                    Method method2 = clazz.getMethod("generateContents", null);
                    return (byte[])method2.invoke(this.value, null);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.getDisplayValue", "887", this);
                }
            }
            Object object = this.value;
            if (this.cacheType == 1 && this.value instanceof byte[]) {
                try {
                    object = SerializationUtility.deserialize((byte[])this.value);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.getDisplayValue", "896", this);
                }
            }
            byArray = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8"));
                printWriter.print(object);
                printWriter.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.getDisplayValue", "908", this);
                Tr.error(tc, "dynacache.error", exception.getMessage());
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "error getting value for CacheEntry " + this.id + ": " + exception.getMessage());
            }
        }
        return byArray;
    }

    public Enumeration getAliasList() {
        return new ArrayEnumerator(this.aliasList);
    }

    public void addAlias(Object object) {
        ValueSet valueSet = new ValueSet(this.aliasList.length + 1);
        if (object != null) {
            for (int i = 0; i < this.aliasList.length; ++i) {
                valueSet.add(this.aliasList[i]);
            }
        }
        valueSet.add(object);
        this.aliasList = valueSet.toArray(new Object[valueSet.size()]);
        this.serializedAliasList = null;
    }

    public void removeAlias(Object object) {
        ValueSet valueSet = new ValueSet(this.aliasList.length);
        if (object != null) {
            for (int i = 0; i < this.aliasList.length; ++i) {
                valueSet.add(this.aliasList[i]);
            }
        }
        valueSet.remove(object);
        this.aliasList = valueSet.toArray(new Object[valueSet.size()]);
        this.serializedAliasList = null;
    }

    public Object getUserMetaData() {
        if (this.serializedUserMetaData != null) {
            try {
                this.userMetaData = SerializationUtility.deserialize(this.serializedUserMetaData);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheEntry.getUserMetaData", "600", this);
                exception.printStackTrace();
            }
            this.serializedUserMetaData = null;
        }
        return this.userMetaData;
    }

    protected void setUserMetaData(Object object) {
        this.userMetaData = object;
        this.serializedUserMetaData = null;
    }

    protected void setSkipMemoryAndWriteToDisk(boolean bl) {
        this.skipMemoryAndWriteToDisk = bl;
    }

    public static CacheEntryPool createCacheEntryPool(DCache dCache, int n) {
        CacheEntryPool cacheEntryPool = new CacheEntryPool(n, dCache);
        return cacheEntryPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (this.cacheEntryPool != null) {
            DCache dCache = this.cacheEntryPool.cache;
            synchronized (dCache) {
                --this.refCount;
                if (this.refCount <= 0) {
                    if (this.refCount < 0) {
                        this.refCount = 0;
                    }
                    if (this.removeWhenUnpinned && this.refCount == 0) {
                        this.returnToPool();
                    }
                }
            }
        }
        Object object = this.id;
        synchronized (object) {
            --this.refCount;
            if (this.refCount <= 0) {
                this.reset();
            }
        }
    }

    protected void returnToPool() {
        CacheEntryPool cacheEntryPool = this.cacheEntryPool;
        assert (this.cacheEntryPool != null);
        assert (this.refCount == 0);
        if (this.lruHead != null) {
            this.lruHead.remove(this);
        }
        this.reset();
        cacheEntryPool.add(this);
    }

    public long getCacheValueSize() {
        long l = -1L;
        if (this.serializedValue != null) {
            l = this.serializedValue.length;
            return l;
        }
        if (this.value instanceof DistributedNioMapObject) {
            DistributedNioMapObject distributedNioMapObject = (DistributedNioMapObject)this.value;
            l = distributedNioMapObject.getCacheValueSize();
        }
        return l;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CacheEntry]").append("\nCacheId: ").append(this.id).append("\nuserMetaData: ").append(this.userMetaData).append("\npriority: ").append(this.priority).append("\ntimeLimit: ").append(this.timeLimit).append("\ninactivity: ").append(this.inactivity).append("\nexpirationTime: ").append(this.expirationTime).append("\nsharingPolicy: ").append(this.sharingPolicy).append("\ncacheValueSize: ").append(this.getCacheValueSize()).append("\nskipMemoryAndWriteToDisk: ").append(this.skipMemoryAndWriteToDisk);
        for (n = 0; this._templates != null && n < this._templates.length; ++n) {
            stringBuffer.append("\n[template " + n + "]");
            stringBuffer.append(this._templates[n]);
        }
        for (n = 0; this._dataIds != null && n < this._dataIds.length; ++n) {
            stringBuffer.append("\n[Dependency " + n + "]");
            stringBuffer.append(this._dataIds[n]);
        }
        for (n = 0; this.aliasList != null && n < this.aliasList.length; ++n) {
            stringBuffer.append("\n[Aliases " + n + "]");
            stringBuffer.append(this.aliasList[n]);
        }
        return stringBuffer.toString();
    }

    public int getCacheType() {
        return this.cacheType;
    }

    public long getCreationTime() {
        return this.timeStamp;
    }

    static class CacheEntryPool
    extends ObjectPool {
        DCache cache = null;
        String cacheName = null;

        public CacheEntryPool(int n, DCache dCache) {
            super("CacheEntry.Pool", n);
            this.cache = dCache;
            this.cacheName = dCache.getCacheName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CacheEntryPool created for named cache " + this.cacheName);
            }
        }

        public Object createObject() {
            CacheEntry cacheEntry = new CacheEntry();
            cacheEntry.reset();
            return cacheEntry;
        }

        public CacheEntry allocate() {
            CacheEntry cacheEntry = (CacheEntry)this.remove();
            cacheEntry.cacheEntryPool = this;
            return cacheEntry;
        }
    }

    static class ArrayEnumerator
    implements Enumeration {
        int pos = 0;
        Object[] array;

        public ArrayEnumerator(Object[] objectArray) {
            this.array = objectArray;
        }

        public boolean hasMoreElements() {
            return this.array.length > this.pos;
        }

        public Object nextElement() {
            return this.array[this.pos++];
        }
    }

    public static class LRUHead
    implements Iterator {
        public int priority = 0;
        private CacheEntry head;
        private CacheEntry tail;
        private CacheEntry _iterator = null;

        public void addFirst(CacheEntry cacheEntry) {
            cacheEntry._previous = null;
            cacheEntry._next = this.head;
            if (this.head != null) {
                this.head._previous = cacheEntry;
            }
            this.head = cacheEntry;
            if (this.tail == null) {
                this.tail = cacheEntry;
            }
        }

        public void addLast(CacheEntry cacheEntry) {
            cacheEntry._previous = this.tail;
            cacheEntry._next = null;
            if (this.head == null) {
                this.head = cacheEntry;
            } else {
                this.tail._next = cacheEntry;
            }
            this.tail = cacheEntry;
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        public boolean isLast(CacheEntry cacheEntry) {
            return this.tail == cacheEntry;
        }

        public Iterator iterator() {
            this._iterator = this.head;
            return this;
        }

        public Object next() {
            CacheEntry cacheEntry = this._iterator;
            this._iterator = this._iterator._next;
            return cacheEntry;
        }

        public boolean hasNext() {
            return this._iterator != null;
        }

        public void remove() {
            throw new IllegalStateException("remove not implemented");
        }

        public void remove(CacheEntry cacheEntry) {
            if (cacheEntry.lruHead != this) {
                System.out.println("internal error for cacheEntry=" + cacheEntry);
                System.out.println("_next=" + cacheEntry._next);
                System.out.println("_previous=" + cacheEntry._previous);
                System.out.println("lruHead=" + cacheEntry.lruHead);
                System.out.println("this=" + this);
            }
            if (this.head == cacheEntry) {
                this.head = cacheEntry._next;
                if (this.head != null) {
                    this.head._previous = null;
                }
            } else {
                cacheEntry._previous._next = cacheEntry._next;
                if (cacheEntry._next != null) {
                    cacheEntry._next._previous = cacheEntry._previous;
                }
            }
            if (this.tail == cacheEntry) {
                this.tail = cacheEntry._previous;
            }
            cacheEntry._previous = null;
            cacheEntry._next = null;
            cacheEntry.lruHead = null;
        }

        public CacheEntry removeFirst() {
            CacheEntry cacheEntry = this.head;
            if (cacheEntry != null) {
                this.head = cacheEntry._next;
                if (this.head != null) {
                    this.head._previous = null;
                } else {
                    this.tail = null;
                }
            }
            return cacheEntry;
        }
    }
}

