/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.dynacache.CacheInstance;
import com.ibm.websphere.models.config.dynacache.ObjectCacheInstance;
import com.ibm.websphere.models.config.dynacache.ServletCacheInstance;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.CacheServiceImpl;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.WCCMCacheConfig;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.CacheableReference;
import com.ibm.ws.runtime.component.binder.ResourceBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.runtime.service.RuntimeCtx;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class CacheInstanceResourceBinder
implements ResourceBinder,
ObjectFactory {
    private static TraceComponent tc = Trace.register(CacheInstanceResourceBinder.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static boolean assertRanOnce = false;
    private static CacheService cacheService = null;
    private static final String refKey = "config";

    public CacheInstanceResourceBinder() {
        assert (assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this));
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CacheInstanceResourceBinder()3 - CTOR");
        }
        if ((cacheService = CacheServiceImpl.getCacheService()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CacheService has not been created");
            }
            throw new IllegalStateException("CacheService has not been created");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CacheInstanceResourceBinder()3 - CTOR " + this);
        }
    }

    public void finialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finialize()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finialize() " + this);
        }
    }

    public void initialize(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(): " + object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize()");
        }
    }

    public boolean isUsedFor(J2EEResourceFactory j2EEResourceFactory) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsedFor()5: " + j2EEResourceFactory);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsedFor()5: " + (j2EEResourceFactory instanceof CacheInstance));
        }
        return j2EEResourceFactory instanceof CacheInstance;
    }

    public String getNamePrefix() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamePrefix()");
        }
        String string = "cacheInstance";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamePrefix(): " + string);
        }
        return string;
    }

    public Object getBindingObject(J2EEResourceFactory j2EEResourceFactory) throws ResourceBindingException {
        return this.getBindingObject(null, j2EEResourceFactory);
    }

    public Object getBindingObject(RuntimeCtx runtimeCtx, J2EEResourceFactory j2EEResourceFactory) throws ResourceBindingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingObject()6" + j2EEResourceFactory);
        }
        WCCMCacheConfig wCCMCacheConfig = cacheService.addCacheInstanceConfig((CacheInstance)j2EEResourceFactory);
        byte[] byArray = null;
        BinaryRefAddr binaryRefAddr = null;
        CacheableReference cacheableReference = null;
        if (j2EEResourceFactory instanceof ServletCacheInstance) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Ready to create naiming reference for ServletCacheInstance ", new Object[]{wCCMCacheConfig.cacheName});
            }
        } else if (j2EEResourceFactory instanceof ObjectCacheInstance || j2EEResourceFactory instanceof CacheInstance) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ready to create naiming reference for ObjectCacheInstance ", new Object[]{wCCMCacheConfig.cacheName});
                }
                byArray = SerializationUtility.serialize((Serializable)((Object)wCCMCacheConfig.cacheName));
                binaryRefAddr = new BinaryRefAddr(refKey, byArray);
                cacheableReference = new CacheableReference("com.ibm.websphere.cache.DistributedObjectCache", binaryRefAddr, "com.ibm.wsspi.cache.CacheInstanceResourceBinder", null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheInstanceResourceBinder.getBindingObject", "106", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not create binding object", new Object[]{exception});
                }
                Tr.error(tc, "DYNA1003E", new Object[]{wCCMCacheConfig.cacheName, exception});
                cacheService.destroyCacheInstance(wCCMCacheConfig.cacheName);
            }
        } else {
            Tr.error(tc, "DYNA1003E", new Object[]{wCCMCacheConfig.cacheName, "UNKNOWN_RESOURCE_TYPE:" + j2EEResourceFactory});
            cacheService.destroyCacheInstance(wCCMCacheConfig.cacheName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBindingObject()6: " + cacheableReference);
        }
        return cacheableReference;
    }

    public Object getObjectInstance(Object object, Name name2, Context context, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance()");
        }
        String string = null;
        Object object2 = null;
        Reference reference = null;
        BinaryRefAddr binaryRefAddr = null;
        try {
            reference = (Reference)object;
            binaryRefAddr = (BinaryRefAddr)reference.get(refKey);
            string = (String)((Object)SerializationUtility.deserialize((byte[])binaryRefAddr.getContent()));
            if (string == null) {
                Tr.error(tc, "DYNA1003E", new Object[]{"null", "referenceIsNull"});
                throw new IllegalStateException("JNDI Name in naming reference was null.");
            }
            object2 = cacheService.createCacheInstance(string);
            if (object2 instanceof ServletCacheInstance) {
                throw new RuntimeException("Access to ServletCacheInstance denied");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheInstanceResourceBinder.getObjectInstance", "103", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not load the config from reference " + string);
            }
            Tr.error(tc, "DYNA1003E", new Object[]{string, exception});
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance(): " + object2);
        }
        return object2;
    }

    public void activateProviderMBean(J2EEResourceProvider j2EEResourceProvider, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activateProviderMBean()8");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "activateProviderMBean()8");
        }
    }

    public void setCache(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCache()4/9" + map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCache()4/9");
        }
    }
}

