/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.DiskCacheSizeInfo;
import com.ibm.ws.cache.DynacacheOnDisk;
import com.ibm.ws.cache.EvictAction;
import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.Result;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Properties;

public class CacheOnDisk
implements AlarmListener,
DynacacheOnDisk,
EvictAction {
    private static final boolean IS_UNIT_TEST = false;
    private static final long SECONDS_FOR_24_HOURS = 86400L;
    private static final long SECONDS_FOR_23_HOURS = 82800L;
    public static final byte PROPERTY_FILE_OK = 0;
    public static final byte PROPERTY_ERROR_NO_FILES = 1;
    public static final byte PROPERTY_ERROR_FILE_NOT_EXIST = 2;
    public static final byte PROPERTY_ERROR_FILE_CORRUPT = 4;
    public static final byte PROPERTY_ERROR_DISABLE_DEPID = 8;
    public static final byte PROPERTY_ERROR_DISABLE_TEMPLATE = 16;
    public static final byte PROPERTY_ERROR_CACHE_SIZE = 32;
    public static final byte PROPERTY_ERROR_FIELD_CHECK = 64;
    public static final byte PROPERTY_ERROR_GB = -128;
    public static final String HTOD_VERSION = "version";
    public static final String HTOD_VERSION_NUM = "6.0";
    public static final String DISABLE_DEPENDENCY_ID = "disableDependencyId";
    public static final String DISABLE_TEMPLATE_SUPPORT = "disableTemplatesSupport";
    public static final String CACHE_SIZE_IN_BYTES = "cacheSizeInBytes";
    public static final String FIELD_CHECK = "fieldCheck";
    public static final String DATA_GB = "dataGB";
    public static final String DEPID_GB = "dependencyIdGB";
    public static final String TEMPLATE_GB = "templateGB";
    public static final String HTOD_LAST_SCAN_FILENAME = "lastscantime";
    public static final String HTOD_PROPERTIES_FILENAME = "htod.properties";
    public static final String HTOD_INVALIDATION_FILENAME = "invalidations.htod";
    public static final String HTOD_IN_PROGRESS_FILENAME = "InProgress";
    public static final int START_NONE = 0;
    public static final int START_LPBT_SCAN = 1;
    public static final int START_LPBT_REMOVE = 2;
    public static final boolean FILTER = true;
    public static final boolean DELETE_IN_PROGRESS_FILE = true;
    public static final int DISK_CACHE_SIZE_IN_ENTRIES_TYPE = 1;
    public static final int DISK_CACHE_SIZE_IN_BYTES_TYPE = 2;
    public static final int GC_THRESHOLD = 20;
    private static TraceComponent tc = Trace.register(CacheOnDisk.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    protected String sep = File.separator;
    protected String swapDirPath = null;
    protected String swapRootDirPath = null;
    protected String cacheName = null;
    protected long sleepInterval = 1800000L;
    protected int cleanupHour = 0;
    protected long invalInterval = 86400000L;
    protected int cleanupFrequency = 0;
    protected boolean delayOffload;
    protected int delayOffloadEntriesLimit = 1000;
    protected int delayOffloadDepIdBuckets = 1000;
    protected int delayOffloadTemplateBuckets = 100;
    protected int dataHashtableSize;
    protected int depIdHashtableSize;
    protected int templateHashtableSize;
    protected int numberOfPools;
    protected int poolSize;
    protected int poolEntryLife;
    protected int invalidationBufferSize;
    protected int invalidationBufferLife;
    protected boolean disableDependencyId = false;
    protected boolean disableTemplatesSupport = false;
    protected boolean disableDependencyIdFromPropertyFile = false;
    protected boolean disableTemplatesSupprotFromPropertyFile = false;
    protected int dataFiles = 0;
    protected int dependencyIdFiles = 0;
    protected int templateFiles = 0;
    protected boolean ignoreValueInInvalidationEvent = false;
    protected int diskCachePerformanceLevel = 1;
    protected int explicitBufferLimitOnStop = 0;
    protected long sleepTime = 0L;
    protected boolean setAlarm = true;
    protected String lastScanFileName = null;
    protected String htodPropertyFileName = null;
    protected String invalidationFileName = null;
    protected String inProgressFileName = null;
    protected final String HTOD_PREF = "_dynacache";
    protected DCache cache = null;
    protected HTODDynacache htod = null;
    protected long lastScanTime = 0L;
    protected byte propertyFileStatus = 0;
    protected ValueSet valueSet = null;
    protected boolean stopping = false;
    protected int startState = 0;
    protected boolean enableCacheSizeInBytes = false;
    protected long currentCacheSizeInBytes = 0L;
    protected int dataGB = 1;
    protected int dependencyIdGB = 1;
    protected int templateGB = 1;
    protected boolean populateEvictionTable = false;
    protected boolean populateDependencyTable = false;
    protected GarbageCollectorThread garbageCollectionThread = null;
    protected int evictionPolicy = 0;
    protected DiskCacheSizeInfo diskCacheSizeInfo = null;
    private boolean doNotify = false;
    private Object diskCacheMonitor = new Object();

    public CacheOnDisk(CacheConfig cacheConfig, DCache dCache) {
        Object object;
        File file;
        if (cacheConfig.diskOffloadLocation == null) {
            cacheConfig.setOffloadOffloadLocationAndProcess("");
        }
        String string = cacheConfig.diskOffloadLocation;
        this.cleanupHour = cacheConfig.htodCleanupHour;
        this.invalInterval = cacheConfig.htodInvalInterval;
        this.cleanupFrequency = cacheConfig.htodCleanupFrequency;
        this.delayOffload = cacheConfig.htodDelayOffload;
        this.delayOffloadEntriesLimit = cacheConfig.htodDelayOffloadEntriesLimit;
        this.delayOffloadDepIdBuckets = cacheConfig.htodDelayOffloadDepIdBuckets;
        this.delayOffloadTemplateBuckets = cacheConfig.htodDelayOffloadTemplateBuckets;
        this.dataHashtableSize = cacheConfig.htodDataHashtableSize;
        this.depIdHashtableSize = cacheConfig.htodDepIdHashtableSize;
        this.templateHashtableSize = cacheConfig.htodTemplateHashtableSize;
        this.numberOfPools = cacheConfig.htodNumberOfPools;
        this.poolSize = cacheConfig.htodPoolSize;
        this.poolEntryLife = cacheConfig.htodPoolEntryLife;
        this.invalidationBufferSize = cacheConfig.htodInvalidationBufferSize;
        this.invalidationBufferLife = cacheConfig.htodInvalidationBufferLife;
        this.disableDependencyId = cacheConfig.disableDependencyId;
        this.disableTemplatesSupport = cacheConfig.disableTemplatesSupport;
        this.disableTemplatesSupport = cacheConfig.enableServletSupport ? cacheConfig.disableTemplatesSupport : true;
        this.ignoreValueInInvalidationEvent = cacheConfig.ignoreValueInInvalidationEvent;
        this.diskCachePerformanceLevel = cacheConfig.diskCachePerformanceLevel;
        this.evictionPolicy = cacheConfig.diskCacheEvictionPolicy;
        this.explicitBufferLimitOnStop = cacheConfig.explicitBufferLimitOnStop;
        int n = cacheConfig.diskCacheSize;
        int n2 = cacheConfig.diskCacheSizeInGB;
        int n3 = cacheConfig.diskCacheEntrySizeInMB;
        int n4 = cacheConfig.diskCacheHighThreshold;
        int n5 = cacheConfig.diskCacheLowThreshold;
        if (this.diskCachePerformanceLevel < 0 || this.diskCachePerformanceLevel > 3) {
            Tr.warning(tc, "DYNA0069W", new Object[]{new Integer(this.diskCachePerformanceLevel), "diskCachePerformanceLevel", dCache.getCacheName(), new Integer(0), new Integer(3), new Integer(1)});
            this.diskCachePerformanceLevel = 1;
        }
        if (this.diskCachePerformanceLevel == 3 || this.diskCachePerformanceLevel == 2 || this.diskCachePerformanceLevel == 1) {
            this.delayOffload = true;
            if (this.diskCachePerformanceLevel == 1) {
                this.delayOffloadEntriesLimit = 1000;
                this.delayOffloadDepIdBuckets = 1000;
                this.delayOffloadTemplateBuckets = 100;
            } else if (this.diskCachePerformanceLevel == 3) {
                this.delayOffloadEntriesLimit = Integer.MAX_VALUE;
                this.delayOffloadDepIdBuckets = Integer.MAX_VALUE;
                this.delayOffloadTemplateBuckets = Integer.MAX_VALUE;
            } else {
                if (this.delayOffloadEntriesLimit < 100) {
                    Tr.warning(tc, "DYNA0069W", new Object[]{new Integer(this.delayOffloadEntriesLimit), "htodDelayOffloadEntriesLimit", dCache.getCacheName(), new Integer(100), new Integer(Integer.MAX_VALUE), new Integer(100)});
                    this.delayOffloadEntriesLimit = 100;
                }
                if (this.delayOffloadDepIdBuckets < 100) {
                    Tr.warning(tc, "DYNA0069W", new Object[]{new Integer(this.delayOffloadDepIdBuckets), "htodDelayOffloadDepIdBuckets", dCache.getCacheName(), new Integer(100), new Integer(Integer.MAX_VALUE), new Integer(100)});
                    this.delayOffloadDepIdBuckets = 100;
                }
                if (this.delayOffloadTemplateBuckets < 10) {
                    Tr.warning(tc, "DYNA0069W", new Object[]{new Integer(this.delayOffloadTemplateBuckets), "htodDelayOffloadTemplateBuckets", dCache.getCacheName(), new Integer(10), new Integer(Integer.MAX_VALUE), new Integer(10)});
                    this.delayOffloadTemplateBuckets = 10;
                }
            }
        } else {
            this.delayOffload = false;
        }
        if (this.diskCachePerformanceLevel != 3) {
            if (this.cleanupFrequency < 0) {
                Tr.warning(tc, "DYNA0069W", new Object[]{new Integer(this.cleanupFrequency), "htodCleanupFrequency", dCache.getCacheName(), new Integer(0), new Integer(1440), new Integer(0)});
                this.cleanupFrequency = 0;
            }
            if (this.cleanupFrequency > 1440) {
                Tr.warning(tc, "DYNA0069W", new Object[]{new Integer(this.cleanupFrequency), "htodCleanupFrequency", dCache.getCacheName(), new Integer(0), new Integer(1440), new Integer(1440)});
                this.cleanupFrequency = 1440;
            }
        }
        if (this.evictionPolicy < 0 || this.evictionPolicy > 2) {
            Tr.warning(tc, "DYNA0069W", new Object[]{new Integer(this.evictionPolicy), "diskCacheEvictionPolicy", dCache.getCacheName(), new Integer(0), new Integer(2), new Integer(0)});
            this.evictionPolicy = 0;
        }
        if (n < 0 || n > 0 && n < 20) {
            Tr.warning(tc, "DYNA0069W", new Object[]{new Integer(n), "diskCacheSize", dCache.getCacheName(), new Integer(20), new Integer(Integer.MAX_VALUE), new Integer(20)});
            n = 20;
        }
        if (n2 < 0 || n2 > 0 && n2 < 3) {
            Tr.warning(tc, "DYNA0069W", new Object[]{new Integer(n2), "diskCacheSizeInGB", dCache.getCacheName(), new Integer(3), new Integer(Integer.MAX_VALUE), new Integer(3)});
            n2 = 3;
        }
        if (n3 < 0) {
            Tr.warning(tc, "DYNA0069W", new Object[]{new Integer(n3), "diskCacheEntrySizeInMB", dCache.getCacheName(), new Integer(0), new Integer(Integer.MAX_VALUE), new Integer(0)});
            n3 = 0;
        }
        if (this.evictionPolicy != 0 && (n4 < 1 || n4 > 100 || n5 < 1 || n5 > 100 || n4 <= n5)) {
            Tr.info(tc, "DYNA0068W", new Object[]{dCache.getCacheName()});
            n4 = 80;
            n5 = 70;
        }
        this.cache = dCache;
        this.cacheName = dCache.getCacheName();
        this.cacheName = this.cacheName.replace('/', '_');
        this.cacheName = this.cacheName.replace('\\', '_');
        String string2 = "";
        String string3 = "";
        int n6 = string.indexOf("##");
        if (n6 == -1) {
            string3 = string + this.sep + this.cacheName;
        } else {
            string2 = string.substring(0, n6) + this.sep + this.cacheName;
            string3 = string.substring(n6 + 2) + this.sep + this.cacheName;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string2.equals("")) {
            bl3 = true;
        } else if (string2.startsWith("${") && string2.indexOf("}") > 0) {
            bl3 = true;
            bl = true;
        } else {
            try {
                file = new File(string2);
                if (!file.exists()) {
                    if (!file.mkdirs()) {
                        bl = true;
                        bl3 = true;
                    }
                } else if (!file.isDirectory()) {
                    bl = true;
                    bl3 = true;
                } else if (!file.canWrite()) {
                    bl = true;
                    bl3 = true;
                }
            }
            catch (Throwable throwable) {
                bl = true;
                bl3 = true;
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.CacheOnDisk", "151", this);
                this.traceDebug("constructor()", "cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
        }
        if (!bl && !bl3) {
            this.swapDirPath = string2;
            Tr.info(tc, "DYNA0053I", new Object[]{dCache.getCacheName(), string2});
        } else {
            try {
                file = new File(string3);
                if (!file.exists()) {
                    if (!file.mkdirs()) {
                        bl2 = true;
                    }
                } else if (!file.isDirectory()) {
                    bl2 = true;
                } else if (!file.canWrite()) {
                    bl2 = true;
                }
            }
            catch (Throwable throwable) {
                bl2 = true;
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.CacheOnDisk", "176", this);
                this.traceDebug("constructor()", "cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
            if (!bl && !bl2) {
                this.swapDirPath = string3;
                Tr.info(tc, "DYNA0053I", new Object[]{dCache.getCacheName(), string3});
            } else if (!bl2) {
                this.swapDirPath = string3;
                Tr.warning(tc, "DYNA0054W", new Object[]{dCache.getCacheName(), string2, string3});
            } else {
                this.swapDirPath = "";
                Tr.error(tc, "DYNA0055E", new Object[]{dCache.getCacheName(), string2, string3});
                this.cache.setSwapToDisk(false);
                return;
            }
        }
        if (dCache.getCacheName() != null) {
            boolean bl4 = cacheConfig.flushToDiskOnStop;
            if (dCache.getCacheName().equals("baseCache") && (object = System.getProperty("com.ibm.ws.cache.flushToDiskOnStop")) != null && ((String)object).equalsIgnoreCase("true")) {
                bl4 = true;
            }
            if (bl4) {
                Tr.info(tc, "DYNA0060I", new Object[]{dCache.getCacheName()});
            } else {
                Tr.info(tc, "DYNA0061I", new Object[]{dCache.getCacheName()});
            }
        }
        int n7 = this.swapDirPath.lastIndexOf(this.sep);
        this.swapRootDirPath = this.swapDirPath.substring(0, n7);
        this.lastScanFileName = this.swapDirPath + this.sep + HTOD_LAST_SCAN_FILENAME;
        this.htodPropertyFileName = this.swapDirPath + this.sep + HTOD_PROPERTIES_FILENAME;
        this.invalidationFileName = this.swapDirPath + this.sep + HTOD_INVALIDATION_FILENAME;
        this.inProgressFileName = this.swapDirPath + this.sep + HTOD_IN_PROGRESS_FILENAME;
        object = new File(this.inProgressFileName);
        if (((File)object).exists()) {
            Tr.warning(tc, "DYNA0056W", null);
            this.deleteDiskCacheFiles();
        }
        this.createInProgressFile();
        this.loadAndCheckPropertyFile();
        if (this.propertyFileStatus != 0 && ((this.propertyFileStatus & 4) > 0 || (this.propertyFileStatus & 0x20) > 0 || (this.propertyFileStatus & 0x40) > 0 || (this.propertyFileStatus & 0xFFFFFF80) > 0)) {
            if (this.currentCacheSizeInBytes > 0L) {
                this.dataGB = this.dataFiles;
                this.dependencyIdGB = this.dependencyIdFiles;
                this.templateGB = this.templateFiles;
            }
            this.deletePropertyFile();
        }
        try {
            this.htod = new HTODDynacache(this.swapDirPath, this.swapDirPath + this.sep + "_dynacache", this.cache, this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.CacheOnDisk", "243", this);
            this.traceDebug("constructor()", "cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            Tr.error(tc, "DYNA0055E", new Object[]{dCache.getCacheName(), string2, string3});
            this.cache.setSwapToDisk(false);
            return;
        }
        if (this.disableDependencyId) {
            if (this.dependencyIdFiles > 0) {
                Tr.warning(tc, "DYNA1033W", new Object[]{String.valueOf(this.disableDependencyId), dCache.getCacheName(), String.valueOf(!this.disableDependencyId)});
                this.disableDependencyId = false;
                if (this.dependencyIdGB == 0) {
                    this.dependencyIdGB = this.dependencyIdFiles;
                }
            } else {
                this.dependencyIdGB = 0;
            }
        } else if (this.dependencyIdFiles == 0) {
            Tr.warning(tc, "DYNA1033W", new Object[]{String.valueOf(this.disableDependencyId), dCache.getCacheName(), String.valueOf(!this.disableDependencyId)});
            this.disableDependencyId = true;
            if (this.dependencyIdGB > 0) {
                this.dependencyIdGB = 0;
            }
        } else if (this.dependencyIdGB == 0) {
            this.dependencyIdGB = this.dependencyIdFiles;
        }
        if (this.disableTemplatesSupport) {
            if (this.templateFiles > 0) {
                Tr.warning(tc, "DYNA1034W", new Object[]{String.valueOf(this.disableTemplatesSupport), dCache.getCacheName(), String.valueOf(!this.disableTemplatesSupport)});
                this.disableTemplatesSupport = false;
                if (this.templateGB == 0) {
                    this.templateGB = this.templateFiles;
                }
            } else {
                this.templateGB = 0;
            }
        } else if (this.templateFiles == 0) {
            Tr.warning(tc, "DYNA1034W", new Object[]{String.valueOf(this.disableTemplatesSupport), dCache.getCacheName(), String.valueOf(!this.disableTemplatesSupport)});
            this.disableTemplatesSupport = true;
            if (this.templateGB > 0) {
                this.templateGB = 0;
            }
        } else if (this.templateGB == 0) {
            this.templateGB = this.templateFiles;
        }
        int n8 = this.dataGB + this.dependencyIdGB + this.templateGB;
        if (n2 > 0 && n8 > n2) {
            n2 = n8;
            Tr.warning(tc, "DYNA0071W", new Object[]{dCache.getCacheName(), new Integer(n2), this.swapDirPath});
        }
        dCache.setEnableDiskCacheSizeInBytesChecking(false);
        if (this.currentCacheSizeInBytes > 0L) {
            if (n2 > 0) {
                dCache.setEnableDiskCacheSizeInBytesChecking(true);
            }
            this.enableCacheSizeInBytes = true;
        } else if (n2 > 0) {
            Tr.error(tc, "DYNA0066W", new Object[]{dCache.getCacheName(), this.swapDirPath});
            n2 = 0;
        }
        this.diskCacheSizeInfo = new DiskCacheSizeInfo(dCache.getCacheName(), n, n3, n2, this.dataGB, this.dependencyIdGB, this.templateGB, n4, n5);
        if (this.propertyFileStatus != 0) {
            this.updatePropertyFile();
        }
        if (this.cleanupFrequency != 0) {
            this.sleepTime = this.cleanupFrequency * 60 * 1000;
        }
        this.readLastScanFile();
        this.setAlarm = true;
        if (this.diskCachePerformanceLevel == 3) {
            this.setAlarm = false;
            this.cleanupFrequency = 0;
            this.startState = 1;
        }
        long l = System.currentTimeMillis();
        if (this.lastScanTime > 0L && this.cleanupFrequency > 0) {
            if (this.lastScanTime + (long)this.cleanupFrequency <= l) {
                this.setAlarm = false;
                this.startState = 1;
            }
        } else {
            this.updateLastScanFile();
        }
        if (this.evictionPolicy != 0) {
            if (!this.enableCacheSizeInBytes) {
                this.evictionPolicy = 0;
                this.populateEvictionTable = false;
                Tr.error(tc, "DYNA0067W", new Object[]{dCache.getCacheName(), this.swapDirPath});
            } else if (n == 0 && n2 == 0) {
                this.evictionPolicy = 0;
                this.populateEvictionTable = false;
                Tr.error(tc, "DYNA0070W", new Object[]{dCache.getCacheName()});
            } else {
                this.htod.initializeEvictionTable();
                this.populateEvictionTable = true;
                if (this.garbageCollectionThread == null) {
                    this.garbageCollectionThread = new GarbageCollectorThread(this);
                    this.garbageCollectionThread.setPriority(1);
                    this.garbageCollectionThread.start();
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            stringBuffer.append("  DiskCacheSize=");
            stringBuffer.append(n);
        }
        if (n2 > 0) {
            stringBuffer.append("  DiskCacheSizeInGB=");
            stringBuffer.append(n2);
        }
        if (n3 > 0) {
            stringBuffer.append("  DiskCacheEntryInMB=");
            stringBuffer.append(n3);
        }
        stringBuffer.append("  DiskCachePerformanceLevel=");
        stringBuffer.append(this.diskCachePerformanceLevel);
        stringBuffer.append("  DelayOffload=");
        stringBuffer.append(this.delayOffload);
        if (this.diskCachePerformanceLevel == 0) {
            if (this.cleanupFrequency == 0) {
                stringBuffer.append("  CleanupHour=");
                stringBuffer.append(this.cleanupHour);
            } else {
                stringBuffer.append("  CleanupFrequency=");
                stringBuffer.append(this.cleanupFrequency);
            }
        } else if (this.diskCachePerformanceLevel == 2 || this.diskCachePerformanceLevel == 1) {
            stringBuffer.append("  DelayOffloadEntriesLimit=");
            stringBuffer.append(this.delayOffloadEntriesLimit);
            stringBuffer.append("  DelayOffloadDepIdBuckets=");
            stringBuffer.append(this.delayOffloadDepIdBuckets);
            stringBuffer.append("  DelayOffloadTemplateBuckets=");
            stringBuffer.append(this.delayOffloadTemplateBuckets);
            if (this.cleanupFrequency == 0) {
                stringBuffer.append("  CleanupHour=");
                stringBuffer.append(this.cleanupHour);
            } else {
                stringBuffer.append("  CleanupFrequency=");
                stringBuffer.append(this.cleanupFrequency);
            }
        }
        stringBuffer.append("  DiskCacheEvictionPolicy=");
        stringBuffer.append(this.evictionPolicy);
        if (this.evictionPolicy != 0) {
            stringBuffer.append("  DiskCacheHighThreshold=");
            stringBuffer.append(n4);
            stringBuffer.append("  DiskCacheLowThreshold=");
            stringBuffer.append(n5);
        }
        stringBuffer.append("  DataHashtableSize=");
        stringBuffer.append(this.dataHashtableSize);
        stringBuffer.append("  DepIdHashtableSize=");
        stringBuffer.append(this.depIdHashtableSize);
        stringBuffer.append("  TemplateHashtableSize=");
        stringBuffer.append(this.templateHashtableSize);
        Tr.info(tc, "DYNA0059I", new Object[]{dCache.getCacheName(), stringBuffer.toString()});
        if (this.setAlarm) {
            if (this.cleanupFrequency == 0) {
                this.sleepTime = this.calculateSleepTime();
                if (this.sleepTime > 82800000L) {
                    this.setAlarm = false;
                    this.startState = 1;
                } else {
                    this.traceDebug("constructor()", "cacheName=" + this.cacheName + " sleepTime=" + this.sleepTime);
                }
            }
            if (this.setAlarm && this.startState != 1 && this.startState != 2 && !this.populateEvictionTable) {
                AlarmManager.createNonDeferrable(this.sleepTime, this, null);
            }
        }
        if (this.diskCachePerformanceLevel != 0) {
            this.populateDependencyTable = true;
        }
    }

    public void close(boolean bl) {
        this.traceDebug("close()", "cacheName=" + this.cacheName + " deleteProgressFile=" + bl);
        if (bl) {
            this.deleteInProgressFile();
        }
        try {
            this.htod.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.close", "306", this);
            this.traceDebug("close()", "cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
        }
    }

    public int writeAuxiliaryDepTables() {
        int n = this.htod.writeAuxiliaryDepTables();
        if (n == 1) {
            this.stopOnError(this.htod.diskCacheException);
        } else {
            this.updatePropertyFile();
        }
        return n;
    }

    private void readLastScanFile() {
        final File file = new File(this.lastScanFileName);
        this.traceDebug("readLastScanFile()", "cacheName=" + this.cacheName);
        if (file.exists()) {
            final CacheOnDisk cacheOnDisk = this;
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    FileInputStream fileInputStream = null;
                    ObjectInputStream objectInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(file);
                        objectInputStream = new ObjectInputStream(fileInputStream);
                        cacheOnDisk.lastScanTime = objectInputStream.readLong();
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.readLastScanFile", "340", cacheOnDisk);
                        CacheOnDisk.this.traceDebug("readLastScanFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    }
                    finally {
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.readLastScanFile", "354", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("readLastScanFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                        }
                    }
                    return null;
                }
            });
        }
    }

    protected void updateLastScanFile() {
        final File file = new File(this.lastScanFileName);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("updateLastScanFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                FileOutputStream fileOutputStream = null;
                ObjectOutputStream objectOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeLong(System.currentTimeMillis());
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.updateLastScanFile", "385", cacheOnDisk);
                    CacheOnDisk.this.traceDebug("updateLastScanFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                }
                finally {
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.updateLastScanFile", "399", cacheOnDisk);
                        CacheOnDisk.this.traceDebug("updateLastScanFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    }
                }
                return null;
            }
        });
    }

    private void loadAndCheckPropertyFile() {
        final File file = new File(this.htodPropertyFileName);
        final File file2 = new File(this.swapDirPath);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                cacheOnDisk.propertyFileStatus = 0;
                String[] stringArray = file2.list();
                if (stringArray != null && stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].startsWith("_dynacache" + HTODDynacache.object_suffix)) {
                            ++cacheOnDisk.dataFiles;
                            continue;
                        }
                        if (stringArray[i].startsWith("_dynacache" + HTODDynacache.dependency_suffix)) {
                            ++cacheOnDisk.dependencyIdFiles;
                            continue;
                        }
                        if (!stringArray[i].startsWith("_dynacache" + HTODDynacache.template_suffix)) continue;
                        ++cacheOnDisk.templateFiles;
                    }
                } else {
                    CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cacheOnDisk.cacheName + " no disk cache files exist");
                    cacheOnDisk.propertyFileStatus = (byte)(cacheOnDisk.propertyFileStatus | 1);
                    return null;
                }
                if (file.exists()) {
                    FileInputStream fileInputStream = null;
                    try {
                        int n;
                        fileInputStream = new FileInputStream(file);
                        Properties properties = new Properties();
                        properties.load(fileInputStream);
                        String string = (String)properties.get(CacheOnDisk.DISABLE_DEPENDENCY_ID);
                        if (string != null) {
                            cacheOnDisk.disableDependencyIdFromPropertyFile = Boolean.valueOf(string);
                        } else {
                            cacheOnDisk.propertyFileStatus = (byte)(cacheOnDisk.propertyFileStatus | 8);
                        }
                        string = (String)properties.get(CacheOnDisk.DISABLE_TEMPLATE_SUPPORT);
                        if (string != null) {
                            cacheOnDisk.disableTemplatesSupprotFromPropertyFile = Boolean.valueOf(string);
                        } else {
                            cacheOnDisk.propertyFileStatus = (byte)(cacheOnDisk.propertyFileStatus | 0x10);
                        }
                        string = (String)properties.get(CacheOnDisk.CACHE_SIZE_IN_BYTES);
                        long l = 0L;
                        if (string == null) {
                            cacheOnDisk.propertyFileStatus = (byte)(cacheOnDisk.propertyFileStatus | 0x20);
                            Object var7_10 = null;
                            return var7_10;
                        }
                        l = Long.parseLong(string);
                        byte[] byArray = string.getBytes();
                        int n2 = 0;
                        for (n = 0; n < byArray.length; ++n) {
                            n2 += byArray[n];
                        }
                        n2 *= 3;
                        string = (String)properties.get(CacheOnDisk.FIELD_CHECK);
                        if (string != null) {
                            n = Integer.parseInt(string);
                            if (n2 != n) {
                                cacheOnDisk.propertyFileStatus = (byte)(cacheOnDisk.propertyFileStatus | 0x40);
                                Object var10_16 = null;
                                return var10_16;
                            }
                        } else {
                            cacheOnDisk.propertyFileStatus = (byte)(cacheOnDisk.propertyFileStatus | 0x40);
                            Object var9_15 = null;
                            return var9_15;
                        }
                        string = (String)properties.get(CacheOnDisk.DATA_GB);
                        n = 0;
                        if (string == null) {
                            cacheOnDisk.propertyFileStatus = (byte)(cacheOnDisk.propertyFileStatus | 0xFFFFFF80);
                            Object var10_18 = null;
                            return var10_18;
                        }
                        n = Integer.parseInt(string);
                        string = (String)properties.get(CacheOnDisk.DEPID_GB);
                        int n3 = 0;
                        if (string == null) {
                            cacheOnDisk.propertyFileStatus = (byte)(cacheOnDisk.propertyFileStatus | 0xFFFFFF80);
                            Object var11_22 = null;
                            return var11_22;
                        }
                        n3 = Integer.parseInt(string);
                        string = (String)properties.get(CacheOnDisk.TEMPLATE_GB);
                        int n4 = 0;
                        if (string == null) {
                            cacheOnDisk.propertyFileStatus = (byte)(cacheOnDisk.propertyFileStatus | 0xFFFFFF80);
                            Object var12_25 = null;
                            return var12_25;
                        }
                        n4 = Integer.parseInt(string);
                        cacheOnDisk.currentCacheSizeInBytes = l;
                        cacheOnDisk.dataGB = n;
                        cacheOnDisk.dependencyIdGB = n3;
                        cacheOnDisk.templateGB = n4;
                        CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cacheOnDisk.cacheName + " htod.properties exist with status=" + cacheOnDisk.propertyFileStatus + " disableDependencyIdFromProperty=" + cacheOnDisk.disableDependencyIdFromPropertyFile + " disableTemplatesSupportFromProperty=" + cacheOnDisk.disableTemplatesSupprotFromPropertyFile + " cacheSizeInBytes=" + cacheOnDisk.currentCacheSizeInBytes + " dataGB=" + cacheOnDisk.dataGB + " dependencyIdGB=" + cacheOnDisk.dependencyIdGB + " templateGB=" + cacheOnDisk.templateGB);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.loadAndCheckPropertyFile", "452", cacheOnDisk);
                        CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                        cacheOnDisk.propertyFileStatus = (byte)(cacheOnDisk.propertyFileStatus | 4);
                    }
                    finally {
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.loadAndCheckPropertyFile", "464", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                        }
                    }
                } else {
                    cacheOnDisk.propertyFileStatus = (byte)(cacheOnDisk.propertyFileStatus | 2);
                    CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cacheOnDisk.cacheName + " htod.properties not exist" + " dependencyIdFiles=" + cacheOnDisk.dependencyIdFiles + " templateFiles=" + cacheOnDisk.templateFiles);
                }
                return null;
            }
        });
    }

    protected void updatePropertyFile() {
        final File file = new File(this.htodPropertyFileName);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("updatePropertyFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                FileOutputStream fileOutputStream = null;
                Properties properties = new Properties();
                try {
                    fileOutputStream = new FileOutputStream(file);
                    properties.put(CacheOnDisk.HTOD_VERSION, CacheOnDisk.HTOD_VERSION_NUM);
                    properties.put(CacheOnDisk.DISABLE_DEPENDENCY_ID, Boolean.toString(CacheOnDisk.this.disableDependencyId));
                    properties.put(CacheOnDisk.DISABLE_TEMPLATE_SUPPORT, Boolean.toString(CacheOnDisk.this.disableTemplatesSupport));
                    long l = 0L;
                    int n = 0;
                    if (cacheOnDisk.enableCacheSizeInBytes) {
                        if (cacheOnDisk.currentCacheSizeInBytes < cacheOnDisk.htod.minDiskCacheSizeInBytes) {
                            cacheOnDisk.currentCacheSizeInBytes = cacheOnDisk.htod.minDiskCacheSizeInBytes;
                        }
                        l = cacheOnDisk.currentCacheSizeInBytes;
                        properties.put(CacheOnDisk.CACHE_SIZE_IN_BYTES, Long.toString(l));
                        String string = String.valueOf(l);
                        byte[] byArray = string.getBytes();
                        n = 0;
                        for (int i = 0; i < byArray.length; ++i) {
                            n += byArray[i];
                        }
                        properties.put(CacheOnDisk.FIELD_CHECK, String.valueOf(n *= 3));
                        properties.put(CacheOnDisk.DATA_GB, String.valueOf(cacheOnDisk.diskCacheSizeInfo.currentDataGB));
                        properties.put(CacheOnDisk.DEPID_GB, String.valueOf(cacheOnDisk.diskCacheSizeInfo.currentDependencyIdGB));
                        properties.put(CacheOnDisk.TEMPLATE_GB, String.valueOf(cacheOnDisk.diskCacheSizeInfo.currentTemplateGB));
                        CacheOnDisk.this.traceDebug("updatePropertyFile()", "cacheName=" + cacheOnDisk.cacheName + " disableDependencyId=" + CacheOnDisk.this.disableDependencyId + " disableTemplatesSupport=" + CacheOnDisk.this.disableTemplatesSupport + " cacheSizeInBytes=" + l + " fieldCheck=" + n + " dataGB=" + cacheOnDisk.diskCacheSizeInfo.currentDataGB + " dependencyIdGB=" + cacheOnDisk.diskCacheSizeInfo.currentDependencyIdGB + " templateGB=" + cacheOnDisk.diskCacheSizeInfo.currentTemplateGB);
                    } else {
                        CacheOnDisk.this.traceDebug("updatePropertyFile()", "cacheName=" + cacheOnDisk.cacheName + " disableDependencyId=" + CacheOnDisk.this.disableDependencyId + " disableTemplatesSupport=" + CacheOnDisk.this.disableTemplatesSupport);
                    }
                    properties.store(fileOutputStream, "HTOD properties - Do not modify the properties");
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.updatePropertyFile", "509", cacheOnDisk);
                    CacheOnDisk.this.traceDebug("updatePropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                }
                finally {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.updatePropertyFile", "520", cacheOnDisk);
                        CacheOnDisk.this.traceDebug("updatePropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    }
                }
                return null;
            }
        });
    }

    private void deletePropertyFile() {
        final File file = new File(this.htodPropertyFileName);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("deletePropertyFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    file.delete();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.deletePropertyFile", "609", cacheOnDisk);
                    CacheOnDisk.this.traceDebug("deletePropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                }
                return null;
            }
        });
    }

    public void deleteDiskCacheFiles() {
        final File file = new File(this.swapDirPath);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("deleteDiskCacheFiles()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        fileArray[i].delete();
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.deleteDiskCacheFiles", "550", cacheOnDisk);
                        CacheOnDisk.this.traceDebug("deleteDiskCacheFiles()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    }
                }
                return null;
            }
        });
    }

    private void deleteAllDiskCacheFiles() {
        final File file = new File(this.swapRootDirPath);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("deleteAllDiskCacheFiles()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].isDirectory()) continue;
                    File[] fileArray2 = fileArray[i].listFiles();
                    for (int j = 0; j < fileArray2.length; ++j) {
                        try {
                            fileArray2[j].delete();
                            continue;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.deleteAllDiskCacheFiles", "583", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("deleteAllDiskCacheFiles()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                        }
                    }
                }
                return null;
            }
        });
    }

    private void createInProgressFile() {
        final File file = new File(this.inProgressFileName);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("createInProgressFile()", "cacheName=" + this.cacheName + " file=" + this.inProgressFileName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    file.createNewFile();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.createInProgressFile", "612", cacheOnDisk);
                    CacheOnDisk.this.traceDebug("createInProgressFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                }
                return null;
            }
        });
    }

    private void deleteInProgressFile() {
        final File file = new File(this.inProgressFileName);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("deleteInProgressFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    file.delete();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.deleteInProgressFile", "638", cacheOnDisk);
                    CacheOnDisk.this.traceDebug("deleteInProgressFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean bl) {
        this.stopping = true;
        this.htod.invalidationBuffer.setStopping(true);
        if (this.garbageCollectionThread != null) {
            this.garbageCollectionThread.stopped = true;
            Object object = this.garbageCollectionThread.GCMonitor;
            synchronized (object) {
                this.garbageCollectionThread.processWalkGarbageCollector = true;
                this.garbageCollectionThread.GCMonitor.notify();
            }
        }
        this.htod.stop(bl);
    }

    public void stopOnError(Exception exception) {
        this.cache.setSwapToDisk(false);
        this.stop(true);
        this.close(false);
        Tr.error(tc, "DYNA0072E", new Object[]{this.cache.getCacheName(), this.swapDirPath, exception.getMessage()});
    }

    protected ValueSet readAndDeleteInvalidationFile() {
        final File file = new File(this.invalidationFileName);
        final CacheOnDisk cacheOnDisk = this;
        this.valueSet = new ValueSet(1);
        if (file.exists()) {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    FileInputStream fileInputStream = null;
                    ObjectInputStream objectInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(file);
                        objectInputStream = new ObjectInputStream(fileInputStream);
                        int n = objectInputStream.readInt();
                        cacheOnDisk.valueSet = new ValueSet(n);
                        for (int i = 0; i < n; ++i) {
                            cacheOnDisk.valueSet.add(objectInputStream.readObject());
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk", "697", cacheOnDisk);
                        CacheOnDisk.this.traceDebug("readAndDeleteInvalidationFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    }
                    finally {
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            file.delete();
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk", "712", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("readAndDeleteInvalidationFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                        }
                    }
                    return null;
                }
            });
        }
        this.traceDebug("readAndDeleteInvalidationFile()", "cacheName=" + this.cacheName + " " + this.invalidationFileName + " valueSet=" + this.valueSet.size());
        return this.valueSet;
    }

    protected void createInvalidationFile() {
        final File file = new File(this.invalidationFileName);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("createInvalidationFile()", "cacheName=" + this.cacheName + " valueSet=" + cacheOnDisk.valueSet.size());
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                FileOutputStream fileOutputStream = null;
                ObjectOutputStream objectOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeInt(cacheOnDisk.valueSet.size());
                    for (Object e2 : CacheOnDisk.this.valueSet) {
                        objectOutputStream.writeObject(e2);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk", "752", cacheOnDisk);
                    CacheOnDisk.this.traceDebug("createInvalidationFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                }
                finally {
                    try {
                        objectOutputStream.close();
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk", "762", cacheOnDisk);
                        CacheOnDisk.this.traceDebug("createInvalidationFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    }
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        CacheOnDisk cacheOnDisk = this;
        synchronized (cacheOnDisk) {
            if (!this.stopping && !this.htod.invalidationBuffer.isDiskClearInProgress()) {
                this.htod.invalidationBuffer.invokeBackgroundInvalidation(true);
            } else if (this.stopping) {
                this.traceDebug("alarm()", "cacheName=" + this.cacheName + " abort disk cleanup because of server is stopping.");
            } else {
                if (this.cleanupFrequency == 0) {
                    this.sleepTime = this.calculateSleepTime();
                }
                this.traceDebug("alarm()", "cacheName=" + this.cache.getCacheName() + " disk clear is in progress - skip disk scan and set alarm sleepTime=" + this.sleepTime);
                AlarmManager.createNonDeferrable(this.sleepTime, this, null);
            }
        }
    }

    protected int cleanUpHTOD(boolean bl) {
        int n = 0;
        if (this.htod != null) {
            try {
                n = this.htod.removeExpiredCache(this.invalInterval, bl);
                if (n == 1) {
                    return n;
                }
                if (bl) {
                    this.updateLastScanFile();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.cleanupHTOD", "867", this);
                this.traceDebug("cleanUpHTOD()", "cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
        }
        if (bl && this.diskCachePerformanceLevel != 3 && !this.stopping && !this.htod.invalidationBuffer.isCleanupPending()) {
            if (this.cleanupFrequency == 0) {
                this.sleepTime = this.calculateSleepTime();
            }
            this.traceDebug("cleanUpHTOD()", "cacheName=" + this.cache.getCacheName() + " set alarm sleepTime=" + this.sleepTime);
            AlarmManager.createNonDeferrable(this.sleepTime, this, null);
        } else if (bl && this.diskCachePerformanceLevel != 3) {
            this.traceDebug("cleanUpHTOD()", "cacheName=" + this.cache.getCacheName() + " alarm is not enabled now. stopping=" + this.stopping + " cleanupPending=" + this.htod.invalidationBuffer.isCleanupPending());
        }
        return n;
    }

    protected void doCleanUp(boolean bl) {
        LowPriCleanupThread lowPriCleanupThread = new LowPriCleanupThread(this, bl);
        lowPriCleanupThread.setPriority(1);
        lowPriCleanupThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeDiskCacheGarbageCollector(int n) {
        if (this.garbageCollectionThread != null && !this.garbageCollectionThread.walkGarbageCollectorInProgress) {
            this.garbageCollectionThread.GCType = n;
            Object object = this.garbageCollectionThread.GCMonitor;
            synchronized (object) {
                this.garbageCollectionThread.processWalkGarbageCollector = true;
                this.garbageCollectionThread.GCMonitor.notify();
            }
        }
    }

    public ArrayList walkDiskCache(int n, int n2, long l) {
        return this.htod.walkEvictionTable(n, n2, l);
    }

    public void deleteFromDisk(ArrayList arrayList) {
        this.htod.invalidationBuffer.add(arrayList, 3);
    }

    public void clearDiskCache() {
        if (this.htod.clearDiskCache() == 1) {
            this.stopOnError(this.htod.diskCacheException);
        } else {
            this.updateLastScanFile();
            this.updatePropertyFile();
            this.createInProgressFile();
        }
    }

    public int writeCacheEntry(CacheEntry cacheEntry) {
        int n = this.htod.writeCacheEntry(cacheEntry);
        if (n == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
        return n;
    }

    public CacheEntry readCacheEntry(Object object) {
        Result result = this.htod.readCacheEntry(object);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)result.data;
        this.htod.returnToResultPool(result);
        return cacheEntry;
    }

    public CacheEntry readCacheEntry(Object object, boolean bl) {
        Result result = this.htod.readCacheEntry(object, bl);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)result.data;
        this.htod.returnToResultPool(result);
        return cacheEntry;
    }

    public void delCacheEntry(CacheEntry cacheEntry, int n, int n2, boolean bl) {
        this.htod.delCacheEntry(cacheEntry, n, n2, bl);
    }

    public void delCacheEntry(ValueSet valueSet, int n, int n2, boolean bl, boolean bl2) {
        this.htod.delCacheEntry(valueSet, n, n2, bl, bl2);
    }

    public ValueSet readDependency(Object object, boolean bl) {
        Result result = this.htod.readDependency(object, bl);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return HTODDynacache.EMPTY_VS;
        }
        ValueSet valueSet = (ValueSet)result.data;
        if (valueSet == null) {
            valueSet = HTODDynacache.EMPTY_VS;
        }
        this.htod.returnToResultPool(result);
        return valueSet;
    }

    public ValueSet readTemplate(String string, boolean bl) {
        Result result = this.htod.readTemplate(string, bl);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return HTODDynacache.EMPTY_VS;
        }
        ValueSet valueSet = (ValueSet)result.data;
        if (valueSet == null) {
            valueSet = HTODDynacache.EMPTY_VS;
        }
        this.htod.returnToResultPool(result);
        return valueSet;
    }

    public ValueSet readCacheIdsByRange(int n, int n2) {
        Result result = this.htod.readCacheIdsByRange(n, n2);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return HTODDynacache.EMPTY_VS;
        }
        ValueSet valueSet = (ValueSet)result.data;
        if (valueSet == null) {
            valueSet = HTODDynacache.EMPTY_VS;
        }
        this.htod.returnToResultPool(result);
        return valueSet;
    }

    public ValueSet readDependencyByRange(int n, int n2) {
        Result result = this.htod.readDependencyByRange(n, n2);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return HTODDynacache.EMPTY_VS;
        }
        ValueSet valueSet = (ValueSet)result.data;
        if (valueSet == null) {
            valueSet = HTODDynacache.EMPTY_VS;
        }
        this.htod.returnToResultPool(result);
        return valueSet;
    }

    public ValueSet readTemplatesByRange(int n, int n2) {
        Result result = this.htod.readTemplatesByRange(n, n2);
        if (result.returnCode == 1) {
            this.stopOnError(result.diskException);
            this.htod.returnToResultPool(result);
            return HTODDynacache.EMPTY_VS;
        }
        ValueSet valueSet = (ValueSet)result.data;
        if (valueSet == null) {
            valueSet = HTODDynacache.EMPTY_VS;
        }
        this.htod.returnToResultPool(result);
        return valueSet;
    }

    public int getCacheIdsSize(boolean bl) {
        if (bl) {
            return this.htod.getCacheIdsSize(bl) - this.htod.invalidationBuffer.size() + this.htod.diskCacheSizeAdjustment;
        }
        return this.htod.getCacheIdsSize(bl);
    }

    public int getDepIdsSize() {
        return this.htod.getDepIdsSize();
    }

    public int getTemplatesSize() {
        return this.htod.getTemplatesSize();
    }

    public long getCacheSizeInBytes() {
        return this.currentCacheSizeInBytes;
    }

    public int getDiskCacheSizeLimit() {
        return this.diskCacheSizeInfo.diskCacheSizeLimit;
    }

    public int getDiskCacheSizeHighLimit() {
        return this.diskCacheSizeInfo.diskCacheSizeHighLimit;
    }

    public int getDiskCachesizeLowLimit() {
        return this.diskCacheSizeInfo.diskCacheSizeLowLimit;
    }

    public int getDiskCacheSizeInGBLimit() {
        return this.diskCacheSizeInfo.diskCacheSizeInGBLimit;
    }

    public long getDiskCacheEntrySizeInBytesLimit() {
        return this.diskCacheSizeInfo.diskCacheEntrySizeInBytesLimit;
    }

    public long getDiskCacheSizeInBytesLimit() {
        return this.diskCacheSizeInfo.getDiskCacheSizeInBytesLimit();
    }

    public long getDiskCacheSizeInBytesHighLimit() {
        return this.diskCacheSizeInfo.getDiskCacheSizeInBytesHighLimit();
    }

    public long getDiskCacheSizeInBytesLowLimit() {
        return this.diskCacheSizeInfo.getDiskCacheSizeInBytesLowLimit();
    }

    public int getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public void delDependencyEntry(Object object, Object object2) {
        if (this.htod.delDependencyEntry(object, object2) == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
    }

    public void delTemplateEntry(String string, Object object) {
        if (this.htod.delTemplateEntry(string, object) == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
    }

    public void delDependency(Object object) {
        if (this.htod.delDependency(object) == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
    }

    public void delTemplate(String string) {
        if (this.htod.delTemplate(string) == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
    }

    public int writeDependency(Object object, ValueSet valueSet) {
        int n = this.htod.writeDependency(object, valueSet);
        if (n == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
        return n;
    }

    public int writeTemplate(String string, ValueSet valueSet) {
        int n = this.htod.writeTemplate(string, valueSet);
        if (n == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
        return n;
    }

    public int writeDependencyEntry(Object object, Object object2) {
        int n = this.htod.writeDependencyEntry(object, object2);
        if (n == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
        return n;
    }

    public int writeTemplateEntry(String string, Object object) {
        int n = this.htod.writeTemplateEntry(string, object);
        if (n == 1) {
            this.stopOnError(this.htod.diskCacheException);
        }
        return n;
    }

    public boolean containsKey(Object object) {
        return this.htod.containsKey(object);
    }

    public void invokeDiskCleanup(boolean bl) {
        this.htod.invokeDiskCleanup(bl);
    }

    public int getStartState() {
        return this.startState;
    }

    public boolean shouldPopulateEvictionTable() {
        return this.populateEvictionTable;
    }

    public int getPendingRemovalSize() {
        return this.htod.getPendingRemovalSize();
    }

    public int getDepIdsBufferedSize() {
        return this.htod.getDepIdsBufferedSize();
    }

    public int getTemplatesBufferedSize() {
        return this.htod.getTemplatesBufferedSize();
    }

    private long calculateSleepTime() {
        int n;
        int n2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n3 = gregorianCalendar.get(11);
        long l = 86400L - (long)((n3 * 60 + (n2 = gregorianCalendar.get(12))) * 60 + (n = gregorianCalendar.get(13))) + (long)(this.cleanupHour * 60 * 60);
        if (l > 86400L) {
            l -= 86400L;
        }
        if (l < 10L) {
            l = 10L;
        }
        return l *= 1000L;
    }

    public boolean isCleanupRunning() {
        return this.htod.invalidationBuffer.isBackgroundInvalidationInProgress();
    }

    public void clearInvalidationBuffers() {
        this.htod.invalidationBuffer.clear(2);
        this.htod.invalidationBuffer.clear(1);
        if (this.evictionPolicy != 0) {
            this.htod.invalidationBuffer.clear(3);
        }
    }

    public Exception getDiskCacheException() {
        return this.htod.diskCacheException;
    }

    public boolean isInvalidationBuffersFull() {
        return this.htod.invalidationBuffer.isFull();
    }

    public void releaseUnusedPools() {
        this.htod.releaseUnusedPools();
    }

    private void traceDebug(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + " " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCleanupComplete() {
        Object object = this.diskCacheMonitor;
        synchronized (object) {
            this.doNotify = true;
            try {
                this.diskCacheMonitor.wait(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.doNotify = false;
        }
    }

    class GarbageCollectorThread
    extends Thread {
        CacheOnDisk cod;
        int GCType;
        boolean stopped;
        boolean walkGarbageCollectorInProgress;
        boolean processWalkGarbageCollector;
        Object GCMonitor;

        GarbageCollectorThread(CacheOnDisk cacheOnDisk2) {
            this.cod = cacheOnDisk2;
            this.stopped = false;
            this.walkGarbageCollectorInProgress = false;
            this.processWalkGarbageCollector = false;
            this.GCMonitor = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList arrayList = null;
            int n = 0;
            if (this.cod.evictionPolicy != 0) {
                do {
                    Object object = this.GCMonitor;
                    synchronized (object) {
                        while (!this.processWalkGarbageCollector) {
                            try {
                                this.GCMonitor.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        this.processWalkGarbageCollector = false;
                        if (!this.stopped) {
                            this.cod.htod.invalidationBuffer.invokeBackgroundInvalidation(false);
                            if (this.cod.htod.invalidationBuffer.size(3) <= n || n == 0) {
                                this.walkGarbageCollectorInProgress = true;
                                if (this.GCType == 1) {
                                    int n2 = this.cod.getCacheIdsSize(true) - this.cod.htod.invalidationBuffer.size(3) - this.cod.diskCacheSizeInfo.diskCacheSizeLowLimit;
                                    arrayList = this.cod.walkDiskCache(this.cod.evictionPolicy, n2, 0L);
                                    if (tc.isEventEnabled()) {
                                        Tr.event(tc, "GarbageCollectorThread.run() cacheName=" + this.cod.cache.getCacheName() + " size exceeding high threshold limit of " + this.cod.diskCacheSizeInfo.highThreshold + "%." + " Disk cache garbage collector evicting " + arrayList.size() + " entries;  Request entries=" + n2);
                                    } else {
                                        CacheOnDisk.this.traceDebug("GarbageCollectorThread.run()", "cacheName=" + this.cod.cache.getCacheName() + " size exceeding high threshold limit of " + this.cod.diskCacheSizeInfo.highThreshold + "%." + " Disk cache garbage collector evicting " + arrayList.size() + " entries;  Request entries=" + n2);
                                    }
                                } else if (this.GCType == 2) {
                                    long l = this.cod.getCacheSizeInBytes() - this.cod.diskCacheSizeInfo.getDiskCacheSizeInBytesLowLimit();
                                    arrayList = this.cod.walkDiskCache(this.cod.evictionPolicy, 0, l);
                                    if (tc.isEventEnabled()) {
                                        Tr.event(tc, "GarbageCollectorThread.run() cacheName=" + this.cod.cache.getCacheName() + " size in GB exceeding high threshold limit of " + this.cod.diskCacheSizeInfo.highThreshold + "%." + " Disk cache garbage collector evicting " + arrayList.size() + " entries;  Request size=" + l + " bytes");
                                    } else {
                                        CacheOnDisk.this.traceDebug("GarbageCollectorThread.run()", "cacheName=" + this.cod.cache.getCacheName() + " size in GB exceeding high threshold limit of " + this.cod.diskCacheSizeInfo.highThreshold + "%." + " Disk cache garbage collector evicting " + arrayList.size() + " entries;  Request size=" + l + " bytes");
                                    }
                                }
                                if (!this.stopped && arrayList != null && arrayList.size() > 0) {
                                    CacheOnDisk.this.deleteFromDisk(arrayList);
                                    n = arrayList.size() * 20 / 100;
                                } else {
                                    n = 0;
                                }
                                this.walkGarbageCollectorInProgress = false;
                                if (!this.stopped) {
                                    this.cod.htod.invalidationBuffer.invokeBackgroundInvalidation(false);
                                }
                            }
                        }
                    }
                } while (!this.stopped);
            }
        }
    }

    class LowPriCleanupThread
    extends Thread {
        CacheOnDisk cod;
        boolean scan = true;

        LowPriCleanupThread(CacheOnDisk cacheOnDisk2, boolean bl) {
            this.cod = cacheOnDisk2;
            this.scan = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.cod.cleanUpHTOD(this.scan) == 1) {
                    CacheOnDisk.this.stopOnError(this.cod.htod.diskCacheException);
                } else if (this.cod.htod.invalidationBuffer.isCleanupPending()) {
                    this.cod.htod.invalidationBuffer.resetCleanupPending();
                    if (this.cod.cleanUpHTOD(true) == 1) {
                        CacheOnDisk.this.stopOnError(this.cod.htod.diskCacheException);
                    }
                }
                Object var2_1 = null;
                this.cod.populateEvictionTable = false;
                this.cod.htod.invalidationBuffer.setlastRemoveTime();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.cod.populateEvictionTable = false;
                this.cod.htod.invalidationBuffer.setlastRemoveTime();
                Object object = CacheOnDisk.this.diskCacheMonitor;
                synchronized (object) {
                    if (CacheOnDisk.this.doNotify) {
                        CacheOnDisk.this.diskCacheMonitor.notifyAll();
                    }
                }
                this.cod.htod.invalidationBuffer.setLoopOnce(false);
                this.cod.htod.invalidationBuffer.resetCleanupPending();
                this.cod.htod.invalidationBuffer.resetBackgroundInvalidationInProgress();
                throw throwable;
            }
            Object object = CacheOnDisk.this.diskCacheMonitor;
            synchronized (object) {
                if (CacheOnDisk.this.doNotify) {
                    CacheOnDisk.this.diskCacheMonitor.notifyAll();
                }
            }
            this.cod.htod.invalidationBuffer.setLoopOnce(false);
            this.cod.htod.invalidationBuffer.resetCleanupPending();
            this.cod.htod.invalidationBuffer.resetBackgroundInvalidationInProgress();
        }
    }
}

