/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.cache.drs.ws390.DynacachePlatformHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.cache.CacheProvider;
import com.ibm.wsspi.cache.CacheProviderLoader;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheProviderLoaderImpl
implements CacheProviderLoader {
    private static TraceComponent tc = Tr.register(CacheProviderLoaderImpl.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    Map<String, CacheProvider> cacheProviders = new HashMap<String, CacheProvider>();
    private boolean hasStarted = false;
    static CacheProviderLoaderImpl cacheLoader = null;

    private CacheProviderLoaderImpl() {
    }

    public static synchronized CacheProviderLoaderImpl getInstance() {
        if (null == cacheLoader) {
            cacheLoader = new CacheProviderLoaderImpl();
        }
        return cacheLoader;
    }

    void loadCacheProviders() {
        this.loadProviderFromExtClassLoader("com.ibm.ws.objectgrid.dynacache.CacheProviderImpl");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Loaded Cache Providers: " + this.cacheProviders);
        }
    }

    void startCacheProviders() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "startCacheProviders");
        }
        for (CacheProvider cacheProvider : this.cacheProviders.values()) {
            cacheProvider.start();
        }
        this.hasStarted = true;
    }

    private CacheProvider loadProviderFromExtClassLoader(String string) {
        CacheProvider cacheProvider = this.cacheProviders.get(string);
        if (cacheProvider == null) {
            ExtClassLoader extClassLoader = ExtClassLoader.getInstance();
            boolean bl = false;
            try {
                Class clazz = extClassLoader.loadClass(string);
                cacheProvider = (CacheProvider)clazz.newInstance();
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            if (bl && cacheProvider != null) {
                this.foundCacheProvider(cacheProvider, string, cacheProvider.getClass().getName());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Provider already exists for " + string);
        }
        return cacheProvider;
    }

    private void loadProvidersFromExtensionRegistry() {
        try {
            String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".cache-provider";
            IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "extensionPointId: " + string + " No. of extensions: " + iConfigurationElementArray.length);
            }
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IConfigurationElement: " + iConfigurationElement.getName());
                }
                if (!iConfigurationElement.getName().equals("component")) continue;
                CacheProvider cacheProvider = (CacheProvider)iConfigurationElement.createExecutableExtension("class");
                String string2 = iConfigurationElement.getAttribute("name");
                String string3 = iConfigurationElement.getAttribute("class");
                if (cacheProvider == null || string2 == null) continue;
                this.foundCacheProvider(cacheProvider, string2, string3);
            }
        }
        catch (CoreException coreException) {
            FFDCFilter.processException((Throwable)coreException, "com.ibm.ws.cache.CacheProviderLoaderImpl.loadProvidersFromExtensionRegistry", "138", null);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheProviderLoaderImpl.loadProvidersFromExtensionRegistry", "141", null);
        }
    }

    private void foundCacheProvider(CacheProvider cacheProvider, String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found cache provider " + string + " className " + string2 + " provider=" + cacheProvider);
        }
        this.cacheProviders.put(string, cacheProvider);
    }

    @Override
    public CacheProvider getCacheProvider(String string) {
        return this.cacheProviders.get(string);
    }

    @Override
    public Map<String, CacheProvider> getCacheProviders() {
        return this.cacheProviders;
    }

    public static boolean loadAndStartCacheProviders() {
        PlatformHelper platformHelper;
        boolean bl;
        String string;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = DynacachePlatformHelper.getProcessType();
        if (string2.equals("ManagedProcess") || string2.equals("UnManagedProcess")) {
            bl2 = true;
        }
        if ("PROXY_SERVER".equals(string = AdminServiceFactory.getAdminService().getServerType()) || "ONDEMAND_ROUTER".equals(string)) {
            bl3 = true;
        }
        boolean bl4 = bl = (platformHelper = PlatformHelperFactory.getPlatformHelper()).isZOS() && platformHelper.isServantJvm();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processType: " + string2 + " serverType: " + string + " isZosSR: " + bl);
        }
        return bl || bl2 || bl3;
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }
}

