/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.exception.DynamicCacheException;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheStatisticsListenerWrapper;
import com.ibm.ws.cache.DCacheBase;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.ExternalCacheServices;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.NullRemoteServices;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.TimeLimitDaemon;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.wsspi.cache.CacheFeatureSupport;
import com.ibm.wsspi.cache.CacheStatistics;
import com.ibm.wsspi.cache.CoreCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CacheProviderWrapper
extends DCacheBase
implements DCache {
    private static TraceComponent tc = Trace.register(CacheProviderWrapper.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    CacheFeatureSupport featureSupport = null;
    CoreCache coreCache = null;
    String cacheProviderName = "";
    CacheStatistics cacheStatistics = null;
    private static final HashMap EMPTY_MAP = new HashMap(0);
    private static final String CLEAR = "clearCache";

    public CacheProviderWrapper(CacheConfig cacheConfig, CacheFeatureSupport cacheFeatureSupport, CoreCache coreCache) {
        super(cacheConfig.cacheName, cacheConfig);
        this.cacheProviderName = cacheConfig.cacheProviderName;
        this.featureSupport = cacheFeatureSupport;
        this.coreCache = coreCache;
        this.swapToDisk = cacheConfig.enableDiskOffload;
        if (this.swapToDisk && !this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"enableDiskOffload", this.cacheName, this.cacheProviderName});
            this.swapToDisk = false;
            cacheConfig.enableDiskOffload = false;
        }
        if (cacheConfig.enableCacheReplication && !cacheFeatureSupport.isReplicationSupported()) {
            Tr.error(tc, "DYNA1065E", new Object[]{"enableCacheReplication", this.cacheName, this.cacheProviderName});
            cacheConfig.enableCacheReplication = false;
        }
        this.cacheStatistics = this.coreCache.getCacheStatistics();
        if (this.cacheStatistics == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "CTOR cacheName=" + this.cacheName + " **ERROR cacheStatistics object is found to be NULL.");
        }
        this.cacheStatisticsListener = new CacheStatisticsListenerWrapper(this.cacheStatistics);
    }

    public boolean containsCacheId(Object object) {
        boolean bl = false;
        if (object != null) {
            bl = this.coreCache.containsCacheId(object);
        }
        return bl;
    }

    public void clear(boolean bl) {
        this.invalidateExternalCaches(null, CLEAR);
        this.coreCache.clear();
    }

    public boolean enableListener(boolean bl) {
        boolean bl2 = super.enableListener(bl);
        this.coreCache.setEventSource(this.eventSource);
        return bl2;
    }

    public CacheStatistics getCacheStatistics() {
        return this.cacheStatistics;
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo entryInfo, boolean bl) {
        com.ibm.websphere.cache.CacheEntry cacheEntry = null;
        Object object = null;
        if (entryInfo != null) {
            object = entryInfo.getIdObject();
            cacheEntry = this.coreCache.get(object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEntry() cacheName=" + this.cacheName + " id=" + object + " cacheEntry=" + cacheEntry);
        }
        return cacheEntry;
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(Object object, int n, boolean bl, boolean bl2) {
        com.ibm.websphere.cache.CacheEntry cacheEntry = this.coreCache.get(object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEntry() cacheName=" + this.cacheName + " id=" + object + " cacheEntry=" + cacheEntry);
        }
        return cacheEntry;
    }

    public com.ibm.websphere.cache.CacheEntry getEntryFromMemory(Object object) {
        com.ibm.websphere.cache.CacheEntry cacheEntry = this.coreCache.get(object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEntryFromMemory() cacheName=" + this.cacheName + " id=" + object + " cacheEntry=" + cacheEntry);
        }
        return cacheEntry;
    }

    public Enumeration getAllIds() {
        Set<Object> set = this.coreCache.getCacheIds();
        ValueSet valueSet = new ValueSet(set.iterator());
        return valueSet.elements();
    }

    public Set getCacheIds() {
        return this.coreCache.getCacheIds();
    }

    public Collection getAllDependencyIds() {
        return this.coreCache.getDependencyIds();
    }

    public Set getCacheIdsByDependency(Object object) {
        return this.coreCache.getCacheIds(object);
    }

    public Set getCacheIdsByTemplate(String string) {
        return this.coreCache.getCacheIds(string);
    }

    public int getNumberCacheEntries() {
        if (this.cacheStatistics != null) {
            return (int)this.cacheStatistics.getMemoryCacheEntriesCount();
        }
        return 0;
    }

    public int getNumberCacheEntriesUnsynchronized() {
        return this.getNumberCacheEntries();
    }

    public Object getValue(Object object, String string, boolean bl, boolean bl2) {
        Object object2 = null;
        com.ibm.websphere.cache.CacheEntry cacheEntry = this.coreCache.get(object);
        if (cacheEntry != null) {
            object2 = cacheEntry.getValue();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getValue() cacheName=" + this.cacheName + " id=" + object + " value=" + object2);
        }
        return object2;
    }

    public Object invalidateAndSet(EntryInfo entryInfo, Object object, boolean bl) {
        Object object2 = null;
        Object object3 = null;
        if (entryInfo != null && object != null) {
            object3 = entryInfo.getIdObject();
            com.ibm.websphere.cache.CacheEntry cacheEntry = this.coreCache.put(entryInfo, object);
            if (cacheEntry != null) {
                object2 = cacheEntry.getValue();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalidateAndSet() cacheName=" + this.cacheName + " id=" + object3 + " value=" + object);
        }
        return object2;
    }

    public void internalInvalidateByDepId(Object object, int n, int n2, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "internalInvalidateByDepId() cacheName=" + this.cacheName + " id=" + object);
        }
        this.invalidateExternalCaches(object, null);
        this.coreCache.invalidateByDependency(object, true);
    }

    private void invalidateExternalCaches(Object object, String string) {
        ExternalCacheServices externalCacheServices = ServerCache.cacheUnit.getExternalCacheServices();
        if (this.cacheConfig.enableServletSupport && externalCacheServices.getExternalCacheGroupNames().hasNext()) {
            Serializable serializable;
            if (null != object) {
                serializable = new HashMap<Object, Object>(1);
                ((HashMap)serializable).put(object, null);
                externalCacheServices.invalidateExternalCaches((HashMap)serializable, EMPTY_MAP);
            }
            if (null != string && 0 != string.trim().length()) {
                serializable = new InvalidateByTemplateEvent(string, -1);
                HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>(1);
                if (string.equals(CLEAR)) {
                    ((InvalidateByTemplateEvent)serializable).setCacheCommand_Clear();
                } else {
                    ValueSet valueSet = new ValueSet(this.coreCache.getCacheIds(string).iterator());
                    ((InvalidateByTemplateEvent)serializable).addRemovedIds(valueSet);
                }
                hashMap.put(string, serializable);
                externalCacheServices.invalidateExternalCaches(EMPTY_MAP, hashMap);
            }
        }
    }

    public void invalidateById(Object object, int n, boolean bl, boolean bl2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalidateById()-1 cacheName=" + this.cacheName + " id=" + object);
        }
        this.invalidateExternalCaches(object, null);
        this.coreCache.invalidate(object, bl);
    }

    public void invalidateById(Object object, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalidateById()-2 cacheName=" + this.cacheName + " id=" + object);
        }
        this.invalidateExternalCaches(object, null);
        this.coreCache.invalidate(object, bl);
    }

    public void invalidateByTemplate(String string, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalidateByTemplate() cacheName=" + this.cacheName + " template=" + string);
        }
        this.invalidateExternalCaches(null, string);
        this.coreCache.invalidateByTemplate(string, bl);
    }

    public boolean isValid(String string) {
        return this.coreCache.containsCacheId(string);
    }

    public void refreshEntry(com.ibm.websphere.cache.CacheEntry cacheEntry) {
        Object object = null;
        if (cacheEntry != null) {
            object = cacheEntry.getIdObject();
            this.coreCache.refreshEntry(object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "refreshEntry() cacheName=" + this.cacheName + " id=" + object);
        }
    }

    public com.ibm.websphere.cache.CacheEntry setEntry(CacheEntry cacheEntry, int n, boolean bl, boolean bl2, boolean bl3) {
        Object object = null;
        com.ibm.websphere.cache.CacheEntry cacheEntry2 = null;
        if (cacheEntry != null) {
            object = cacheEntry.getIdObject();
            EntryInfo entryInfo = new EntryInfo();
            entryInfo.copyMetadata(cacheEntry);
            this.coreCache.put(entryInfo, cacheEntry.getValue());
            if (bl3) {
                cacheEntry2 = this.coreCache.get(object);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setEntry() cacheName=" + this.cacheName + " id=" + object);
        }
        return cacheEntry2;
    }

    public void setValue(EntryInfo entryInfo, Object object, boolean bl) {
        Object object2 = null;
        if (entryInfo != null) {
            object2 = entryInfo.getIdObject();
        }
        this.coreCache.put(entryInfo, object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setValue() cacheName=" + this.cacheName + " id=" + object2);
        }
    }

    public void start() {
        this.coreCache.start();
    }

    public void stop() {
        this.coreCache.stop();
    }

    public void addAlias(Object object, Object[] objectArray, boolean bl, boolean bl2) {
        if (this.featureSupport.isAliasSupported()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addAlias() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else {
            Tr.error(tc, "DYNA1063E", new Object[]{"addAlias()", this.cacheName, this.cacheProviderName});
        }
    }

    public void removeAlias(Object object, boolean bl, boolean bl2) {
        if (this.featureSupport.isAliasSupported()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeAlias() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else {
            Tr.error(tc, "DYNA1063E", new Object[]{"removeAlias()", this.cacheName, this.cacheProviderName});
        }
    }

    public int getPushPullTableSize() {
        if (this.featureSupport.isReplicationSupported()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPushPullTableSize() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else {
            Tr.error(tc, "DYNA1065E", new Object[]{"getPushPullTableSize()", this.cacheName, this.cacheProviderName});
        }
        return 0;
    }

    public boolean shouldPull(int n, Object object) {
        boolean bl = false;
        if (this.featureSupport.isReplicationSupported()) {
            // empty if block
        }
        return bl;
    }

    public void clearDisk() {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clearDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"clearDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clearDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
    }

    public boolean containsKeyDisk(Object object) {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "containsKeyDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"containsKeyDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "containsKeyDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return false;
    }

    public int getActualIdsSizeDisk() {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getActualIdsSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getActualIdsSizeDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getActualIdsSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return 0;
    }

    public long getCacheSizeInBytesDisk() {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCacheSizeInBytesDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getCacheSizeInBytesDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCacheSizeInBytesDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return 0L;
    }

    public Set getCacheIdsByDependencyDisk(Object object) {
        HashSet hashSet = new HashSet();
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCacheIdsByDependencyDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getCacheIdsByDependencyDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCacheIdsByDependencyDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return hashSet;
    }

    public Set getCacheIdsByTemplateDisk(String string) {
        HashSet hashSet = new HashSet();
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCacheIdsByTemplateDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getCacheIdsByTemplateDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCacheIdsByTemplateDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return hashSet;
    }

    public int getDepIdsBufferedSizeDisk() {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDepIdsBufferedSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getDepIdsBufferedSizeDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDepIdsBufferedSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return 0;
    }

    public Set getDepIdsByRangeDisk(int n, int n2) {
        HashSet hashSet = new HashSet();
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDepIdsByRangeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getDepIdsByRangeDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDepIdsByRangeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return hashSet;
    }

    public int getDepIdsSizeDisk() {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDepIdsSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getDepIdsSizeDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDepIdsSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return 0;
    }

    public Exception getDiskCacheException() {
        Exception exception = null;
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDiskCacheException() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getDiskCacheException()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDiskCacheException() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return exception;
    }

    public int getDiskCacheHashcode(boolean bl, boolean bl2) throws DynamicCacheException {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDiskCacheHashcode() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getDiskCacheHashcode()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDiskCacheHashcode() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return 0;
    }

    public float getDiskCacheSizeInMBs() {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDiskCacheSizeInMBs() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getDiskCacheSizeInMBs()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDiskCacheSizeInMBs() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return 0.0f;
    }

    public com.ibm.websphere.cache.CacheEntry getEntryDisk(Object object) {
        com.ibm.websphere.cache.CacheEntry cacheEntry = null;
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getEntryDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getEntryDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEntryDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return cacheEntry;
    }

    public Set getIdsByRangeDisk(int n, int n2) {
        HashSet hashSet = new HashSet();
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getIdsByRangeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getIdsByRangeDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdsByRangeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return hashSet;
    }

    public int getIdsSizeDisk() {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getIdsSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getIdsSizeDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdsSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return 0;
    }

    public int getPendingRemovalSizeDisk() {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPendingRemovalSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getPendingRemovalSizeDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPendingRemovalSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return 0;
    }

    public int getTemplatesBufferedSizeDisk() {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getTemplatesBufferedSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getTemplatesBufferedSizeDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTemplatesBufferedSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return 0;
    }

    public Set getTemplatesByRangeDisk(int n, int n2) {
        HashSet hashSet = new HashSet();
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getTemplatesByRangeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getTemplatesByRangeDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTemplatesByRangeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return hashSet;
    }

    public int getTemplatesSizeDisk() {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getTemplatesSizeDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"getTemplatesSizeDisk()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTemplatesSizeDisk() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return 0;
    }

    public void invokeDiskCleanup(boolean bl) {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invokeDiskCleanup() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"invokeDiskCleanup()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invokeDiskCleanup() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
    }

    public boolean isDiskCleanupRunning() {
        boolean bl = false;
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isDiskCleanupRunning() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"isDiskCleanupRunning()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isDiskCleanupRunning() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return bl;
    }

    public boolean isDiskInvalidationBufferFull() {
        boolean bl = false;
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isDiskInvalidationBufferFull() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"isDiskInvalidationBufferFull()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isDiskInvalidationBufferFull() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
        return bl;
    }

    public void releaseDiskCacheUnusedPools() {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "releaseDiskCacheUnusedPools() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"releaseDiskCacheUnusedPools()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseDiskCacheUnusedPools() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
    }

    public void setEnableDiskCacheSizeInBytesChecking(boolean bl) {
        if (this.swapToDisk) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setEnableDiskCacheSizeInBytesChecking() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
            }
        } else if (!this.featureSupport.isDiskCacheSupported()) {
            Tr.error(tc, "DYNA1064E", new Object[]{"setEnableDiskCacheSizeInBytesChecking()", this.cacheName, this.cacheProviderName});
            Thread.dumpStack();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setEnableDiskCacheSizeInBytesChecking() cacheName=" + this.cacheName + " no operation is done because the disk cache offload is not enabled");
        }
    }

    public void setSwapToDisk(boolean bl) {
        if (bl) {
            if (this.featureSupport.isDiskCacheSupported()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setSwapToDisk() cacheName=" + this.cacheName + " ERROR because it is not implemented yet");
                }
                this.swapToDisk = false;
            } else {
                Tr.error(tc, "DYNA1064E", new Object[]{"setSwapToDisk()", this.cacheName, this.cacheProviderName});
                Thread.dumpStack();
                this.swapToDisk = false;
            }
        } else {
            this.swapToDisk = false;
        }
    }

    public void refreshCachePerf() {
    }

    public void resetPMICounters() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resetPMICounters() cacheName=" + this.cacheName);
        }
    }

    public void updateStatisticsForVBC(com.ibm.websphere.cache.CacheEntry cacheEntry, boolean bl) {
        Object object = null;
        if (cacheEntry != null) {
            object = cacheEntry.getIdObject();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updateStatisticsForVBC() cacheName=" + this.cacheName + " id=" + object + " directive=" + bl);
        }
    }

    public void setBatchUpdateDaemon(BatchUpdateDaemon batchUpdateDaemon) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBatchUpdateDaemon() cacheName=" + this.cacheName);
        }
    }

    public void addToTimeLimitDaemon(Object object, long l, int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addToTimeLimitDaemon() cacheName=" + this.cacheName + " ERROR because it should not be called");
        }
    }

    public void batchUpdate(HashMap hashMap, HashMap hashMap2, ArrayList arrayList) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "batchUpdate() cacheName=" + this.cacheName + " ERROR because it should not be called");
        }
    }

    public RemoteServices getRemoteServices() {
        return new NullRemoteServices();
    }

    public boolean freeLruEntry() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "freeLruEntry() cacheName=" + this.cacheName + " ERROR because it should not be called");
        }
        return false;
    }

    public void setRemoteServices(RemoteServices remoteServices) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setRemoteServices() cacheName=" + this.cacheName + " ERROR because it should not be called");
        }
    }

    public void setTimeLimitDaemon(TimeLimitDaemon timeLimitDaemon) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTimeLimitDaemon() cacheName=" + this.cacheName + " ERROR because it should not be called");
        }
    }

    public void trimCache() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "trimCache() cacheName=" + this.cacheName + " ERROR because it should not be called");
        }
    }
}

