/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.applicationserver.DynamicCache;
import com.ibm.websphere.models.config.dynacache.CacheInstance;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheInstanceInfo;
import com.ibm.ws.cache.CacheProviderLoaderImpl;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.CacheUnitImpl;
import com.ibm.ws.cache.DistributedLockingMapImpl;
import com.ibm.ws.cache.DistributedMapImpl;
import com.ibm.ws.cache.DistributedNioMapImpl;
import com.ibm.ws.cache.DistributedObjectCacheAdapter;
import com.ibm.ws.cache.MBeans;
import com.ibm.ws.cache.NotificationService;
import com.ibm.ws.cache.PropertiesEntityResolver;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.WCCMCacheConfig;
import com.ibm.ws.cache.command.CommandCache;
import com.ibm.ws.cache.config.ConfigManager;
import com.ibm.ws.cache.drs.DRSMessageListener;
import com.ibm.ws.cache.drs.DRSNotificationService;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.cache.servlet.ServletCacheConfig;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.PropertyVetoException;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.naming.util.CacheableReference;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.CacheResourceMgr;
import com.ibm.ws.runtime.service.MultibrokerDomain;
import com.ibm.ws.runtime.service.ResourceMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.cache.CacheInstanceResourceBinder;
import com.ibm.wsspi.cache.CacheProvider;
import com.ibm.wsspi.drs.DRSBootstrap;
import com.ibm.wsspi.drs.DRSDataXfer;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class CacheServiceImpl
extends ComponentImpl
implements CacheService,
DeployedObjectListener,
VetoableChangeListener {
    private static TraceComponent tc = Trace.register(CacheServiceImpl.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static boolean assertRanOnce = false;
    private static String DISTRIBUTED_MAP_PROPERTIES = "distributedmap.properties";
    private static String CACHE_INSTANCES_PROPERTIES = "cacheinstances.properties";
    public static String state = null;
    private DCache cache = null;
    private CommandCache commandCache = null;
    private JSPCache jspCache = null;
    private CacheUnitImpl cacheUnit = null;
    private boolean cacheEnabled = false;
    private ConfigManager configManager = null;
    private NotificationService _drsNotifSvc = null;
    private HashMap wccmCacheConfigs = null;
    private static CacheService cacheService = null;
    private CacheConfig.Environment environment = null;
    private WCCMCacheConfig baseCacheConfig = null;
    private WCCMCacheConfig dMapCacheConfig = null;
    private WCCMCacheConfig commonCacheConfig = null;
    private HashSet processedUrls = new HashSet();
    private MBeans mbeans = null;
    private CacheProviderLoaderImpl providerLoader = null;
    private boolean serviceStarted = false;

    public CacheServiceImpl() {
        assert (assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this));
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CacheServiceImpl() - CTOR");
        }
        if (cacheService != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CacheServiceImpl() - CTOR CacheServiceImpl already exists");
            }
            throw new IllegalStateException(" CacheServiceImpl already exists");
        }
        cacheService = this;
        this.wccmCacheConfigs = new HashMap();
        this.environment = new CacheConfig.Environment();
        this.environment.isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
        this.mbeans = new MBeans();
        this.providerLoader = CacheProviderLoaderImpl.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CacheServiceImpl() - CTOR");
        }
    }

    public static CacheService getCacheService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCacheService()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCacheService() cacheService=" + cacheService);
        }
        return cacheService;
    }

    public String expandWebSphereVariable(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandWebSphereVariables() string=" + string);
        }
        if (string != null) {
            string = super.expandVariable(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandWebSphereVariables() string=" + string);
        }
        return string;
    }

    public NotificationService getDRSNotificationService() {
        return this._drsNotifSvc;
    }

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize() WCCM config=" + object);
        }
        if (this.isProxyServerServantRegionOnZOS()) {
            Tr.info(tc, "Cache Service is unavailable in this environment.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize()");
            }
            throw new ComponentDisabledException();
        }
        assert (object != null);
        DynamicCache dynamicCache = (DynamicCache)object;
        if (!dynamicCache.isEnable()) {
            throw new ComponentDisabledException();
        }
        super.addService(CacheService.class);
        if (this.isApplicationServerAvailable()) {
            object2 = (ResourceMgr)super.getService(ResourceMgr.class);
            object2.addResourceBinder(new CacheInstanceResourceBinder());
            super.releaseService(object2);
        } else if (this.isProxyServerOnZOS()) {
            object2 = (CacheResourceMgr)super.getService(CacheResourceMgr.class);
            object2.addResourceBinder(new CacheInstanceResourceBinder());
            super.releaseService(object2);
        }
        object2 = (VariableMap)super.getService(VariableMap.class);
        this.environment.tmpDir = object2.expand("${WAS_TEMP_DIR}");
        this.environment.propDir = object2.expand("${WAS_PROPS_DIR}");
        this.environment.dtdDir = object2.expand("${WAS_INSTALL_ROOT}/properties");
        super.releaseService(object2);
        Server server2 = (Server)super.getService(Server.class);
        this.environment.serverCellName = server2.getCellName();
        this.environment.serverNodeName = server2.getNodeName();
        this.environment.serverServerName = server2.getName();
        super.releaseService(server2);
        ApplicationServer applicationServer = (ApplicationServer)super.getService(ApplicationServer.class);
        if (this.isApplicationServerAvailable()) {
            applicationServer.addVetoableChangeListener("state", this);
            super.releaseService(applicationServer);
        }
        this.baseCacheConfig = new WCCMCacheConfig(dynamicCache, this.environment);
        this.commonCacheConfig = new WCCMCacheConfig(dynamicCache, this.environment);
        this.wccmCacheConfigs.put("services/cache/basecache", this.baseCacheConfig);
        assert (this.baseCacheConfig.cacheName.equals("baseCache"));
        if (this.baseCacheConfig.disableTemplateInvalidation) {
            Tr.info(tc, "dynacache.error", "Error type=config warning. CacheConfig.disableTemplateInvalidation=true. Template invalidations are disabled for JSP reload.");
        }
        this.dMapCacheConfig = new WCCMCacheConfig(dynamicCache, this.environment);
        this.wccmCacheConfigs.put("services/cache/distributedmap", this.dMapCacheConfig);
        this.dMapCacheConfig.cacheName = "default";
        this.dMapCacheConfig.configSource = 255;
        this.dMapCacheConfig.enableServletSupport = false;
        PropertiesEntityResolver.propertiesDir = this.baseCacheConfig.propertiesDir;
        this.getCacheInstanceInfo();
        this.commonCacheConfig.restoreDynacacheProviderDefaults();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize()");
        }
    }

    public WCCMCacheConfig addCacheInstanceConfig(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCacheInstanceConfig()1of3 properties=" + properties);
        }
        assert (properties != null);
        assert (properties.containsKey("com.ibm.ws.cache.CacheConfig.cacheName"));
        WCCMCacheConfig wCCMCacheConfig = new WCCMCacheConfig(properties, this.commonCacheConfig, this.environment);
        String string = wCCMCacheConfig.cacheName;
        this.wccmCacheConfigs.put(string, wCCMCacheConfig);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addCacheInstanceConfig()1of3 Saved the dynacache internal config object as ", new Object[]{string, wCCMCacheConfig});
        }
        assert (wCCMCacheConfig != null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCacheInstanceConfig()1of3 config=" + wCCMCacheConfig.hashCode());
        }
        return wCCMCacheConfig;
    }

    public WCCMCacheConfig addCacheInstanceConfig(CacheInstance cacheInstance) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCacheInstanceConfig()2of3");
        }
        assert (cacheInstance != null);
        WCCMCacheConfig wCCMCacheConfig = new WCCMCacheConfig(cacheInstance, this.environment);
        String string = wCCMCacheConfig.cacheName;
        this.wccmCacheConfigs.put(string, wCCMCacheConfig);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Saved the dynacache internal config object as", new Object[]{string, wCCMCacheConfig});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCacheInstanceConfig()2of3 config=" + wCCMCacheConfig.hashCode());
        }
        return wCCMCacheConfig;
    }

    public void addCacheInstanceConfig(CacheConfig cacheConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCacheInstanceConfig()3of3");
        }
        assert (cacheConfig != null);
        cacheConfig.configSource = cacheConfig.enableServletSupport ? 7 : 8;
        String string = cacheConfig.cacheName;
        this.wccmCacheConfigs.put(string, cacheConfig);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Saved the dynacache internal config object as", new Object[]{string, cacheConfig});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCacheInstanceConfig()3of3 config=" + cacheConfig.hashCode());
        }
    }

    public WCCMCacheConfig getCacheInstanceConfig(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCacheInstanceConfig() reference=" + string);
        }
        WCCMCacheConfig wCCMCacheConfig = null;
        String string2 = string;
        if (string != null) {
            if (string.equalsIgnoreCase("baseCache")) {
                string2 = "services/cache/basecache";
            } else if (string.equalsIgnoreCase("default")) {
                string2 = "services/cache/distributedmap";
            }
            wCCMCacheConfig = (WCCMCacheConfig)this.wccmCacheConfigs.get(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCacheInstanceConfig() config=" + (wCCMCacheConfig != null ? "" + wCCMCacheConfig.hashCode() : "null") + " reference=" + string2);
        }
        return wCCMCacheConfig;
    }

    public WCCMCacheConfig removeCacheInstanceConfig(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeCacheInstanceConfig() reference=" + string);
        }
        WCCMCacheConfig wCCMCacheConfig = null;
        String string2 = string;
        if (string != null) {
            if (string.equalsIgnoreCase("baseCache")) {
                string2 = "services/cache/basecache";
            } else if (string.equalsIgnoreCase("default")) {
                string2 = "services/cache/distributedmap";
            }
            wCCMCacheConfig = (WCCMCacheConfig)this.wccmCacheConfigs.remove(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeCacheInstanceConfig() config=" + (wCCMCacheConfig != null ? "" + wCCMCacheConfig.hashCode() : "null") + " reference=" + string2);
        }
        return wCCMCacheConfig;
    }

    public void destroyCacheInstance(String string) {
        WCCMCacheConfig wCCMCacheConfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyCacheInstance() reference=" + string);
        }
        if ((wCCMCacheConfig = this.removeCacheInstanceConfig(string)) != null) {
            if (wCCMCacheConfig.cache != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "destroyCacheInstance() Stopping named cache: " + wCCMCacheConfig.cacheName);
                }
                wCCMCacheConfig.cache.stop();
            }
            wCCMCacheConfig.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyCacheInstance()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createCacheInstance(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCacheInstance() reference=" + string + " serviceStarted=" + this.serviceStarted);
        }
        if (!this.serviceStarted) {
            throw new IllegalStateException("cache service not yet started.");
        }
        String string2 = string;
        if (string.equalsIgnoreCase("baseCache")) {
            string = "services/cache/basecache";
        }
        if (string.equalsIgnoreCase("default")) {
            string = "services/cache/distributedmap";
        }
        boolean bl = string.equalsIgnoreCase("services/cache/basecache");
        boolean bl2 = string.equalsIgnoreCase("services/cache/distributedmap");
        WCCMCacheConfig wCCMCacheConfig = (WCCMCacheConfig)this.wccmCacheConfigs.get(string);
        if (wCCMCacheConfig == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createCacheInstance() Error - Config not found. Reference=" + new Object[]{string});
            }
            throw new IllegalStateException("Config not found. Reference=" + string);
        }
        WCCMCacheConfig wCCMCacheConfig2 = wCCMCacheConfig;
        synchronized (wCCMCacheConfig2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Entered synchronized (config) for " + wCCMCacheConfig.cacheName);
            }
            if (wCCMCacheConfig.distributedObjectCache == null) {
                if (bl) {
                    assert (wCCMCacheConfig.cache != null);
                    wCCMCacheConfig.distributedObjectCache = new DistributedMapImpl(wCCMCacheConfig.cache);
                } else {
                    wCCMCacheConfig.distributedObjectCache = this.createDistributedObjectCache(wCCMCacheConfig);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createCacheInstance() Reference  in=" + string2);
            Tr.debug(tc, "createCacheInstance() Reference out=" + string);
            Tr.debug(tc, "createCacheInstance()        Config=" + wCCMCacheConfig);
            Tr.debug(tc, "createCacheInstance()     isServlet=" + wCCMCacheConfig.enableServletSupport);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCacheInstance()  distributedObjectCache=" + wCCMCacheConfig.distributedObjectCache);
        }
        return wCCMCacheConfig.distributedObjectCache;
    }

    private DistributedObjectCache createDistributedObjectCache(WCCMCacheConfig wCCMCacheConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDistributedObjectCache() cacheName=" + (wCCMCacheConfig != null ? wCCMCacheConfig.cacheName : "null"));
        }
        assert (wCCMCacheConfig != null);
        if (wCCMCacheConfig.distributedObjectCache != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createDistributedObjectCache() ERROR - DistributedObjectCache already exists for " + wCCMCacheConfig.cacheName);
            }
            throw new IllegalStateException("DistributedObjectCache already exists for " + wCCMCacheConfig.cacheName);
        }
        if (wCCMCacheConfig.cache != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createDistributedObjectCache() Cache already exists(1). cacheName=" + wCCMCacheConfig.cacheName);
            }
            throw new IllegalStateException("Cache already exists for (1) " + wCCMCacheConfig.cacheName);
        }
        if (ServerCache.getCache(wCCMCacheConfig.cacheName) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createDistributedObjectCache() Cache already exists(2). cacheName=" + wCCMCacheConfig.cacheName);
            }
            throw new IllegalStateException("Cache already exists(2). cacheName=" + wCCMCacheConfig.cacheName);
        }
        DistributedObjectCacheAdapter distributedObjectCacheAdapter = null;
        switch (wCCMCacheConfig.configSource) {
            case 254: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDistributedObjectCache() Creating map from config type: CacheConfig.INTERNAL_BASE_CACHE");
                }
                assert (wCCMCacheConfig.cacheName.equals("baseCache"));
                wCCMCacheConfig.cache = ServerCache.getCache("baseCache");
                distributedObjectCacheAdapter = new DistributedMapImpl(wCCMCacheConfig.cache);
                break;
            }
            case 255: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDistributedObjectCache() Creating map from config type: CacheConfig.INTERNAL_DMAP_CACHE");
                }
                assert (wCCMCacheConfig.cacheName.equals("default"));
                assert (wCCMCacheConfig.cache == null);
                wCCMCacheConfig.cache = ServerCache.createCache(wCCMCacheConfig.cacheName, wCCMCacheConfig);
                distributedObjectCacheAdapter = new DistributedMapImpl(wCCMCacheConfig.cache);
                break;
            }
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDistributedObjectCache() Creating map from config type: CacheConfig.WCCM_DYNAMIC_CACHE");
                }
                throw new IllegalStateException("Can not create a BaseCacheInstnace for " + wCCMCacheConfig.cacheName);
            }
            case 2: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDistributedObjectCache() Creating map from config type: CacheConfig.WCCM_CACHE_INSTANCE");
                }
                assert (wCCMCacheConfig.cache == null);
                wCCMCacheConfig.cache = ServerCache.createCache(wCCMCacheConfig.cacheName, wCCMCacheConfig);
                distributedObjectCacheAdapter = new DistributedMapImpl(wCCMCacheConfig.cache);
                break;
            }
            case 3: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDistributedObjectCache() Creating ServletWrapper from config type: CacheConfig.WCCM_SERVLET_CACHE_INSTANCE");
                }
                assert (wCCMCacheConfig.cache != null);
                throw new IllegalStateException("Can not create a ServletCacheInstnace for " + wCCMCacheConfig.cacheName);
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDistributedObjectCache() Creating map from config type: " + (wCCMCacheConfig.configSource == 4 ? "CacheConfig.WCCM_OBJECT_CACHE_INSTANCE" : (wCCMCacheConfig.configSource == 8 ? "CacheConfig.FACTORY_OBJECT_CACHE_INSTANCE" : "CacheConfig.FILE_OBJECT_CACHE_INSTANCE")));
                }
                if (wCCMCacheConfig.enableLockingSupport && !wCCMCacheConfig.enableNioSupport) {
                    assert (wCCMCacheConfig.cache == null);
                    ServerCache.createCache(wCCMCacheConfig.cacheName, wCCMCacheConfig);
                    assert (wCCMCacheConfig.cache != null);
                    distributedObjectCacheAdapter = new DistributedLockingMapImpl(wCCMCacheConfig.cache);
                    break;
                }
                if (!wCCMCacheConfig.enableLockingSupport && !wCCMCacheConfig.enableNioSupport) {
                    assert (wCCMCacheConfig.cache == null);
                    ServerCache.createCache(wCCMCacheConfig.cacheName, wCCMCacheConfig);
                    assert (wCCMCacheConfig.cache != null);
                    distributedObjectCacheAdapter = new DistributedMapImpl(wCCMCacheConfig.cache);
                    break;
                }
                if (!wCCMCacheConfig.enableNioSupport) break;
                assert (wCCMCacheConfig.cache == null);
                ServerCache.createCache(wCCMCacheConfig.cacheName, wCCMCacheConfig);
                assert (wCCMCacheConfig.cache != null);
                distributedObjectCacheAdapter = new DistributedNioMapImpl(wCCMCacheConfig.cache);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown cache config source (" + wCCMCacheConfig.configSource + ") for " + wCCMCacheConfig.cacheName);
            }
        }
        assert (distributedObjectCacheAdapter != null);
        assert (wCCMCacheConfig.cache != null);
        Tr.info(tc, "DYNA1001I", new Object[]{wCCMCacheConfig.cacheName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDistributedObjectCache() distributedObjectCache=" + distributedObjectCacheAdapter);
        }
        return distributedObjectCacheAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initNotificationServiceInstance(NotificationService notificationService, CacheConfig cacheConfig) {
        assert (notificationService != null);
        assert (cacheConfig != null);
        assert (cacheConfig.drss != null);
        assert (cacheConfig.cache != null);
        assert (cacheConfig.drss.getMessageBrokerDomainName() != null);
        assert (!cacheConfig.drss.getMessageBrokerDomainName().equals(""));
        assert (cacheConfig.enableCacheReplication);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initNotificationServiceInstance() name=" + cacheConfig.cacheName + " enableReplication=" + cacheConfig.enableCacheReplication);
        }
        DRSMessageListener dRSMessageListener = null;
        if (cacheConfig.enableCacheReplication && cacheConfig.isDefaultCacheProvider()) {
            MultibrokerDomain multibrokerDomain = null;
            try {
                multibrokerDomain = (MultibrokerDomain)super.getService(MultibrokerDomain.class);
                dRSMessageListener = new DRSMessageListener(this.cacheUnit, cacheConfig.cache);
                notificationService.setDRSMessageListener(dRSMessageListener);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("Configure DRS Controller Instance", "Dynacache DRS Controller Instance");
                hashMap.put("MISC_PARM_SUPPRESS_IMPLICIT_ANNOUNCE", true);
                DRSDataXfer dRSDataXfer = multibrokerDomain.createInstance(cacheConfig.cacheName, dRSMessageListener, (DRSBootstrap)((Object)notificationService), cacheConfig.drss, null, hashMap);
                notificationService.setDDX(dRSDataXfer);
            }
            finally {
                super.releaseService(multibrokerDomain);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initNotificationServiceInstance() DRSMessageListener=" + dRSMessageListener);
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start() baseCacheConfig.enableCacheReplication=" + this.baseCacheConfig.enableCacheReplication);
        }
        try {
            this.setClassLoader();
            if (CacheProviderLoaderImpl.loadAndStartCacheProviders()) {
                this.providerLoader.loadCacheProviders();
            }
            if (this.baseCacheConfig.enableCacheReplication) {
                this._drsNotifSvc = new DRSNotificationService();
            }
            ServerCache.cacheService = this;
            this.cacheUnit = new CacheUnitImpl(this);
            ServerCache.cache = this.cache = this.cacheUnit.getCache();
            ServerCache.commandCache = this.commandCache = this.cacheUnit.getCommandCache();
            ServerCache.jspCache = this.jspCache = this.cacheUnit.getJSPCache();
            ServerCache.cacheUnit = this.cacheUnit;
            if (this.baseCacheConfig.enableCacheReplication) {
                this.initNotificationServiceInstance(this._drsNotifSvc, this.baseCacheConfig);
            }
            ConfigManager.setPropertiesDirectory(this.baseCacheConfig.dtdDir);
            this.configManager = ConfigManager.getInstance();
            this.configManager.setReloadInterval(this.baseCacheConfig.configReloadInterval);
            this.configManager.loadConfig(this.baseCacheConfig.propertiesDir + "cachespec.xml", false, false, null, null);
            ApplicationMgr applicationMgr = (ApplicationMgr)super.getService(ApplicationMgr.class);
            if (this.isApplicationServerAvailable()) {
                applicationMgr.addDeployedObjectListener(this);
                super.releaseService(applicationMgr);
            }
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(this, "DynaCache");
            mBeanFactory.activateMBean("DynaCache", defaultRuntimeCollaborator, mBeanFactory.getConfigId("WebSphere Dynamic Cache"), null);
            this.cacheEnabled = true;
            ServerCache.cacheEnabled = true;
            assert (this.baseCacheConfig.cacheName == "baseCache");
            this.bindInstanceToJNDI("services/cache/basecache");
            this.bindInstanceToJNDI("services/cache/distributedmap");
            this.initializeDistributedMap(this.getClass().getClassLoader(), DISTRIBUTED_MAP_PROPERTIES);
            this.initializeDistributedMap(this.getClass().getClassLoader(), CACHE_INSTANCES_PROPERTIES);
            Tr.info(tc, "DYNA0048I");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "start() Dynamic Caching initialized");
            }
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.cache.ServerCache.start", "227", this);
            this.cacheEnabled = false;
            Tr.error(tc, "dynacache.cacheInitFailed", new Object[]{this.baseCacheConfig.serverNameFQ, adminException.getMessage()});
            adminException.printStackTrace();
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.cache.CacheServiceImpl.start", "232", this);
            this.cacheEnabled = false;
            Tr.error(tc, "dynacache.cacheInitFailed", new Object[]{this.baseCacheConfig.serverNameFQ, illegalStateException.getMessage()});
            illegalStateException.printStackTrace();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheServiceImpl.start", "237", this);
            this.cacheEnabled = false;
            Tr.error(tc, "dynacache.cacheInitFailed", new Object[]{this.baseCacheConfig.serverNameFQ, throwable.getMessage()});
            throwable.printStackTrace();
        }
        this.serviceStarted = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start() cacheEnabled=" + this.cacheEnabled);
        }
    }

    public void stop() {
        Object object;
        Map map;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop()");
        }
        if (this.cache != null) {
            this.cache.stop();
        }
        if ((map = ServerCache.getCacheInstances()) != null) {
            object = map.values().iterator();
            while (object.hasNext()) {
                ((DCache)object.next()).stop();
            }
        }
        object = new HashMap(this.wccmCacheConfigs);
        for (WCCMCacheConfig wCCMCacheConfig : object.values()) {
            this.destroyCacheInstance(wCCMCacheConfig.cacheName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop()");
        }
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged() Type=" + deployedObjectEvent.getPropertyName() + " Value=" + deployedObjectEvent.getNewValue());
        }
        DeployedObject deployedObject = deployedObjectEvent.getDeployedObject();
        if (deployedObjectEvent.getPropertyName().equals("state")) {
            ModuleFile moduleFile;
            if (deployedObjectEvent.getNewValue().equals("STARTING")) {
                ModuleFile moduleFile2 = deployedObject.getModuleFile();
                String string = moduleFile2.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stateChanged() appName=" + string + " isWARFile=" + moduleFile2.isWARFile() + " isEJBJarFile=" + moduleFile2.isEJBJarFile() + " isRARFile=" + moduleFile2.isRARFile());
                }
                if (moduleFile2.isWARFile()) {
                    try {
                        this.initializeDistributedMap(deployedObject.getClassLoader(), DISTRIBUTED_MAP_PROPERTIES);
                        this.initializeDistributedMap(deployedObject.getClassLoader(), CACHE_INSTANCES_PROPERTIES);
                        String string2 = moduleFile2.getAbsolutePath();
                        DeployedModule deployedModule = (DeployedModule)deployedObject;
                        ModuleDeployment moduleDeployment = deployedModule.getModuleDeployment();
                        WebModule webModule = (WebModule)((EARFile)deployedModule.getDeployedApplication().getModuleFile()).getModule(moduleDeployment.getUri(), moduleDeployment.getAltDD());
                        String string3 = webModule.getContextRoot();
                        if (!string3.startsWith("/")) {
                            string3 = "/" + string3;
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("servlet", string3);
                        hashMap.put("static", string3);
                        hashMap.put("webservice", string3);
                        hashMap.put("portlet", string3);
                        this.configManager.loadConfig(string2, true, true, string, hashMap);
                        ServletCacheConfig.getInstance().moduleStarting((DeployedModule)deployedObject);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheServiceImpl.stateChanged", "270", this);
                    }
                } else if (moduleFile2.isEJBJarFile()) {
                    try {
                        this.initializeDistributedMap(deployedObject.getClassLoader(), DISTRIBUTED_MAP_PROPERTIES);
                        this.initializeDistributedMap(deployedObject.getClassLoader(), CACHE_INSTANCES_PROPERTIES);
                        String string4 = moduleFile2.getAbsolutePath();
                        HashMap hashMap = new HashMap();
                        this.configManager.loadEJBJarConfig(string4, string, hashMap);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheServiceImpl.stateChanged", "274", this);
                    }
                } else {
                    try {
                        String string5 = moduleFile2.getBinariesPath();
                        HashMap hashMap = new HashMap();
                        this.configManager.loadConfig(string5, false, true, string, hashMap);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheServiceImpl.stateChanged", "274", this);
                    }
                }
            } else if (deployedObjectEvent.getNewValue().equals("STOPPING") && (moduleFile = deployedObject.getModuleFile()).isEJBJarFile()) {
                String string = moduleFile.getName();
                String string6 = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stateChanged()unloadEJBJarConfig from appName=" + string);
                }
                try {
                    string6 = moduleFile.getAbsolutePath();
                    this.configManager.unloadEJBJarConfig(string6);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FFDCFilter.processException((Throwable)fileNotFoundException, "com.ibm.ws.cache.CacheServiceImpl.stateChanged", "1039", this);
                    Tr.debug(tc, "Could NOT unload " + string6 + " from " + string);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged()");
        }
    }

    private void initializeDistributedMap(ClassLoader classLoader, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeDistributedMap() classLoader=" + classLoader);
        }
        try {
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                if (this.processedUrls.contains(uRL)) continue;
                this.processConfigUrl(uRL);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.CacheServiceImpl.initializeDistributedMap", "880", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeDistributedMap()");
        }
    }

    public void setClassLoader() {
        ApplicationServer applicationServer = (ApplicationServer)super.getService(ApplicationServer.class);
        if (this.isApplicationServerAvailable()) {
            ServerCache.setClassLoader(applicationServer.getClassLoader());
            super.releaseService(applicationServer);
        } else {
            ServerCache.setClassLoader(Thread.currentThread().getContextClassLoader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConfigUrl(URL uRL) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processConfigUrl() configUrl=" + uRL);
        }
        this.processedUrls.add(uRL);
        InputStream inputStream = uRL.openStream();
        Properties properties = new Properties();
        properties.load(inputStream);
        inputStream.close();
        int n = 0;
        VariableMap variableMap = (VariableMap)super.getService(VariableMap.class);
        try {
            boolean bl = false;
            do {
                String string;
                String string2;
                if ((string2 = properties.getProperty(string = "cache.instance." + n)) != null && string2.charAt(0) == '/') {
                    string2 = string2.substring(1);
                }
                if (string2 != null) {
                    Object object;
                    Object object2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processConfigUrl() Adding new cache instance. instanceName=" + string2);
                    }
                    bl = true;
                    Iterator<Object> iterator = properties.keySet().iterator();
                    Properties properties2 = new Properties();
                    properties2.put("com.ibm.ws.cache.CacheConfig.cacheName", string2);
                    while (iterator.hasNext()) {
                        object2 = (String)iterator.next();
                        if (!((String)object2).startsWith(string + ".")) continue;
                        object = variableMap.expand(properties.getProperty((String)object2)).trim();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "processConfigUrl() Adding property: " + (String)object2 + " value:" + (String)object);
                        }
                        properties2.put("com.ibm.ws.cache.CacheConfig" + ((String)object2).substring(string.length()), object);
                        String string3 = ((String)object2).substring(string.length() + 1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "processConfigUrl() Adding property: " + string3 + " value:" + (String)object);
                        }
                        properties2.put(string3, object);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processConfigUrl() Final props=" + properties2);
                    }
                    if ((object2 = ServerCache.getCache(string2)) == null && this.getCacheInstanceConfig(string2) == null) {
                        object = this.addCacheInstanceConfig(properties2);
                        assert (string2 == ((WCCMCacheConfig)object).cacheName);
                        this.bindInstanceToJNDI(string2);
                    } else if (tc.isWarningEnabled()) {
                        Tr.warning(tc, "Cache instance " + string2 + " is not added because a cache with this name already exists.");
                    }
                } else {
                    bl = false;
                }
                ++n;
            } while (bl);
        }
        finally {
            super.releaseService(variableMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processConfigUrl() configUrl=" + uRL);
        }
    }

    public int getCacheSize() {
        return this.mbeans.getCacheSize(this.baseCacheConfig);
    }

    public int getUsedCacheSize() {
        return this.mbeans.getUsedCacheSize(this.cache);
    }

    public boolean getDiskOverflow() {
        return this.mbeans.getDiskOverflow(this.baseCacheConfig);
    }

    public String[] getCacheStatisticNames() {
        return this.mbeans.getCacheStatisticNames(this.cache);
    }

    public String[] getCacheStatisticNames(String string) {
        return this.mbeans.getCacheStatisticNames(string);
    }

    public String[] getCacheInstanceNames() {
        return this.mbeans.getCacheInstanceNames(this.cache);
    }

    public String[] getAllCacheStatistics() {
        return this.mbeans.getAllCacheStatistics(this.cache);
    }

    public String[] getAllCacheStatistics(String string) throws AttributeNotFoundException {
        return this.mbeans.getAllCacheStatistics(string);
    }

    public String[] getCacheStatistics(String[] stringArray) throws AttributeNotFoundException {
        return this.mbeans.getCacheStatistics(stringArray, this.cache);
    }

    public String[] getCacheStatistics(String string, String[] stringArray) throws AttributeNotFoundException {
        return this.mbeans.getCacheStatistics(string, stringArray);
    }

    public String[] getCacheIDsInMemory(String string, String string2) throws AttributeNotFoundException {
        return this.mbeans.getCacheIDsInMemory(string, string2);
    }

    public String[] getCacheIDsOnDisk(String string, String string2) throws AttributeNotFoundException {
        return this.mbeans.getCacheIDsOnDisk(string, string2);
    }

    public String[] invalidateCacheIDs(String string, String string2, boolean bl) throws AttributeNotFoundException {
        return this.mbeans.invalidateCacheIDs(string, string2, bl);
    }

    public String getCacheEntry(String string, String string2) throws AttributeNotFoundException {
        return this.mbeans.getCacheEntry(string, string2);
    }

    public void clearCache(String string) throws AttributeNotFoundException {
        this.mbeans.clearCache(string);
    }

    public DCache getCache() {
        return this.cache;
    }

    public CommandCache getCommandCache() {
        return this.commandCache;
    }

    public JSPCache getJSPCache() {
        return this.jspCache;
    }

    public CachePerf getCachePerf() {
        throw new RuntimeException("Unsupported function - contact DynaCache support");
    }

    public CacheConfig getBaseCacheConfig() {
        return this.baseCacheConfig;
    }

    public CacheConfig getCommonCacheConfig() {
        return this.commonCacheConfig;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ArrayList getServletCacheInstanceNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("baseCache");
        if (this.wccmCacheConfigs != null) {
            for (String string : this.wccmCacheConfigs.keySet()) {
                WCCMCacheConfig wCCMCacheConfig = (WCCMCacheConfig)this.wccmCacheConfigs.get(string);
                if (!wCCMCacheConfig.enableServletSupport || string.equalsIgnoreCase("services/cache/basecache")) continue;
                arrayList.add(string);
            }
        }
        this.getCacheInstanceInfo();
        return arrayList;
    }

    public CacheInstanceInfo[] getCacheInstanceInfo() {
        CacheInstanceInfo[] cacheInstanceInfoArray = CacheInstanceInfo.getCacheInstanceInfo(this);
        return cacheInstanceInfoArray;
    }

    protected void populateCacheInstanceInfo(CacheInstanceInfo cacheInstanceInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "populateCacheInstanceInfo()");
        }
        if (this.wccmCacheConfigs != null) {
            for (String string : this.wccmCacheConfigs.keySet()) {
                WCCMCacheConfig wCCMCacheConfig = (WCCMCacheConfig)this.wccmCacheConfigs.get(string);
                CacheInstanceInfo.allConfigured.add(string);
                if (wCCMCacheConfig.configSource == 7 || wCCMCacheConfig.configSource == 8) {
                    CacheInstanceInfo.allFactory.add(string);
                }
                if (wCCMCacheConfig.configSource == 5 || wCCMCacheConfig.configSource == 6) {
                    CacheInstanceInfo.allFile.add(string);
                }
                if (wCCMCacheConfig.cache != null) {
                    CacheInstanceInfo.allActive.add(string);
                }
                if (wCCMCacheConfig.enableServletSupport) {
                    CacheInstanceInfo.servletConfigured.add(string);
                    continue;
                }
                CacheInstanceInfo.objectConfigured.add(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "populateCacheInstanceInfo()");
        }
    }

    private synchronized void bindInstanceToJNDI(String string) {
        boolean bl;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "bindInstanceToJNDI() instanceName=" + string);
            }
            bl = true;
            String string2 = "config";
            byte[] byArray = null;
            BinaryRefAddr binaryRefAddr = null;
            CacheableReference cacheableReference = null;
            try {
                byArray = SerializationUtility.serialize((Serializable)((Object)string));
                binaryRefAddr = new BinaryRefAddr(string2, byArray);
                cacheableReference = new CacheableReference("com.ibm.websphere.cache.DistributedObjectCache", binaryRefAddr, "com.ibm.wsspi.cache.CacheInstanceResourceBinder", null);
                JndiHelper.recursiveBind((Context)new InitialContext(), string, (Object)cacheableReference);
                bl = false;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "bindInstanceToJNDI() ERROR - Could not create binding object. Platform isZOS=" + this.environment.isZOS, new Object[]{exception});
                    exception.printStackTrace();
                }
                if (this.environment.isZOS && exception instanceof NameAlreadyBoundException) break block5;
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheServiceImpl.bindInstanceToJNDI", "1276", this);
                Tr.error(tc, "DYNA1003E", new Object[]{string, exception});
                cacheService.destroyCacheInstance(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindInstanceToJNDI() isBindFailure=" + bl);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        state = (String)propertyChangeEvent.getNewValue();
    }

    private boolean isApplicationServerAvailable() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isApplicationServerAvailable");
        }
        boolean bl2 = PlatformHelperFactory.getPlatformHelper().isZOS();
        boolean bl3 = PlatformHelperFactory.getPlatformHelper().isControlJvm();
        boolean bl4 = bl = !bl2 || !bl3;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isApplicationServerAvailable", new Boolean(bl));
        }
        return bl;
    }

    private boolean isProxyServerOnZOS() {
        boolean bl = PlatformHelperFactory.getPlatformHelper().isZOS();
        boolean bl2 = PlatformHelperFactory.getPlatformHelper().isControlJvm();
        String string = AdminServiceFactory.getAdminService().getServerType();
        boolean bl3 = bl && bl2 && ("PROXY_SERVER".equals(string) || "ONDEMAND_ROUTER".equals(string));
        return bl3;
    }

    private boolean isProxyServerServantRegionOnZOS() {
        boolean bl = PlatformHelperFactory.getPlatformHelper().isZOS();
        boolean bl2 = PlatformHelperFactory.getPlatformHelper().isServantJvm();
        String string = AdminServiceFactory.getAdminService().getServerType();
        boolean bl3 = bl && bl2 && ("PROXY_SERVER".equals(string) || "ONDEMAND_ROUTER".equals(string));
        return bl3;
    }

    public CacheProvider getCacheProvider(String string) {
        if (!this.providerLoader.hasStarted()) {
            this.providerLoader.startCacheProviders();
        }
        return this.providerLoader.getCacheProvider(string);
    }
}

