/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.intf.CacheStatisticsListener;

public class CacheStatisticsListenerImpl
implements CacheStatisticsListener {
    private static TraceComponent tc = Trace.register(CacheStatisticsListenerImpl.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private long cacheHits = 0L;
    private long cacheMisses = 0L;
    private long memoryCacheHits = 0L;
    private long diskCacheHits = 0L;
    private long cacheRemoves = 0L;
    private long cacheLruRemoves = 0L;
    private long overflowEntriesFromMemory = 0L;
    private long explicitInvalidationsFromMemory = 0L;
    private long explicitInvalidationsFromDisk = 0L;
    private long explicitInvalidationsLocal = 0L;
    private long explicitInvalidationsRemote = 0L;
    private long timeoutInvalidationsFromMemory = 0L;
    private long timeoutInvalidationsFromDisk = 0L;
    private long garbageCollectorInvalidationsFromDisk = 0L;
    private long overflowInvalidationsFromDisk = 0L;
    private long depIdsOffloadedToDisk = 0L;
    private long depIdBasedInvalidationsFromDisk = 0L;
    private long templatesOffloadedToDisk = 0L;
    private long templateBasedInvalidationsFromDisk = 0L;
    private long objectsReadFromDisk = 0L;
    private long objectsReadFromDisk4K = 0L;
    private long objectsReadFromDisk40K = 0L;
    private long objectsReadFromDisk400K = 0L;
    private long objectsReadFromDisk4000K = 0L;
    private long objectsReadFromDiskSize = 0L;
    private long objectsWriteToDisk = 0L;
    private long objectsWriteToDisk4K = 0L;
    private long objectsWriteToDisk40K = 0L;
    private long objectsWriteToDisk400K = 0L;
    private long objectsWriteToDisk4000K = 0L;
    private long objectsWriteToDiskSize = 0L;
    private long objectsDeleteFromDisk = 0L;
    private long objectsDeleteFromDisk4K = 0L;
    private long objectsDeleteFromDisk40K = 0L;
    private long objectsDeleteFromDisk400K = 0L;
    private long objectsDeleteFromDisk4000K = 0L;
    private long objectsDeleteFromDiskSize = 0L;
    private long remoteInvalidationNotifications = 0L;
    private long remoteUpdateNotifications = 0L;
    private long remoteObjectUpdates = 0L;
    private long remoteObjectUpdateSize = 0L;
    private long remoteObjectHits = 0L;
    private long remoteObjectFetchSize = 0L;
    private long remoteObjectMisses = 0L;
    private long objectsAsyncLruToDisk = 0L;
    private Object diskReadMonitor = new Object();
    private String cacheName;

    public CacheStatisticsListenerImpl(String string) {
        this.cacheName = string;
    }

    public final void localCacheHit(Object object, int n) {
        ++this.cacheHits;
        if (n == 1) {
            ++this.memoryCacheHits;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.cacheName + ": Cache Hit: " + object + " memoryCacheHits=" + this.memoryCacheHits + " cacheHits=" + this.cacheHits);
            }
        } else {
            ++this.diskCacheHits;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.cacheName + ": Cache Hit: " + object + " diskCacheHits=" + this.diskCacheHits + " cacheHits=" + this.cacheHits);
            }
        }
    }

    public final void cacheMiss(Object object) {
        ++this.cacheMisses;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": Cache Miss: id=" + object + " cacheMisses=" + this.cacheMisses);
        }
    }

    public void start() {
    }

    public final void remove(Object object, int n, int n2, int n3) {
        switch (n) {
            case 1: {
                ++this.cacheRemoves;
                if (n2 == 3) {
                    ++this.explicitInvalidationsFromDisk;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this.cacheName + " Remove id=" + object + " explicitInvalidationsFromDisk=" + this.explicitInvalidationsFromDisk);
                    }
                } else {
                    ++this.explicitInvalidationsFromMemory;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this.cacheName + " Remove id=" + object + " explicitInvalidationsFromMemory=" + this.explicitInvalidationsFromMemory);
                    }
                }
                if (n3 == 2) {
                    ++this.explicitInvalidationsRemote;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, this.cacheName + " Remove id=" + object + " explicitInvalidationsRemote=" + this.explicitInvalidationsRemote);
                    break;
                }
                ++this.explicitInvalidationsLocal;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, this.cacheName + " Remove id=" + object + " explicitInvalidationsLocal=" + this.explicitInvalidationsLocal);
                break;
            }
            case 2: {
                ++this.cacheLruRemoves;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, this.cacheName + " Remove id=" + object + " cacheLruRemoves=" + this.cacheLruRemoves);
                break;
            }
            case 3: {
                ++this.cacheRemoves;
                if (n2 == 3) {
                    ++this.timeoutInvalidationsFromDisk;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, this.cacheName + " Remove id=" + object + " timeoutInvalidationsFromDisk=" + this.timeoutInvalidationsFromDisk);
                    break;
                }
                ++this.timeoutInvalidationsFromMemory;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, this.cacheName + " Remove id=" + object + " timeoutInvalidationsFromMemory=" + this.timeoutInvalidationsFromMemory);
                break;
            }
            case 7: {
                ++this.garbageCollectorInvalidationsFromDisk;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, this.cacheName + " Remove id=" + object + " garbageCollectorInvalidationsFromDisk=" + this.garbageCollectorInvalidationsFromDisk);
                break;
            }
            case 8: {
                ++this.overflowInvalidationsFromDisk;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, this.cacheName + " Remove id=" + object + " overflowInvalidationsFromDisk=" + this.overflowInvalidationsFromDisk);
            }
        }
    }

    public final void depIdsOffloadedToDisk(Object object) {
        ++this.depIdsOffloadedToDisk;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": dependency ID offload to disk  did=" + object + " depIdsOffloadedToDisk=" + this.depIdsOffloadedToDisk);
        }
    }

    public final void depIdBasedInvalidationsFromDisk(Object object) {
        ++this.depIdBasedInvalidationsFromDisk;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": dependency ID based invalidation  did=" + object + " depIdBasedInvalidationsFromDisk=" + this.depIdBasedInvalidationsFromDisk);
        }
    }

    public final void templatesOffloadedToDisk(Object object) {
        ++this.templatesOffloadedToDisk;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": template offload to disk template=" + object + " templatesOffloadedToDisk=" + this.templatesOffloadedToDisk);
        }
    }

    public final void templateBasedInvalidationsFromDisk(Object object) {
        ++this.templateBasedInvalidationsFromDisk;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": template based invalidation  template=" + object + " templateBasedInvalidationsFromDisk=" + this.templateBasedInvalidationsFromDisk);
        }
    }

    public final void remoteInvalidationNotifications(Object object) {
        ++this.remoteInvalidationNotifications;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": remote invalidation notification id=" + object + " remoteInvalidationNotifications=" + this.remoteInvalidationNotifications);
        }
    }

    public final void remoteUpdateNotifications(Object object) {
        ++this.remoteUpdateNotifications;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": remote update notification id=" + object + " remoteUpdateNotifications=" + this.remoteUpdateNotifications);
        }
    }

    public final void remoteUpdateNotifications(int n) {
        this.remoteUpdateNotifications += (long)n;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": remote update notification numNotifications=" + n + " remoteUpdateNotifications=" + this.remoteUpdateNotifications);
        }
    }

    public final void remoteObjectUpdates(Object object, int n) {
        ++this.remoteObjectUpdates;
        this.remoteObjectUpdateSize += (long)n;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": remote object update id=" + object + " valueSize=" + n + " remoteObjectUpdates=" + this.remoteObjectUpdates + " remoteObjectUpdateSize=" + this.remoteObjectUpdateSize);
        }
    }

    public final void remoteObjectHits(Object object, int n) {
        ++this.cacheHits;
        ++this.remoteObjectHits;
        this.remoteObjectFetchSize += (long)n;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": remote object hit id=" + object + " valueSize=" + n + " cacheHits=" + this.cacheHits + " remoteObjectHits=" + this.remoteObjectHits + " remoteObjectFetchSize=" + this.remoteObjectFetchSize);
        }
    }

    public final void remoteObjectMisses(Object object) {
        ++this.cacheMisses;
        ++this.remoteObjectMisses;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": remote object miss id=" + object + " cacheMisses=" + this.cacheMisses + " remoteObjectMisses=" + this.remoteObjectMisses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readEntryFromDisk(Object object, int n) {
        Object object2 = this.diskReadMonitor;
        synchronized (object2) {
            ++this.objectsReadFromDisk;
            this.objectsReadFromDiskSize += (long)n;
            if (n <= 4000) {
                ++this.objectsReadFromDisk4K;
            } else if (n <= 40000) {
                ++this.objectsReadFromDisk40K;
            } else if (n <= 400000) {
                ++this.objectsReadFromDisk400K;
            } else if (n <= 4000000) {
                ++this.objectsReadFromDisk4000K;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": read entry from disk id=" + object + " valueSize=" + n + " objectsReadFromDisk=" + this.objectsReadFromDisk + " objectsReadFromDiskSize" + this.objectsReadFromDiskSize);
        }
    }

    public final void writeEntryToDisk(Object object, int n) {
        ++this.objectsWriteToDisk;
        this.objectsWriteToDiskSize += (long)n;
        if (n <= 4000) {
            ++this.objectsWriteToDisk4K;
        } else if (n <= 40000) {
            ++this.objectsWriteToDisk40K;
        } else if (n <= 400000) {
            ++this.objectsWriteToDisk400K;
        } else if (n <= 4000000) {
            ++this.objectsWriteToDisk4000K;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": write entry to disk id=" + object + " valueSize=" + n + " objectsWriteToDisk=" + this.objectsWriteToDisk + " objectsWriteToDiskSize=" + this.objectsWriteToDiskSize);
        }
    }

    public final void deleteEntryFromDisk(Object object, int n) {
        ++this.objectsDeleteFromDisk;
        this.objectsDeleteFromDiskSize += (long)n;
        if (n <= 4000) {
            ++this.objectsDeleteFromDisk4K;
        } else if (n <= 40000) {
            ++this.objectsDeleteFromDisk40K;
        } else if (n <= 400000) {
            ++this.objectsDeleteFromDisk400K;
        } else if (n <= 4000000) {
            ++this.objectsDeleteFromDisk4000K;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": delete entry from disk id=" + object + " valueSize=" + n + " objectsDeleteFromDisk=" + this.objectsDeleteFromDisk + " objectsDeleteFromDiskSize=" + this.objectsDeleteFromDiskSize);
        }
    }

    public final void objectsAsyncLruToDisk() {
        ++this.objectsAsyncLruToDisk;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": objectsAsyncLruToDisk=" + this.objectsAsyncLruToDisk);
        }
    }

    public final void overflowEntriesFromMemory() {
        ++this.overflowEntriesFromMemory;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + ": overflowEntriesFromMemory=" + this.overflowEntriesFromMemory);
        }
    }

    public final void reset() {
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.cacheRemoves = 0L;
        this.cacheLruRemoves = 0L;
        this.overflowEntriesFromMemory = 0L;
        this.memoryCacheHits = 0L;
        this.diskCacheHits = 0L;
        this.explicitInvalidationsFromMemory = 0L;
        this.explicitInvalidationsFromDisk = 0L;
        this.explicitInvalidationsLocal = 0L;
        this.explicitInvalidationsRemote = 0L;
        this.timeoutInvalidationsFromMemory = 0L;
        this.timeoutInvalidationsFromDisk = 0L;
        this.garbageCollectorInvalidationsFromDisk = 0L;
        this.overflowInvalidationsFromDisk = 0L;
        this.depIdsOffloadedToDisk = 0L;
        this.depIdBasedInvalidationsFromDisk = 0L;
        this.templatesOffloadedToDisk = 0L;
        this.templateBasedInvalidationsFromDisk = 0L;
        this.objectsReadFromDisk = 0L;
        this.objectsReadFromDisk4K = 0L;
        this.objectsReadFromDisk40K = 0L;
        this.objectsReadFromDisk400K = 0L;
        this.objectsReadFromDisk4000K = 0L;
        this.objectsReadFromDiskSize = 0L;
        this.objectsWriteToDisk = 0L;
        this.objectsWriteToDisk4K = 0L;
        this.objectsWriteToDisk40K = 0L;
        this.objectsWriteToDisk400K = 0L;
        this.objectsWriteToDisk4000K = 0L;
        this.objectsWriteToDiskSize = 0L;
        this.objectsDeleteFromDisk = 0L;
        this.objectsDeleteFromDisk4K = 0L;
        this.objectsDeleteFromDisk40K = 0L;
        this.objectsDeleteFromDisk400K = 0L;
        this.objectsDeleteFromDisk4000K = 0L;
        this.objectsDeleteFromDiskSize = 0L;
        this.remoteInvalidationNotifications = 0L;
        this.remoteUpdateNotifications = 0L;
        this.remoteObjectUpdates = 0L;
        this.remoteObjectUpdateSize = 0L;
        this.remoteObjectHits = 0L;
        this.remoteObjectFetchSize = 0L;
        this.remoteObjectMisses = 0L;
        this.objectsAsyncLruToDisk = 0L;
    }

    public final void resetMemory() {
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.cacheRemoves = 0L;
        this.cacheLruRemoves = 0L;
        this.overflowEntriesFromMemory = 0L;
        this.memoryCacheHits = 0L;
        this.explicitInvalidationsFromMemory = 0L;
        this.explicitInvalidationsLocal = 0L;
        this.explicitInvalidationsRemote = 0L;
        this.timeoutInvalidationsFromMemory = 0L;
        this.remoteInvalidationNotifications = 0L;
        this.remoteUpdateNotifications = 0L;
        this.remoteObjectUpdates = 0L;
        this.remoteObjectUpdateSize = 0L;
        this.remoteObjectHits = 0L;
        this.remoteObjectFetchSize = 0L;
        this.remoteObjectMisses = 0L;
    }

    public final void resetDisk() {
        this.diskCacheHits = 0L;
        this.explicitInvalidationsFromDisk = 0L;
        this.timeoutInvalidationsFromDisk = 0L;
        this.garbageCollectorInvalidationsFromDisk = 0L;
        this.overflowInvalidationsFromDisk = 0L;
        this.depIdsOffloadedToDisk = 0L;
        this.depIdBasedInvalidationsFromDisk = 0L;
        this.templatesOffloadedToDisk = 0L;
        this.templateBasedInvalidationsFromDisk = 0L;
        this.objectsReadFromDisk = 0L;
        this.objectsReadFromDisk4K = 0L;
        this.objectsReadFromDisk40K = 0L;
        this.objectsReadFromDisk400K = 0L;
        this.objectsReadFromDisk4000K = 0L;
        this.objectsReadFromDiskSize = 0L;
        this.objectsWriteToDisk = 0L;
        this.objectsWriteToDisk4K = 0L;
        this.objectsWriteToDisk40K = 0L;
        this.objectsWriteToDisk400K = 0L;
        this.objectsWriteToDisk4000K = 0L;
        this.objectsWriteToDiskSize = 0L;
        this.objectsDeleteFromDisk = 0L;
        this.objectsDeleteFromDisk4K = 0L;
        this.objectsDeleteFromDisk40K = 0L;
        this.objectsDeleteFromDisk400K = 0L;
        this.objectsDeleteFromDisk4000K = 0L;
        this.objectsDeleteFromDiskSize = 0L;
        this.objectsAsyncLruToDisk = 0L;
    }

    public long getCacheHitsCount() {
        return this.cacheHits;
    }

    public long getCacheLruRemovesCount() {
        return this.cacheLruRemoves;
    }

    public long getCacheMissesCount() {
        return this.cacheMisses;
    }

    public long getCacheRemovesCount() {
        return this.cacheRemoves;
    }

    public long getDepIdBasedInvalidationsFromDiskCount() {
        return this.depIdBasedInvalidationsFromDisk;
    }

    public long getDepIdsOffloadedToDiskCount() {
        return this.depIdsOffloadedToDisk;
    }

    public long getDiskCacheHitsCount() {
        return this.diskCacheHits;
    }

    public long getExplicitInvalidationsFromDiskCount() {
        return this.explicitInvalidationsFromDisk;
    }

    public long getExplicitInvalidationsFromMemoryCount() {
        return this.explicitInvalidationsFromMemory;
    }

    public long getExplicitInvalidationsLocalCount() {
        return this.explicitInvalidationsLocal;
    }

    public long getExplicitInvalidationsRemoteCount() {
        return this.explicitInvalidationsRemote;
    }

    public long getGarbageCollectorInvalidationsFromDiskCount() {
        return this.garbageCollectorInvalidationsFromDisk;
    }

    public long getMemoryCacheHitsCount() {
        return this.memoryCacheHits;
    }

    public long getObjectsAsyncLruToDiskCount() {
        return this.objectsAsyncLruToDisk;
    }

    public long getObjectsDeleteFromDiskCount() {
        return this.objectsDeleteFromDisk;
    }

    public long getObjectsDeleteFromDisk4000KCount() {
        return this.objectsDeleteFromDisk4000K;
    }

    public long getObjectsDeleteFromDisk400KCount() {
        return this.objectsDeleteFromDisk400K;
    }

    public long getObjectsDeleteFromDisk40KCount() {
        return this.objectsDeleteFromDisk40K;
    }

    public long getObjectsDeleteFromDisk4KCount() {
        return this.objectsDeleteFromDisk4K;
    }

    public long getObjectsDeleteFromDiskSizeCount() {
        return this.objectsDeleteFromDiskSize;
    }

    public long getObjectsReadFromDiskCount() {
        return this.objectsReadFromDisk;
    }

    public long getObjectsReadFromDisk4000KCount() {
        return this.objectsReadFromDisk4000K;
    }

    public long getObjectsReadFromDisk400KCount() {
        return this.objectsReadFromDisk400K;
    }

    public long getObjectsReadFromDisk40KCount() {
        return this.objectsReadFromDisk40K;
    }

    public long getObjectsReadFromDisk4KCount() {
        return this.objectsReadFromDisk4K;
    }

    public long getObjectsReadFromDiskSizeCount() {
        return this.objectsReadFromDiskSize;
    }

    public long getObjectsWriteToDiskCount() {
        return this.objectsWriteToDisk;
    }

    public long getObjectsWriteToDisk4000KCount() {
        return this.objectsWriteToDisk4000K;
    }

    public long getObjectsWriteToDisk400KCount() {
        return this.objectsWriteToDisk400K;
    }

    public long getObjectsWriteToDisk40KCount() {
        return this.objectsWriteToDisk40K;
    }

    public long getObjectsWriteToDisk4KCount() {
        return this.objectsWriteToDisk4K;
    }

    public long getObjectsWriteToDiskSizeCount() {
        return this.objectsWriteToDiskSize;
    }

    public long getOverflowEntriesFromMemoryCount() {
        return this.overflowEntriesFromMemory;
    }

    public long getOverflowInvalidationsFromDiskCount() {
        return this.overflowInvalidationsFromDisk;
    }

    public long getRemoteInvalidationNotificationsCount() {
        return this.remoteInvalidationNotifications;
    }

    public long getRemoteObjectFetchSizeCount() {
        return this.remoteObjectFetchSize;
    }

    public long getRemoteObjectHitsCount() {
        return this.remoteObjectHits;
    }

    public long getRemoteObjectMissesCount() {
        return this.remoteObjectMisses;
    }

    public long getRemoteObjectUpdatesCount() {
        return this.remoteObjectUpdates;
    }

    public long getRemoteObjectUpdateSizeCount() {
        return this.remoteObjectUpdateSize;
    }

    public long getRemoteUpdateNotificationsCount() {
        return this.remoteUpdateNotifications;
    }

    public long getTemplateBasedInvalidationsFromDiskCount() {
        return this.templateBasedInvalidationsFromDisk;
    }

    public long getTemplatesOffloadedToDiskCount() {
        return this.templatesOffloadedToDisk;
    }

    public long getTimeoutInvalidationsFromDiskCount() {
        return this.timeoutInvalidationsFromDisk;
    }

    public long getTimeoutInvalidationsFromMemoryCount() {
        return this.timeoutInvalidationsFromMemory;
    }
}

