/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.command.CacheableCommand;
import com.ibm.websphere.command.CommandException;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.CacheUnit;
import com.ibm.ws.cache.ExternalCacheFragment;
import com.ibm.ws.cache.ExternalCacheGroup;
import com.ibm.ws.cache.ExternalCacheServices;
import com.ibm.ws.cache.InvalidationAuditDaemon;
import com.ibm.ws.cache.NotificationService;
import com.ibm.ws.cache.NullNotificationService;
import com.ibm.ws.cache.NullRemoteServices;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.TimeLimitDaemon;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.command.CommandCache;
import com.ibm.ws.cache.command.CommandStoragePolicy;
import com.ibm.ws.cache.drs.DRSRemoteServices;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CacheUnitImpl
implements CacheUnit {
    static TraceComponent tc = Trace.register(CacheUnitImpl.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private String uniqueCacheName = null;
    private DCache cache = null;
    private CommandCache commandCache = null;
    private ExternalCacheServices externalCacheServices = null;
    private CommandStoragePolicy commandStoragePolicy = null;
    private JSPCache jspCache = null;
    protected CacheConfig commonCacheConfig = null;
    protected BatchUpdateDaemon batchUpdateDaemon = null;
    protected InvalidationAuditDaemon invalidationAuditDaemon = null;
    protected NotificationService notificationService = null;
    protected RemoteServices remoteServices = null;
    protected TimeLimitDaemon timeLimitDaemon = null;

    public CacheUnitImpl(CacheService cacheService) throws RemoteException {
        this.initialize(cacheService);
    }

    public String getUniqueCacheName() {
        return this.uniqueCacheName;
    }

    public void batchUpdate(String string, HashMap hashMap, HashMap hashMap2, ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "batchUpdate():" + string);
        }
        this.invalidationAuditDaemon.registerInvalidations(string, hashMap.values().iterator());
        this.invalidationAuditDaemon.registerInvalidations(string, hashMap2.values().iterator());
        arrayList = this.invalidationAuditDaemon.filterEntryList(string, arrayList);
        DCache dCache = ServerCache.getCache(string);
        if (dCache != null) {
            dCache.batchUpdate(hashMap, hashMap2, arrayList);
            if (dCache.getCacheConfig().enableServletSupport) {
                this.externalCacheServices.invalidateExternalCaches(hashMap, hashMap2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "batchUpdate()");
        }
    }

    public CacheableCommand getCommand(CacheableCommand cacheableCommand, boolean bl) throws CommandException {
        return this.commandCache.getCommandLocally(cacheableCommand, bl);
    }

    public CacheEntry getEntry(String string, Object object, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEntry: {0}", object);
        }
        DCache dCache = this.getCache(string);
        CacheEntry cacheEntry = null;
        if (dCache != null) {
            cacheEntry = (CacheEntry)dCache.getEntry(object, 2, bl, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEntry: {0}", object);
        }
        return cacheEntry;
    }

    public void setEntry(String string, CacheEntry cacheEntry) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEntry: {0}", cacheEntry.id);
        }
        if ((cacheEntry = this.invalidationAuditDaemon.filterEntry(string, cacheEntry)) != null) {
            DCache dCache = this.getCache(string);
            dCache.setEntry(cacheEntry, 2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEntry: {0}", cacheEntry == null ? "null" : cacheEntry.id);
        }
    }

    public void setExternalCacheFragment(ExternalCacheFragment externalCacheFragment) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setExternalCacheFragment: {0}", externalCacheFragment.getUri());
        }
        if ((externalCacheFragment = this.invalidationAuditDaemon.filterExternalCacheFragment(this.cache.getCacheName(), externalCacheFragment)) != null) {
            this.batchUpdateDaemon.pushExternalCacheFragment(externalCacheFragment, this.cache);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setExternalCacheFragment: {0}", externalCacheFragment.getUri());
        }
    }

    public void addExternalCacheAdapter(String string, String string2, String string3) {
        this.externalCacheServices.addExternalCacheAdapter(string, string2, string3);
    }

    public void removeExternalCacheAdapter(String string, String string2) {
        this.externalCacheServices.removeExternalCacheAdapter(string, string2);
    }

    public DCache getCache() {
        return this.cache;
    }

    public DCache getCache(String string) {
        return ServerCache.getCache(string);
    }

    public CommandCache getCommandCache() {
        return this.commandCache;
    }

    public ExternalCacheServices getExternalCacheServices() {
        return this.externalCacheServices;
    }

    public CommandStoragePolicy getCommandStoragePolicy() {
        return this.commandStoragePolicy;
    }

    public JSPCache getJSPCache() {
        return this.jspCache;
    }

    private void initialize(CacheService cacheService) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.commonCacheConfig = cacheService.getCommonCacheConfig();
        CacheConfig cacheConfig = cacheService.getBaseCacheConfig();
        cacheConfig.determineCacheProvider();
        try {
            this.uniqueCacheName = cacheConfig.serverNameFQ;
            try {
                this.commandStoragePolicy = (CommandStoragePolicy)this.getClass().getClassLoader().loadClass(cacheConfig.commandStoragePolicyClassName).newInstance();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheUnitImpl.initialize", "488", this);
                throwable.printStackTrace();
                Tr.error(tc, "dynacache.configerror", throwable.getMessage());
                throw new IllegalArgumentException("commandStoragePolicy must fully specify a bean name for an object of type com.ibm.ws.cache.command.CommandStoragePolicy");
            }
            this.printDebug(cacheConfig);
            this.cache = cacheConfig.isDefaultCacheProvider() ? new Cache("baseCache", cacheConfig) : ServerCache.createCache("baseCache", cacheConfig);
            cacheConfig.cache = this.cache;
            this.commandCache = new CommandCache();
            this.jspCache = new JSPCache();
            this.externalCacheServices = new ExternalCacheServices();
            if (cacheConfig.isDefaultCacheProvider() && cacheConfig.notificationType.equalsIgnoreCase("DRS")) {
                this.notificationService = cacheService.getDRSNotificationService();
                this.remoteServices = new DRSRemoteServices();
            } else {
                this.remoteServices = new NullRemoteServices();
                this.notificationService = new NullNotificationService();
                ServerCache.setSharingPolicy(1);
            }
            this.timeLimitDaemon = new TimeLimitDaemon(cacheConfig.maxTimeLimitInSeconds, cacheConfig.timeGranularityInSeconds, this.getLruToDiskTriggerTime(cacheConfig));
            this.invalidationAuditDaemon = new InvalidationAuditDaemon(cacheConfig.timeHoldingInvalidations);
            this.batchUpdateDaemon = new BatchUpdateDaemon(cacheConfig.batchUpdateInterval);
            this.batchUpdateDaemon.setExternalCacheServices(this.externalCacheServices);
            this.batchUpdateDaemon.setInvalidationAuditDaemon(this.invalidationAuditDaemon);
            if (cacheConfig.isDefaultCacheProvider()) {
                this.cache.setBatchUpdateDaemon(this.batchUpdateDaemon);
                this.cache.setRemoteServices(this.remoteServices);
                this.cache.setTimeLimitDaemon(this.timeLimitDaemon);
            }
            this.commandCache.setBatchUpdateDaemon(this.batchUpdateDaemon);
            this.commandCache.setCache(this.cache);
            this.commandCache.setRemoteServices(this.remoteServices);
            this.commandCache.setDefaultPriority(cacheConfig.commandCachePriority);
            this.commandCache.setCommandStoragePolicy(this.commandStoragePolicy);
            this.jspCache.setBatchUpdateDaemon(this.batchUpdateDaemon);
            this.jspCache.setCache(this.cache);
            this.jspCache.setRemoteServices(this.remoteServices);
            this.jspCache.setDefaultPriority(cacheConfig.jspCachePriority);
            this.jspCache.setExternalCacheServices(this.externalCacheServices);
            this.remoteServices.setCacheUnit(this.uniqueCacheName, this);
            this.remoteServices.setNotificationService(this.notificationService);
            this.notificationService.setCacheStatisticsListener(this.cache.getCacheStatisticsListener());
            String string = AdminServiceFactory.getAdminService().getProcessType();
            if (!string.equals("DeploymentManager")) {
                HashMap hashMap = null;
                hashMap = this.initializeExternalCacheGroups(cacheConfig.externalGroups);
                this.externalCacheServices.setExternalCacheGroups(hashMap);
            }
            this.batchUpdateDaemon.start();
            if (cacheConfig.isDefaultCacheProvider()) {
                this.cache.start();
            }
            this.commandCache.start();
            this.externalCacheServices.start();
            this.jspCache.start();
            this.invalidationAuditDaemon.start();
            this.notificationService.setCacheName("baseCache");
            this.notificationService.start();
            this.remoteServices.setCacheName("baseCache");
            this.remoteServices.start();
            this.timeLimitDaemon.start();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Registering this cache unit with any other live cache units...");
            }
            this.notificationService.registerCacheUnit(this.uniqueCacheName, this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "succeeded");
            }
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.cache.CacheUnitImpl.initialize", "640", this);
            throw illegalStateException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.CacheUnitImpl.initialize", "644", this);
            Tr.error(tc, "dynacache.configerror", exception.getMessage());
            throw new IllegalStateException("Unexpected exception in Configuration.initializeDynacache method.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private void printDebug(CacheConfig cacheConfig) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing CacheUnit " + this.uniqueCacheName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "batchUpdateInterval set to " + cacheConfig.batchUpdateInterval);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "timeHoldingInvalidations set to " + cacheConfig.timeHoldingInvalidations);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cacheSprayerName set to " + cacheConfig.cacheSprayerName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "notificationType set to " + cacheConfig.notificationType);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cacheSize set to " + cacheConfig.cacheSize);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cachePriority set to " + cacheConfig.cachePriority);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jspCachePriority set to " + cacheConfig.jspCachePriority);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "commandCachePriority set to " + cacheConfig.commandCachePriority);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "commandStoragePolicy created from class " + cacheConfig.commandStoragePolicyClassName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "maxTimeLimitInSeconds set to " + cacheConfig.maxTimeLimitInSeconds);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "timeGranularityInSeconds set to " + cacheConfig.timeGranularityInSeconds);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "provider set to " + cacheConfig.cacheProviderName);
        }
    }

    private int getLruToDiskTriggerTime(CacheConfig cacheConfig) {
        int n = 5000;
        if (cacheConfig.lruToDiskTriggerTime > cacheConfig.timeGranularityInSeconds * 1000 || cacheConfig.lruToDiskTriggerTime < 1) {
            Tr.warning(tc, "DYNA0069W", new Object[]{new Integer(cacheConfig.lruToDiskTriggerTime), "lruToDiskTriggerTime", this.cache.getCacheName(), new Integer(1), new Integer(cacheConfig.timeGranularityInSeconds * 1000), new Integer(5000)});
        } else {
            n = cacheConfig.lruToDiskTriggerTime;
        }
        return n;
    }

    private HashMap initializeExternalCacheGroups(List list) {
        HashMap<String, ExternalCacheGroup> hashMap = new HashMap<String, ExternalCacheGroup>();
        if (list != null) {
            for (CacheConfig.ExternalCacheGroup externalCacheGroup : list) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ecg.name = " + externalCacheGroup.name);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ecg.type = " + externalCacheGroup.type);
                }
                ExternalCacheGroup externalCacheGroup2 = new ExternalCacheGroup(externalCacheGroup.name, externalCacheGroup.type);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding External Cache Group id = " + externalCacheGroup.name + ", externalCacheGroup = " + externalCacheGroup2);
                }
                hashMap.put(externalCacheGroup.name, externalCacheGroup2);
                for (CacheConfig.ExternalCacheGroupMember externalCacheGroupMember : externalCacheGroup.members) {
                    externalCacheGroup2.addExternalCacheAdapter(externalCacheGroupMember.address, externalCacheGroupMember.beanName);
                }
            }
        }
        return hashMap;
    }

    public CacheConfig getCacheConfig() {
        return this.commonCacheConfig;
    }

    public void addAlias(String string, Object object, Object[] objectArray) {
        block3: {
            DCache dCache;
            if (object != null && objectArray != null && (dCache = this.getCache(string)) != null) {
                try {
                    dCache.addAlias(object, objectArray, false, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Adding alias for cache id " + object + " failure: " + illegalArgumentException.getMessage());
                }
            }
        }
    }

    public void removeAlias(String string, Object object) {
        block3: {
            DCache dCache;
            if (object != null && (dCache = this.getCache(string)) != null) {
                try {
                    dCache.removeAlias(object, false, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Removing alias " + object + " failure: " + illegalArgumentException.getMessage());
                }
            }
        }
    }
}

