/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.WorkManager;
import com.ibm.websphere.cache.ChangeEvent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.websphere.cache.PreInvalidationListener;
import com.ibm.ws.asynchbeans.AsynchBeansService;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.asynchbeans.WorkManagerConfiguration;
import com.ibm.wsspi.cache.EventSource;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.HashSet;

public class DCAsyncEventSource
implements EventSource {
    private static TraceComponent tc = Trace.register(DCAsyncEventSource.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    WorkManager _manager = null;
    com.ibm.websphere.asynchbeans.EventSource _eventSourceIL;
    InvalidationListener _invalidationListeners;
    com.ibm.websphere.asynchbeans.EventSource _eventSourcePIL;
    PreInvalidationListener _preInvalidationListener;
    com.ibm.websphere.asynchbeans.EventSource _eventSourceCL;
    ChangeListener _changeListeners;
    private HashSet _hsInvalidationListeners = new HashSet(2);
    private HashSet _hsChangeListeners = new HashSet(2);
    private int _invalidationListenerCount = 0;
    private int _preInvalidationListenerCount = 0;
    private int _changeListenerCount = 0;

    public DCAsyncEventSource() throws Exception {
        if (this._manager == null) {
            AsynchBeansService asynchBeansService = (AsynchBeansService)WsServiceRegistry.getService((Object)this, AsynchBeansService.class);
            WorkManagerConfiguration workManagerConfiguration = asynchBeansService.createWorkManagerConfiguration();
            workManagerConfiguration.setName("com.ibm.ws.cache.DCAsyncEventSource");
            workManagerConfiguration.setGrowable(true);
            workManagerConfiguration.setNumAlarmThreads(0);
            workManagerConfiguration.setMinThreads(0);
            workManagerConfiguration.setMaxThreads(10);
            workManagerConfiguration.setExcluded(true);
            workManagerConfiguration.setEnabledServices(new String[0]);
            workManagerConfiguration.setJNDIName("dynacache_workMgr");
            this._manager = asynchBeansService.getWorkManager(workManagerConfiguration);
        }
        this._eventSourceIL = this._manager.createEventSource();
        this._eventSourceCL = this._manager.createEventSource();
        this._eventSourcePIL = this._manager.createEventSource();
        this._invalidationListeners = (InvalidationListener)this._eventSourceIL.getEventTrigger(InvalidationListener.class);
        this._preInvalidationListener = (PreInvalidationListener)this._eventSourcePIL.getEventTrigger(PreInvalidationListener.class);
        this._changeListeners = (ChangeListener)this._eventSourceCL.getEventTrigger(ChangeListener.class);
    }

    public int getInvalidationListenerCount() {
        return this._invalidationListenerCount;
    }

    public int getPreInvalidationListenerCount() {
        return this._preInvalidationListenerCount;
    }

    public int getChangeListenerCount() {
        return this._changeListenerCount;
    }

    public void fireEvent(InvalidationEvent invalidationEvent) {
        block2: {
            try {
                this._invalidationListeners.fireEvent(invalidationEvent);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.DCAsyncEventSource.fireEvent", "96", this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Exception thrown in fireEvent method of InvalidationListener\n" + throwable.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InvalidationListener invalidationListener) {
        this._eventSourceIL.addListener(invalidationListener);
        HashSet hashSet = this._hsInvalidationListeners;
        synchronized (hashSet) {
            this._hsInvalidationListeners.add(invalidationListener);
            this._invalidationListenerCount = this._hsInvalidationListeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InvalidationListener invalidationListener) {
        this._eventSourceIL.removeListener(invalidationListener);
        HashSet hashSet = this._hsInvalidationListeners;
        synchronized (hashSet) {
            this._hsInvalidationListeners.remove(invalidationListener);
            this._invalidationListenerCount = this._hsInvalidationListeners.size();
        }
    }

    public boolean shouldInvalidate(Object object, int n, int n2) {
        boolean bl;
        block2: {
            bl = true;
            try {
                bl = this._preInvalidationListener.shouldInvalidate(object, n, n2);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.DCAsyncEventSource.shouldInvalidate", "135", this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Exception thrown in shouldInvalidate method of PreInvalidationListener\n" + throwable.toString());
            }
        }
        return bl;
    }

    public void addListener(PreInvalidationListener preInvalidationListener) {
        if (this._preInvalidationListenerCount == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Over-writing current PreInvalidationListener with new one");
            }
            this._eventSourcePIL.removeListener(this._preInvalidationListener);
        }
        this._eventSourcePIL.addListener(preInvalidationListener);
        this._preInvalidationListener = preInvalidationListener;
        this._preInvalidationListenerCount = 1;
    }

    public void removeListener(PreInvalidationListener preInvalidationListener) {
        if (preInvalidationListener == this._preInvalidationListener) {
            this._eventSourcePIL.removeListener(preInvalidationListener);
            this._preInvalidationListenerCount = 0;
            this._preInvalidationListener = null;
        }
    }

    public void cacheEntryChanged(ChangeEvent changeEvent) {
        block2: {
            try {
                this._changeListeners.cacheEntryChanged(changeEvent);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.DCAsyncEventSource.cacheEntryChanged", "176", this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Exception thrown in cacheEntryChanged method of ChangeListener\n" + throwable.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChangeListener changeListener) {
        this._eventSourceCL.addListener(changeListener);
        HashSet hashSet = this._hsChangeListeners;
        synchronized (hashSet) {
            this._hsChangeListeners.add(changeListener);
            this._changeListenerCount = this._hsChangeListeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ChangeListener changeListener) {
        this._eventSourceCL.removeListener(changeListener);
        HashSet hashSet = this._hsChangeListeners;
        synchronized (hashSet) {
            this._hsChangeListeners.remove(changeListener);
            this._changeListenerCount = this._hsChangeListeners.size();
        }
    }
}

