/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.ChangeEvent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.websphere.cache.PreInvalidationListener;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.EventSource;
import java.util.HashSet;

public class DCEventSource
implements EventSource {
    private static TraceComponent tc = Trace.register(DCEventSource.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    static final InvalidationListener[] EMPTY_INV_LISTENERS = new InvalidationListener[0];
    static final ChangeListener[] EMPTY_CHANGE_LISTENERS = new ChangeListener[0];
    private int invalidationListenerCount = 0;
    private int preInvalidationListenerCount = 0;
    private int changeListenerCount = 0;
    private boolean bUpdateInvalidationListener = false;
    private boolean bUpdateChangeListener = false;
    private HashSet hsInvalidationListeners = new HashSet(2);
    private HashSet hsChangeListeners = new HashSet(2);
    private InvalidationListener[] currentInvalidationListeners = EMPTY_INV_LISTENERS;
    private PreInvalidationListener currentPreInvalidationListener;
    private ChangeListener[] currentChangeListeners = EMPTY_CHANGE_LISTENERS;

    public int getInvalidationListenerCount() {
        return this.invalidationListenerCount;
    }

    public int getPreInvalidationListenerCount() {
        return this.preInvalidationListenerCount;
    }

    public int getChangeListenerCount() {
        return this.changeListenerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(InvalidationEvent invalidationEvent) {
        block9: {
            if (this.bUpdateInvalidationListener) {
                HashSet hashSet = this.hsInvalidationListeners;
                synchronized (hashSet) {
                    if (this.invalidationListenerCount > 0) {
                        this.currentInvalidationListeners = new InvalidationListener[this.invalidationListenerCount];
                        this.hsInvalidationListeners.toArray(this.currentInvalidationListeners);
                    } else {
                        this.currentInvalidationListeners = EMPTY_INV_LISTENERS;
                    }
                    this.bUpdateInvalidationListener = false;
                }
            }
            try {
                for (int i = 0; i < this.currentInvalidationListeners.length; ++i) {
                    this.currentInvalidationListeners[i].fireEvent(invalidationEvent);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.DCEventSource.fireEvent", "85", this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Exception thrown in fireEvent method of InvalidationListener\n" + throwable.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InvalidationListener invalidationListener) {
        HashSet hashSet = this.hsInvalidationListeners;
        synchronized (hashSet) {
            this.hsInvalidationListeners.add(invalidationListener);
            this.invalidationListenerCount = this.hsInvalidationListeners.size();
            this.bUpdateInvalidationListener = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InvalidationListener invalidationListener) {
        HashSet hashSet = this.hsInvalidationListeners;
        synchronized (hashSet) {
            this.hsInvalidationListeners.remove(invalidationListener);
            this.invalidationListenerCount = this.hsInvalidationListeners.size();
            this.bUpdateInvalidationListener = true;
        }
    }

    public boolean shouldInvalidate(Object object, int n, int n2) {
        boolean bl;
        block3: {
            bl = true;
            if (this.preInvalidationListenerCount > 0) {
                try {
                    bl = this.currentPreInvalidationListener.shouldInvalidate(object, n, n2);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.DCEventSource.shouldInvalidate", "120", this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Exception thrown in shouldInvalidate method of PreInvalidationListener\n" + throwable.toString());
                }
            }
        }
        return bl;
    }

    public void addListener(PreInvalidationListener preInvalidationListener) {
        if (this.preInvalidationListenerCount == 1 && tc.isDebugEnabled()) {
            Tr.debug(tc, "Over-writing current PreInvalidationListener with new one");
        }
        this.currentPreInvalidationListener = preInvalidationListener;
        this.preInvalidationListenerCount = 1;
    }

    public void removeListener(PreInvalidationListener preInvalidationListener) {
        if (preInvalidationListener == this.currentPreInvalidationListener) {
            this.currentPreInvalidationListener = null;
            this.preInvalidationListenerCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheEntryChanged(ChangeEvent changeEvent) {
        block9: {
            if (this.bUpdateChangeListener) {
                HashSet hashSet = this.hsChangeListeners;
                synchronized (hashSet) {
                    if (this.changeListenerCount > 0) {
                        this.currentChangeListeners = new ChangeListener[this.changeListenerCount];
                        this.hsChangeListeners.toArray(this.currentChangeListeners);
                    } else {
                        this.currentChangeListeners = EMPTY_CHANGE_LISTENERS;
                    }
                    this.bUpdateChangeListener = false;
                }
            }
            try {
                for (int i = 0; i < this.currentChangeListeners.length; ++i) {
                    this.currentChangeListeners[i].cacheEntryChanged(changeEvent);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.DCEventSource.cacheEntryChanged", "169", this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Exception thrown in cacheEntryChanged method of ChangeListener\n" + throwable.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChangeListener changeListener) {
        HashSet hashSet = this.hsChangeListeners;
        synchronized (hashSet) {
            this.hsChangeListeners.add(changeListener);
            this.changeListenerCount = this.hsChangeListeners.size();
            this.bUpdateChangeListener = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ChangeListener changeListener) {
        HashSet hashSet = this.hsChangeListeners;
        synchronized (hashSet) {
            this.hsChangeListeners.remove(changeListener);
            this.changeListenerCount = this.hsChangeListeners.size();
            this.bUpdateChangeListener = true;
        }
    }
}

