/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.websphere.cache.PreInvalidationListener;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheStatisticsListenerImpl;
import com.ibm.ws.cache.DCEventSource;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.intf.CacheStatisticsListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.EventSource;
import java.util.Collection;

public abstract class DCacheBase {
    private static TraceComponent tc = Trace.register(DCacheBase.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final String DEFAULT_CACHE_NAME = "baseCache";
    public static final int DEFAULT_CACHE_SIZE = 2000;
    public static final String DEFAULT_DISTRIBUTED_MAP_NAME = "default";
    public static final String DEFAULT_BASE_JNDI_NAME = "services/cache/basecache";
    public static final String DEFAULT_DMAP_JNDI_NAME = "services/cache/distributedmap";
    public static final boolean FIRE_INVALIDATION_LISTENER = true;
    public static final boolean COORDINATE = true;
    public static final boolean INCREMENT_REFF_COUNT = true;
    public static final boolean IGNORE_COUNTING = true;
    public static final boolean ASK_PERMISSION = true;
    public static final boolean FROM_DEPID_TEMPLATE_INVALIDATION = true;
    public static final boolean CHECK_PREINVALIDATION_LISTENER = true;
    public static final boolean ENTRY_OVERWRITTEN_ON_DISK = true;
    protected String cacheName;
    protected String cacheNameNonPrefixed;
    protected CacheConfig cacheConfig = null;
    protected CachePerf cachePerf = null;
    protected CacheStatisticsListener cacheStatisticsListener = null;
    protected boolean hasPushPullEntries = false;
    protected boolean bEnableListener = false;
    protected EventSource eventSource = null;
    protected boolean ignoreValueInInvalidationEvent = false;
    protected boolean swapToDisk = false;

    public DCacheBase(String string, CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
        this.ignoreValueInInvalidationEvent = cacheConfig.ignoreValueInInvalidationEvent;
        this.cacheName = string;
        cacheConfig.cacheNameNonPrefixed = this.cacheNameNonPrefixed = cacheConfig.cacheNameNonPrefixed != null ? cacheConfig.cacheNameNonPrefixed : string;
        this.cacheStatisticsListener = new CacheStatisticsListenerImpl(string);
    }

    public synchronized boolean addChangeListener(ChangeListener changeListener) {
        if (this.bEnableListener && changeListener != null) {
            this.eventSource.addListener(changeListener);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addChangeListener() cacheName=" + this.cacheName + " listener=" + this.eventSource.getChangeListenerCount());
            }
            return true;
        }
        return false;
    }

    public synchronized boolean addInvalidationListener(InvalidationListener invalidationListener) {
        if (this.bEnableListener && invalidationListener != null) {
            this.eventSource.addListener(invalidationListener);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addInvalidationListener() cacheName=" + this.cacheName + " listener=" + this.eventSource.getInvalidationListenerCount());
            }
            return true;
        }
        return false;
    }

    public synchronized boolean addPreInvalidationListener(PreInvalidationListener preInvalidationListener) {
        if (this.bEnableListener && preInvalidationListener != null) {
            if (this.eventSource.getPreInvalidationListenerCount() > 0 && tc.isDebugEnabled()) {
                Tr.debug(tc, "addPreInvalidationListener() cacheName=" + this.cacheName + " one already exists. Overwriting old listener.");
            }
            this.eventSource.addListener(preInvalidationListener);
            return true;
        }
        return false;
    }

    public void clear() {
        boolean bl = true;
        this.clear(bl);
    }

    public synchronized boolean enableListener(boolean bl) {
        boolean bl2 = true;
        if (bl && this.eventSource == null) {
            bl2 = this.initEventSource();
        }
        this.bEnableListener = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enableListener() cacheName=" + this.cacheName + " enable=" + bl + " success=" + bl2 + " ignoreValueInInvalidationEvent=" + this.ignoreValueInInvalidationEvent);
        }
        return bl2;
    }

    private boolean initEventSource() {
        boolean bl = true;
        if (this.cacheConfig.useListenerContext) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.cache.DCAsyncEventSource");
                this.eventSource = (EventSource)clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " Using listener's J2EE context for callback - cacheName= " + this.cacheName);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.Cache.initEventSource", "1969", this);
                exception.printStackTrace();
                bl = false;
            }
            catch (Error error) {
                FFDCFilter.processException((Throwable)error, "com.ibm.ws.cache.Cache.initEventSource", "1973", this);
                error.printStackTrace();
                bl = false;
            }
        }
        if (this.eventSource == null) {
            this.eventSource = new DCEventSource();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using caller thread context for callback - cacheName= " + this.cacheName);
            }
        }
        return bl;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public Collection getCacheIdsByDependency(String string) {
        return this.getCacheIdsByDependency((Object)string);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getCacheNameNonPrefixed() {
        return this.cacheNameNonPrefixed;
    }

    public CachePerf getCachePerf() {
        return this.cachePerf;
    }

    public CacheStatisticsListener getCacheStatisticsListener() {
        return this.cacheStatisticsListener;
    }

    public int getDefaultPriority() {
        return this.cacheConfig.getCachePriority();
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo entryInfo) {
        return this.getEntry(entryInfo, true);
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(String string) {
        return this.getEntry((Object)string);
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(Object object) {
        return this.getEntry(object, 5, true, false);
    }

    public EventSource getEventSource() {
        return this.eventSource;
    }

    public int getMaxNumberCacheEntries() {
        return this.cacheConfig.cacheSize;
    }

    public boolean getSwapToDisk() {
        return this.swapToDisk;
    }

    public Object getValue(com.ibm.websphere.cache.EntryInfo entryInfo, boolean bl) {
        return this.getValue(entryInfo.getIdObject(), entryInfo.getTemplate(), bl, false);
    }

    public Object getValue(Object object, boolean bl) {
        return this.getValue(object, null, bl, false);
    }

    public Object getValue(String string, boolean bl) {
        return this.getValue((Object)string, bl);
    }

    public boolean hasPushPullEntries() {
        return this.hasPushPullEntries;
    }

    public void invalidateById(Object object, boolean bl) {
        this.invalidateById(object, 1, bl, true);
    }

    public void invalidateById(Object object, boolean bl, boolean bl2) {
        this.invalidateById(object, 1, bl, bl2);
    }

    public void invalidateById(Object object, int n, boolean bl) {
        this.invalidateById(object, n, bl, true);
    }

    public void invalidateById(String string, boolean bl) {
        this.invalidateById(string, 1, bl, true);
    }

    public void invalidateById(Object object, int n, int n2, boolean bl, boolean bl2) {
        this.invalidateById(object, n, n2, bl, bl2, true);
    }

    public boolean isEnableListener() {
        return this.bEnableListener;
    }

    public synchronized boolean removeChangeListener(ChangeListener changeListener) {
        if (this.bEnableListener && changeListener != null) {
            this.eventSource.removeListener(changeListener);
            return true;
        }
        return false;
    }

    public synchronized boolean removeInvalidationListener(InvalidationListener invalidationListener) {
        if (this.bEnableListener && invalidationListener != null) {
            this.eventSource.removeListener(invalidationListener);
            return true;
        }
        return false;
    }

    public synchronized boolean removePreInvalidationListener(PreInvalidationListener preInvalidationListener) {
        if (this.bEnableListener && preInvalidationListener != null) {
            this.eventSource.removeListener(preInvalidationListener);
            return true;
        }
        return false;
    }

    public com.ibm.websphere.cache.CacheEntry setEntry(CacheEntry cacheEntry) {
        return this.setEntry(cacheEntry, 5);
    }

    public com.ibm.websphere.cache.CacheEntry setEntry(CacheEntry cacheEntry, int n) {
        return this.setEntry(cacheEntry, n, false, false, false);
    }

    public void setValue(EntryInfo entryInfo, Object object) {
        this.setValue(entryInfo, object, !this.shouldPull(entryInfo.getSharingPolicy(), entryInfo.id));
    }

    public abstract void invalidateById(Object var1, int var2, int var3, boolean var4, boolean var5, boolean var6);

    public abstract void invalidateById(Object var1, int var2, boolean var3, boolean var4);

    public abstract Collection getCacheIdsByDependency(Object var1);

    public abstract void clear(boolean var1);

    public abstract com.ibm.websphere.cache.CacheEntry getEntry(Object var1, int var2, boolean var3, boolean var4);

    public abstract void setValue(EntryInfo var1, Object var2, boolean var3);

    public abstract com.ibm.websphere.cache.CacheEntry setEntry(CacheEntry var1, int var2, boolean var3, boolean var4, boolean var5);

    public abstract com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo var1, boolean var2);

    public abstract Object getValue(Object var1, String var2, boolean var3, boolean var4);

    public abstract boolean shouldPull(int var1, Object var2);
}

