/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.FastHashtable;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyTable
implements Serializable {
    private static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Trace.register(DependencyTable.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static final int DEFAULT_SIZE = 2000;
    static final int CONCURRENT_HASHMAP = 0;
    static final int HASHTABLE = 1;
    private int tableType = 0;
    private Map<Object, ValueSet> dependencyToEntryTable = null;

    public DependencyTable() {
        this(2000);
    }

    public DependencyTable(int n) {
        this.dependencyToEntryTable = new ConcurrentHashMap<Object, ValueSet>(n, 0.75f, 1);
    }

    public DependencyTable(int n, int n2) {
        if (n == 1) {
            this.dependencyToEntryTable = new Hashtable<Object, ValueSet>(n2);
            this.tableType = n;
        } else {
            this.dependencyToEntryTable = new ConcurrentHashMap<Object, ValueSet>(n2, 0.75f, 1);
        }
    }

    public void add(Object object, Object object2) {
        if (tc.isDebugEnabled() && object2 instanceof String) {
            Tr.debug(tc, "IMPORTANT: adding dependency " + object + " --> " + object2);
        }
        if (object == null) {
            throw new IllegalArgumentException("dependency cannot be null");
        }
        ValueSet valueSet = this.dependencyToEntryTable.get(object);
        if (valueSet == null) {
            valueSet = new ValueSet(4);
            this.dependencyToEntryTable.put(object, valueSet);
        }
        valueSet.add(object2);
    }

    public void add(Object object, ValueSet valueSet) {
        if (object == null) {
            throw new IllegalArgumentException("dependency cannot be null");
        }
        if (valueSet != null) {
            this.dependencyToEntryTable.put(object, valueSet);
        }
    }

    public ValueSet removeDependency(Object object) {
        return this.dependencyToEntryTable.remove(object);
    }

    public boolean removeEntry(String string, Object object) {
        return this.removeEntry((Object)string, object);
    }

    public boolean removeEntry(Object object, Object object2) {
        boolean bl = false;
        ValueSet valueSet = this.dependencyToEntryTable.get(object);
        if (valueSet == null) {
            return bl;
        }
        bl = valueSet.remove(object2);
        if (valueSet.size() == 0) {
            this.removeDependency(object);
        }
        return bl;
    }

    public void clear() {
        if (this.tableType == 1) {
            ((Hashtable)this.dependencyToEntryTable).clear();
        } else {
            ((FastHashtable)((Object)this.dependencyToEntryTable)).clear();
        }
    }

    public Iterator<Object> getKeys() {
        return this.dependencyToEntryTable.keySet().iterator();
    }

    public ValueSet getEntries(Object object) {
        ValueSet valueSet = this.dependencyToEntryTable.get(object);
        return valueSet;
    }
}

