/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;

public class DiskCacheSizeInfo {
    private static TraceComponent tc = Trace.register(DiskCacheSizeInfo.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static final boolean IS_UNIT_TEST = false;
    public static final long GB_SIZE = 0x40000000L;
    public static final long MB_SIZE = 0x100000L;
    public static final int TYPE_CACHE_DATA = 1;
    public static final int TYPE_DEPENDENCY_ID_DATA = 2;
    public static final int TYPE_TEMPLATE_DATA = 3;
    private String cacheName;
    protected int diskCacheSizeLimit = 0;
    protected int diskCacheSizeHighLimit = 0;
    protected int diskCacheSizeLowLimit = 0;
    protected int highThreshold = 0;
    protected int lowThreshold = 0;
    protected long diskCacheEntrySizeInBytesLimit = 0L;
    protected int diskCacheSizeInGBLimit = 0;
    private long diskCacheSizeInBytesLimit = 0L;
    private long diskCacheSizeInBytesHighLimit = 0L;
    private long diskCacheSizeInBytesLowLimit = 0L;
    protected int currentDataGB = 0;
    protected int currentDependencyIdGB = 0;
    protected int currentTemplateGB = 0;
    protected boolean allowOverflow = false;

    private DiskCacheSizeInfo() {
    }

    public DiskCacheSizeInfo(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.cacheName = string;
        this.diskCacheSizeLimit = n;
        this.diskCacheSizeInGBLimit = n3;
        this.diskCacheEntrySizeInBytesLimit = (long)n2 * 0x100000L;
        this.highThreshold = n7;
        this.lowThreshold = n8;
        this.currentDataGB = n4;
        this.currentDependencyIdGB = n5;
        this.currentTemplateGB = n6;
        if (this.diskCacheSizeLimit > 0) {
            this.diskCacheSizeHighLimit = this.diskCacheSizeLimit * this.highThreshold / 100;
            this.diskCacheSizeLowLimit = this.diskCacheSizeLimit * this.lowThreshold / 100;
            this.traceDebug("constructor()", "cacheName=" + this.cacheName + " diskCacheSizeLimit=" + this.diskCacheSizeLimit + " diskCacheSizeHighLimit=" + this.diskCacheSizeHighLimit + " diskCacheSizeLowLimit=" + this.diskCacheSizeLowLimit);
        }
        if (this.diskCacheSizeInGBLimit > 0) {
            this.diskCacheSizeInBytesLimit = (long)(n3 - this.currentDependencyIdGB - this.currentTemplateGB) * 0x40000000L;
            this.diskCacheSizeInBytesHighLimit = this.diskCacheSizeInBytesLimit * (long)this.highThreshold / 100L;
            this.diskCacheSizeInBytesLowLimit = this.diskCacheSizeInBytesLimit * (long)this.lowThreshold / 100L;
            this.traceDebug("constructor()", "cacheName=" + this.cacheName + " diskCacheSizeInBytesLimit=" + this.diskCacheSizeInBytesLimit + " diskCacheSizeInBytesHighLimit=" + this.diskCacheSizeInBytesHighLimit + " diskCacheSizeInBytesLowLimit=" + this.diskCacheSizeInBytesLowLimit);
        }
    }

    public synchronized boolean checkAddVolume(int n, int n2) {
        if (this.diskCacheSizeInGBLimit > 0) {
            boolean bl = false;
            int n3 = 0;
            switch (n) {
                case 1: {
                    if (this.currentDataGB >= n2 + 1) {
                        return true;
                    }
                    if (this.allowOverflow) {
                        this.traceDebug("checkAddVolume()", "cacheName=" + this.cacheName + " allow overflow for data file vol=" + n2);
                        return true;
                    }
                    n3 = this.currentDataGB + this.currentDependencyIdGB + this.currentTemplateGB + 1;
                    if (this.diskCacheSizeInGBLimit >= n3) {
                        ++this.currentDataGB;
                        break;
                    }
                    return false;
                }
                case 2: {
                    if (this.currentDependencyIdGB >= n2 + 1) {
                        return true;
                    }
                    if (this.allowOverflow) {
                        this.traceDebug("checkAddVolume()", "cacheName=" + this.cacheName + " allow overflow for dependency file id vol=" + n2);
                        return true;
                    }
                    n3 = this.currentDataGB + this.currentDependencyIdGB + this.currentTemplateGB + 1;
                    if (this.diskCacheSizeInGBLimit >= n3) {
                        ++this.currentDependencyIdGB;
                        bl = true;
                        break;
                    }
                    return false;
                }
                case 3: {
                    if (this.currentTemplateGB >= n2 + 1) {
                        return true;
                    }
                    if (this.allowOverflow) {
                        this.traceDebug("checkAddVolume()", "cacheName=" + this.cacheName + " allow overflow for template file vol=" + n2);
                        return true;
                    }
                    n3 = this.currentDataGB + this.currentDependencyIdGB + this.currentTemplateGB + 1;
                    if (this.diskCacheSizeInGBLimit >= n3) {
                        ++this.currentTemplateGB;
                        bl = true;
                        break;
                    }
                    return false;
                }
            }
            if (bl) {
                this.diskCacheSizeInBytesLimit = (long)(this.diskCacheSizeInGBLimit - this.currentDependencyIdGB - this.currentTemplateGB) * 0x40000000L;
                this.diskCacheSizeInBytesHighLimit = this.diskCacheSizeInBytesLimit * (long)this.highThreshold / 100L;
                this.diskCacheSizeInBytesLowLimit = this.diskCacheSizeInBytesLimit * (long)this.lowThreshold / 100L;
                this.traceDebug("checkAddVolume()", "new limit: cacheName=" + this.cacheName + " add type=" + n + " diskCacheSizeInBytesLimit=" + this.diskCacheSizeInBytesLimit + " diskCacheSizeInBytesHighLimit=" + this.diskCacheSizeInBytesHighLimit + " diskCacheSizeInBytesLowLimit=" + this.diskCacheSizeInBytesLowLimit);
            }
            this.traceDebug("checkAddVolume()", "cacheName=" + this.cacheName + " add type=" + n + " currentDataGB=" + this.currentDataGB + " currentDependencyIdGB=" + this.currentDependencyIdGB + " currentTemplateGB=" + this.currentTemplateGB);
        }
        return true;
    }

    public synchronized void reset() {
        this.currentDataGB = 1;
        if (this.currentDependencyIdGB > 0) {
            this.currentDependencyIdGB = 1;
        }
        if (this.currentTemplateGB > 0) {
            this.currentTemplateGB = 1;
        }
        if (this.diskCacheSizeInGBLimit > 0) {
            this.diskCacheSizeInBytesLimit = (long)(this.diskCacheSizeInGBLimit - this.currentDependencyIdGB - this.currentTemplateGB) * 0x40000000L;
            this.diskCacheSizeInBytesHighLimit = this.diskCacheSizeInBytesLimit * (long)this.highThreshold / 100L;
            this.diskCacheSizeInBytesLowLimit = this.diskCacheSizeInBytesLimit * (long)this.lowThreshold / 100L;
            this.traceDebug("reset()", "cacheName=" + this.cacheName + " diskCacheSizeInBytesLimit=" + this.diskCacheSizeInBytesLimit + " diskCacheSizeInBytesHighLimit=" + this.diskCacheSizeInBytesHighLimit + " diskCacheSizeInBytesLowLimit=" + this.diskCacheSizeInBytesLowLimit);
        }
    }

    public synchronized long getDiskCacheSizeInBytesHighLimit() {
        return this.diskCacheSizeInBytesHighLimit;
    }

    public synchronized long getDiskCacheSizeInBytesLowLimit() {
        return this.diskCacheSizeInBytesLowLimit;
    }

    public synchronized long getDiskCacheSizeInBytesLimit() {
        return this.diskCacheSizeInBytesLimit;
    }

    public long getDiskCacheSizeHighLimit() {
        return this.diskCacheSizeHighLimit;
    }

    public long getDiskCacheSizeLowLimit() {
        return this.diskCacheSizeLowLimit;
    }

    public long getDiskCacheSizeLimit() {
        return this.diskCacheSizeLimit;
    }

    public long getDiskCacheEntrySizeInBytesLimit() {
        return this.diskCacheEntrySizeInBytesLimit;
    }

    private void traceDebug(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + " " + string2);
        }
    }
}

