/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.ServletCacheRequest;
import com.ibm.ws.cache.DependencyTable;
import com.ibm.ws.cache.ExternalCacheFragment;
import com.ibm.ws.cache.ExternalCacheGroup;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;

public class ExternalCacheServices
implements Serializable {
    private static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Trace.register(ExternalCacheServices.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private HashMap externalCacheGroups = new HashMap();
    private HashMap externalURLToECFTable = new HashMap();
    private DependencyTable idDependencyTable = new DependencyTable(1, 200);
    private DependencyTable uriDependencyTable = new DependencyTable(1, 200);

    public Iterator getExternalCacheGroupNames() {
        return this.externalCacheGroups.keySet().iterator();
    }

    public void setExternalCacheGroups(HashMap hashMap) {
        this.externalCacheGroups = hashMap;
    }

    public void addExternalCacheAdapter(String string, String string2, String string3) {
        ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(string);
        if (externalCacheGroup == null) {
            Tr.error(tc, "dynacache.externalnotfound", string);
            return;
        }
        externalCacheGroup.addExternalCacheAdapter(string2, string3);
    }

    public void removeExternalCacheAdapter(String string, String string2) {
        ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(string);
        if (externalCacheGroup == null) {
            return;
        }
        externalCacheGroup.removeExternalCacheAdapter(string2);
    }

    public void start() {
        if (this.externalCacheGroups == null) {
            throw new IllegalStateException("externalCacheGroups must be set before start()");
        }
    }

    public void batchUpdate(HashMap hashMap, HashMap hashMap2, ArrayList arrayList) {
        this.invalidateExternalCaches(hashMap, hashMap2);
        this.writeToExternalCaches(arrayList);
    }

    public void invalidateExternalCaches(HashMap hashMap, HashMap hashMap2) {
        boolean bl;
        Object object5;
        Object object2;
        Object object32;
        if (this.externalCacheGroups == null || this.externalCacheGroups.size() == 0) {
            return;
        }
        ValueSet valueSet = new ValueSet(4);
        for (Object object32 : hashMap.keySet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ExternalCacheServices.invalidate id: " + object32);
            }
            if ((object2 = this.idDependencyTable.removeDependency(object32)) == null) continue;
            valueSet.union((ValueSet)object2);
        }
        Iterator iterator = hashMap2.keySet().iterator();
        object32 = null;
        while (iterator.hasNext()) {
            Iterator iterator2;
            Object object4;
            object2 = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ExternalCacheServices.invalidate template: " + (String)object2);
            }
            if (((InvalidateByTemplateEvent)(object4 = (InvalidateByTemplateEvent)hashMap2.get(object2))).isCacheCommand_Clear()) {
                for (Object object5 : this.externalCacheGroups.values()) {
                    ((ExternalCacheGroup)object5).clear((InvalidateByTemplateEvent)object4);
                }
                this.externalURLToECFTable.clear();
                this.idDependencyTable.clear();
                this.uriDependencyTable.clear();
                return;
            }
            if (((InvalidateByTemplateEvent)object4).isCacheCommand_InvalidateByTemplate()) {
                iterator2 = this.externalCacheGroups.values().iterator();
                while (iterator2.hasNext()) {
                    object5 = (ExternalCacheGroup)iterator2.next();
                    ((ExternalCacheGroup)object5).invalidateTemplate((InvalidateByTemplateEvent)object4);
                }
            }
            if ((iterator2 = ((InvalidateByTemplateEvent)object4).getRemovedIds()) != null && ((HashSet)((Object)iterator2)).size() > 0) {
                if (object32 == null) {
                    object32 = new HashSet(hashMap2.size());
                }
                ((HashSet)object32).add(iterator2);
            }
            if ((object5 = this.uriDependencyTable.removeDependency(object2)) == null) continue;
            valueSet.union((ValueSet)object5);
        }
        object2 = new ValueSet(10);
        for (Iterator iterator2 : valueSet) {
            Object object6;
            object5 = ((ExternalCacheFragment)((Object)iterator2)).getUri();
            ((HashSet)object2).add(object5);
            this.externalURLToECFTable.remove(object5);
            Enumeration enumeration = ((ExternalCacheFragment)((Object)iterator2)).getInvalidationIds();
            while (enumeration.hasMoreElements()) {
                object6 = enumeration.nextElement();
                this.idDependencyTable.removeEntry(object6, iterator2);
            }
            object6 = ((ExternalCacheFragment)((Object)iterator2)).getTemplates();
            while (object6.hasMoreElements()) {
                Object object7 = (String)object6.nextElement();
                this.uriDependencyTable.removeEntry((String)object7, iterator2);
            }
        }
        boolean bl2 = ((HashSet)object2).isEmpty();
        boolean bl3 = hashMap.isEmpty();
        boolean bl4 = bl = object32 == null || ((HashSet)object32).isEmpty();
        if (bl2 && bl3 && bl) {
            return;
        }
        for (Object object7 : this.externalCacheGroups.values()) {
            if (!bl2) {
                ((ExternalCacheGroup)object7).invalidatePages((ValueSet)object2);
            }
            if (!bl3) {
                ((ExternalCacheGroup)object7).invalidateIds(hashMap);
            }
            if (bl) continue;
            ((ExternalCacheGroup)object7).invalidateIds((HashSet)object32);
        }
    }

    private void writeToExternalCaches(ArrayList arrayList) {
        Object object;
        Object object2;
        if (this.externalCacheGroups == null) {
            return;
        }
        HashMap hashMap = new HashMap();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList2;
            Object object3 = (ExternalCacheFragment)arrayList.get(i);
            object2 = ((ExternalCacheFragment)object3).getExternalCacheGroupId();
            object = this.externalCacheGroups.get(object2);
            if (object == null) continue;
            String string = ((ExternalCacheFragment)object3).getUri();
            boolean bl = false;
            ExternalCacheFragment externalCacheFragment = (ExternalCacheFragment)this.externalURLToECFTable.get(string);
            if (externalCacheFragment != null && externalCacheFragment.getTimeStamp() >= ((ExternalCacheFragment)object3).getTimeStamp()) {
                if (!externalCacheFragment.getHostList().contains(((ExternalCacheFragment)object3).getHost())) {
                    bl = true;
                }
                if (System.currentTimeMillis() - externalCacheFragment.getTimeStamp() < 30000L) continue;
            }
            ((ExternalCacheFragment)object3).addHostToList(((ExternalCacheFragment)object3).getHost());
            if (!bl) {
                Object object4;
                this.externalURLToECFTable.put(string, object3);
                arrayList2 = ((ExternalCacheFragment)object3).getInvalidationIds();
                while (arrayList2.hasMoreElements()) {
                    object4 = (String)arrayList2.nextElement();
                    this.idDependencyTable.add(object4, object3);
                }
                object4 = ((ExternalCacheFragment)object3).getTemplates();
                while (object4.hasMoreElements()) {
                    String string2 = (String)object4.nextElement();
                    this.uriDependencyTable.add((Object)string2, object3);
                }
            }
            if ((arrayList2 = (ArrayList)hashMap.get(object2)) == null) {
                arrayList2 = new ArrayList();
                hashMap.put(object2, arrayList2);
            }
            arrayList2.add(((ExternalCacheFragment)object3).getEntry());
        }
        for (Object object3 : hashMap.keySet()) {
            object2 = (ArrayList)hashMap.get(object3);
            object = (ExternalCacheGroup)this.externalCacheGroups.get(object3);
            ((ExternalCacheGroup)object).writePages((ArrayList)object2);
        }
    }

    public void preInvoke(String string, ServletCacheRequest servletCacheRequest, HttpServletResponse httpServletResponse) {
        ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(string);
        if (externalCacheGroup != null) {
            externalCacheGroup.preInvoke(servletCacheRequest, httpServletResponse);
        }
    }

    public void postInvoke(String string, ServletCacheRequest servletCacheRequest, HttpServletResponse httpServletResponse) {
        ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(string);
        if (externalCacheGroup != null) {
            externalCacheGroup.postInvoke(servletCacheRequest, httpServletResponse);
        }
    }
}

