/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.DependencyTable;
import com.ibm.ws.cache.FastHashtable;
import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.Result;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import java.util.Enumeration;

public class HTODDependencyTable {
    public static final int DEP_ID_TABLE = 1;
    public static final int TEMPLATE_TABLE = 2;
    private static TraceComponent tc = Trace.register(DependencyTable.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private FastHashtable dependencyToEntryTable = null;
    private FastHashtable dependencyNotUpdatedTable = null;
    private int type;
    private int maxSize;
    private int entryRemove;
    public int delayOffloadEntriesLimit;
    private HTODDynacache htod;

    public HTODDependencyTable(int n, int n2, int n3, int n4, int n5, HTODDynacache hTODDynacache) {
        this.type = n;
        this.dependencyToEntryTable = new FastHashtable(n2);
        this.dependencyNotUpdatedTable = new FastHashtable(n2 / 2);
        this.maxSize = n3;
        this.entryRemove = n4;
        this.delayOffloadEntriesLimit = n5;
        this.htod = hTODDynacache;
    }

    public int add(Object object, ValueSet valueSet, Object object2) {
        int n = 0;
        this.dependencyNotUpdatedTable.remove(object);
        valueSet.add(object2);
        if (valueSet.size() > this.delayOffloadEntriesLimit) {
            if (this.type == 1) {
                n = this.htod.writeValueSet(2, object, valueSet, true);
                this.htod.cache.getCacheStatisticsListener().depIdsOffloadedToDisk(object);
            } else {
                n = this.htod.writeValueSet(3, object, valueSet, true);
                this.htod.cache.getCacheStatisticsListener().templatesOffloadedToDisk(object);
            }
            this.dependencyToEntryTable.remove(object);
            if (n == 2 && valueSet.size() > 0) {
                this.htod.delCacheEntry(valueSet, 8, 5, false, true);
                n = 0;
            }
        }
        return n;
    }

    public int add(Object object, ValueSet valueSet) {
        int n = 0;
        if (this.dependencyToEntryTable.size() >= this.maxSize) {
            n = this.reduceTableSize();
        }
        this.dependencyNotUpdatedTable.put(object, valueSet);
        this.dependencyToEntryTable.put(object, valueSet);
        return n;
    }

    public int add(Object object, Object object2) {
        int n = 0;
        if (this.dependencyToEntryTable.size() >= this.maxSize) {
            n = this.reduceTableSize();
        }
        ValueSet valueSet = new ValueSet(4);
        valueSet.add(object2);
        this.dependencyNotUpdatedTable.put(object, valueSet);
        this.dependencyToEntryTable.put(object, valueSet);
        return n;
    }

    public int replace(Object object, ValueSet valueSet) {
        int n = 0;
        this.dependencyNotUpdatedTable.remove(object);
        if (valueSet != null && valueSet.size() > this.delayOffloadEntriesLimit) {
            this.dependencyToEntryTable.remove(object);
            if (this.type == 1) {
                n = this.htod.writeValueSet(2, object, valueSet, true);
                this.htod.cache.getCacheStatisticsListener().depIdsOffloadedToDisk(object);
            } else {
                n = this.htod.writeValueSet(3, object, valueSet, true);
                this.htod.cache.getCacheStatisticsListener().templatesOffloadedToDisk(object);
            }
        } else if (valueSet.size() > 0) {
            this.dependencyToEntryTable.put(object, valueSet);
        } else {
            this.dependencyToEntryTable.remove(object);
        }
        if (n == 2 && valueSet.size() > 0) {
            this.htod.delCacheEntry(valueSet, 8, 5, false, true);
            n = 0;
        }
        return n;
    }

    public void removeDependency(Object object) {
        this.dependencyNotUpdatedTable.remove(object);
        this.dependencyToEntryTable.remove(object);
    }

    public Result removeEntry(Object object, Object object2) {
        Result result = this.htod.getFromResultPool();
        ValueSet valueSet = (ValueSet)this.dependencyToEntryTable.get(object);
        if (valueSet == null) {
            return result;
        }
        result.bExist = true;
        valueSet.remove(object2);
        this.dependencyNotUpdatedTable.remove(object);
        if (valueSet.size() == 0) {
            this.dependencyToEntryTable.remove(object);
            result.returnCode = this.type == 1 ? this.htod.delValueSet(2, object) : this.htod.delValueSet(3, object);
        }
        return result;
    }

    public void clear() {
        this.dependencyToEntryTable.clear();
        this.dependencyNotUpdatedTable.clear();
    }

    public Enumeration getKeys() {
        return this.dependencyToEntryTable.keys();
    }

    public Enumeration getNotUpdateKeys() {
        return this.dependencyNotUpdatedTable.keys();
    }

    public ValueSet getEntries(Object object) {
        ValueSet valueSet = (ValueSet)this.dependencyToEntryTable.get(object);
        return valueSet;
    }

    public boolean isEmpty() {
        return this.dependencyToEntryTable.isEmpty();
    }

    public boolean isUpdated(Object object) {
        return !this.dependencyNotUpdatedTable.contains(object);
    }

    private int reduceTableSize() {
        Object object;
        int n = 0;
        int n2 = this.entryRemove;
        if (this.dependencyNotUpdatedTable.size() > 0) {
            Enumeration enumeration = this.dependencyNotUpdatedTable.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                this.dependencyNotUpdatedTable.remove(object);
                this.dependencyToEntryTable.remove(object);
                if (--n2 != 0) continue;
                break;
            }
        }
        if (n2 > 0) {
            int n3 = 5;
            while (n2 > 0) {
                object = this.dependencyToEntryTable.keys();
                while (object.hasMoreElements()) {
                    Object e2 = object.nextElement();
                    ValueSet valueSet = (ValueSet)this.dependencyToEntryTable.get(e2);
                    if (valueSet.size() < n3) {
                        if (this.type == 1) {
                            n = this.htod.writeValueSet(2, e2, valueSet, true);
                            this.htod.cache.getCacheStatisticsListener().depIdsOffloadedToDisk(e2);
                        } else {
                            n = this.htod.writeValueSet(3, e2, valueSet, true);
                            this.htod.cache.getCacheStatisticsListener().templatesOffloadedToDisk(e2);
                        }
                        this.dependencyToEntryTable.remove(e2);
                        --n2;
                        if (n == 1) {
                            return n;
                        }
                        if (n == 2) {
                            this.htod.delCacheEntry(valueSet, 8, 5, false, true);
                            n = 0;
                            return n;
                        }
                    }
                    if (n2 != 0) continue;
                    break;
                }
                n3 += 3;
            }
        }
        return n;
    }

    public int size() {
        return this.dependencyToEntryTable.size();
    }
}

