/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheOnDisk;
import com.ibm.ws.cache.DiskCacheSizeInfo;
import com.ibm.ws.cache.ExplicitIdData;
import com.ibm.ws.cache.HTODDependencyTable;
import com.ibm.ws.cache.HTODInvalidationBuffer;
import com.ibm.ws.cache.PrimitiveArrayPool;
import com.ibm.ws.cache.ReadWriteLock;
import com.ibm.ws.cache.Result;
import com.ibm.ws.cache.SerializationUtility;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.persistent.filemgr.FileManager;
import com.ibm.ws.cache.persistent.filemgr.FileManagerException;
import com.ibm.ws.cache.persistent.filemgr.FileManagerImpl;
import com.ibm.ws.cache.persistent.htod.HashtableAction;
import com.ibm.ws.cache.persistent.htod.HashtableEntry;
import com.ibm.ws.cache.persistent.htod.HashtableOnDisk;
import com.ibm.ws.cache.persistent.htod.HashtableOnDiskException;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class HTODDynacache {
    private static final boolean IS_UNIT_TEST = false;
    public static final boolean CHECK_EXPIRED = true;
    public static final boolean DELETE = true;
    public static final boolean EXIST = true;
    public static final boolean COMPLETE_CLEAR = true;
    public static final boolean FILTER = true;
    public static final boolean ALL = true;
    public static final boolean ADD_IF_NEW = true;
    public static final int NUM_SCAN = 50;
    public static final String DISKCACHE_MORE = "DISKCACHE_MORE";
    public static final boolean CALLED_FROM_REMOVE = true;
    public static final int NO_EXCEPTION = 0;
    public static final int DISK_EXCEPTION = 1;
    public static final int DISK_SIZE_OVER_LIMIT_EXCEPTION = 2;
    public static final int OTHER_EXCEPTION = 3;
    public static final int SERIALIZATION_EXCEPTION = 4;
    public static final int DISK_SIZE_IN_ENTRIES_OVER_LIMIT_EXCEPTION = 5;
    public static final int DISK_CACHE_ENTRY_SIZE_OVER_LIMIT_EXCEPTION = 6;
    public static final int NO_EXCEPTION_ENTRY_OVERWRITTEN = 7;
    public static final int CACHE_ID_DATA = 1;
    public static final int DEP_ID_DATA = 2;
    public static final int TEMPLATE_ID_DATA = 3;
    public static final String DISK_CACHE_IN_GB_OVER_LIMIT_MSG = "The disk cache size in GB is over the limit.";
    public static final ValueSet EMPTY_VS = new ValueSet(1);
    TraceComponent tc = Trace.register(HTODDynacache.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    protected ReadWriteLock readWriteLock = new ReadWriteLock();
    public PrimitiveArrayPool byteArrayPool = null;
    public PrimitiveArrayPool longArrayPool = null;
    public HashtableEntryObjectPool htEntryPool = null;
    protected ResultObjectPool resultPool = null;
    protected EvictionEntryPool evictionEntryPool = null;
    protected HTODInvalidationBuffer invalidationBuffer = null;
    protected String filename;
    protected String dirname;
    protected FileManager object_filemgr;
    protected FileManager dependency_filemgr;
    protected FileManager template_filemgr;
    public static String object_suffix = "-objects";
    public static String dependency_suffix = "-dependencies";
    public static String template_suffix = "-templates";
    protected HashtableOnDisk object_cache = null;
    protected HashtableOnDisk dependency_cache = null;
    protected HashtableOnDisk template_cache = null;
    protected DCache cache = null;
    protected CacheOnDisk cod = null;
    boolean auto_rehash = false;
    long scanExpiredTime = 0L;
    public String cacheName = "";
    protected int initial_hashtable_size = 1296109;
    protected int hashtable_threshold = 75;
    protected int initial_valueset_size = 509;
    protected boolean valueset_rehash = true;
    protected int physical_disk_manager = 2;
    protected ValueSet removeIdsList = null;
    protected HTODDependencyTable auxDataDependencyTable = null;
    protected HTODDependencyTable auxTemplateDependencyTable = null;
    protected boolean delayOffload = false;
    protected boolean disableDependencyId = false;
    protected boolean disableTemplatesSupport = false;
    protected boolean processCompleteClear = true;
    private long deletedSize = 0L;
    protected long minDiskCacheSizeInBytes = 0L;
    protected int diskCacheSizeAdjustment = 0;
    protected BinaryHeap EvictionTable = null;
    protected Object evictionTableMonitor = new Object();
    protected Random rand = null;
    protected Exception diskCacheException = null;
    protected boolean deleteDiskFiles = false;
    protected long timeElapsedWriteAuxTables = 0L;
    protected int numDepIdsInAuxTable = 0;
    protected int numCacheIdsInDepIdAuxTable = 0;
    protected int numTemplatesInAuxTable = 0;
    protected int numCacheIdsInTemplateAuxTable = 0;
    protected int numExplicitBufferLimitOnStop = 0;
    protected HashMap cacheIdsTable = null;

    public HTODDynacache() {
        PrimitiveArrayPool.PoolConfig poolConfig = new PrimitiveArrayPool.PoolConfig();
        poolConfig.type = 1;
        poolConfig.numberOfPools = 20;
        poolConfig.poolSize = 2;
        poolConfig.poolEntryLife = 300000;
        poolConfig.scanFrequency = 60000;
        this.byteArrayPool = new PrimitiveArrayPool(poolConfig, this.cacheName);
        PrimitiveArrayPool.PoolConfig poolConfig2 = new PrimitiveArrayPool.PoolConfig();
        poolConfig2.type = 2;
        poolConfig2.numberOfPools = 20;
        poolConfig2.poolSize = 2;
        poolConfig2.poolEntryLife = 300000;
        poolConfig2.scanFrequency = 60000;
        this.longArrayPool = new PrimitiveArrayPool(poolConfig2, this.cacheName);
        this.htEntryPool = new HashtableEntryObjectPool(200);
        this.resultPool = new ResultObjectPool(10);
        this.minDiskCacheSizeInBytes = this.calculateMinCacheSizeInBytes();
        this.rand = new Random(System.currentTimeMillis());
    }

    public HTODDynacache(String string, String string2, DCache dCache, CacheOnDisk cacheOnDisk) throws IOException, ClassNotFoundException, FileManagerException {
        this.dirname = string;
        this.filename = string2;
        this.cache = dCache;
        this.cod = cacheOnDisk;
        this.cacheName = dCache.getCacheName();
        this.delayOffload = cacheOnDisk.delayOffload;
        this.disableDependencyId = cacheOnDisk.disableDependencyId;
        this.disableTemplatesSupport = cacheOnDisk.disableTemplatesSupport;
        PrimitiveArrayPool.PoolConfig poolConfig = new PrimitiveArrayPool.PoolConfig();
        poolConfig.type = 1;
        poolConfig.numberOfPools = cacheOnDisk.numberOfPools;
        poolConfig.poolSize = cacheOnDisk.poolSize;
        poolConfig.poolEntryLife = cacheOnDisk.poolEntryLife;
        poolConfig.scanFrequency = 60000;
        this.byteArrayPool = new PrimitiveArrayPool(poolConfig, this.cacheName);
        PrimitiveArrayPool.PoolConfig poolConfig2 = new PrimitiveArrayPool.PoolConfig();
        poolConfig2.type = 2;
        poolConfig2.numberOfPools = cacheOnDisk.numberOfPools;
        poolConfig2.poolSize = cacheOnDisk.poolSize;
        poolConfig2.poolEntryLife = cacheOnDisk.poolEntryLife;
        poolConfig2.scanFrequency = 60000;
        this.longArrayPool = new PrimitiveArrayPool(poolConfig2, this.cacheName);
        this.htEntryPool = new HashtableEntryObjectPool(200);
        this.invalidationBuffer = new HTODInvalidationBuffer(this.cod);
        this.init_files();
        if (this.delayOffload) {
            if (!this.disableDependencyId) {
                this.auxDataDependencyTable = new HTODDependencyTable(1, 1000, cacheOnDisk.delayOffloadDepIdBuckets, 2, cacheOnDisk.delayOffloadEntriesLimit, this);
            }
            if (!this.disableTemplatesSupport) {
                this.auxTemplateDependencyTable = new HTODDependencyTable(2, 100, cacheOnDisk.delayOffloadTemplateBuckets, 2, cacheOnDisk.delayOffloadEntriesLimit, this);
            }
        }
        this.minDiskCacheSizeInBytes = this.calculateMinCacheSizeInBytes();
        ValueSet valueSet = this.cod.readAndDeleteInvalidationFile();
        if (valueSet != null && valueSet.size() > 0) {
            this.invalidationBuffer.add(valueSet, 2, 1, 5, false, true, false);
            this.cod.startState = 2;
            valueSet.clear();
            valueSet = null;
        }
        if (this.cod.currentCacheSizeInBytes == 0L && this.getCacheIdsSize() == 0) {
            this.cod.currentCacheSizeInBytes = this.minDiskCacheSizeInBytes;
        }
        this.resultPool = new ResultObjectPool(10);
        this.rand = new Random(System.currentTimeMillis());
    }

    protected void init_files() throws IOException, ClassNotFoundException, FileManagerException {
        this.initFileManager();
        this.object_cache = HashtableOnDisk.getInstance(this.object_filemgr, this.auto_rehash, 0L, true, this);
        if (this.object_cache == null) {
            HashtableOnDisk.createInstance(this.object_filemgr, this.cod.dataHashtableSize, this.hashtable_threshold);
            this.cod.dataGB = 1;
            this.cod.dataFiles = 1;
            this.object_cache = HashtableOnDisk.getInstance(this.object_filemgr, this.auto_rehash, 0L, true, this);
        }
        if (!this.disableDependencyId) {
            this.dependency_cache = HashtableOnDisk.getInstance(this.dependency_filemgr, this.auto_rehash, 0L, false, this);
            if (this.dependency_cache == null) {
                HashtableOnDisk.createInstance(this.dependency_filemgr, this.cod.depIdHashtableSize, this.hashtable_threshold);
                this.cod.dependencyIdGB = 1;
                this.cod.dependencyIdFiles = 1;
                this.dependency_cache = HashtableOnDisk.getInstance(this.dependency_filemgr, this.auto_rehash, 0L, false, this);
            }
        } else {
            this.cod.dependencyIdGB = 0;
            this.cod.dependencyIdFiles = 0;
        }
        if (!this.disableTemplatesSupport) {
            this.template_cache = HashtableOnDisk.getInstance(this.template_filemgr, this.auto_rehash, 0L, false, this);
            if (this.template_cache == null) {
                HashtableOnDisk.createInstance(this.template_filemgr, this.cod.templateHashtableSize, this.hashtable_threshold);
                this.cod.templateGB = 1;
                this.cod.templateFiles = 1;
                this.template_cache = HashtableOnDisk.getInstance(this.template_filemgr, this.auto_rehash, 0L, false, this);
            }
        } else {
            this.cod.templateGB = 0;
            this.cod.templateFiles = 0;
        }
    }

    void initFileManager() throws IOException, FileManagerException {
        this.object_filemgr = new FileManagerImpl(this.filename + object_suffix + ".htod", false, "rw", this.physical_disk_manager, this);
        if (!this.disableDependencyId) {
            this.dependency_filemgr = new FileManagerImpl(this.filename + dependency_suffix + ".htod", false, "rw", this.physical_disk_manager, this);
        }
        if (!this.disableTemplatesSupport) {
            this.template_filemgr = new FileManagerImpl(this.filename + template_suffix + ".htod", false, "rw", this.physical_disk_manager, this);
        }
    }

    public void initializeEvictionTable() {
        this.evictionEntryPool = new EvictionEntryPool(500);
        this.EvictionTable = new BinaryHeap(new EvictionTableEntry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            this.readWriteLock.preWrite();
            this.closeNoRWLock();
            this.readWriteLock.postWrite();
        }
        if (this.deleteDiskFiles) {
            this.deleteDiskCacheFiles();
            this.deleteDiskFiles = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeNoRWLock() {
        this.cod.diskCacheSizeInfo.allowOverflow = true;
        try {
            this.object_cache.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.closeNoRWLock", "309", this);
            this.traceDebug("closeNoRWLock()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
        }
        try {
            if (!this.disableDependencyId) {
                this.dependency_cache.close();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.closeNoRWLock", "315", this);
            this.traceDebug("closeNoRWLock()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
        }
        try {
            if (!this.disableTemplatesSupport) {
                this.template_cache.close();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.closeNoRWLock", "321", this);
            this.traceDebug("closeNoRWLock()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
        }
        try {
            this.object_filemgr.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.closeNoRWLock", "327", this);
            this.traceDebug("closeNoRWLock()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
        }
        try {
            if (!this.disableDependencyId) {
                this.dependency_filemgr.close();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.closeNoRWLock", "333", this);
            this.traceDebug("closeNoRWLock()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
        }
        try {
            if (!this.disableTemplatesSupport) {
                this.template_filemgr.close();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.closeNoRWLock", "339", this);
            this.traceDebug("closeNoRWLock()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
        }
        finally {
            this.cod.diskCacheSizeInfo.allowOverflow = false;
        }
    }

    public int writeAuxiliaryDepTables() {
        this.numDepIdsInAuxTable = 0;
        this.numTemplatesInAuxTable = 0;
        this.numCacheIdsInDepIdAuxTable = 0;
        this.numCacheIdsInTemplateAuxTable = 0;
        this.numExplicitBufferLimitOnStop = 0;
        int n = 0;
        if (this.cod.valueSet == null) {
            this.cod.valueSet = new ValueSet(16);
        }
        if (this.delayOffload) {
            int n2;
            ValueSet valueSet;
            Object e2;
            Enumeration enumeration;
            long l = System.currentTimeMillis();
            if (!this.disableDependencyId && !this.auxDataDependencyTable.isEmpty()) {
                enumeration = this.auxDataDependencyTable.getKeys();
                while (enumeration.hasMoreElements()) {
                    e2 = enumeration.nextElement();
                    if (!this.auxDataDependencyTable.isUpdated(e2)) continue;
                    valueSet = this.auxDataDependencyTable.getEntries(e2);
                    if (valueSet != null && valueSet.size() > 0) {
                        this.numCacheIdsInDepIdAuxTable += valueSet.size();
                    }
                    n = this.writeValueSet(2, e2, valueSet, true);
                    this.cache.getCacheStatisticsListener().depIdsOffloadedToDisk(e2);
                    if (n == 1) {
                        return n;
                    }
                    if (n == 2) {
                        n2 = valueSet.size();
                        this.traceDebug("writeAuxiliaryDepTables()", "cacheName=" + this.cache.getCacheName() + " depid=" + e2 + " disk overflow size=" + n2);
                        if (n2 > 0) {
                            if (this.cod.valueSet == null) {
                                if (n2 < 16) {
                                    n2 = 16;
                                }
                                this.cod.valueSet = new ValueSet(n2);
                            }
                            this.cod.valueSet.union(valueSet);
                        }
                    }
                    ++this.numDepIdsInAuxTable;
                }
                this.auxDataDependencyTable.clear();
            }
            if (!this.disableTemplatesSupport && !this.auxTemplateDependencyTable.isEmpty()) {
                enumeration = this.auxTemplateDependencyTable.getKeys();
                while (enumeration.hasMoreElements()) {
                    e2 = enumeration.nextElement();
                    if (!this.auxTemplateDependencyTable.isUpdated(e2)) continue;
                    valueSet = this.auxTemplateDependencyTable.getEntries(e2);
                    if (valueSet != null && valueSet.size() > 0) {
                        this.numCacheIdsInTemplateAuxTable += valueSet.size();
                    }
                    n = this.writeValueSet(3, e2, valueSet, true);
                    this.cache.getCacheStatisticsListener().templatesOffloadedToDisk(e2);
                    if (n == 1) {
                        return n;
                    }
                    if (n == 2) {
                        n2 = valueSet.size();
                        this.traceDebug("writeAuxiliaryDepTables()", "cacheName=" + this.cache.getCacheName() + " template=" + e2 + " disk overflow size=" + n2);
                        if (n2 > 0) {
                            if (this.cod.valueSet == null) {
                                if (n2 < 16) {
                                    n2 = 16;
                                }
                                this.cod.valueSet = new ValueSet(n2);
                            }
                            this.cod.valueSet.union(valueSet);
                        }
                    }
                    ++this.numTemplatesInAuxTable;
                }
                this.auxTemplateDependencyTable.clear();
            }
            this.timeElapsedWriteAuxTables = System.currentTimeMillis() - l;
            if (this.cod.valueSet != null && this.cod.valueSet.size() > 0) {
                this.numExplicitBufferLimitOnStop = this.cod.valueSet.size();
                if (this.cod.explicitBufferLimitOnStop > 0 && this.cod.valueSet.size() > this.cod.explicitBufferLimitOnStop) {
                    this.deleteDiskFiles = true;
                } else {
                    this.cod.createInvalidationFile();
                }
                this.cod.valueSet.clear();
                this.cod.valueSet = null;
            }
        }
        return n;
    }

    public void dump_object_statistics() {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            outputStreamWriter.write("========================================================================");
            outputStreamWriter.write("------------------ Object File Manager Statistics ---------------\n");
            this.object_filemgr.dump_stats(outputStreamWriter, true);
            outputStreamWriter.write("------------------ Object HTOD Statistics ---------------\n");
            this.object_cache.dump_htod_stats(outputStreamWriter, true);
            outputStreamWriter.write("========================================================================");
            if (!this.disableDependencyId) {
                outputStreamWriter.write("========================================================================");
                outputStreamWriter.write("------------------ Dependency File Manager Statistics ---------------\n");
                this.dependency_filemgr.dump_stats(outputStreamWriter, true);
                outputStreamWriter.write("------------------ Dependency HTOD Statistics ---------------\n");
                this.dependency_cache.dump_htod_stats(outputStreamWriter, true);
                outputStreamWriter.write("========================================================================");
            }
            if (!this.disableTemplatesSupport) {
                outputStreamWriter.write("========================================================================");
                outputStreamWriter.write("------------------ Template File Manager Statistics ---------------\n");
                this.template_filemgr.dump_stats(outputStreamWriter, true);
                outputStreamWriter.write("------------------ Template HTOD Statistics ---------------\n");
                this.template_cache.dump_htod_stats(outputStreamWriter, true);
                outputStreamWriter.write("========================================================================");
            }
            outputStreamWriter.flush();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.dump_object_statistics", "376", this);
            this.traceDebug("dump_object_statistics()", "cacheName=" + this.cache.getCacheName() + "\nException: " + ExceptionUtility.getStackTrace(throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clearDiskCache() {
        int n = 0;
        Exception exception = null;
        try {
            this.invalidationBuffer.setDiskClearInProgress(true);
            if (this.delayOffload) {
                if (!this.disableDependencyId) {
                    this.auxDataDependencyTable.clear();
                }
                if (!this.disableTemplatesSupport) {
                    this.auxTemplateDependencyTable.clear();
                }
            }
            this.stop(true);
            ReadWriteLock readWriteLock = this.readWriteLock;
            synchronized (readWriteLock) {
                block26: {
                    this.readWriteLock.preWrite();
                    try {
                        this.closeNoRWLock();
                        this.deleteDiskCacheFiles();
                        this.cod.diskCacheSizeInfo.reset();
                        this.init_files();
                        this.cod.enableCacheSizeInBytes = true;
                        this.cod.currentCacheSizeInBytes = this.minDiskCacheSizeInBytes;
                        if (this.cod.diskCacheSizeInfo.diskCacheSizeInGBLimit > 0) {
                            this.cache.setEnableDiskCacheSizeInBytesChecking(true);
                        }
                        this.diskCacheSizeAdjustment = 0;
                        if (this.cod.evictionPolicy == 0) break block26;
                        Object object = this.evictionTableMonitor;
                        synchronized (object) {
                            this.EvictionTable.clear();
                        }
                    }
                    catch (FileManagerException fileManagerException) {
                        this.diskCacheException = fileManagerException;
                        exception = fileManagerException;
                        n = 1;
                    }
                    catch (HashtableOnDiskException hashtableOnDiskException) {
                        this.diskCacheException = hashtableOnDiskException;
                        exception = hashtableOnDiskException;
                        n = 1;
                    }
                    catch (IOException iOException) {
                        this.diskCacheException = iOException;
                        exception = iOException;
                        n = 1;
                    }
                    catch (Exception exception2) {
                        n = 3;
                        exception = exception2;
                    }
                    finally {
                        if (n != 0) {
                            this.traceDebug("clearDiskCache()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n == 1 || n == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.clearDiskCache", "525", this);
                        }
                        this.readWriteLock.postWrite();
                    }
                }
            }
        }
        finally {
            this.invalidationBuffer.setDiskClearInProgress(false);
        }
        return n;
    }

    public void stop(boolean bl) {
        this.processCompleteClear = bl;
        if (this.invalidationBuffer.isBackgroundInvalidationInProgress()) {
            this.invalidationBuffer.setLoopOnce(true);
            if (this.invalidationBuffer.isCleanupPending()) {
                this.invalidationBuffer.resetCleanupPending();
            }
            this.cod.waitForCleanupComplete();
        }
        if (bl) {
            this.invalidationBuffer.clear(2);
            this.invalidationBuffer.clear(1);
            this.invalidationBuffer.clear(3);
        } else {
            this.invalidationBuffer.clear(1);
            this.invalidationBuffer.clear(3);
            this.cod.valueSet = this.invalidationBuffer.getAndRemoveFromExplicitBuffer();
            if (this.cod.valueSet != null && this.cod.valueSet.size() > 0) {
                this.traceDebug("stop()", "cacheName=" + this.cache.getCacheName() + " offload explicit buffer size=" + this.cod.valueSet.size());
            }
        }
        this.diskCacheSizeAdjustment = 0;
    }

    public void invokeDiskCleanup(boolean bl) {
        if (bl || this.invalidationBuffer.size() > 0) {
            this.invalidationBuffer.invokeBackgroundInvalidation(bl);
        }
    }

    public void deleteDiskCacheFiles() {
        this.cod.deleteDiskCacheFiles();
    }

    public void delCacheEntry(CacheEntry cacheEntry, int n, int n2, boolean bl) {
        this.invalidationBuffer.add(cacheEntry.id, 2, n, n2, bl, false, false);
        for (int i = 0; i < cacheEntry.aliasList.length; ++i) {
            this.invalidationBuffer.add(cacheEntry.aliasList[i], 2, n, n2, bl, false, true);
        }
    }

    public void delCacheEntry(ValueSet valueSet, int n, int n2, boolean bl, boolean bl2) {
        if (valueSet != null && valueSet.size() > 0) {
            this.invalidationBuffer.add(valueSet, 2, n, n2, bl, bl2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Result delCacheEntry(Object object, int n) {
        Object object2;
        int n2;
        Result result = this.getFromResultPool();
        HashtableEntry hashtableEntry = null;
        EvictionTableEntry evictionTableEntry = null;
        boolean bl = false;
        if (n == 2) {
            if (object instanceof ExplicitIdData) {
                n2 = ((ExplicitIdData)object).info;
                object = ((ExplicitIdData)object).id;
                result.cause = n2 & 0xF;
                result.source = (n2 & 0x10) == 0 ? 5 : 2;
                result.bFromDepIdTemplateInvalidation = (n2 & 0x40) != 0;
                bl = (n2 & 0xFFFFFF80) != 0;
            } else {
                this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.getCacheName() + " *** ERROR *** id is not ExplicitIdData");
                this.invalidationBuffer.remove(object, n);
                object = null;
            }
        } else if (n == 3) {
            if (object instanceof EvictionTableEntry) {
                evictionTableEntry = (EvictionTableEntry)object;
                result.cause = System.currentTimeMillis() > evictionTableEntry.expirationTime ? 3 : 7;
                result.source = 5;
                bl = true;
            }
        } else {
            bl = true;
            result.cause = 3;
            result.source = 5;
        }
        if (bl && this.cache.isEnableListener() && this.cache.getEventSource().getPreInvalidationListenerCount() > 0 && n != 2) {
            block95: {
                if (evictionTableEntry != null) {
                    try {
                        try {
                            object = this.object_cache.getCacheKey(evictionTableEntry);
                            result.returnCode = 0;
                        }
                        catch (FileManagerException fileManagerException) {
                            this.diskCacheException = fileManagerException;
                            result.diskException = fileManagerException;
                            result.returnCode = 1;
                            object2 = null;
                            if (result.returnCode == 1 || result.returnCode == 3) {
                                FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "655", this);
                            }
                            if (result.returnCode != 0) {
                                this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                                this.invalidationBuffer.remove(evictionTableEntry, n);
                                return result;
                            }
                            break block95;
                        }
                        catch (HashtableOnDiskException hashtableOnDiskException) {
                            this.diskCacheException = hashtableOnDiskException;
                            result.diskException = hashtableOnDiskException;
                            result.returnCode = 1;
                            object2 = null;
                            if (result.returnCode == 1 || result.returnCode == 3) {
                                FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "655", this);
                            }
                            if (result.returnCode != 0) {
                                this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                                this.invalidationBuffer.remove(evictionTableEntry, n);
                                return result;
                            }
                            break block95;
                        }
                        catch (IOException iOException) {
                            this.diskCacheException = iOException;
                            result.diskException = iOException;
                            result.returnCode = 1;
                            object2 = null;
                            if (result.returnCode == 1 || result.returnCode == 3) {
                                FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "655", this);
                            }
                            if (result.returnCode != 0) {
                                this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                                this.invalidationBuffer.remove(evictionTableEntry, n);
                                return result;
                            }
                            break block95;
                        }
                        catch (Exception exception) {
                            result.returnCode = 3;
                            result.diskException = exception;
                            object2 = null;
                            if (result.returnCode == 1 || result.returnCode == 3) {
                                FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "655", this);
                            }
                            if (result.returnCode != 0) {
                                this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                                this.invalidationBuffer.remove(evictionTableEntry, n);
                                return result;
                            }
                        }
                        object2 = null;
                        if (result.returnCode == 1 || result.returnCode == 3) {
                            FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "655", this);
                        }
                        if (result.returnCode != 0) {
                            this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                            this.invalidationBuffer.remove(evictionTableEntry, n);
                            return result;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        if (result.returnCode == 1 || result.returnCode == 3) {
                            FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "655", this);
                        }
                        if (result.returnCode == 0) throw throwable;
                        this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                        this.invalidationBuffer.remove(evictionTableEntry, n);
                        return result;
                    }
                }
            }
            if (!this.cache.getEventSource().shouldInvalidate(object, result.source, result.cause)) {
                if (n == 3) {
                    this.EvictionTable.insert(evictionTableEntry);
                    this.invalidationBuffer.remove(evictionTableEntry, n);
                } else {
                    this.invalidationBuffer.remove(object, n);
                    if (this.cod.diskCachePerformanceLevel == 3 && result.cause == 3) {
                        this.cod.cache.addToTimeLimitDaemon(object, System.currentTimeMillis(), -1);
                    }
                }
                this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.getCacheName() + " Skipping invalidate for id=" + object + " source=" + result.source + " cause=" + result.cause);
                return result;
            }
            if (n == 3) {
                object = evictionTableEntry;
            }
        }
        n2 = 0;
        if (bl && this.cache.isEnableListener() && this.cache.getEventSource().getInvalidationListenerCount() > 0 && !this.cod.ignoreValueInInvalidationEvent) {
            n2 = 1;
        }
        if (object != null) {
            Object object3 = this.readWriteLock;
            // MONITORENTER : object3
            try {
                this.readWriteLock.preWrite();
                if (this.invalidationBuffer.isLoopOnce()) {
                    object2 = result;
                    return object2;
                }
                hashtableEntry = this.object_cache.getAndRemove(object, n2 != 0);
                if (hashtableEntry != null) {
                    this.diskCacheSizeAdjustment = 1;
                    if (n != 3 && this.cod.evictionPolicy != 0) {
                        object2 = this.evictionTableMonitor;
                        // MONITORENTER : object2
                        long l = hashtableEntry.expirationTime();
                        if (l <= 0L) {
                            l = Long.MAX_VALUE;
                        }
                        evictionTableEntry = this.EvictionTable.findAndRemove(l, hashtableEntry.getKey().hashCode(), hashtableEntry.size());
                        // MONITOREXIT : object2
                    }
                    result.data = n == 3 ? hashtableEntry.getKey() : object;
                    result.numDelete = 1;
                    this.deletedSize = hashtableEntry.size() > 0 ? (this.deletedSize += (long)hashtableEntry.size()) : (this.deletedSize += (long)hashtableEntry.valueLength());
                    if (this.cod.enableCacheSizeInBytes) {
                        this.cod.currentCacheSizeInBytes -= (long)hashtableEntry.size();
                    }
                    this.cache.getCacheStatisticsListener().deleteEntryFromDisk(object, hashtableEntry.size());
                }
            }
            catch (FileManagerException fileManagerException) {
                this.diskCacheException = fileManagerException;
                result.diskException = fileManagerException;
                result.returnCode = 1;
            }
            catch (HashtableOnDiskException hashtableOnDiskException) {
                this.diskCacheException = hashtableOnDiskException;
                result.diskException = hashtableOnDiskException;
                result.returnCode = 1;
            }
            catch (IOException iOException) {
                this.diskCacheException = iOException;
                result.diskException = iOException;
                result.returnCode = 1;
            }
            catch (Exception exception) {
                result.returnCode = 3;
                result.diskException = exception;
            }
            finally {
                if (result.returnCode != 0) {
                    this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                }
                if (result.returnCode == 1 || result.returnCode == 3) {
                    FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "700", this);
                }
                this.readWriteLock.postWrite();
            }
            // MONITOREXIT : object3
            if (hashtableEntry != null) {
                object3 = null;
                object2 = hashtableEntry.getValue();
                if (object2 != null) {
                    try {
                        object3 = (CacheEntry)SerializationUtility.deserialize((byte[])object2);
                    }
                    catch (Exception exception) {
                        result.returnCode = 4;
                        result.diskException = exception;
                        this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "718", this);
                    }
                }
                if (object3 != null) {
                    int n3;
                    Object object4 = this.cache;
                    // MONITORENTER : object4
                    if (this.invalidationBuffer.isLoopOnce() && this.processCompleteClear) {
                        this.diskCacheSizeAdjustment = 0;
                        // MONITOREXIT : object4
                        return result;
                    }
                    if (((CacheEntry)object3)._dataIds != null) {
                        for (n3 = 0; n3 < ((CacheEntry)object3)._dataIds.length; ++n3) {
                            result.returnCode = this.delDependencyEntry(((CacheEntry)object3)._dataIds[n3], ((CacheEntry)object3).id);
                            if (result.returnCode != 1) continue;
                            // MONITOREXIT : object4
                            return result;
                        }
                    }
                    if (((CacheEntry)object3)._templates != null) {
                        for (n3 = 0; n3 < ((CacheEntry)object3)._templates.length; ++n3) {
                            result.returnCode = this.delTemplateEntry(((CacheEntry)object3)._templates[n3], ((CacheEntry)object3).id);
                            if (result.returnCode != 1) continue;
                            // MONITOREXIT : object4
                            return result;
                        }
                    }
                    for (n3 = 0; n3 < ((CacheEntry)object3).aliasList.length; ++n3) {
                        ReadWriteLock readWriteLock = this.readWriteLock;
                        // MONITORENTER : readWriteLock
                        try {
                            this.readWriteLock.preWrite();
                            this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.getCacheName() + " deleting alias with id= " + ((CacheEntry)object3).id + " alias=" + ((CacheEntry)object3).aliasList[n3]);
                            this.object_cache.remove(((CacheEntry)object3).aliasList[n3]);
                            if (n == 2) {
                                this.invalidationBuffer.remove(((CacheEntry)object3).aliasList[n3], 2);
                            }
                            ++result.numDelete;
                        }
                        catch (FileManagerException fileManagerException) {
                            this.diskCacheException = fileManagerException;
                            result.diskException = fileManagerException;
                            result.returnCode = 1;
                        }
                        catch (HashtableOnDiskException hashtableOnDiskException) {
                            this.diskCacheException = hashtableOnDiskException;
                            result.diskException = hashtableOnDiskException;
                            result.returnCode = 1;
                        }
                        catch (IOException fileManagerException) {
                            this.diskCacheException = fileManagerException;
                            result.diskException = fileManagerException;
                            result.returnCode = 1;
                        }
                        catch (Exception hashtableOnDiskException) {
                            result.returnCode = 3;
                            result.diskException = hashtableOnDiskException;
                        }
                        finally {
                            if (result.returnCode != 0) {
                                this.traceDebug("delCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                            }
                            if (result.returnCode == 1 || result.returnCode == 3) {
                                FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.delCacheEntry", "700", this);
                            }
                            this.readWriteLock.postWrite();
                        }
                        // MONITOREXIT : readWriteLock
                    }
                    // MONITOREXIT : object4
                    if (((CacheEntry)object3).sharingPolicy == 4 || ((CacheEntry)object3).sharingPolicy == 3) {
                        if (n == 2) {
                            if (result.source == 5 && result.bFromDepIdTemplateInvalidation) {
                                this.cache.invalidateById(((CacheEntry)object3).id, result.cause, result.source, false, false);
                            }
                        } else {
                            this.cache.invalidateById(((CacheEntry)object3).id, result.cause, result.source, false, false);
                        }
                    }
                    if (bl && this.cache.isEnableListener() && this.cache.getEventSource().getInvalidationListenerCount() > 0) {
                        object2 = null;
                        if (!this.cod.ignoreValueInInvalidationEvent && (object2 = (Object)hashtableEntry.getSerializedCacheValue()) == null) {
                            object2 = ((CacheEntry)object3).serializedValue;
                        }
                        object4 = null;
                        object4 = result.cause == 7 ? new InvalidationEvent(((CacheEntry)object3).id, object2, 7, 1, this.cache.getCacheNameNonPrefixed()) : new InvalidationEvent(((CacheEntry)object3).id, object2, 4, 1, this.cache.getCacheNameNonPrefixed());
                        this.cache.getEventSource().fireEvent((InvalidationEvent)object4);
                    }
                    this.returnToHashtableEntryPool(hashtableEntry);
                    if (this.cache.getCachePerf().isPMIEnabled()) {
                        object4 = "";
                        if (((CacheEntry)object3)._templates != null && ((CacheEntry)object3)._templates.length > 0) {
                            object4 = ((CacheEntry)object3)._templates[0];
                        }
                        this.cache.getCachePerf().onInvalidate((String)object4, result.cause, 3, result.source);
                    }
                    this.cache.getCacheStatisticsListener().remove(((CacheEntry)object3).id, result.cause, 3, result.source);
                    ((CacheEntry)object3).reset();
                }
            }
        }
        this.diskCacheSizeAdjustment = 0;
        this.invalidationBuffer.remove(object, n);
        return result;
    }

    public int delDependency(Object object) {
        int n = 0;
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                this.auxDataDependencyTable.removeDependency(object);
            }
            n = this.delValueSet(2, object);
        }
        return n;
    }

    public int delTemplate(String string) {
        int n = 0;
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                this.auxTemplateDependencyTable.removeDependency(string);
            }
            n = this.delValueSet(3, string);
        }
        return n;
    }

    public int delDependencyEntry(Object object, Object object2) {
        int n = 0;
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                Result result = this.auxDataDependencyTable.removeEntry(object, object2);
                n = result.returnCode;
                if (!result.bExist && n != 1) {
                    n = this.delValueSetEntry(2, object, object2);
                }
            } else {
                n = this.delValueSetEntry(2, object, object2);
            }
        }
        return n;
    }

    public int delTemplateEntry(String string, Object object) {
        int n = 0;
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                Result result = this.auxTemplateDependencyTable.removeEntry(string, object);
                n = result.returnCode;
                if (!result.bExist && n != 1) {
                    n = this.delValueSetEntry(3, string, object);
                }
            } else {
                n = this.delValueSetEntry(3, string, object);
            }
        }
        return n;
    }

    public Result readCacheEntry(Object object) {
        return this.readCacheEntry(object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result readCacheEntry(Object object, boolean bl) {
        Object object2;
        Object object3;
        boolean bl2;
        HashtableEntry hashtableEntry;
        CacheEntry cacheEntry;
        Result result;
        block52: {
            result = this.getFromResultPool();
            cacheEntry = null;
            if (this.invalidationBuffer.contains(object)) {
                return result;
            }
            hashtableEntry = null;
            bl2 = true;
            if (this.cache.isEnableListener() && this.cache.getEventSource().getInvalidationListenerCount() > 0 && !this.cod.ignoreValueInInvalidationEvent) {
                bl2 = false;
            }
            object3 = null;
            try {
                this.readWriteLock.preRead();
                hashtableEntry = this.object_cache.getHashTableEntry(object, bl2);
            }
            catch (FileManagerException fileManagerException) {
                this.diskCacheException = fileManagerException;
                result.diskException = fileManagerException;
                result.returnCode = 1;
                return result.returnCode;
            }
            catch (HashtableOnDiskException hashtableOnDiskException) {
                this.diskCacheException = hashtableOnDiskException;
                result.diskException = hashtableOnDiskException;
                result.returnCode = 1;
                return result.returnCode;
            }
            catch (IOException iOException) {
                this.diskCacheException = iOException;
                result.diskException = iOException;
                result.returnCode = 1;
                return result.returnCode;
            }
            catch (Exception exception) {
                result.returnCode = 3;
                result.diskException = exception;
                return result.diskException;
            }
            finally {
                this.readWriteLock.postRead();
                if (result.returnCode != 0) {
                    this.traceDebug("readCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                }
                if (result.returnCode != 1 && result.returnCode != 3) break block52;
                FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readCacheEntry", "916", this);
                return result;
            }
        }
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        Object object4 = object;
        if (hashtableEntry != null) {
            block53: {
                if (hashtableEntry.isAliasId()) {
                    bl4 = true;
                    object4 = object3 = hashtableEntry.getValue();
                    this.traceDebug("readCacheEntry()", "cacheName=" + this.cache.getCacheName() + " found alias=" + object + " cacheId=" + object4);
                    this.returnToHashtableEntryPool(hashtableEntry);
                    try {
                        this.readWriteLock.preRead();
                        if (this.invalidationBuffer.contains(object4)) {
                            Result result2 = result;
                            return result2;
                        }
                        hashtableEntry = this.object_cache.getHashTableEntry(object4, bl2);
                    }
                    catch (FileManagerException fileManagerException) {
                        this.diskCacheException = fileManagerException;
                        result.diskException = fileManagerException;
                        result.returnCode = 1;
                        return result.returnCode;
                    }
                    catch (HashtableOnDiskException hashtableOnDiskException) {
                        this.diskCacheException = hashtableOnDiskException;
                        result.diskException = hashtableOnDiskException;
                        result.returnCode = 1;
                        return result.returnCode;
                    }
                    catch (IOException iOException) {
                        this.diskCacheException = iOException;
                        result.diskException = iOException;
                        result.returnCode = 1;
                        return result.returnCode;
                    }
                    catch (Exception exception) {
                        result.returnCode = 3;
                        result.diskException = exception;
                        return result.diskException;
                    }
                    finally {
                        this.readWriteLock.postRead();
                        if (result.returnCode != 0) {
                            this.traceDebug("readCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                        }
                        if (result.returnCode != 1 && result.returnCode != 3) break block53;
                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readCacheEntry", "916", this);
                        return result;
                    }
                }
            }
            if (hashtableEntry != null) {
                if (hashtableEntry.isExpired()) {
                    bl3 = true;
                    if (bl2) {
                        if (this.cache.isEnableListener() && this.cache.getEventSource().getInvalidationListenerCount() > 0) {
                            object2 = new InvalidationEvent(object4, null, 4, 1, this.cache.getCacheNameNonPrefixed());
                            if (!this.invalidationBuffer.contains(object4)) {
                                this.cache.getEventSource().fireEvent((InvalidationEvent)object2);
                            }
                        }
                        this.invalidationBuffer.add(object4, 2, 3, 5, false, false, false);
                        if (bl4) {
                            this.invalidationBuffer.add(object, 2, 3, 5, false, false, true);
                        }
                        if (this.cod.diskCachePerformanceLevel != 3 && !bl) {
                            this.cache.internalInvalidateByDepId(object4, 3, 5, true);
                        }
                        this.returnToHashtableEntryPool(hashtableEntry);
                        return result;
                    }
                }
                object3 = hashtableEntry.getValue();
                n = hashtableEntry.size();
                if (object3 != null) {
                    try {
                        cacheEntry = (CacheEntry)SerializationUtility.deserialize((byte[])object3);
                        object2 = hashtableEntry.getSerializedCacheValue();
                        if (object2 != null) {
                            cacheEntry.serializedValue = object2;
                        }
                    }
                    catch (Exception exception) {
                        result.returnCode = 4;
                        result.diskException = exception;
                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readCacheEntry", "953", this);
                        this.traceDebug("readCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                    }
                    finally {
                        this.returnToHashtableEntryPool(hashtableEntry);
                    }
                }
            }
        }
        if (cacheEntry != null) {
            if (bl3) {
                if (this.cache.isEnableListener() && this.cache.getEventSource().getInvalidationListenerCount() > 0) {
                    object2 = new InvalidationEvent(cacheEntry.id, cacheEntry.serializedValue, 4, 1, this.cache.getCacheNameNonPrefixed());
                    if (!this.invalidationBuffer.contains(cacheEntry.id)) {
                        this.cache.getEventSource().fireEvent((InvalidationEvent)object2);
                    }
                }
                this.invalidationBuffer.add(cacheEntry.id, 2, 3, 5, false, false, false);
                for (int i = 0; i < cacheEntry.aliasList.length; ++i) {
                    this.invalidationBuffer.add(cacheEntry.aliasList[i], 2, 3, 5, false, false, true);
                }
                if (this.cod.diskCachePerformanceLevel != 3 && !bl) {
                    this.cache.internalInvalidateByDepId(cacheEntry.id, 3, 5, true);
                }
                cacheEntry = null;
            } else if (!bl && cacheEntry.serializedValue != null) {
                this.cache.getCacheStatisticsListener().readEntryFromDisk(cacheEntry.id, n);
            }
        }
        result.data = cacheEntry;
        return result;
    }

    public Result readDependency(Object object, boolean bl) {
        Result result = this.getFromResultPool();
        ValueSet valueSet = null;
        if (object == null) {
            return result;
        }
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                valueSet = this.auxDataDependencyTable.getEntries(object);
                if (valueSet == null) {
                    Result result2 = this.readValueSet(2, object, bl);
                    result.copy(result2);
                    this.returnToResultPool(result2);
                    if (result.returnCode != 1 && (valueSet = (ValueSet)result.data) != null && !bl && valueSet.size() <= this.auxDataDependencyTable.delayOffloadEntriesLimit) {
                        result.returnCode = this.auxDataDependencyTable.add(object, valueSet);
                    }
                } else if (bl) {
                    this.auxDataDependencyTable.removeDependency(object);
                    result.returnCode = this.delValueSet(2, object);
                }
            } else {
                Result result3 = this.readValueSet(2, object, bl);
                result.copy(result3);
                this.returnToResultPool(result3);
                valueSet = (ValueSet)result.data;
            }
            if (result.returnCode != 1 && valueSet != null) {
                this.invalidationBuffer.filter(valueSet);
            }
            result.data = valueSet;
        }
        return result;
    }

    public Result readTemplate(String string, boolean bl) {
        Result result = this.getFromResultPool();
        ValueSet valueSet = null;
        if (string == null) {
            return result;
        }
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                valueSet = this.auxTemplateDependencyTable.getEntries(string);
                if (valueSet == null) {
                    Result result2 = this.readValueSet(3, string, bl);
                    result.copy(result2);
                    this.returnToResultPool(result2);
                    if (result.returnCode != 1 && (valueSet = (ValueSet)result.data) != null && !bl && valueSet.size() <= this.auxTemplateDependencyTable.delayOffloadEntriesLimit) {
                        result.returnCode = this.auxTemplateDependencyTable.add((Object)string, valueSet);
                    }
                } else if (bl) {
                    this.auxTemplateDependencyTable.removeDependency(string);
                    result.returnCode = this.delValueSet(3, string);
                }
            } else {
                Result result3 = this.readValueSet(3, string, bl);
                result.copy(result3);
                this.returnToResultPool(result3);
                valueSet = (ValueSet)result.data;
            }
            if (result.returnCode != 1 && valueSet != null) {
                this.invalidationBuffer.filter(valueSet);
            }
            result.data = valueSet;
        }
        return result;
    }

    public Result readCacheIdsByRange(int n, int n2) {
        Result result = this.readByRange(1, n, n2, true, true);
        return result;
    }

    public Result readDependencyByRange(int n, int n2) {
        Result result = this.getFromResultPool();
        if (!this.disableDependencyId) {
            Result result2 = this.readByRange(2, n, n2, false, false);
            result.copy(result2);
            this.returnToResultPool(result2);
        }
        return result;
    }

    public Result readTemplatesByRange(int n, int n2) {
        Result result = this.getFromResultPool();
        if (!this.disableDependencyId) {
            Result result2 = this.readByRange(3, n, n2, false, false);
            result.copy(result2);
            this.returnToResultPool(result2);
        }
        return result;
    }

    public int getCacheIdsSize(boolean bl) {
        return this.getCacheIdsSize();
    }

    public int getCacheIdsSize() {
        this.readWriteLock.preRead();
        int n = this.object_cache.size();
        this.readWriteLock.postRead();
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public int getDepIdsSize() {
        int n = 0;
        if (!this.disableDependencyId) {
            this.readWriteLock.preRead();
            n = this.dependency_cache.size();
            this.readWriteLock.postRead();
            if (n < 0) {
                n = 0;
            }
        }
        return n;
    }

    public int getTemplatesSize() {
        int n = 0;
        if (!this.disableTemplatesSupport) {
            this.readWriteLock.preRead();
            n = this.template_cache.size();
            this.readWriteLock.postRead();
            if (n < 0) {
                n = 0;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeCacheEntry(CacheEntry cacheEntry) {
        int n = 0;
        Exception exception = null;
        this.invalidationBuffer.remove(cacheEntry.id);
        byte[] byArray = null;
        int n2 = -1;
        try {
            cacheEntry.skipValueSerialized = true;
            byArray = SerializationUtility.serialize(cacheEntry);
            n2 = byArray.length;
        }
        catch (Exception exception2) {
            n = 4;
            FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.cache.HTODDynacache.writeCacheEntry", "1174", this);
            this.traceDebug("writeCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\nException: " + ExceptionUtility.getStackTrace(exception2));
            int n3 = n;
            return n3;
        }
        finally {
            cacheEntry.skipValueSerialized = false;
        }
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            try {
                int n4;
                this.readWriteLock.preWrite();
                int n5 = 68 + cacheEntry.serializedId.length + n2 + cacheEntry.serializedValue.length;
                if (n5 % 512 != 0) {
                    n5 = (n5 / 512 + 1) * 512;
                }
                int n6 = 0;
                HashtableEntry hashtableEntry = null;
                hashtableEntry = cacheEntry.timeLimit > 0 ? this.object_cache.put(cacheEntry.id, byArray, n2, cacheEntry.expirationTime, cacheEntry.serializedId, cacheEntry.serializedValue, false) : this.object_cache.put(cacheEntry.id, byArray, n2, -1L, cacheEntry.serializedId, cacheEntry.serializedValue, false);
                if (this.cod.evictionPolicy != 0) {
                    Object object;
                    n4 = 1;
                    if (hashtableEntry != null) {
                        if (cacheEntry.getId().hashCode() == hashtableEntry.getKey().hashCode() && cacheEntry.expirationTime == hashtableEntry.expirationTime() && n5 == hashtableEntry.size()) {
                            n4 = 0;
                        } else {
                            object = this.evictionTableMonitor;
                            synchronized (object) {
                                long l = hashtableEntry.expirationTime();
                                if (l <= 0L) {
                                    l = Long.MAX_VALUE;
                                }
                                EvictionTableEntry evictionTableEntry = this.EvictionTable.findAndRemove(l, hashtableEntry.getKey().hashCode(), hashtableEntry.size());
                            }
                        }
                    }
                    if (n4 == 1) {
                        object = (EvictionTableEntry)this.evictionEntryPool.remove();
                        ((EvictionTableEntry)object).hashcode = cacheEntry.getId().hashCode();
                        ((EvictionTableEntry)object).expirationTime = cacheEntry.expirationTime;
                        if (((EvictionTableEntry)object).expirationTime <= 0L) {
                            ((EvictionTableEntry)object).expirationTime = Long.MAX_VALUE;
                        }
                        ((EvictionTableEntry)object).size = n5;
                        Object object2 = this.evictionTableMonitor;
                        synchronized (object2) {
                            this.EvictionTable.insert((EvictionTableEntry)object);
                        }
                    }
                }
                if (hashtableEntry != null) {
                    this.traceDebug("writeCacheEntry()", "cacheName=" + this.cache.getCacheName() + " overwritten with id=" + cacheEntry.id);
                    n = 7;
                    n6 = hashtableEntry.size();
                    this.returnToHashtableEntryPool(hashtableEntry);
                }
                if (this.cod.enableCacheSizeInBytes) {
                    this.cod.currentCacheSizeInBytes = this.cod.currentCacheSizeInBytes + (long)n5 - (long)n6;
                }
                this.cache.getCacheStatisticsListener().writeEntryToDisk(cacheEntry.id, n5);
                for (n4 = 0; n4 < cacheEntry.aliasList.length; ++n4) {
                    this.traceDebug("writeCacheEntry()", "cacheName=" + this.cache.getCacheName() + " adding alias with id=" + cacheEntry.id + " alias=" + cacheEntry.aliasList[n4]);
                    this.object_cache.put(cacheEntry.aliasList[n4], cacheEntry.getIdObject(), -1, -1L, null, null, true);
                    this.invalidationBuffer.remove(cacheEntry.aliasList[n4], 2);
                }
            }
            catch (FileManagerException fileManagerException) {
                this.diskCacheException = fileManagerException;
                exception = fileManagerException;
                n = 1;
            }
            catch (HashtableOnDiskException hashtableOnDiskException) {
                this.diskCacheException = hashtableOnDiskException;
                exception = hashtableOnDiskException;
                n = 1;
            }
            catch (IOException iOException) {
                exception = iOException;
                if (iOException.getMessage().equals(DISK_CACHE_IN_GB_OVER_LIMIT_MSG)) {
                    n = 2;
                } else {
                    this.diskCacheException = iOException;
                    n = 1;
                }
            }
            catch (Exception exception3) {
                n = 3;
                exception = exception3;
            }
            finally {
                this.readWriteLock.postWrite();
                if (n != 0 && n != 7) {
                    this.traceDebug("writeCacheEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                }
                if (n == 1 || n == 3) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.writeCacheEntry", "1239", this);
                }
            }
        }
        return n;
    }

    public int writeDependency(Object object, ValueSet valueSet) {
        int n = 0;
        if (valueSet.size() == 0) {
            this.traceDebug("writeDependency()", "cacheName=" + this.cache.getCacheName() + " valueSet=0");
        }
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                ValueSet valueSet2 = this.auxDataDependencyTable.getEntries(object);
                if (valueSet2 == null) {
                    if (valueSet.size() <= this.auxDataDependencyTable.delayOffloadEntriesLimit) {
                        Result result = this.writeValueSetEntry(2, object, null, valueSet, false);
                        n = result.returnCode;
                        boolean bl = result.bComplete;
                        this.returnToResultPool(result);
                        if (n != 1 && !bl) {
                            n = this.auxDataDependencyTable.add(object, valueSet);
                        }
                    } else {
                        n = this.writeValueSet(2, object, valueSet, false);
                        this.cache.getCacheStatisticsListener().depIdsOffloadedToDisk(object);
                    }
                } else {
                    valueSet2.union(valueSet);
                    if (valueSet2.size() > this.auxDataDependencyTable.delayOffloadEntriesLimit) {
                        this.auxDataDependencyTable.removeDependency(object);
                        n = this.writeValueSet(2, object, valueSet2, true);
                        if (n != 0) {
                            valueSet.clear();
                            valueSet.addAll(valueSet2);
                        }
                        this.cache.getCacheStatisticsListener().depIdsOffloadedToDisk(object);
                    }
                }
            } else {
                n = this.writeValueSet(2, object, valueSet, false);
            }
        }
        return n;
    }

    public int writeDependencyEntry(Object object, Object object2) {
        int n = 0;
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                ValueSet valueSet = this.auxDataDependencyTable.getEntries(object);
                if (valueSet == null) {
                    Result result = this.writeValueSetEntry(2, object, object2, null, false);
                    n = result.returnCode;
                    boolean bl = result.bExist;
                    this.returnToResultPool(result);
                    if (n != 1 && n != 2 && !bl) {
                        n = this.auxDataDependencyTable.add(object, object2);
                    }
                } else {
                    n = this.auxDataDependencyTable.add(object, valueSet, object2);
                }
            } else {
                Result result = this.writeValueSetEntry(2, object, object2, null, true);
                n = result.returnCode;
                this.returnToResultPool(result);
            }
        }
        return n;
    }

    public int writeTemplate(String string, ValueSet valueSet) {
        int n = 0;
        if (valueSet.size() == 0) {
            this.traceDebug("writeTemplate()", "cacheName=" + this.cache.getCacheName() + " valueSet=0");
        }
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                ValueSet valueSet2 = this.auxTemplateDependencyTable.getEntries(string);
                if (valueSet2 == null) {
                    if (valueSet.size() <= this.auxTemplateDependencyTable.delayOffloadEntriesLimit) {
                        Result result = this.writeValueSetEntry(3, string, null, valueSet, false);
                        n = result.returnCode;
                        boolean bl = result.bComplete;
                        this.returnToResultPool(result);
                        if (n != 1 && !bl) {
                            n = this.auxTemplateDependencyTable.add((Object)string, valueSet);
                        }
                    } else {
                        n = this.writeValueSet(3, string, valueSet, false);
                        this.cache.getCacheStatisticsListener().templatesOffloadedToDisk(string);
                    }
                } else {
                    valueSet2.union(valueSet);
                    if (valueSet2.size() > this.auxTemplateDependencyTable.delayOffloadEntriesLimit) {
                        this.auxTemplateDependencyTable.removeDependency(string);
                        n = this.writeValueSet(3, string, valueSet2, true);
                        if (n != 0) {
                            valueSet.clear();
                            valueSet.addAll(valueSet2);
                        }
                        this.cache.getCacheStatisticsListener().templatesOffloadedToDisk(string);
                    }
                }
            } else {
                n = this.writeValueSet(3, string, valueSet, false);
            }
        }
        return n;
    }

    public int writeTemplateEntry(String string, Object object) {
        int n = 0;
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                ValueSet valueSet = this.auxTemplateDependencyTable.getEntries(string);
                if (valueSet == null) {
                    Result result = this.writeValueSetEntry(3, string, object, null, false);
                    n = result.returnCode;
                    boolean bl = result.bExist;
                    this.returnToResultPool(result);
                    if (n != 1 && n != 2 && !bl) {
                        n = this.auxTemplateDependencyTable.add((Object)string, object);
                    }
                } else {
                    n = this.auxTemplateDependencyTable.add(string, valueSet, object);
                }
            } else {
                Result result = this.writeValueSetEntry(3, string, object, null, true);
                n = result.returnCode;
                this.returnToResultPool(result);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    Result readValueSet(int n, Object object, boolean bl) {
        ValueSet valueSet;
        Result result;
        block79: {
            HashtableOnDisk hashtableOnDisk;
            block77: {
                block76: {
                    result = this.getFromResultPool();
                    valueSet = new ValueSet(4);
                    HashtableOnDisk hashtableOnDisk2 = null;
                    hashtableOnDisk = null;
                    if (bl) {
                        ReadWriteLock readWriteLock = this.readWriteLock;
                        synchronized (readWriteLock) {
                            block71: {
                                block69: {
                                    block68: {
                                        this.readWriteLock.preWrite();
                                        hashtableOnDisk2 = n == 2 ? this.dependency_cache : this.template_cache;
                                        Long l = (Long)hashtableOnDisk2.get(object);
                                        if (l == null) break block68;
                                        long l2 = l;
                                        FileManager fileManager = hashtableOnDisk2.getFileManager();
                                        if (l2 != -1L) {
                                            hashtableOnDisk = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, false, this);
                                            int n2 = hashtableOnDisk.size();
                                            if (n2 > 0) {
                                                valueSet = new ValueSet(n2);
                                                ValueSetReadCallback valueSetReadCallback = new ValueSetReadCallback(valueSet, null);
                                                hashtableOnDisk.iterateKeys(valueSetReadCallback, 0, n2);
                                                hashtableOnDisk.clear();
                                                hashtableOnDisk.close();
                                                hashtableOnDisk = null;
                                            }
                                            HashtableOnDisk.destroyInstance(fileManager, l2);
                                        }
                                        hashtableOnDisk2.remove(object);
                                    }
                                    Object var17_26 = null;
                                    if (result.returnCode != 0) {
                                        this.traceDebug("readValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                                    }
                                    if (result.returnCode != 1 && result.returnCode != 3) break block69;
                                    FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1432", this);
                                }
                                try {
                                    if (hashtableOnDisk != null) {
                                        hashtableOnDisk.close();
                                    }
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1439", this);
                                }
                                this.readWriteLock.postWrite();
                                {
                                    break block71;
                                    catch (FileManagerException fileManagerException) {
                                        this.diskCacheException = fileManagerException;
                                        result.diskException = fileManagerException;
                                        result.returnCode = 1;
                                        Object var17_27 = null;
                                        if (result.returnCode != 0) {
                                            this.traceDebug("readValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                                        }
                                        if (result.returnCode == 1 || result.returnCode == 3) {
                                            FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1432", this);
                                        }
                                        try {
                                            if (hashtableOnDisk != null) {
                                                hashtableOnDisk.close();
                                            }
                                        }
                                        catch (Exception exception) {
                                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1439", this);
                                        }
                                        this.readWriteLock.postWrite();
                                        break block71;
                                    }
                                    catch (HashtableOnDiskException hashtableOnDiskException) {
                                        this.diskCacheException = hashtableOnDiskException;
                                        result.diskException = hashtableOnDiskException;
                                        result.returnCode = 1;
                                        Object var17_28 = null;
                                        if (result.returnCode != 0) {
                                            this.traceDebug("readValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                                        }
                                        if (result.returnCode == 1 || result.returnCode == 3) {
                                            FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1432", this);
                                        }
                                        try {
                                            if (hashtableOnDisk != null) {
                                                hashtableOnDisk.close();
                                            }
                                        }
                                        catch (Exception exception) {
                                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1439", this);
                                        }
                                        this.readWriteLock.postWrite();
                                        break block71;
                                    }
                                    catch (IOException iOException) {
                                        this.diskCacheException = iOException;
                                        result.diskException = iOException;
                                        result.returnCode = 1;
                                        Object var17_29 = null;
                                        if (result.returnCode != 0) {
                                            this.traceDebug("readValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                                        }
                                        if (result.returnCode == 1 || result.returnCode == 3) {
                                            FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1432", this);
                                        }
                                        try {
                                            if (hashtableOnDisk != null) {
                                                hashtableOnDisk.close();
                                            }
                                        }
                                        catch (Exception exception) {
                                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1439", this);
                                        }
                                        this.readWriteLock.postWrite();
                                        break block71;
                                    }
                                    catch (Exception exception) {
                                        result.returnCode = 3;
                                        result.diskException = exception;
                                        Object var17_30 = null;
                                        if (result.returnCode != 0) {
                                            this.traceDebug("readValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                                        }
                                        if (result.returnCode == 1 || result.returnCode == 3) {
                                            FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1432", this);
                                        }
                                        try {
                                            if (hashtableOnDisk != null) {
                                                hashtableOnDisk.close();
                                            }
                                        }
                                        catch (Exception exception2) {
                                            FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1439", this);
                                        }
                                        this.readWriteLock.postWrite();
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var17_31 = null;
                                    if (result.returnCode != 0) {
                                        this.traceDebug("readValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                                    }
                                    if (result.returnCode == 1 || result.returnCode == 3) {
                                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1432", this);
                                    }
                                    try {
                                        if (hashtableOnDisk != null) {
                                            hashtableOnDisk.close();
                                        }
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1439", this);
                                    }
                                    this.readWriteLock.postWrite();
                                    throw throwable;
                                }
                            }
                        }
                    }
                    this.readWriteLock.preRead();
                    hashtableOnDisk2 = n == 2 ? this.dependency_cache : this.template_cache;
                    Long l = (Long)hashtableOnDisk2.get(object);
                    if (l == null) break block76;
                    long l3 = l;
                    FileManager fileManager = hashtableOnDisk2.getFileManager();
                    if (l3 == -1L) break block76;
                    hashtableOnDisk = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l3, false, this);
                    int n3 = hashtableOnDisk.size();
                    if (n3 <= 0) break block76;
                    valueSet = new ValueSet(n3);
                    ValueSetReadCallback valueSetReadCallback = new ValueSetReadCallback(valueSet, null);
                    hashtableOnDisk.iterateKeys(valueSetReadCallback, 0, n3);
                    hashtableOnDisk.close();
                    hashtableOnDisk = null;
                }
                Object var21_41 = null;
                if (result.returnCode != 0) {
                    this.traceDebug("readValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                }
                if (result.returnCode != 1 && result.returnCode != 3) break block77;
                FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1488", this);
            }
            try {
                if (hashtableOnDisk != null) {
                    hashtableOnDisk.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1495", this);
            }
            this.readWriteLock.postRead();
            {
                break block79;
                catch (FileManagerException fileManagerException) {
                    this.diskCacheException = fileManagerException;
                    result.diskException = fileManagerException;
                    result.returnCode = 1;
                    Object var21_42 = null;
                    if (result.returnCode != 0) {
                        this.traceDebug("readValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                    }
                    if (result.returnCode == 1 || result.returnCode == 3) {
                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1488", this);
                    }
                    try {
                        if (hashtableOnDisk != null) {
                            hashtableOnDisk.close();
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1495", this);
                    }
                    this.readWriteLock.postRead();
                    break block79;
                }
                catch (HashtableOnDiskException hashtableOnDiskException) {
                    this.diskCacheException = hashtableOnDiskException;
                    result.diskException = hashtableOnDiskException;
                    result.returnCode = 1;
                    Object var21_43 = null;
                    if (result.returnCode != 0) {
                        this.traceDebug("readValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                    }
                    if (result.returnCode == 1 || result.returnCode == 3) {
                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1488", this);
                    }
                    try {
                        if (hashtableOnDisk != null) {
                            hashtableOnDisk.close();
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1495", this);
                    }
                    this.readWriteLock.postRead();
                    break block79;
                }
                catch (IOException iOException) {
                    this.diskCacheException = iOException;
                    result.diskException = iOException;
                    result.returnCode = 1;
                    Object var21_44 = null;
                    if (result.returnCode != 0) {
                        this.traceDebug("readValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                    }
                    if (result.returnCode == 1 || result.returnCode == 3) {
                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1488", this);
                    }
                    try {
                        if (hashtableOnDisk != null) {
                            hashtableOnDisk.close();
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1495", this);
                    }
                    this.readWriteLock.postRead();
                    break block79;
                }
                catch (Exception exception) {
                    result.returnCode = 3;
                    result.diskException = exception;
                    Object var21_45 = null;
                    if (result.returnCode != 0) {
                        this.traceDebug("readValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                    }
                    if (result.returnCode == 1 || result.returnCode == 3) {
                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1488", this);
                    }
                    try {
                        if (hashtableOnDisk != null) {
                            hashtableOnDisk.close();
                        }
                    }
                    catch (Exception exception3) {
                        FFDCFilter.processException((Throwable)exception3, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1495", this);
                    }
                    this.readWriteLock.postRead();
                }
            }
            catch (Throwable throwable) {
                Object var21_46 = null;
                if (result.returnCode != 0) {
                    this.traceDebug("readValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                }
                if (result.returnCode == 1 || result.returnCode == 3) {
                    FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1488", this);
                }
                try {
                    if (hashtableOnDisk != null) {
                        hashtableOnDisk.close();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSet", "1495", this);
                }
                this.readWriteLock.postRead();
                throw throwable;
            }
        }
        result.data = valueSet;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    Result readValueSetSize(int n, Object object) {
        Result result;
        block35: {
            HashtableOnDisk hashtableOnDisk;
            block33: {
                block32: {
                    result = this.getFromResultPool();
                    ValueSet valueSet = new ValueSet(4);
                    HashtableOnDisk hashtableOnDisk2 = null;
                    hashtableOnDisk = null;
                    this.readWriteLock.preRead();
                    hashtableOnDisk2 = n == 2 ? this.dependency_cache : this.template_cache;
                    Long l = (Long)hashtableOnDisk2.get(object);
                    if (l == null) break block32;
                    long l2 = l;
                    FileManager fileManager = hashtableOnDisk2.getFileManager();
                    if (l2 != -1L) {
                        hashtableOnDisk = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, false, this);
                        result.dataSize = hashtableOnDisk.size();
                        hashtableOnDisk.close();
                        hashtableOnDisk = null;
                        break block32;
                    }
                    result.dataSize = 0;
                }
                Object var13_14 = null;
                if (result.returnCode != 0) {
                    this.traceDebug("readValueSetSize()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                }
                if (result.returnCode != 1 && result.returnCode != 3) break block33;
                FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSetSize", "1621", this);
            }
            try {
                if (hashtableOnDisk != null) {
                    hashtableOnDisk.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSetSize", "1628", this);
            }
            this.readWriteLock.postRead();
            {
                break block35;
                catch (FileManagerException fileManagerException) {
                    this.diskCacheException = fileManagerException;
                    result.diskException = fileManagerException;
                    result.returnCode = 1;
                    Object var13_15 = null;
                    if (result.returnCode != 0) {
                        this.traceDebug("readValueSetSize()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                    }
                    if (result.returnCode == 1 || result.returnCode == 3) {
                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSetSize", "1621", this);
                    }
                    try {
                        if (hashtableOnDisk != null) {
                            hashtableOnDisk.close();
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSetSize", "1628", this);
                    }
                    this.readWriteLock.postRead();
                    break block35;
                }
                catch (HashtableOnDiskException hashtableOnDiskException) {
                    this.diskCacheException = hashtableOnDiskException;
                    result.diskException = hashtableOnDiskException;
                    result.returnCode = 1;
                    Object var13_16 = null;
                    if (result.returnCode != 0) {
                        this.traceDebug("readValueSetSize()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                    }
                    if (result.returnCode == 1 || result.returnCode == 3) {
                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSetSize", "1621", this);
                    }
                    try {
                        if (hashtableOnDisk != null) {
                            hashtableOnDisk.close();
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSetSize", "1628", this);
                    }
                    this.readWriteLock.postRead();
                    break block35;
                }
                catch (IOException iOException) {
                    this.diskCacheException = iOException;
                    result.diskException = iOException;
                    result.returnCode = 1;
                    Object var13_17 = null;
                    if (result.returnCode != 0) {
                        this.traceDebug("readValueSetSize()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                    }
                    if (result.returnCode == 1 || result.returnCode == 3) {
                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSetSize", "1621", this);
                    }
                    try {
                        if (hashtableOnDisk != null) {
                            hashtableOnDisk.close();
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSetSize", "1628", this);
                    }
                    this.readWriteLock.postRead();
                    break block35;
                }
                catch (Exception exception) {
                    result.returnCode = 3;
                    result.diskException = exception;
                    Object var13_18 = null;
                    if (result.returnCode != 0) {
                        this.traceDebug("readValueSetSize()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                    }
                    if (result.returnCode == 1 || result.returnCode == 3) {
                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSetSize", "1621", this);
                    }
                    try {
                        if (hashtableOnDisk != null) {
                            hashtableOnDisk.close();
                        }
                    }
                    catch (Exception exception2) {
                        FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.cache.HTODDynacache.readValueSetSize", "1628", this);
                    }
                    this.readWriteLock.postRead();
                }
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                if (result.returnCode != 0) {
                    this.traceDebug("readValueSetSize()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                }
                if (result.returnCode == 1 || result.returnCode == 3) {
                    FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readValueSetSize", "1621", this);
                }
                try {
                    if (hashtableOnDisk != null) {
                        hashtableOnDisk.close();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.readValueSetSize", "1628", this);
                }
                this.readWriteLock.postRead();
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result readByRange(int n, int n2, int n3, boolean bl, boolean bl2) {
        Result result = this.getFromResultPool();
        ValueSet valueSet = null;
        ValueSet valueSet2 = null;
        boolean bl3 = false;
        HashtableOnDisk hashtableOnDisk = null;
        try {
            this.readWriteLock.preRead();
            hashtableOnDisk = n == 1 ? this.object_cache : (n == 2 ? this.dependency_cache : this.template_cache);
            if (hashtableOnDisk != null) {
                if (n2 < 0) {
                    n2 = hashtableOnDisk.getPreviousRangeIndex();
                } else if (n2 > 0) {
                    n2 = hashtableOnDisk.getNextRangeIndex();
                } else {
                    hashtableOnDisk.initRangeIndex();
                }
                if (n3 == -1) {
                    bl3 = true;
                    n3 = hashtableOnDisk.size();
                }
                if (n3 <= 0) {
                    result.data = EMPTY_VS;
                    Result result2 = result;
                    return result2;
                }
                this.traceDebug("readByRange()", "cacheName=" + this.cache.getCacheName() + " before range index=" + n2 + " length=" + n3);
                valueSet = new ValueSet(n3);
                if (bl) {
                    valueSet2 = new ValueSet(n3 / 2);
                }
                ValueSetReadCallback valueSetReadCallback = new ValueSetReadCallback(valueSet, valueSet2);
                int n4 = hashtableOnDisk.iterateKeys(valueSetReadCallback, n2, n3);
                if (bl) {
                    this.traceDebug("readByRange()", "cacheName=" + this.cache.getCacheName() + " after range index=" + n4 + " length=" + n3 + " idsFound=" + valueSet.size() + " idsExpired=" + valueSet2.size());
                } else {
                    this.traceDebug("readByRange()", "cacheName=" + this.cache.getCacheName() + " after range index=" + n4 + " length=" + n3 + " idsFound=" + valueSet.size());
                }
                hashtableOnDisk.addRangeIndex(n4);
                if (bl) {
                    if (!bl3 && valueSet.size() + valueSet2.size() >= n3) {
                        valueSet.add(DISKCACHE_MORE);
                    }
                } else if (!bl3 && valueSet.size() >= n3) {
                    valueSet.add(DISKCACHE_MORE);
                }
                if (valueSet2 != null && valueSet2.size() > 0) {
                    this.invalidationBuffer.add(valueSet2, 1, 3, 5, false, true, true);
                }
                if (bl2) {
                    this.invalidationBuffer.filter(valueSet);
                }
            }
        }
        catch (FileManagerException fileManagerException) {
            this.diskCacheException = fileManagerException;
            result.diskException = fileManagerException;
            result.returnCode = 1;
        }
        catch (HashtableOnDiskException hashtableOnDiskException) {
            this.diskCacheException = hashtableOnDiskException;
            result.diskException = hashtableOnDiskException;
            result.returnCode = 1;
        }
        catch (IOException iOException) {
            this.diskCacheException = iOException;
            result.diskException = iOException;
            result.returnCode = 1;
        }
        catch (Exception exception) {
            result.returnCode = 3;
            result.diskException = exception;
        }
        finally {
            this.readWriteLock.postRead();
            if (result.returnCode != 0) {
                this.traceDebug("readByRange()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
            }
            if (result.returnCode == 1 || result.returnCode == 3) {
                FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readByRange", "1582", this);
            }
        }
        result.data = valueSet;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result readExpiredByRange(ValueSet valueSet, int n, int n2) {
        Result result = this.getFromResultPool();
        HashtableOnDisk hashtableOnDisk = null;
        this.scanExpiredTime = 0L;
        try {
            this.readWriteLock.preRead();
            hashtableOnDisk = this.object_cache;
            if (hashtableOnDisk == null) {
                result.bComplete = true;
                Result result2 = result;
                return result2;
            }
            if (n == 0) {
                hashtableOnDisk.rangeExpiredIndex = 0;
            }
            long l = System.currentTimeMillis();
            DynaAction dynaAction = new DynaAction(valueSet, this);
            int n3 = hashtableOnDisk.iterateKeys(dynaAction, hashtableOnDisk.rangeExpiredIndex, n2);
            this.scanExpiredTime = System.currentTimeMillis() - l;
            if (valueSet.size() + dynaAction.notExpiredCount < n2) {
                hashtableOnDisk.rangeExpiredIndex = 0;
                result.bComplete = true;
            } else {
                hashtableOnDisk.rangeExpiredIndex = n3;
            }
        }
        catch (FileManagerException fileManagerException) {
            this.diskCacheException = fileManagerException;
            result.diskException = fileManagerException;
            result.returnCode = 1;
        }
        catch (HashtableOnDiskException hashtableOnDiskException) {
            this.diskCacheException = hashtableOnDiskException;
            result.diskException = hashtableOnDiskException;
            result.returnCode = 1;
        }
        catch (IOException iOException) {
            this.diskCacheException = iOException;
            result.diskException = iOException;
            result.returnCode = 1;
        }
        catch (Exception exception) {
            result.returnCode = 3;
            result.diskException = exception;
        }
        finally {
            this.readWriteLock.postRead();
            if (result.returnCode != 0) {
                this.traceDebug("readExpiredByRange()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
            }
            if (result.returnCode == 1 || result.returnCode == 3) {
                FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.readExpiredByRange", "1640", this);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    int writeValueSet(int n, Object object, ValueSet valueSet, boolean bl) {
        int n2 = 0;
        Exception exception = null;
        HashtableOnDisk hashtableOnDisk = null;
        if (valueSet.size() == 0) {
            return n2;
        }
        HashtableOnDisk hashtableOnDisk2 = null;
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            block47: {
                block45: {
                    int n3;
                    this.readWriteLock.preWrite();
                    hashtableOnDisk = n == 2 ? this.dependency_cache : this.template_cache;
                    Long l = (Long)hashtableOnDisk.get(object);
                    long l2 = 0L;
                    FileManager fileManager = hashtableOnDisk.getFileManager();
                    if (l == null) {
                        n3 = this.calculateTableSize(object, valueSet.size());
                        l2 = HashtableOnDisk.createInstance(fileManager, n3, this.hashtable_threshold);
                        hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, false, this);
                        hashtableOnDisk.put(object, new Long(l2));
                    } else {
                        l2 = l;
                        if (l2 != -1L) {
                            hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, false, this);
                        } else {
                            n3 = this.calculateTableSize(object, valueSet.size());
                            l2 = HashtableOnDisk.createInstance(fileManager, n3, this.hashtable_threshold);
                            hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, false, this);
                            hashtableOnDisk.put(object, new Long(l2));
                        }
                        if (bl) {
                            if (hashtableOnDisk2.size() > 0) {
                                hashtableOnDisk2.clear();
                            }
                            hashtableOnDisk2.tempTableSize = this.calculateTableSize(object, valueSet.size());
                        } else {
                            hashtableOnDisk2.tempTableSize = this.calculateTableSize(object, hashtableOnDisk2.size() + valueSet.size());
                        }
                    }
                    Object object2 = null;
                    do {
                        if ((object2 = valueSet.getOne()) == null) continue;
                        hashtableOnDisk2.put(object2, null);
                        valueSet.remove(object2);
                    } while (object2 != null);
                    hashtableOnDisk2.close();
                    hashtableOnDisk2 = null;
                    Object var17_19 = null;
                    if (n2 != 0) {
                        this.traceDebug("writeValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                    }
                    if (n2 != 1 && n2 != 3) break block45;
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1738", this);
                }
                try {
                    if (hashtableOnDisk2 != null) {
                        hashtableOnDisk2.close();
                    }
                }
                catch (Exception exception2) {
                    FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1745", this);
                }
                this.readWriteLock.postWrite();
                {
                    break block47;
                    catch (FileManagerException fileManagerException) {
                        this.diskCacheException = fileManagerException;
                        exception = fileManagerException;
                        n2 = 1;
                        Object var17_20 = null;
                        if (n2 != 0) {
                            this.traceDebug("writeValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n2 == 1 || n2 == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1738", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception3) {
                            FFDCFilter.processException((Throwable)exception3, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1745", this);
                        }
                        this.readWriteLock.postWrite();
                        break block47;
                    }
                    catch (HashtableOnDiskException hashtableOnDiskException) {
                        this.diskCacheException = hashtableOnDiskException;
                        exception = hashtableOnDiskException;
                        n2 = 1;
                        Object var17_21 = null;
                        if (n2 != 0) {
                            this.traceDebug("writeValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n2 == 1 || n2 == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1738", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception4) {
                            FFDCFilter.processException((Throwable)exception4, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1745", this);
                        }
                        this.readWriteLock.postWrite();
                        break block47;
                    }
                    catch (IOException iOException) {
                        exception = iOException;
                        if (iOException.getMessage().equals(DISK_CACHE_IN_GB_OVER_LIMIT_MSG)) {
                            n2 = 2;
                        } else {
                            this.diskCacheException = iOException;
                            n2 = 1;
                        }
                        Object var17_22 = null;
                        if (n2 != 0) {
                            this.traceDebug("writeValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n2 == 1 || n2 == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1738", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception5) {
                            FFDCFilter.processException((Throwable)exception5, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1745", this);
                        }
                        this.readWriteLock.postWrite();
                        break block47;
                    }
                    catch (Exception exception6) {
                        n2 = 3;
                        exception = exception6;
                        Object var17_23 = null;
                        if (n2 != 0) {
                            this.traceDebug("writeValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n2 == 1 || n2 == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1738", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception7) {
                            FFDCFilter.processException((Throwable)exception7, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1745", this);
                        }
                        this.readWriteLock.postWrite();
                    }
                }
                catch (Throwable throwable) {
                    Object var17_24 = null;
                    if (n2 != 0) {
                        this.traceDebug("writeValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                    }
                    if (n2 == 1 || n2 == 3) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1738", this);
                    }
                    try {
                        if (hashtableOnDisk2 != null) {
                            hashtableOnDisk2.close();
                        }
                    }
                    catch (Exception exception8) {
                        FFDCFilter.processException((Throwable)exception8, "com.ibm.ws.cache.HTODDynacache.writeValueSet", "1745", this);
                    }
                    this.readWriteLock.postWrite();
                    throw throwable;
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    int delValueSet(int n, Object object) {
        int n2 = 0;
        Exception exception = null;
        HashtableOnDisk hashtableOnDisk = null;
        HashtableOnDisk hashtableOnDisk2 = null;
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            block38: {
                block36: {
                    block35: {
                        this.readWriteLock.preWrite();
                        hashtableOnDisk = n == 2 ? this.dependency_cache : this.template_cache;
                        Long l = (Long)hashtableOnDisk.get(object);
                        if (l == null) break block35;
                        long l2 = l;
                        FileManager fileManager = hashtableOnDisk.getFileManager();
                        if (l2 != -1L) {
                            hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, false, this);
                            hashtableOnDisk2.clear();
                            hashtableOnDisk2.close();
                            hashtableOnDisk2 = null;
                            HashtableOnDisk.destroyInstance(fileManager, l2);
                        }
                        hashtableOnDisk.remove(object);
                    }
                    Object var14_15 = null;
                    if (n2 != 0) {
                        this.traceDebug("delValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                    }
                    if (n2 != 1 && n2 != 3) break block36;
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1811", this);
                }
                try {
                    if (hashtableOnDisk2 != null) {
                        hashtableOnDisk2.close();
                    }
                }
                catch (Exception exception2) {
                    FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1818", this);
                }
                this.readWriteLock.postWrite();
                {
                    break block38;
                    catch (FileManagerException fileManagerException) {
                        this.diskCacheException = fileManagerException;
                        exception = fileManagerException;
                        n2 = 1;
                        Object var14_16 = null;
                        if (n2 != 0) {
                            this.traceDebug("delValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n2 == 1 || n2 == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1811", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception3) {
                            FFDCFilter.processException((Throwable)exception3, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1818", this);
                        }
                        this.readWriteLock.postWrite();
                        break block38;
                    }
                    catch (HashtableOnDiskException hashtableOnDiskException) {
                        this.diskCacheException = hashtableOnDiskException;
                        exception = hashtableOnDiskException;
                        n2 = 1;
                        Object var14_17 = null;
                        if (n2 != 0) {
                            this.traceDebug("delValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n2 == 1 || n2 == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1811", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception4) {
                            FFDCFilter.processException((Throwable)exception4, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1818", this);
                        }
                        this.readWriteLock.postWrite();
                        break block38;
                    }
                    catch (IOException iOException) {
                        this.diskCacheException = iOException;
                        exception = iOException;
                        n2 = 1;
                        Object var14_18 = null;
                        if (n2 != 0) {
                            this.traceDebug("delValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n2 == 1 || n2 == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1811", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception5) {
                            FFDCFilter.processException((Throwable)exception5, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1818", this);
                        }
                        this.readWriteLock.postWrite();
                        break block38;
                    }
                    catch (Exception exception6) {
                        n2 = 3;
                        exception = exception6;
                        Object var14_19 = null;
                        if (n2 != 0) {
                            this.traceDebug("delValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n2 == 1 || n2 == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1811", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception7) {
                            FFDCFilter.processException((Throwable)exception7, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1818", this);
                        }
                        this.readWriteLock.postWrite();
                    }
                }
                catch (Throwable throwable) {
                    Object var14_20 = null;
                    if (n2 != 0) {
                        this.traceDebug("delValueSet()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                    }
                    if (n2 == 1 || n2 == 3) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1811", this);
                    }
                    try {
                        if (hashtableOnDisk2 != null) {
                            hashtableOnDisk2.close();
                        }
                    }
                    catch (Exception exception8) {
                        FFDCFilter.processException((Throwable)exception8, "com.ibm.ws.cache.HTODDynacache.delValueSet", "1818", this);
                    }
                    this.readWriteLock.postWrite();
                    throw throwable;
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    int delValueSetEntry(int n, Object object, Object object2) {
        int n2 = 0;
        Exception exception = null;
        HashtableOnDisk hashtableOnDisk = null;
        HashtableOnDisk hashtableOnDisk2 = null;
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            block39: {
                block37: {
                    block36: {
                        this.readWriteLock.preWrite();
                        hashtableOnDisk = n == 2 ? this.dependency_cache : this.template_cache;
                        Long l = (Long)hashtableOnDisk.get(object);
                        if (l == null) break block36;
                        long l2 = l;
                        FileManager fileManager = hashtableOnDisk.getFileManager();
                        if (l2 != -1L) {
                            hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, false, this);
                            hashtableOnDisk2.remove(object2);
                            if (hashtableOnDisk2.size() == 0) {
                                HashtableOnDisk.destroyInstance(fileManager, l2);
                                hashtableOnDisk.remove(object);
                            }
                            hashtableOnDisk2.close();
                            hashtableOnDisk2 = null;
                            break block36;
                        }
                        hashtableOnDisk.remove(object);
                    }
                    Object var15_16 = null;
                    if (n2 != 0) {
                        this.traceDebug("delValueSetEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                    }
                    if (n2 != 1 && n2 != 3) break block37;
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delValueSetEntry", "1881", this);
                }
                try {
                    if (hashtableOnDisk2 != null) {
                        hashtableOnDisk2.close();
                    }
                }
                catch (Exception exception2) {
                    FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.cache.HTODDynacache.delValueSetEntry", "1888", this);
                }
                this.readWriteLock.postWrite();
                {
                    break block39;
                    catch (FileManagerException fileManagerException) {
                        this.diskCacheException = fileManagerException;
                        exception = fileManagerException;
                        n2 = 1;
                        Object var15_17 = null;
                        if (n2 != 0) {
                            this.traceDebug("delValueSetEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n2 == 1 || n2 == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delValueSetEntry", "1881", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception3) {
                            FFDCFilter.processException((Throwable)exception3, "com.ibm.ws.cache.HTODDynacache.delValueSetEntry", "1888", this);
                        }
                        this.readWriteLock.postWrite();
                        break block39;
                    }
                    catch (HashtableOnDiskException hashtableOnDiskException) {
                        this.diskCacheException = hashtableOnDiskException;
                        exception = hashtableOnDiskException;
                        n2 = 1;
                        Object var15_18 = null;
                        if (n2 != 0) {
                            this.traceDebug("delValueSetEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n2 == 1 || n2 == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delValueSetEntry", "1881", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception4) {
                            FFDCFilter.processException((Throwable)exception4, "com.ibm.ws.cache.HTODDynacache.delValueSetEntry", "1888", this);
                        }
                        this.readWriteLock.postWrite();
                        break block39;
                    }
                    catch (IOException iOException) {
                        this.diskCacheException = iOException;
                        exception = iOException;
                        n2 = 1;
                        Object var15_19 = null;
                        if (n2 != 0) {
                            this.traceDebug("delValueSetEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n2 == 1 || n2 == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delValueSetEntry", "1881", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception5) {
                            FFDCFilter.processException((Throwable)exception5, "com.ibm.ws.cache.HTODDynacache.delValueSetEntry", "1888", this);
                        }
                        this.readWriteLock.postWrite();
                        break block39;
                    }
                    catch (Exception exception6) {
                        n2 = 3;
                        exception = exception6;
                        Object var15_20 = null;
                        if (n2 != 0) {
                            this.traceDebug("delValueSetEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                        }
                        if (n2 == 1 || n2 == 3) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delValueSetEntry", "1881", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception7) {
                            FFDCFilter.processException((Throwable)exception7, "com.ibm.ws.cache.HTODDynacache.delValueSetEntry", "1888", this);
                        }
                        this.readWriteLock.postWrite();
                    }
                }
                catch (Throwable throwable) {
                    Object var15_21 = null;
                    if (n2 != 0) {
                        this.traceDebug("delValueSetEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(exception));
                    }
                    if (n2 == 1 || n2 == 3) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.delValueSetEntry", "1881", this);
                    }
                    try {
                        if (hashtableOnDisk2 != null) {
                            hashtableOnDisk2.close();
                        }
                    }
                    catch (Exception exception8) {
                        FFDCFilter.processException((Throwable)exception8, "com.ibm.ws.cache.HTODDynacache.delValueSetEntry", "1888", this);
                    }
                    this.readWriteLock.postWrite();
                    throw throwable;
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    Result writeValueSetEntry(int n, Object object, Object object2, ValueSet valueSet, boolean bl) {
        Result result = this.getFromResultPool();
        HashtableOnDisk hashtableOnDisk = null;
        HashtableOnDisk hashtableOnDisk2 = null;
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            block52: {
                block50: {
                    block49: {
                        this.readWriteLock.preWrite();
                        hashtableOnDisk = n == 2 ? this.dependency_cache : this.template_cache;
                        Long l = (Long)hashtableOnDisk.get(object);
                        long l2 = 0L;
                        FileManager fileManager = hashtableOnDisk.getFileManager();
                        if (l == null) {
                            if (bl && object2 != null) {
                                l2 = HashtableOnDisk.createInstance(fileManager, this.initial_valueset_size, this.hashtable_threshold);
                                hashtableOnDisk.put(object, new Long(l2));
                                hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, false, this);
                                hashtableOnDisk2.put(object2, null);
                            } else {
                                hashtableOnDisk.put(object, new Long(-1L));
                            }
                        } else {
                            result.bExist = true;
                            l2 = l;
                            if (l2 != -1L) {
                                hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, false, this);
                            } else {
                                l2 = HashtableOnDisk.createInstance(fileManager, this.initial_valueset_size, this.hashtable_threshold);
                                hashtableOnDisk2 = HashtableOnDisk.getInstance(fileManager, this.valueset_rehash, l2, false, this);
                                hashtableOnDisk.put(object, new Long(l2));
                            }
                            if (valueSet != null) {
                                int n2 = hashtableOnDisk2.size();
                                if (n2 > 0) {
                                    if (valueSet.size() + n2 > this.cod.delayOffloadEntriesLimit) {
                                        hashtableOnDisk2.tempTableSize = this.calculateTableSize(object, hashtableOnDisk2.size() + valueSet.size());
                                        object2 = null;
                                        do {
                                            if ((object2 = valueSet.getOne()) == null) continue;
                                            hashtableOnDisk2.put(object2, null);
                                            valueSet.remove(object2);
                                        } while (object2 != null);
                                        result.bComplete = true;
                                    } else {
                                        ValueSet valueSet2 = new ValueSet(n2);
                                        ValueSetReadCallback valueSetReadCallback = new ValueSetReadCallback(valueSet2, null);
                                        hashtableOnDisk2.iterateKeys(valueSetReadCallback, 0, n2);
                                        valueSet.union(valueSet2);
                                        hashtableOnDisk2.clear();
                                    }
                                }
                            } else if (object2 != null) {
                                hashtableOnDisk2.put(object2, null);
                            }
                        }
                        if (hashtableOnDisk2 == null) break block49;
                        hashtableOnDisk2.close();
                        hashtableOnDisk2 = null;
                    }
                    Object var19_20 = null;
                    if (result.returnCode != 0) {
                        this.traceDebug("writeValueSetEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                    }
                    if (result.returnCode != 1 && result.returnCode != 3) break block50;
                    FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1967", this);
                }
                try {
                    if (hashtableOnDisk2 != null) {
                        hashtableOnDisk2.close();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1974", this);
                }
                this.readWriteLock.postWrite();
                {
                    break block52;
                    catch (FileManagerException fileManagerException) {
                        this.diskCacheException = fileManagerException;
                        result.diskException = fileManagerException;
                        result.returnCode = 1;
                        Object var19_21 = null;
                        if (result.returnCode != 0) {
                            this.traceDebug("writeValueSetEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                        }
                        if (result.returnCode == 1 || result.returnCode == 3) {
                            FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1967", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1974", this);
                        }
                        this.readWriteLock.postWrite();
                        break block52;
                    }
                    catch (HashtableOnDiskException hashtableOnDiskException) {
                        this.diskCacheException = hashtableOnDiskException;
                        result.diskException = hashtableOnDiskException;
                        result.returnCode = 1;
                        Object var19_22 = null;
                        if (result.returnCode != 0) {
                            this.traceDebug("writeValueSetEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                        }
                        if (result.returnCode == 1 || result.returnCode == 3) {
                            FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1967", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1974", this);
                        }
                        this.readWriteLock.postWrite();
                        break block52;
                    }
                    catch (IOException iOException) {
                        result.diskException = iOException;
                        if (iOException.getMessage().equals(DISK_CACHE_IN_GB_OVER_LIMIT_MSG)) {
                            result.returnCode = 2;
                        } else {
                            this.diskCacheException = iOException;
                            result.returnCode = 1;
                        }
                        Object var19_23 = null;
                        if (result.returnCode != 0) {
                            this.traceDebug("writeValueSetEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                        }
                        if (result.returnCode == 1 || result.returnCode == 3) {
                            FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1967", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1974", this);
                        }
                        this.readWriteLock.postWrite();
                        break block52;
                    }
                    catch (Exception exception) {
                        result.returnCode = 3;
                        result.diskException = exception;
                        Object var19_24 = null;
                        if (result.returnCode != 0) {
                            this.traceDebug("writeValueSetEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                        }
                        if (result.returnCode == 1 || result.returnCode == 3) {
                            FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1967", this);
                        }
                        try {
                            if (hashtableOnDisk2 != null) {
                                hashtableOnDisk2.close();
                            }
                        }
                        catch (Exception exception2) {
                            FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1974", this);
                        }
                        this.readWriteLock.postWrite();
                    }
                }
                catch (Throwable throwable) {
                    Object var19_25 = null;
                    if (result.returnCode != 0) {
                        this.traceDebug("writeValueSetEntry()", "cacheName=" + this.cache.getCacheName() + "\n Exception: " + ExceptionUtility.getStackTrace(result.diskException));
                    }
                    if (result.returnCode == 1 || result.returnCode == 3) {
                        FFDCFilter.processException((Throwable)result.diskException, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1967", this);
                    }
                    try {
                        if (hashtableOnDisk2 != null) {
                            hashtableOnDisk2.close();
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.HTODDynacache.writeValueSetEntry", "1974", this);
                    }
                    this.readWriteLock.postWrite();
                    throw throwable;
                }
            }
        }
        return result;
    }

    public int getNumObjects() {
        this.readWriteLock.preRead();
        int n = Math.max(this.object_cache.size(), 0);
        if (!this.disableDependencyId) {
            n += Math.max(this.dependency_cache.size(), 0);
        }
        if (!this.disableTemplatesSupport) {
            n += Math.max(this.template_cache.size(), 0);
        }
        this.readWriteLock.postRead();
        return n;
    }

    public String cacheType() {
        return "htod";
    }

    public void dump_htod_stats(Writer writer, boolean bl) {
        try {
            this.object_cache.dump_htod_stats(writer, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dump_filemgr_stats(Writer writer, boolean bl) {
        try {
            this.object_cache.dump_filemgr_stats(writer, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dump_stats_header(Writer writer) {
        try {
            this.object_cache.dump_stats_header(writer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dump_filemgr_header(Writer writer) {
        try {
            this.object_cache.dump_filemgr_header(writer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void reset_stats() {
        this.object_cache.reset_stats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object object) {
        boolean bl = false;
        if (!this.invalidationBuffer.contains(object)) {
            try {
                this.readWriteLock.preRead();
                bl = this.object_cache.containsKey(object);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.HTODDynacache.containsKey", "1877", this);
                this.traceDebug("containsKey()", "cacheName=" + this.cache.getCacheName() + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
            finally {
                this.readWriteLock.postRead();
            }
        }
        return bl;
    }

    private int populateAuxDependencyTable(int n, HashMap hashMap, int n2, int n3) {
        DepEntry depEntry;
        int n4 = 0;
        HTODDependencyTable hTODDependencyTable = null;
        int n5 = 0;
        if (n == 2) {
            hTODDependencyTable = this.auxDataDependencyTable;
            n5 = this.getDepIdsSize();
        } else {
            hTODDependencyTable = this.auxTemplateDependencyTable;
            n5 = this.getTemplatesSize();
        }
        if (n5 == 0) {
            return n4;
        }
        Result result = this.readByRange(n, 0, -1, false, false);
        n4 = result.returnCode;
        if (n4 == 1) {
            this.returnToResultPool(result);
            return n4;
        }
        ValueSet valueSet = (ValueSet)result.data;
        this.returnToResultPool(result);
        if (valueSet == null || valueSet != null && valueSet.isEmpty()) {
            return n4;
        }
        Iterator iterator = null;
        Iterator iterator2 = null;
        if (this.cod.diskCachePerformanceLevel == 2 || this.cod.diskCachePerformanceLevel == 1) {
            int n6;
            ArrayList<DepEntry> arrayList = new ArrayList(n2);
            int n7 = 0;
            for (Object e2 : valueSet) {
                result = this.readValueSetSize(n, e2);
                if (n4 == 1) {
                    this.returnToResultPool(result);
                    return n4;
                }
                n6 = result.dataSize;
                if (n6 > n3) continue;
                depEntry = new DepEntry(e2, n6);
                arrayList.add(n7, depEntry);
                ++n7;
            }
            arrayList.trimToSize();
            if (arrayList.size() > n2) {
                int n8 = arrayList.size() - n2;
                Collections.sort(arrayList, new DepSizeComparator());
                for (n6 = 0; n6 < n8; ++n6) {
                    arrayList.remove(0);
                }
            }
            int n9 = arrayList.size();
            valueSet.clear();
            for (n6 = 0; n6 < n9; ++n6) {
                valueSet.add(((DepEntry)arrayList.get((int)n6)).id);
            }
        }
        for (ArrayList<DepEntry> arrayList : valueSet) {
            result = this.readValueSet(n, arrayList, false);
            if (n4 == 1) {
                this.returnToResultPool(result);
                return n4;
            }
            ValueSet valueSet2 = (ValueSet)result.data;
            this.returnToResultPool(result);
            if (valueSet2 == null || valueSet2 != null && valueSet2.isEmpty()) continue;
            ValueSet valueSet3 = new ValueSet(valueSet2.size());
            for (Object e3 : valueSet2) {
                depEntry = hashMap.get(e3);
                if (depEntry == null) {
                    hashMap.put(e3, e3);
                    depEntry = e3;
                }
                valueSet3.add(depEntry);
            }
            hTODDependencyTable.add(arrayList, valueSet3);
            if (n4 != 1) continue;
            return n4;
        }
        return n4;
    }

    protected int removeExpiredCache(long l, boolean bl) {
        int n;
        int n2 = 0;
        if (this.object_cache == null) {
            this.traceDebug("removeExpiredCache()", "The disk object cache is null for cacheName=" + this.cache.getCacheName());
            return n2;
        }
        this.deletedSize = 0L;
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        if (!bl && (n = this.invalidationBuffer.size() + this.invalidationBuffer.size(3)) == 0) {
            return n2;
        }
        if (this.getCacheIdsSize() > 0) {
            long l10;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  DiskCacheSize=");
            stringBuffer.append(this.getCacheIdsSize());
            stringBuffer.append("  DepIdsSize=");
            stringBuffer.append(this.getDepIdsSize());
            stringBuffer.append("  TemplatesSize=");
            stringBuffer.append(this.getTemplatesSize());
            if (this.cod.enableCacheSizeInBytes) {
                stringBuffer.append("  CacheSizeInBytes=");
                stringBuffer.append(this.cod.currentCacheSizeInBytes);
            }
            stringBuffer.append("  Scan=");
            stringBuffer.append(bl);
            stringBuffer.append("  ExplicitBuffer=");
            stringBuffer.append(this.invalidationBuffer.size(2));
            stringBuffer.append("  ScanBuffer=");
            stringBuffer.append(this.invalidationBuffer.size(1));
            stringBuffer.append("  GCBuffer=");
            stringBuffer.append(this.invalidationBuffer.size(3));
            if (bl) {
                Tr.info(this.tc, "DYNA0057I", new Object[]{this.cache.getCacheName(), stringBuffer.toString()});
            } else if (!bl && this.tc.isEventEnabled()) {
                Tr.event(this.tc, "The disk cache cleanup started for the cache name \"" + this.cache.getCacheName() + "\"." + "The statistics are: " + stringBuffer.toString());
            } else {
                this.traceDebug("removeExpiredCache()", "The disk cache cleanup started for cache name \"" + this.cache.getCacheName() + "\"." + " The statistics are: " + stringBuffer.toString());
            }
            if (this.cod.populateDependencyTable) {
                this.cacheIdsTable = new HashMap(this.getCacheIdsSize());
                this.cod.populateDependencyTable = false;
                l10 = System.currentTimeMillis();
                if (!this.disableDependencyId && (n2 = this.populateAuxDependencyTable(2, this.cacheIdsTable, this.cod.delayOffloadDepIdBuckets, this.cod.delayOffloadEntriesLimit)) == 1) {
                    this.cacheIdsTable.clear();
                    this.cacheIdsTable = null;
                    return n2;
                }
                if (!this.disableTemplatesSupport && (n2 = this.populateAuxDependencyTable(3, this.cacheIdsTable, this.cod.delayOffloadTemplateBuckets, this.cod.delayOffloadEntriesLimit)) == 1) {
                    this.cacheIdsTable.clear();
                    this.cacheIdsTable = null;
                    return n2;
                }
                l3 = System.currentTimeMillis() - l10;
            }
            int n3 = 0;
            boolean bl2 = false;
            ValueSet valueSet = new ValueSet(50);
            long l11 = System.currentTimeMillis();
            block0: do {
                Object object;
                int n4 = 0;
                this.scanExpiredTime = 0L;
                if (bl && this.invalidationBuffer.size() < this.cod.invalidationBufferSize) {
                    if (this.invalidationBuffer.isLoopOnce()) break;
                    if (this.cod.evictionPolicy != 0 && this.cod.diskCachePerformanceLevel != 3 && this.EvictionTable.size() > 0) {
                        object = this.getExpiredEntriesFromEvictionTable();
                        l6 = ((ArrayList)object).size();
                        this.invalidationBuffer.add((ArrayList)object, 3);
                        if (this.tc.isDebugEnabled() || this.tc.isEventEnabled()) {
                            l11 = System.currentTimeMillis();
                            stringBuffer.setLength(0);
                            stringBuffer.append("removeExpiredCache()");
                            stringBuffer.append(":scanGC ++++ cacheName=");
                            stringBuffer.append(this.cache.getCacheName());
                            stringBuffer.append(" DiskCacheSize=");
                            stringBuffer.append(this.getCacheIdsSize());
                            if (this.cod.enableCacheSizeInBytes) {
                                stringBuffer.append("  CacheSizeInBytes=");
                                stringBuffer.append(this.cod.currentCacheSizeInBytes);
                            }
                            stringBuffer.append(" ScanExpiredEntries=");
                            stringBuffer.append(l6);
                            stringBuffer.append(" ExplicitEntriesDeleted=");
                            stringBuffer.append(l7);
                            stringBuffer.append(" ScanEntriesDeleted=");
                            stringBuffer.append(l8);
                            stringBuffer.append(" GCEntriesDeleted=");
                            stringBuffer.append(l9);
                            stringBuffer.append(" DeletedSize=");
                            stringBuffer.append(this.deletedSize);
                            stringBuffer.append(" ExplicitBuffer=");
                            stringBuffer.append(this.invalidationBuffer.size(2));
                            stringBuffer.append(" ScanBuffer=");
                            stringBuffer.append(this.invalidationBuffer.size(1));
                            stringBuffer.append(" GCBuffer=");
                            stringBuffer.append(this.invalidationBuffer.size(3));
                            stringBuffer.append(" CleanupScanPending=");
                            stringBuffer.append(this.invalidationBuffer.isCleanupPending());
                            if (this.tc.isDebugEnabled()) {
                                Tr.debug(this.tc, stringBuffer.toString());
                            } else {
                                Tr.event(this.tc, stringBuffer.toString());
                            }
                        }
                        bl2 = true;
                    } else {
                        object = this.readExpiredByRange(valueSet, n3, 50);
                        n2 = ((Result)object).returnCode;
                        if (n2 == 1) break;
                        bl2 = ((Result)object).bComplete;
                        l4 += this.scanExpiredTime;
                        n4 = valueSet.size();
                        if (n4 > 0) {
                            this.invalidationBuffer.add(valueSet, 1, 3, 5, false, true, false);
                            valueSet.clear();
                        }
                        l6 += (long)n4;
                        if (this.tc.isEventEnabled() && System.currentTimeMillis() - l11 >= 10000L) {
                            l11 = System.currentTimeMillis();
                            stringBuffer.setLength(0);
                            stringBuffer.append("removeExpiredCache()");
                            stringBuffer.append(":scanDisk ++++ cacheName=");
                            stringBuffer.append(this.cache.getCacheName());
                            stringBuffer.append(" DiskCacheSize=");
                            stringBuffer.append(this.getCacheIdsSize());
                            if (this.cod.enableCacheSizeInBytes) {
                                stringBuffer.append("  CacheSizeInBytes=");
                                stringBuffer.append(this.cod.currentCacheSizeInBytes);
                            }
                            stringBuffer.append(" ScanExpiredEntries=");
                            stringBuffer.append(l6);
                            stringBuffer.append(" ExplicitEntriesDeleted=");
                            stringBuffer.append(l7);
                            stringBuffer.append(" ScanEntriesDeleted=");
                            stringBuffer.append(l8);
                            stringBuffer.append(" GCEntriesDeleted=");
                            stringBuffer.append(l9);
                            stringBuffer.append(" DeletedSize=");
                            stringBuffer.append(this.deletedSize);
                            stringBuffer.append(" ExplicitBuffer=");
                            stringBuffer.append(this.invalidationBuffer.size(2));
                            stringBuffer.append(" ScanBuffer=");
                            stringBuffer.append(this.invalidationBuffer.size(1));
                            stringBuffer.append(" GCBuffer=");
                            stringBuffer.append(this.invalidationBuffer.size(3));
                            stringBuffer.append(" CleanupScanPending=");
                            stringBuffer.append(this.invalidationBuffer.isCleanupPending());
                            Tr.event(this.tc, stringBuffer.toString());
                        }
                        Thread.yield();
                    }
                } else if (!bl) {
                    bl2 = true;
                }
                object = null;
                int n5 = 0;
                long l12 = 0L;
                while (!this.invalidationBuffer.isLoopOnce()) {
                    l10 = System.currentTimeMillis();
                    int n6 = 2;
                    object = this.invalidationBuffer.get(2);
                    if (object == null) {
                        n6 = 1;
                        object = this.invalidationBuffer.get(1);
                        if (object == null) {
                            n6 = 3;
                            object = this.invalidationBuffer.get(3);
                        }
                    }
                    if (object != null) {
                        Result result = this.delCacheEntry(object, n6);
                        n2 = result.returnCode;
                        if (n2 == 1) {
                            bl2 = true;
                            continue block0;
                        }
                        if (result.numDelete > 0) {
                            object = result.data;
                            long l13 = System.currentTimeMillis() - l10;
                            l5 += l13;
                            l12 += l13;
                            if (n6 == 2) {
                                l7 += (long)result.numDelete;
                            } else if (n6 == 1) {
                                l8 += (long)result.numDelete;
                                this.cache.internalInvalidateByDepId(object, result.cause, result.source, true);
                            } else {
                                l9 += (long)result.numDelete;
                                this.cache.internalInvalidateByDepId(object, result.cause, result.source, true);
                            }
                            n5 += result.numDelete;
                        }
                        this.returnToResultPool(result);
                    }
                    Thread.yield();
                    if (object != null) continue;
                }
            } while (!bl2 && !this.invalidationBuffer.isLoopOnce() && ++n3 > 0);
            stringBuffer.setLength(0);
            stringBuffer.append("  DiskCacheSize=");
            stringBuffer.append(this.getCacheIdsSize());
            stringBuffer.append("  DepIdsSize=");
            stringBuffer.append(this.getDepIdsSize());
            stringBuffer.append("  TemplatesSize=");
            stringBuffer.append(this.getTemplatesSize());
            if (this.cod.enableCacheSizeInBytes) {
                stringBuffer.append("  CacheSizeInBytes=");
                stringBuffer.append(this.cod.currentCacheSizeInBytes);
            }
            stringBuffer.append("  TimeElapsed=");
            stringBuffer.append(System.currentTimeMillis() - l2);
            if (l3 != 0L) {
                stringBuffer.append("  PopulateDepTablesTime=");
                stringBuffer.append(l3);
            }
            stringBuffer.append("  ScanTime=");
            stringBuffer.append(l4);
            stringBuffer.append("  DeleteTime=");
            stringBuffer.append(l5);
            stringBuffer.append("  ExplicitEntriesDeleted=");
            stringBuffer.append(l7);
            stringBuffer.append("  ScanEntriesDeleted=");
            stringBuffer.append(l8);
            stringBuffer.append("  GCEntriesDeleted=");
            stringBuffer.append(l9);
            stringBuffer.append("  TotalDeletedSize=");
            stringBuffer.append(this.deletedSize);
            if (bl) {
                Tr.info(this.tc, "DYNA0058I", new Object[]{this.cache.getCacheName(), stringBuffer.toString()});
            } else if (!bl && this.tc.isEventEnabled()) {
                Tr.event(this.tc, "The disk cache cleanup finished for cache name \"" + this.cache.getCacheName() + "\"." + " The statistics are: " + stringBuffer.toString());
            } else {
                this.traceDebug("removeExpiredCache()", "The disk cache cleanup finished for cache name \"" + this.cache.getCacheName() + "\"." + " The statistics are: " + stringBuffer.toString());
            }
        }
        if (this.invalidationBuffer.isLoopOnce()) {
            this.invalidationBuffer.setLoopOnce(false);
        }
        this.invalidationBuffer.setlastRemoveTime();
        this.cod.populateDependencyTable = false;
        if (this.cacheIdsTable != null) {
            this.cacheIdsTable.clear();
            this.cacheIdsTable = null;
        }
        return n2;
    }

    private int calculateTableSize(Object object, int n) {
        int n2 = this.initial_valueset_size;
        boolean bl = false;
        do {
            if (n > n2) {
                n2 = n2 * 2 + 1;
                continue;
            }
            float f = (float)n2 / (float)n;
            if ((double)f < 1.5) {
                n2 = n2 * 2 + 1;
            }
            bl = true;
        } while (!bl);
        return n2;
    }

    protected int calculateMinCacheSizeInBytes() {
        return this.cod.dataHashtableSize * 8 + 16900;
    }

    public DiskCacheSizeInfo getDiskCacheSizeInfo() {
        return this.cod.diskCacheSizeInfo;
    }

    public void returnToHashtableEntryPool(HashtableEntry hashtableEntry) {
        if (hashtableEntry != null) {
            hashtableEntry.reset();
            this.htEntryPool.add(hashtableEntry);
        }
    }

    public HashtableEntry getFromHashtableEntryPool() {
        return (HashtableEntry)this.htEntryPool.remove();
    }

    public void returnToResultPool(Result result) {
        if (result != null) {
            result.reset();
            this.resultPool.add(result);
        }
    }

    public Result getFromResultPool() {
        return (Result)this.resultPool.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList walkEvictionTable(int n, int n2, long l) {
        Object object;
        if (n != 1 && n != 2) {
            return null;
        }
        ArrayList<EvictionTableEntry> arrayList = null;
        arrayList = n2 > 0 ? new ArrayList<EvictionTableEntry>(n2) : new ArrayList(256);
        int n3 = 0;
        long l2 = 0L;
        EvictionTableEntry evictionTableEntry = null;
        long l3 = System.currentTimeMillis();
        do {
            object = this.evictionTableMonitor;
            synchronized (object) {
                evictionTableEntry = this.EvictionTable.minimum();
                if (evictionTableEntry != null && evictionTableEntry.expirationTime <= l3) {
                    arrayList.add(this.EvictionTable.deleteMin());
                    ++n3;
                    l2 += (long)evictionTableEntry.size;
                } else {
                    evictionTableEntry = null;
                }
            }
        } while (evictionTableEntry != null);
        if (n2 > 0 && n2 <= n3 || l > 0L && l <= l2) {
            return arrayList;
        }
        if (n == 1) {
            if (n2 > 0) {
                while (n3 < n2 && this.EvictionTable.size() > 0) {
                    object = this.evictionTableMonitor;
                    synchronized (object) {
                        int n4 = this.rand.nextInt(this.EvictionTable.size()) + 1;
                        EvictionTableEntry evictionTableEntry2 = this.EvictionTable.heapArray[n4];
                        if (evictionTableEntry2 != null) {
                            ++n3;
                            arrayList.add(evictionTableEntry2);
                            this.EvictionTable.delete(evictionTableEntry2);
                        }
                    }
                }
            } else {
                while (l2 < l && this.EvictionTable.size() > 0) {
                    object = this.evictionTableMonitor;
                    synchronized (object) {
                        int n5 = this.rand.nextInt(this.EvictionTable.size()) + 1;
                        EvictionTableEntry evictionTableEntry3 = this.EvictionTable.heapArray[n5];
                        if (evictionTableEntry3 != null) {
                            l2 += (long)evictionTableEntry3.size;
                            arrayList.add(evictionTableEntry3);
                            this.EvictionTable.delete(evictionTableEntry3);
                        }
                    }
                }
            }
        } else if (n == 2) {
            object = this.evictionTableMonitor;
            synchronized (object) {
                int n6;
                EvictionTableEntry[] evictionTableEntryArray = new EvictionTableEntry[this.EvictionTable.size()];
                System.arraycopy(this.EvictionTable.heapArray, 1, evictionTableEntryArray, 0, this.EvictionTable.size());
                Arrays.sort(evictionTableEntryArray, new EvictionSizeComparator());
                if (n2 > 0) {
                    for (n6 = evictionTableEntryArray.length - 1; n3 < n2 && n6 >= 0; ++n3, --n6) {
                        EvictionTableEntry evictionTableEntry4 = evictionTableEntryArray[n6];
                        arrayList.add(evictionTableEntry4);
                        this.EvictionTable.delete(evictionTableEntry4);
                    }
                } else {
                    while (l2 < l && n6 >= 0) {
                        EvictionTableEntry evictionTableEntry5 = evictionTableEntryArray[n6];
                        l2 += (long)evictionTableEntry5.size;
                        arrayList.add(evictionTableEntry5);
                        --n6;
                        this.EvictionTable.delete(evictionTableEntry5);
                    }
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getExpiredEntriesFromEvictionTable() {
        if (this.cod.evictionPolicy == 0) {
            return null;
        }
        ArrayList<EvictionTableEntry> arrayList = new ArrayList<EvictionTableEntry>(256);
        EvictionTableEntry evictionTableEntry = null;
        long l = System.currentTimeMillis();
        do {
            Object object = this.evictionTableMonitor;
            synchronized (object) {
                evictionTableEntry = this.EvictionTable.minimum();
                if (evictionTableEntry != null && evictionTableEntry.expirationTime <= l) {
                    arrayList.add(this.EvictionTable.deleteMin());
                } else {
                    evictionTableEntry = null;
                }
            }
        } while (evictionTableEntry != null);
        return arrayList;
    }

    private void traceDebug(String string, String string2) {
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, string + " " + string2);
        }
    }

    public int getPendingRemovalSize() {
        return this.invalidationBuffer.size();
    }

    public int getDepIdsBufferedSize() {
        if (this.delayOffload) {
            if (!this.disableDependencyId) {
                return this.auxDataDependencyTable.size();
            }
            return 0;
        }
        return 0;
    }

    public int getTemplatesBufferedSize() {
        if (this.delayOffload) {
            if (!this.disableTemplatesSupport) {
                return this.auxTemplateDependencyTable.size();
            }
            return 0;
        }
        return 0;
    }

    public void releaseUnusedPools() {
        this.byteArrayPool.release();
        this.longArrayPool.release();
    }

    public static class DepEntry {
        public int size;
        public Object id;

        public DepEntry(Object object, int n) {
            this.id = object;
            this.size = n;
        }
    }

    public static class DepSizeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((DepEntry)object).size - ((DepEntry)object2).size;
        }
    }

    public static class BinaryHeap {
        public EvictionTableEntry[] heapArray = new EvictionTableEntry[this.DEFAULT_SIZE];
        private int DEFAULT_SIZE = 1024;
        private int heapSize;

        public BinaryHeap(EvictionTableEntry evictionTableEntry) {
            this.heapArray[0] = evictionTableEntry;
            this.heapArray[0].index = 0;
            this.heapArray[0].expirationTime = Long.MIN_VALUE;
            this.heapSize = 0;
        }

        public synchronized void insert(EvictionTableEntry evictionTableEntry) {
            int n = ++this.heapSize;
            this.growIfNec();
            while (evictionTableEntry.lessThan(this.heapArray[BinaryHeap.parent(n)])) {
                this.heapArray[n] = this.heapArray[BinaryHeap.parent(n)];
                this.heapArray[n].index = n;
                n = BinaryHeap.parent(n);
            }
            this.heapArray[n] = evictionTableEntry;
            this.heapArray[n].index = n;
        }

        public void printHeap() {
            System.out.println("PRINT HEAP");
            for (int i = 0; i <= this.size(); ++i) {
                System.out.println("*** evt:" + this.heapArray[i]);
            }
        }

        public EvictionTableEntry minimum() {
            if (this.isEmpty()) {
                return null;
            }
            return this.heapArray[1];
        }

        public synchronized void clear() {
            for (int i = 1; i <= this.heapSize; ++i) {
                this.heapArray[i] = null;
            }
            this.heapSize = 0;
        }

        public synchronized EvictionTableEntry deleteMin() {
            EvictionTableEntry evictionTableEntry;
            if (this.isEmpty()) {
                evictionTableEntry = null;
            } else {
                EvictionTableEntry evictionTableEntry2 = this.heapArray[this.heapSize];
                this.heapArray[this.heapSize--] = null;
                if (this.isEmpty()) {
                    evictionTableEntry = evictionTableEntry2;
                } else {
                    evictionTableEntry = this.heapArray[1];
                    this.heapArray[1] = evictionTableEntry2;
                    this.heapArray[1].index = 1;
                    this.heapify(1);
                }
            }
            return evictionTableEntry;
        }

        public synchronized EvictionTableEntry findAndRemove(long l, int n, int n2) {
            int n3;
            EvictionTableEntry evictionTableEntry = null;
            for (n3 = 1; n3 <= this.heapSize; ++n3) {
                evictionTableEntry = this.heapArray[n3];
                if (evictionTableEntry.expirationTime == l && evictionTableEntry.size == n2 && evictionTableEntry.hashcode == n) break;
            }
            if (n3 > this.heapSize) {
                evictionTableEntry = null;
            } else {
                this.heapArray[n3] = this.heapArray[0];
                this.heapArray[n3].index = n3;
                this.percolateUp(n3);
                this.deleteMin();
                this.heapArray[0].index = 0;
            }
            return evictionTableEntry;
        }

        public synchronized void delete(EvictionTableEntry evictionTableEntry) {
            int n = this.findKey(evictionTableEntry);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            this.heapArray[n] = this.heapArray[0];
            this.heapArray[n].index = n;
            this.percolateUp(n);
            this.deleteMin();
            this.heapArray[0].index = 0;
        }

        private int findKey(EvictionTableEntry evictionTableEntry) {
            return evictionTableEntry.index;
        }

        private void percolateUp(int n) {
            while (this.heapArray[n].lessThan(this.heapArray[BinaryHeap.parent(n)])) {
                int n2 = BinaryHeap.parent(n);
                EvictionTableEntry evictionTableEntry = this.heapArray[n2];
                this.heapArray[n2] = this.heapArray[n];
                this.heapArray[n2].index = n2;
                this.heapArray[n] = evictionTableEntry;
                this.heapArray[n].index = n;
                int n3 = n;
                n = n2;
                this.heapify(n3);
            }
        }

        private void heapify(int n) {
            EvictionTableEntry evictionTableEntry = this.heapArray[n];
            while (BinaryHeap.left(n) <= this.heapSize) {
                int n2 = BinaryHeap.left(n);
                if (n2 < this.heapSize && this.heapArray[BinaryHeap.right(n)].lessThan(this.heapArray[n2])) {
                    ++n2;
                }
                if (!this.heapArray[n2].lessThan(evictionTableEntry)) break;
                this.heapArray[n] = this.heapArray[n2];
                this.heapArray[n].index = n;
                n = n2;
            }
            this.heapArray[n] = evictionTableEntry;
            this.heapArray[n].index = n;
        }

        public boolean isEmpty() {
            return this.heapSize == 0;
        }

        public int size() {
            return this.heapSize;
        }

        private static int parent(int n) {
            return n / 2;
        }

        private static int left(int n) {
            return 2 * n;
        }

        private static int right(int n) {
            return 2 * n + 1;
        }

        private void growIfNec() {
            if (this.heapSize + 1 == this.heapArray.length) {
                EvictionTableEntry[] evictionTableEntryArray = this.heapArray;
                this.heapArray = new EvictionTableEntry[this.heapSize * 2];
                System.arraycopy(evictionTableEntryArray, 0, this.heapArray, 0, evictionTableEntryArray.length);
            }
        }
    }

    static class EvictionEntryPool
    extends ObjectPool {
        public EvictionEntryPool(int n) {
            super("EvictionEntryPool", n);
        }

        public Object createObject() {
            return new EvictionTableEntry();
        }

        public boolean add(EvictionTableEntry evictionTableEntry) {
            evictionTableEntry.reset();
            return super.add(evictionTableEntry);
        }
    }

    public static class EvictionTableEntry {
        public int size;
        public long expirationTime;
        public int hashcode;
        public int index;

        public boolean lessThan(EvictionTableEntry evictionTableEntry) {
            return this.expirationTime < evictionTableEntry.expirationTime;
        }

        public boolean equals(EvictionTableEntry evictionTableEntry) {
            return this.expirationTime == evictionTableEntry.expirationTime;
        }

        public boolean lessThanOrEquals(EvictionTableEntry evictionTableEntry) {
            return this.expirationTime <= evictionTableEntry.expirationTime;
        }

        public void reset() {
            this.expirationTime = 0L;
            this.size = 0;
            this.hashcode = 0;
            this.index = -1;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" index=");
            stringBuffer.append(this.index);
            stringBuffer.append(" expirationTime=");
            stringBuffer.append(this.expirationTime);
            stringBuffer.append(" hashcode=");
            stringBuffer.append(this.hashcode);
            stringBuffer.append(" size=");
            stringBuffer.append(this.size);
            return stringBuffer.toString();
        }
    }

    public static class EvictionSizeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((EvictionTableEntry)object).size - ((EvictionTableEntry)object2).size;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }
    }

    class DynaAction
    implements HashtableAction {
        ValueSet expiredIds;
        int notExpiredCount = 0;
        HTODDynacache htod = null;

        DynaAction(ValueSet valueSet, HTODDynacache hTODDynacache2) {
            this.expiredIds = valueSet;
            this.htod = hTODDynacache2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean execute(HashtableEntry hashtableEntry) throws Exception {
            Object object = hashtableEntry.getKey();
            Object object2 = null;
            if (this.htod.cacheIdsTable != null) {
                object2 = HTODDynacache.this.cacheIdsTable.get(object);
                if (object2 == null) {
                    HTODDynacache.this.cacheIdsTable.put(object, object);
                    object2 = object;
                }
            } else {
                object2 = object;
            }
            if (hashtableEntry.isExpired()) {
                this.expiredIds.add(object2);
            } else {
                long l;
                if (this.htod.cod.populateEvictionTable && !hashtableEntry.isAliasId()) {
                    EvictionTableEntry evictionTableEntry = (EvictionTableEntry)this.htod.evictionEntryPool.remove();
                    evictionTableEntry.hashcode = object2.hashCode();
                    evictionTableEntry.expirationTime = hashtableEntry.expirationTime();
                    if (evictionTableEntry.expirationTime <= 0L) {
                        evictionTableEntry.expirationTime = Long.MAX_VALUE;
                    }
                    evictionTableEntry.size = hashtableEntry.size();
                    Object object3 = this.htod.evictionTableMonitor;
                    synchronized (object3) {
                        this.htod.EvictionTable.insert(evictionTableEntry);
                    }
                }
                ++this.notExpiredCount;
                if (!hashtableEntry.isAliasId() && this.htod.cod.diskCachePerformanceLevel == 3 && (l = hashtableEntry.expirationTime()) > 0L && !this.htod.invalidationBuffer.contains(object2)) {
                    this.htod.cache.addToTimeLimitDaemon(object2, l, -1);
                }
            }
            HTODDynacache.this.returnToHashtableEntryPool(hashtableEntry);
            return true;
        }
    }

    class ValueSetReadCallback
    implements HashtableAction {
        ValueSet ids;
        ValueSet expiredIds;

        ValueSetReadCallback(ValueSet valueSet, ValueSet valueSet2) {
            this.ids = valueSet;
            this.expiredIds = valueSet2;
        }

        public boolean execute(HashtableEntry hashtableEntry) throws Exception {
            if (this.expiredIds != null && hashtableEntry.isExpired()) {
                this.expiredIds.add(hashtableEntry.getKey());
            } else {
                this.ids.add(hashtableEntry.getKey());
            }
            HTODDynacache.this.returnToHashtableEntryPool(hashtableEntry);
            return true;
        }
    }

    static class ResultObjectPool
    extends ObjectPool {
        public ResultObjectPool(int n) {
            super("HashtableEntryPool", n);
        }

        public Object createObject() {
            return new Result();
        }
    }

    static class HashtableEntryObjectPool
    extends ObjectPool {
        public HashtableEntryObjectPool(int n) {
            super("HashtableEntryPool", n);
        }

        public Object createObject() {
            return new HashtableEntry();
        }
    }
}

