/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.CacheOnDisk;
import com.ibm.ws.cache.ExplicitIdData;
import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class HTODInvalidationBuffer {
    private static TraceComponent tc = Trace.register(HTODInvalidationBuffer.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static final boolean IS_UNIT_TEST = false;
    public static final boolean SCAN = true;
    public static final boolean FIRE_EVENT = true;
    public static final boolean CHECK_FULL = true;
    public static final boolean ALIAS_ID = true;
    public static final int SCAN_BUFFER = 1;
    public static final int EXPLICIT_BUFFER = 2;
    public static final int GC_BUFFER = 3;
    public static final byte STATUS_FIRE_EVENT = -128;
    public static final byte STATUS_FROM_DEPID_TEMPLATE = 64;
    public static final byte STATUS_ALIAS = 32;
    public static final byte STATUS_REMOTE = 16;
    public static final byte STATUS_CAUSE_MASK = 15;
    private CacheOnDisk cod = null;
    private HashMap explicitBuffer = null;
    private ValueSet scanBuffer = null;
    private ArrayList garbageCollectorBuffer = null;
    private boolean backgroundInvalidationInProgress = false;
    private boolean cleanupDiskPending = false;
    private boolean loopOnce = false;
    private boolean stopping = false;
    private boolean diskClearInProgress = false;
    private int maxInvalidationBufferSize = 0;
    private int maxInvalidationBufferLife = 0;
    private long lastRemoveTime = 0L;
    private long lastWaitTime = 0L;

    private HTODInvalidationBuffer() {
    }

    public HTODInvalidationBuffer(CacheOnDisk cacheOnDisk) {
        this.cod = cacheOnDisk;
        this.maxInvalidationBufferSize = cacheOnDisk.invalidationBufferSize;
        this.maxInvalidationBufferLife = cacheOnDisk.invalidationBufferLife;
        this.explicitBuffer = new HashMap(this.maxInvalidationBufferSize);
        this.scanBuffer = new ValueSet(this.maxInvalidationBufferSize);
        if (this.cod.evictionPolicy != 0) {
            this.garbageCollectorBuffer = new ArrayList(this.maxInvalidationBufferSize);
        }
        this.backgroundInvalidationInProgress = false;
        this.cleanupDiskPending = false;
        this.loopOnce = false;
        this.stopping = false;
    }

    protected synchronized void add(Object object, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (object == null) {
            return;
        }
        if (n == 2) {
            byte by = 0;
            if (n2 != 0 && n3 != 0) {
                by = (byte)n2;
                if (n3 == 2) {
                    by = (byte)(by | 0x10);
                }
                if (bl) {
                    by = (byte)(by | 0x40);
                }
                if (bl3) {
                    by = (byte)(by | 0x20);
                }
                if (bl2) {
                    by = (byte)(by | 0xFFFFFF80);
                }
            }
            this.explicitBuffer.put(object, new Byte(by));
            this.scanBuffer.remove(object);
        } else if (n == 1) {
            if (!this.explicitBuffer.containsKey(object)) {
                this.scanBuffer.add(object);
            }
        } else if (n == 3 && this.garbageCollectorBuffer != null && !this.explicitBuffer.containsKey(object) && !this.scanBuffer.contains(object)) {
            this.garbageCollectorBuffer.add(object);
        }
        if (this.isFull() || n == 3) {
            this.invokeBackgroundInvalidation(false);
        }
    }

    protected synchronized void add(ValueSet valueSet, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (valueSet == null || valueSet.isEmpty()) {
            return;
        }
        int n4 = valueSet.size();
        if (n == 2) {
            byte by = 0;
            if (n2 != 0 && n3 != 0) {
                by = (byte)n2;
                if (n3 == 2) {
                    by = (byte)(by | 0x10);
                }
                if (bl) {
                    by = (byte)(by | 0x40);
                }
                if (bl2) {
                    by = (byte)(by | 0xFFFFFF80);
                }
            }
            for (Object e2 : valueSet) {
                this.explicitBuffer.put(e2, new Byte(by));
            }
            if (!this.scanBuffer.isEmpty()) {
                this.filter(this.scanBuffer, valueSet);
            }
        } else if (n == 1) {
            if (!this.explicitBuffer.isEmpty()) {
                this.filter(valueSet, this.explicitBuffer);
            }
            this.scanBuffer.addAll(valueSet);
        } else if (n == 3 && this.garbageCollectorBuffer != null) {
            this.garbageCollectorBuffer.addAll(valueSet);
        }
        if (n4 > 50) {
            this.traceDebug("add(ValueSet, boolean)", "cacheName=" + this.cod.cacheName + " idSet=" + n4 + " idSetFilter=" + valueSet.size() + " bufferType=" + n + " explicitBuffer=" + this.explicitBuffer.size() + " scanBuffer=" + this.scanBuffer.size());
        }
        if (bl3 && this.isFull() || n == 3) {
            this.invokeBackgroundInvalidation(false);
        }
    }

    protected synchronized void add(ArrayList arrayList, int n) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        if (n == 3 && this.garbageCollectorBuffer != null) {
            this.garbageCollectorBuffer.addAll(arrayList);
            this.invokeBackgroundInvalidation(false);
        }
    }

    protected synchronized Object get(int n) {
        Object object = null;
        if (n == 2) {
            if (!this.explicitBuffer.isEmpty()) {
                Set set = this.explicitBuffer.keySet();
                Iterator iterator = set.iterator();
                ExplicitIdData explicitIdData = new ExplicitIdData();
                while (iterator.hasNext()) {
                    explicitIdData.id = iterator.next();
                    explicitIdData.info = (Byte)this.explicitBuffer.get(explicitIdData.id);
                    if ((explicitIdData.info & 0x20) != 0) continue;
                    object = explicitIdData;
                    break;
                }
            }
        } else if (n == 1) {
            if (!this.scanBuffer.isEmpty()) {
                object = this.scanBuffer.getOne();
            }
        } else if (n == 3 && this.garbageCollectorBuffer != null && !this.garbageCollectorBuffer.isEmpty()) {
            object = this.garbageCollectorBuffer.get(0);
        }
        return object;
    }

    protected synchronized void remove(Object object, int n) {
        if (object == null) {
            return;
        }
        if (n == 2) {
            this.explicitBuffer.remove(object);
        } else if (n == 1) {
            this.scanBuffer.remove(object);
        } else if (n == 3 && this.garbageCollectorBuffer != null && object instanceof HTODDynacache.EvictionTableEntry) {
            HTODDynacache.EvictionTableEntry evictionTableEntry;
            int n2;
            HTODDynacache.EvictionTableEntry evictionTableEntry2 = (HTODDynacache.EvictionTableEntry)object;
            for (n2 = 0; n2 < this.garbageCollectorBuffer.size() && (evictionTableEntry = (HTODDynacache.EvictionTableEntry)this.garbageCollectorBuffer.get(n2)) != evictionTableEntry2; ++n2) {
            }
            if (n2 < this.garbageCollectorBuffer.size()) {
                this.garbageCollectorBuffer.remove(n2);
            }
            this.cod.htod.evictionEntryPool.add(object);
        }
    }

    protected synchronized void remove(Object object) {
        if (object == null) {
            return;
        }
        this.explicitBuffer.remove(object);
        this.scanBuffer.remove(object);
    }

    protected synchronized ValueSet getAndRemoveFromExplicitBuffer() {
        ValueSet valueSet = null;
        if (this.explicitBuffer.size() == 0) {
            valueSet = new ValueSet(1);
        } else {
            valueSet = new ValueSet(this.explicitBuffer.size());
            for (Object k : this.explicitBuffer.keySet()) {
                byte by = (Byte)this.explicitBuffer.get(k);
                if ((by & 0x20) != 0) continue;
                valueSet.add(k);
            }
            this.explicitBuffer.clear();
        }
        this.traceDebug("getAndRemoveFromExplicitBuffer", "cacheName=" + this.cod.cacheName + " bufferSize=" + valueSet.size());
        return valueSet;
    }

    protected synchronized void clear(int n) {
        if (n == 2) {
            this.explicitBuffer.clear();
        } else if (n == 1) {
            this.scanBuffer.clear();
        } else if (n == 3 && this.garbageCollectorBuffer != null) {
            for (int i = 0; i < this.garbageCollectorBuffer.size(); ++i) {
                HTODDynacache.EvictionTableEntry evictionTableEntry = (HTODDynacache.EvictionTableEntry)this.garbageCollectorBuffer.get(i);
                this.cod.htod.evictionEntryPool.add(evictionTableEntry);
            }
            this.garbageCollectorBuffer.clear();
        }
        this.traceDebug("clear()", "cacheName=" + this.cod.cacheName + " bufferType=" + n);
    }

    protected synchronized void invokeBackgroundInvalidation(boolean bl) {
        if (!this.stopping) {
            if (!this.backgroundInvalidationInProgress) {
                this.backgroundInvalidationInProgress = true;
                this.cod.doCleanUp(bl);
            } else if (bl) {
                this.traceDebug("invokeBackgroundInvalidation()", "cacheName=" + this.cod.cacheName + " set cleanupDiskPending to true");
                this.cleanupDiskPending = true;
            }
        }
    }

    protected synchronized boolean contains(Object object) {
        boolean bl = false;
        if (this.garbageCollectorBuffer != null) {
            if (this.explicitBuffer.containsKey(object) || this.scanBuffer.contains(object) || this.garbageCollectorBuffer.contains(object)) {
                bl = true;
            }
        } else if (this.explicitBuffer.containsKey(object) || this.scanBuffer.contains(object)) {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean isFull() {
        boolean bl = false;
        int n = 0;
        n = this.garbageCollectorBuffer != null ? this.explicitBuffer.size() + this.scanBuffer.size() + this.garbageCollectorBuffer.size() : this.explicitBuffer.size() + this.scanBuffer.size();
        if (n > this.maxInvalidationBufferSize || System.currentTimeMillis() - this.lastRemoveTime >= (long)this.maxInvalidationBufferLife) {
            bl = true;
            this.setlastRemoveTime();
        }
        return bl;
    }

    protected synchronized void filter(ValueSet valueSet) {
        boolean bl = this.explicitBuffer.isEmpty();
        boolean bl2 = this.scanBuffer.isEmpty();
        if (!(valueSet == null || valueSet.isEmpty() || bl && bl2)) {
            Iterator iterator = valueSet.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!bl && this.explicitBuffer.containsKey(e2)) {
                    iterator.remove();
                    continue;
                }
                if (bl2 || !this.scanBuffer.contains(e2)) continue;
                iterator.remove();
            }
        }
    }

    private void filter(ValueSet valueSet, ValueSet valueSet2) {
        if (valueSet != null && valueSet2 != null && !valueSet.isEmpty() && !valueSet2.isEmpty()) {
            Iterator iterator = valueSet.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!valueSet2.contains(e2)) continue;
                iterator.remove();
            }
        }
    }

    private void filter(ValueSet valueSet, HashMap hashMap) {
        if (valueSet != null && hashMap != null && !valueSet.isEmpty() && !hashMap.isEmpty()) {
            Iterator iterator = valueSet.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!hashMap.containsKey(e2)) continue;
                iterator.remove();
            }
        }
    }

    protected synchronized int size(int n) {
        if (n == 2) {
            return this.explicitBuffer.size();
        }
        if (n == 1) {
            return this.scanBuffer.size();
        }
        if (n == 3 && this.garbageCollectorBuffer != null) {
            return this.garbageCollectorBuffer.size();
        }
        return 0;
    }

    protected synchronized int size() {
        return this.explicitBuffer.size() + this.scanBuffer.size();
    }

    protected synchronized boolean isCleanupPending() {
        return this.cleanupDiskPending;
    }

    protected synchronized void resetCleanupPending() {
        this.cleanupDiskPending = false;
        this.traceDebug("resetCleanupPending()", "cacheName=" + this.cod.cacheName);
    }

    protected synchronized boolean isBackgroundInvalidationInProgress() {
        return this.backgroundInvalidationInProgress;
    }

    protected synchronized void resetBackgroundInvalidationInProgress() {
        this.backgroundInvalidationInProgress = false;
    }

    protected synchronized boolean isLoopOnce() {
        return this.loopOnce;
    }

    protected synchronized void setLoopOnce(boolean bl) {
        this.loopOnce = bl;
        this.traceDebug("setLoopOnce()", "cacheName=" + this.cod.cacheName + " loopOnce=" + bl + " explicitBuffer=" + this.explicitBuffer.size() + " scanBuffer=" + this.scanBuffer.size());
    }

    protected synchronized void setlastRemoveTime() {
        this.lastRemoveTime = System.currentTimeMillis();
    }

    protected synchronized void setStopping(boolean bl) {
        this.stopping = bl;
        this.traceDebug("setStopping()", "cacheName=" + this.cod.cacheName + " stopping=" + this.stopping);
    }

    protected synchronized boolean isDiskClearInProgress() {
        return this.diskClearInProgress;
    }

    protected synchronized void setDiskClearInProgress(boolean bl) {
        this.diskClearInProgress = bl;
    }

    private void traceDebug(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + " " + string2);
        }
    }
}

