/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.drs.ws390.DynacachePlatformHelper;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class IdObject
implements Externalizable {
    private static final long serialVersionUID = -1537510527687102354L;
    private static TraceComponent tc = Trace.register(IdObject.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public Object id = null;
    public boolean useServerClassLoader = false;
    private byte[] serializedId = null;

    public IdObject() {
    }

    public IdObject(Object object) {
        this.id = object;
    }

    public void setClassLoaderType(boolean bl) {
        this.useServerClassLoader = bl;
    }

    public boolean prepareForSerialization() {
        boolean bl = true;
        String string = null;
        if (this.serializedId == null && bl) {
            try {
                this.serializedId = SerializationUtility.serialize((Serializable)this.id);
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (this.serializedId == null) {
                Tr.error(tc, "dynacache.error", new Object[]{"OBJECT_NOT_REPLICATED_OR_SAVED_TO_DISK ID className=" + this.id.getClass().getName() + " exception=" + string});
                bl = false;
            }
        }
        return bl;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.prepareForSerialization();
        if (this.serializedId != null) {
            objectOutput.writeInt(this.serializedId.length);
            objectOutput.write(this.serializedId);
            objectOutput.writeBoolean(this.useServerClassLoader);
        } else {
            objectOutput.writeInt(-1);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        block10: {
            try {
                int n = objectInput.readInt();
                if (n > 0) {
                    this.serializedId = new byte[n];
                    objectInput.readFully(this.serializedId);
                    try {
                        this.useServerClassLoader = objectInput.readBoolean();
                    }
                    catch (Exception exception) {
                        this.useServerClassLoader = false;
                    }
                } else {
                    this.serializedId = null;
                }
                if (this.serializedId != null) {
                    try {
                        if (!DynacachePlatformHelper.isZOS_Controller()) {
                            this.id = this.useServerClassLoader ? SerializationUtility.deserialize_1(this.serializedId, 0, this.serializedId.length) : SerializationUtility.deserialize(this.serializedId);
                            this.serializedId = null;
                        }
                        break block10;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.IdObject.readExternal", "366", this);
                        exception.printStackTrace();
                    }
                    break block10;
                }
                this.id = null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.IdObject.readExternal", "468", this);
                exception.printStackTrace();
            }
        }
    }

    public Object getId() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IdObject)) {
            return false;
        }
        IdObject idObject = (IdObject)object;
        if (this.id == null || idObject.id == null) {
            return super.equals(object);
        }
        return this.id.equals(idObject.id);
    }

    public int hashCode() {
        if (this.id == null) {
            return IdObject.class.hashCode();
        }
        return this.id.hashCode();
    }

    public String toString() {
        String string = "";
        if (this.id != null) {
            string = this.id.toString();
        }
        return string;
    }
}

