/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.ExternalCacheFragment;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.InvalidationEvent;
import com.ibm.ws.cache.NonSyncHashtable;
import com.ibm.ws.cache.ReadWriteLock;
import com.ibm.ws.cache.RealTimeDaemon;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

public class InvalidationAuditDaemon
extends RealTimeDaemon {
    TraceComponent tc = Trace.register(InvalidationAuditDaemon.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private long lastTimeCleared = 0L;
    private HashMap cacheInstanceinvalidationTables = new HashMap();

    public InvalidationAuditDaemon(int n) {
        super(n);
        this.lastTimeCleared = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp(long l, long l2) {
        String[] stringArray;
        this.lastTimeCleared = l2;
        InvalidationAuditDaemon invalidationAuditDaemon = this;
        synchronized (invalidationAuditDaemon) {
            int n = this.cacheInstanceinvalidationTables.size();
            if (n <= 0) {
                return;
            }
            stringArray = new String[n];
            this.cacheInstanceinvalidationTables.keySet().toArray(stringArray);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            InvalidationTableList invalidationTableList = this.getInvalidationTableList(stringArray[i]);
            ReadWriteLock readWriteLock = invalidationTableList.readWriteLock;
            synchronized (readWriteLock) {
                invalidationTableList.readWriteLock.preWrite();
                try {
                    invalidationTableList.pastIdSet.clear();
                    NonSyncHashtable nonSyncHashtable = invalidationTableList.pastIdSet;
                    invalidationTableList.pastIdSet = invalidationTableList.presentIdSet;
                    invalidationTableList.presentIdSet = invalidationTableList.futureIdSet;
                    invalidationTableList.futureIdSet = nonSyncHashtable;
                    invalidationTableList.pastTemplateSet.clear();
                    nonSyncHashtable = invalidationTableList.pastTemplateSet;
                    invalidationTableList.pastTemplateSet = invalidationTableList.presentTemplateSet;
                    invalidationTableList.presentTemplateSet = invalidationTableList.futureTemplateSet;
                    invalidationTableList.futureTemplateSet = nonSyncHashtable;
                }
                finally {
                    invalidationTableList.readWriteLock.postWrite();
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInvalidations(String string, Iterator iterator) {
        InvalidationTableList invalidationTableList = this.getInvalidationTableList(string);
        if (invalidationTableList != null) {
            ReadWriteLock readWriteLock = invalidationTableList.readWriteLock;
            synchronized (readWriteLock) {
                invalidationTableList.readWriteLock.preWrite();
                try {
                    while (iterator.hasNext()) {
                        try {
                            long l;
                            Externalizable externalizable;
                            Object object;
                            Externalizable externalizable2;
                            Object e2 = iterator.next();
                            if (e2 instanceof InvalidateByIdEvent) {
                                externalizable2 = (InvalidateByIdEvent)e2;
                                object = ((InvalidateByIdEvent)externalizable2).getId();
                                externalizable = (InvalidateByIdEvent)invalidationTableList.presentIdSet.get(object);
                                l = ((InvalidateByIdEvent)externalizable2).getTimeStamp();
                                if (externalizable != null && ((InvalidateByIdEvent)externalizable).getTimeStamp() >= l) continue;
                                invalidationTableList.presentIdSet.put(object, externalizable2);
                                continue;
                            }
                            externalizable2 = (InvalidateByTemplateEvent)e2;
                            object = ((InvalidateByTemplateEvent)externalizable2).getTemplate();
                            externalizable = (InvalidateByTemplateEvent)invalidationTableList.presentTemplateSet.get(object);
                            l = ((InvalidateByTemplateEvent)externalizable2).getTimeStamp();
                            if (externalizable != null && ((InvalidateByTemplateEvent)externalizable).getTimeStamp() >= l) continue;
                            invalidationTableList.presentTemplateSet.put(object, externalizable2);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.InvalidationAuditDaemon.registerInvalidations", "126", this);
                            exception.printStackTrace();
                        }
                    }
                }
                finally {
                    invalidationTableList.readWriteLock.postWrite();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry filterEntry(String string, CacheEntry cacheEntry) {
        InvalidationTableList invalidationTableList = this.getInvalidationTableList(string);
        invalidationTableList.readWriteLock.preRead();
        try {
            CacheEntry cacheEntry2 = this.internalFilterEntry(string, invalidationTableList, cacheEntry);
            return cacheEntry2;
        }
        finally {
            invalidationTableList.readWriteLock.postRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList filterEntryList(String string, ArrayList arrayList) {
        InvalidationTableList invalidationTableList = this.getInvalidationTableList(string);
        invalidationTableList.readWriteLock.preRead();
        try {
            ArrayList arrayList2;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                CacheEntry cacheEntry;
                arrayList2 = iterator.next();
                if (!(arrayList2 instanceof CacheEntry) || this.internalFilterEntry(string, invalidationTableList, cacheEntry = (CacheEntry)((Object)arrayList2)) != null) continue;
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, "filterEntryList(): Filtered OUT cacheName=" + string + " id=" + cacheEntry.id);
                }
                iterator.remove();
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            invalidationTableList.readWriteLock.postRead();
        }
    }

    private final CacheEntry internalFilterEntry(String string, InvalidationTableList invalidationTableList, CacheEntry cacheEntry) {
        InvalidateByIdEvent invalidateByIdEvent = null;
        if (cacheEntry == null) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "internalFilterEntry(): Filtered cacheName=" + string + " CE == NULL");
            }
            return null;
        }
        if (cacheEntry.id == null) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "internalFilterEntry(): Filtered cacheName=" + string + " id == NULL");
            }
            return null;
        }
        long l = cacheEntry.getTimeStamp();
        invalidateByIdEvent = (InvalidateByIdEvent)invalidationTableList.presentIdSet.get(cacheEntry.id);
        if (invalidateByIdEvent != null && invalidateByIdEvent.getTimeStamp() > l) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "internalFilterEntry(): Filtered Found a more recent InvalidateByIdEvent for the cacheEntry in presentIdSet. cacheName=" + string + " id=" + cacheEntry.id);
            }
            return null;
        }
        if (this.collision(invalidationTableList.presentTemplateSet, cacheEntry.getTemplates(), l) || this.collision(invalidationTableList.presentIdSet, cacheEntry.getDataIds(), l)) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "internalFilterEntry(): Filtered due to preexisting invalidations due to dependencies and templates in present template and IdSet. cacheName=" + string + " id=" + cacheEntry.id);
            }
            return null;
        }
        if (l > this.lastTimeCleared) {
            return cacheEntry;
        }
        invalidateByIdEvent = (InvalidateByIdEvent)invalidationTableList.pastIdSet.get(cacheEntry.id);
        if (invalidateByIdEvent != null && invalidateByIdEvent.getTimeStamp() > l) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "internalFilterEntry(): Filtered Found a more recent InvalidateByIdEvent for the cacheEntry in pastIdSet. cacheName=" + string + " id=" + cacheEntry.id);
            }
            return null;
        }
        if (this.collision(invalidationTableList.pastTemplateSet, cacheEntry.getTemplates(), l) || this.collision(invalidationTableList.pastIdSet, cacheEntry.getDataIds(), l)) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "internalFilterEntry(): Filtered due to preexisting invalidations due to dependencies and templates in past template and IdSet. cacheName=" + string + " id=" + cacheEntry.id);
            }
            return null;
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalCacheFragment filterExternalCacheFragment(String string, ExternalCacheFragment externalCacheFragment) {
        InvalidationTableList invalidationTableList = this.getInvalidationTableList(string);
        invalidationTableList.readWriteLock.preRead();
        try {
            ExternalCacheFragment externalCacheFragment2 = this.internalFilterExternalCacheFragment(string, invalidationTableList, externalCacheFragment);
            return externalCacheFragment2;
        }
        finally {
            invalidationTableList.readWriteLock.postRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList filterExternalCacheFragmentList(String string, ArrayList arrayList) {
        InvalidationTableList invalidationTableList = this.getInvalidationTableList(string);
        invalidationTableList.readWriteLock.preRead();
        try {
            Serializable serializable;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                serializable = (ExternalCacheFragment)iterator.next();
                if (null != this.internalFilterExternalCacheFragment(string, invalidationTableList, (ExternalCacheFragment)serializable)) continue;
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, "filterExternalCacheFragmentList(): Filtered OUT cacheName=" + string + " uri=" + ((ExternalCacheFragment)serializable).getUri());
                }
                iterator.remove();
            }
            serializable = arrayList;
            return serializable;
        }
        finally {
            invalidationTableList.readWriteLock.postRead();
        }
    }

    private final ExternalCacheFragment internalFilterExternalCacheFragment(String string, InvalidationTableList invalidationTableList, ExternalCacheFragment externalCacheFragment) {
        if (externalCacheFragment == null) {
            return null;
        }
        long l = externalCacheFragment.getTimeStamp();
        if (this.collision(invalidationTableList.presentTemplateSet, externalCacheFragment.getInvalidationIds(), l) || this.collision(invalidationTableList.presentIdSet, externalCacheFragment.getTemplates(), l)) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "internalFilterExternalCacheFragment(): Filtered due to preexisting invalidations due to dependencies and templates in present template and IdSet. cacheName=" + string + " url=" + externalCacheFragment.getUri());
            }
            return null;
        }
        if (l > this.lastTimeCleared) {
            return externalCacheFragment;
        }
        if (this.collision(invalidationTableList.pastTemplateSet, externalCacheFragment.getInvalidationIds(), l) || this.collision(invalidationTableList.pastIdSet, externalCacheFragment.getTemplates(), l)) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "internalFilterExternalCacheFragment(): Filtered due to preexisting invalidations due to dependencies and templates in past template and IdSet. cacheName=" + string + " url=" + externalCacheFragment.getUri());
            }
            return null;
        }
        return externalCacheFragment;
    }

    private final boolean collision(NonSyncHashtable nonSyncHashtable, Enumeration enumeration, long l) {
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            InvalidationEvent invalidationEvent = (InvalidationEvent)nonSyncHashtable.get(e2);
            if (invalidationEvent == null || invalidationEvent.getTimeStamp() <= l) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvalidationTableList getInvalidationTableList(String string) {
        InvalidationTableList invalidationTableList = null;
        InvalidationAuditDaemon invalidationAuditDaemon = this;
        synchronized (invalidationAuditDaemon) {
            invalidationTableList = (InvalidationTableList)this.cacheInstanceinvalidationTables.get(string);
            if (invalidationTableList == null) {
                invalidationTableList = new InvalidationTableList();
                this.cacheInstanceinvalidationTables.put(string, invalidationTableList);
            }
        }
        return invalidationTableList;
    }

    static class InvalidationTableList {
        public NonSyncHashtable pastIdSet = new NonSyncHashtable(1000);
        public NonSyncHashtable presentIdSet = new NonSyncHashtable(1000);
        public NonSyncHashtable futureIdSet = new NonSyncHashtable(1000);
        public NonSyncHashtable pastTemplateSet = new NonSyncHashtable(100);
        public NonSyncHashtable presentTemplateSet = new NonSyncHashtable(100);
        public NonSyncHashtable futureTemplateSet = new NonSyncHashtable(100);
        public ReadWriteLock readWriteLock = new ReadWriteLock();

        InvalidationTableList() {
        }
    }
}

