/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.CacheEntry;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.WCCMCacheConfig;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.wsspi.cache.CacheStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.management.AttributeNotFoundException;

public class MBeans {
    private static TraceComponent tc = Trace.register(MBeans.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final boolean INCLUDE_VALUE = true;

    public int getCacheSize(WCCMCacheConfig wCCMCacheConfig) {
        if (wCCMCacheConfig != null) {
            return wCCMCacheConfig.cacheSize;
        }
        return 0;
    }

    public int getUsedCacheSize(DCache dCache) {
        if (dCache != null) {
            Enumeration enumeration = dCache.getAllIds();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                ++n;
                enumeration.nextElement();
            }
            return n;
        }
        return 0;
    }

    public boolean getDiskOverflow(WCCMCacheConfig wCCMCacheConfig) {
        if (wCCMCacheConfig != null) {
            return wCCMCacheConfig.enableDiskOffload;
        }
        return false;
    }

    public String[] getCacheStatisticNames(String string) {
        DCache dCache = ServerCache.getCache(string);
        return this.getCacheStatisticNames(dCache);
    }

    public String[] getCacheStatisticNames(DCache dCache) {
        Map map = MBeans.getCacheStatisticsMap(dCache.getCacheStatistics());
        String[] stringArray = new String[map.size()];
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public String[] getCacheInstanceNames(DCache dCache) {
        Map map = ServerCache.getCacheInstances();
        String[] stringArray = new String[map.size() + 1];
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        stringArray[stringArray.length - 1] = dCache.getCacheName();
        return stringArray;
    }

    public String[] getAllCacheStatistics(DCache dCache) {
        Map map = MBeans.getCacheStatisticsMap(dCache.getCacheStatistics());
        Iterator iterator = map.keySet().iterator();
        Iterator iterator2 = map.values().iterator();
        String[] stringArray = new String[map.size()];
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next() + "=" + iterator2.next();
            ++n;
        }
        return stringArray;
    }

    public String[] getAllCacheStatistics(String string) throws AttributeNotFoundException {
        DCache dCache = this.getCache(string);
        Map map = MBeans.getCacheStatisticsMap(dCache.getCacheStatistics());
        Iterator iterator = map.keySet().iterator();
        Iterator iterator2 = map.values().iterator();
        String[] stringArray = new String[map.size()];
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next() + "=" + iterator2.next();
            ++n;
        }
        return stringArray;
    }

    public String[] getCacheStatistics(String[] stringArray, DCache dCache) throws AttributeNotFoundException {
        if (stringArray == null) {
            return null;
        }
        Map map = MBeans.getCacheStatisticsMap(dCache.getCacheStatistics());
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (!map.containsKey(stringArray[i])) {
                throw new AttributeNotFoundException(stringArray[i] + " is not a valid cache statistic name");
            }
            stringArray2[i] = stringArray[i] + "=" + map.get(stringArray[i]);
        }
        return stringArray2;
    }

    public String[] getCacheStatistics(String string, String[] stringArray) throws AttributeNotFoundException {
        if (stringArray == null) {
            return null;
        }
        DCache dCache = this.getCache(string);
        Map map = MBeans.getCacheStatisticsMap(dCache.getCacheStatistics());
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (!map.containsKey(stringArray[i])) {
                throw new AttributeNotFoundException(stringArray[i] + " is not a valid cache statistic name");
            }
            stringArray2[i] = stringArray[i] + "=" + map.get(stringArray[i]);
        }
        return stringArray2;
    }

    public String[] getCacheIDsInMemory(String string, String string2) throws AttributeNotFoundException {
        Object object;
        if (string == null) {
            throw new AttributeNotFoundException(string + " is not a valid cache instance name.");
        }
        DCache dCache = this.getCache(string);
        Pattern pattern = this.checkPattern(string2);
        ArrayList<String> arrayList = new ArrayList<String>(10);
        int n = 0;
        Enumeration enumeration = dCache.getAllIds();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            String string3 = object.toString();
            boolean bl = this.checkMatch(pattern, string3);
            if (!bl) continue;
            arrayList.add(string3);
            ++n;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCacheIDsInMemory/" + string + "/" + "Exiting. Number of matches found = " + n);
        }
        object = arrayList.toArray(new String[arrayList.size()]);
        return object;
    }

    public String[] getCacheIDsOnDisk(String string, String string2) throws AttributeNotFoundException {
        if (string == null) {
            throw new AttributeNotFoundException(string + " is not a valid cache instance name.");
        }
        DCache dCache = this.getCache(string);
        if (!dCache.getSwapToDisk()) {
            throw new AttributeNotFoundException("Disk caching is not enabled.");
        }
        Pattern pattern = this.checkPattern(string2);
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (dCache.getIdsSizeDisk() > 0) {
            int n = 0;
            boolean bl = false;
            do {
                bl = false;
                Collection collection = dCache.getIdsByRangeDisk(n, 100);
                if (collection != null && collection.contains("DISKCACHE_MORE")) {
                    bl = true;
                }
                n = 1;
                collection.remove("DISKCACHE_MORE");
                for (Object e2 : collection) {
                    String string3 = e2.toString();
                    boolean bl2 = this.checkMatch(pattern, string3);
                    if (!bl2) continue;
                    arrayList.add(string3);
                }
            } while (bl);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCacheIDsOnDisk: Exiting. Number of matches found = " + arrayList.size());
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    public String[] invalidateCacheIDs(String string, String string2, boolean bl) throws AttributeNotFoundException {
        String[] stringArray;
        if (string == null) {
            throw new AttributeNotFoundException(string + " is not a valid cache instance name.");
        }
        DCache dCache = this.getCache(string);
        if (string2.equals("*")) {
            dCache.clear();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalidateCacheIDs: Exiting. Cleared memory and disk cache since input pattern is *");
            }
            return new String[]{"*"};
        }
        this.checkPattern(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.getCacheIDsInMemory(string, string2);
        if (null != stringArray2) {
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList.add(stringArray2[i]);
            }
        }
        if (dCache.getSwapToDisk() && null != (stringArray = this.getCacheIDsOnDisk(string, string2))) {
            void e2;
            boolean i = false;
            while (e2 < stringArray.length) {
                arrayList.add(stringArray[e2]);
                ++e2;
            }
        }
        for (Object stringArray3 : arrayList) {
            dCache.invalidateById(stringArray3, bl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalidateCacheIDs: Exiting. Number of matches found = " + arrayList.size());
        }
        String[] stringArray3 = arrayList.toArray(new String[arrayList.size()]);
        return stringArray3;
    }

    public String getCacheEntry(String string, String string2) throws AttributeNotFoundException {
        if (string == null) {
            throw new AttributeNotFoundException(string + " is not a valid cache instance name.");
        }
        if (string2 == null) {
            throw new AttributeNotFoundException(string2 + " is null.");
        }
        DCache dCache = this.getCache(string);
        EntryInfo entryInfo = new EntryInfo();
        entryInfo.setId(string2);
        CacheEntry cacheEntry = dCache.getEntry(entryInfo, true);
        String string3 = null;
        if (null != cacheEntry) {
            string3 = ((Object)cacheEntry).toString();
            cacheEntry.finish();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCacheEntry: Returning: " + string3 + " for cacheInstance = " + string);
        }
        return string3;
    }

    public void clearCache(String string) throws AttributeNotFoundException {
        if (string == null) {
            throw new AttributeNotFoundException(string + " is not a valid cache instance name.");
        }
        DCache dCache = this.getCache(string);
        dCache.clear();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clearCache: Exiting. Cleared memory and disk cache.");
        }
    }

    private DCache getCache(String string) throws AttributeNotFoundException {
        DCache dCache = null;
        dCache = string.equals("baseCache") ? ServerCache.cache : ServerCache.getConfiguredCache(string);
        if (dCache == null) {
            throw new AttributeNotFoundException(string + " is not a valid cache instance name.");
        }
        return dCache;
    }

    private Pattern checkPattern(String string) throws AttributeNotFoundException {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new AttributeNotFoundException("The pattern " + string + " is not a valid regular expression. Caught PatternSyntaxException:" + patternSyntaxException.getMessage());
        }
        return pattern;
    }

    private boolean checkMatch(Pattern pattern, String string) {
        return pattern.matcher(string).find();
    }

    public static Map getCacheStatisticsMap(CacheStatistics cacheStatistics) {
        TreeMap<String, Number> treeMap = new TreeMap<String, Number>();
        if (cacheStatistics != null) {
            treeMap.put("CacheHits", cacheStatistics.getCacheHitsCount());
            treeMap.put("CacheLruRemoves", cacheStatistics.getCacheLruRemovesCount());
            treeMap.put("CacheMisses", cacheStatistics.getCacheMissesCount());
            treeMap.put("CacheRemoves", cacheStatistics.getCacheRemovesCount());
            treeMap.put("ExplicitInvalidationsFromMemory", cacheStatistics.getExplicitInvalidationsFromMemoryCount());
            treeMap.put("MemoryCacheEntries", cacheStatistics.getMemoryCacheEntriesCount());
            treeMap.put("MemoryCacheSizeInMB", Float.valueOf(cacheStatistics.getMemoryCacheSizeInMBCount()));
            treeMap.put("TimeoutInvalidationsFromMemory", cacheStatistics.getTimeoutInvalidationsFromMemoryCount());
            Map<String, Number> map = cacheStatistics.getExtendedStats();
            if (map != null) {
                treeMap.putAll(cacheStatistics.getExtendedStats());
            }
        }
        return treeMap;
    }
}

