/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.ffdc.FFDCFilter;

public class ReadWriteLock {
    private static TraceComponent tc = Trace.register(ReadWriteLock.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private int read = 0;
    private int write = 0;
    private boolean writing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void preRead() {
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            while (true) {
                if (this.write <= 0) {
                    ++this.read;
                    return;
                }
                try {
                    this.wait();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "read wait");
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.cache.ReadWriteLock.preRead", "80", this);
                    interruptedException.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRead() {
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            --this.read;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preWrite() {
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            ++this.write;
            while (this.read > 0 || this.writing) {
                try {
                    this.wait();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "write wait");
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.cache.ReadWriteLock.preWrite", "113", this);
                    interruptedException.printStackTrace();
                }
            }
            this.writing = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postWrite() {
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            --this.write;
            this.writing = false;
            this.notifyAll();
        }
    }
}

