/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;

public class SerializationUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] serialize(Serializable serializable) throws IOException {
        if (serializable == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        byte[] byArray = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            byArray = byteArrayOutputStream.toByteArray();
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
        return byArray;
    }

    public static final Serializable deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        return SerializationUtility.deserialize(byArray, 0, byArray.length);
    }

    public static final Serializable deserialize(byte[] byArray, int n, int n2) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            byteArrayInputStream.mark(byArray.length);
            objectInputStream = new WsObjectInputStream(byteArrayInputStream);
            Serializable serializable = (Serializable)objectInputStream.readObject();
            return serializable;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader = ServerCache.getClassLoader();
            if (classLoader != null) {
                byteArrayInputStream.reset();
                objectInputStream = new WsObjectInputStream(byteArrayInputStream, classLoader);
                Serializable serializable = (Serializable)objectInputStream.readObject();
                return serializable;
            }
            throw classNotFoundException;
        }
        catch (StreamCorruptedException streamCorruptedException) {
            ClassLoader classLoader = ServerCache.getClassLoader();
            if (classLoader != null) {
                byteArrayInputStream.reset();
                objectInputStream = new WsObjectInputStream(byteArrayInputStream, classLoader);
                Serializable serializable = (Serializable)objectInputStream.readObject();
                return serializable;
            }
            throw streamCorruptedException;
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }

    public static final Serializable deserialize_1(byte[] byArray, int n, int n2) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            byteArrayInputStream.mark(byArray.length);
            ClassLoader classLoader = ServerCache.getClassLoader();
            if (classLoader != null) {
                byteArrayInputStream.reset();
                objectInputStream = new WsObjectInputStream(byteArrayInputStream, classLoader);
                Object object = objectInputStream.readObject();
                Serializable serializable = (Serializable)object;
                return serializable;
            }
            byteArrayInputStream.reset();
            objectInputStream = new WsObjectInputStream(byteArrayInputStream);
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            Object object = objectInputStream.readObject();
            Serializable serializable = (Serializable)object;
            return serializable;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw classNotFoundException;
        }
        catch (StreamCorruptedException streamCorruptedException) {
            streamCorruptedException.printStackTrace();
            throw streamCorruptedException;
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }
}

