/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheInstanceInfo;
import com.ibm.ws.cache.CacheProviderWrapper;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.CacheServiceImpl;
import com.ibm.ws.cache.CacheUnitImpl;
import com.ibm.ws.cache.DistributedMapImpl;
import com.ibm.ws.cache.DistributedNioMapImpl;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.WCCMCacheConfig;
import com.ibm.ws.cache.command.CommandCache;
import com.ibm.ws.cache.drs.DRSNotificationService;
import com.ibm.ws.cache.drs.DRSRemoteServices;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.CacheFeatureSupport;
import com.ibm.wsspi.cache.CacheProvider;
import com.ibm.wsspi.cache.CoreCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ServerCache {
    private static TraceComponent tc = Trace.register(ServerCache.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static boolean cacheEnabled = false;
    public static CacheUnitImpl cacheUnit = null;
    public static DCache cache = null;
    public static CommandCache commandCache = null;
    public static JSPCache jspCache = null;
    public static CacheService cacheService = null;
    public static ClassLoader classLoader = null;
    private static int sharingPolicy = 1;
    private static int pushFrequency = 0;
    private static Map cacheInstances = new HashMap();
    private static Map commandCacheInstances = new HashMap();
    private static Map jspCacheInstances = new HashMap();
    private static Map jaxRpcCacheInstances = new HashMap();
    private static Map monitors = new HashMap();
    private static Object cacheIntancesMonitor = new Object();

    public static int getSharingPolicy() {
        return sharingPolicy;
    }

    public static void setSharingPolicy(int n) {
        sharingPolicy = n;
    }

    public static int getPushFrequency() {
        return pushFrequency;
    }

    public static void setPushFrequency(int n) {
        pushFrequency = n;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setClassLoader()classLoader=" + classLoader);
        }
        ServerCache.classLoader = classLoader;
    }

    public static boolean isBatchEnabled() {
        return pushFrequency > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getCacheInstances() {
        Object object = cacheIntancesMonitor;
        synchronized (object) {
            return new HashMap(cacheInstances);
        }
    }

    public static JSPCache getJspCache(String string) {
        JSPCache jSPCache = jspCache;
        if (string != null && !string.equalsIgnoreCase("baseCache") && !string.equalsIgnoreCase("services/cache/basecache")) {
            jSPCache = (JSPCache)jspCacheInstances.get(string);
            if (!jspCacheInstances.containsKey(string)) {
                WCCMCacheConfig wCCMCacheConfig = cacheService.getCacheInstanceConfig(string);
                if (wCCMCacheConfig == null) {
                    Tr.error(tc, "DYNA1004E", new Object[]{string});
                    jSPCache = null;
                } else if (!wCCMCacheConfig.enableServletSupport) {
                    Tr.error(tc, "DYNA1004E", new Object[]{string});
                    jSPCache = null;
                } else {
                    DCache dCache = ServerCache.getCache(string);
                    if (dCache == null) {
                        dCache = ServerCache.createCache(string, wCCMCacheConfig);
                    }
                    jSPCache = new JSPCache();
                    jSPCache.setCache(dCache);
                    jSPCache.setBatchUpdateDaemon(ServerCache.cacheUnit.batchUpdateDaemon);
                    jSPCache.setRemoteServices(dCache.getRemoteServices());
                    jSPCache.setDefaultPriority(wCCMCacheConfig.jspCachePriority);
                    jSPCache.setExternalCacheServices(cacheUnit.getExternalCacheServices());
                    jSPCache.start();
                }
                jspCacheInstances.put(string, jSPCache);
            }
        }
        return jSPCache;
    }

    public static CommandCache getCommandCache(String string) {
        CommandCache commandCache = ServerCache.commandCache;
        if (string != null && !string.equalsIgnoreCase("baseCache") && !string.equalsIgnoreCase("services/cache/basecache")) {
            commandCache = (CommandCache)commandCacheInstances.get(string);
            if (!commandCacheInstances.containsKey(string)) {
                WCCMCacheConfig wCCMCacheConfig = cacheService.getCacheInstanceConfig(string);
                if (wCCMCacheConfig == null) {
                    Tr.error(tc, "DYNA1004E", new Object[]{string});
                    commandCache = null;
                } else if (!wCCMCacheConfig.enableServletSupport) {
                    Tr.error(tc, "DYNA1004E", new Object[]{string});
                    commandCache = null;
                } else {
                    DCache dCache = ServerCache.getCache(string);
                    if (dCache == null) {
                        dCache = ServerCache.createCache(string, wCCMCacheConfig);
                    }
                    commandCache = new CommandCache();
                    commandCache.setCache(dCache);
                    commandCache.setBatchUpdateDaemon(ServerCache.cacheUnit.batchUpdateDaemon);
                    commandCache.setRemoteServices(dCache.getRemoteServices());
                    commandCache.setDefaultPriority(wCCMCacheConfig.commandCachePriority);
                    commandCache.setCommandStoragePolicy(cacheUnit.getCommandStoragePolicy());
                    commandCache.start();
                }
                commandCacheInstances.put(string, commandCache);
            }
        }
        return commandCache;
    }

    public static DCache getJaxRpcCache(String string) {
        DCache dCache = cache;
        if (string != null && !string.equalsIgnoreCase("baseCache") && !string.equalsIgnoreCase("services/cache/basecache")) {
            dCache = (DCache)jaxRpcCacheInstances.get(string);
            if (!jaxRpcCacheInstances.containsKey(string)) {
                WCCMCacheConfig wCCMCacheConfig = cacheService.getCacheInstanceConfig(string);
                if (wCCMCacheConfig == null) {
                    Tr.error(tc, "DYNA1004E", new Object[]{string});
                    dCache = null;
                } else if (!wCCMCacheConfig.enableServletSupport) {
                    Tr.error(tc, "DYNA1004E", new Object[]{string});
                    dCache = null;
                } else {
                    dCache = ServerCache.getCache(string);
                    if (dCache == null) {
                        dCache = ServerCache.createCache(string, wCCMCacheConfig);
                    }
                }
                jaxRpcCacheInstances.put(string, dCache);
            }
        }
        return dCache;
    }

    public static DCache getCache(String string) {
        DCache dCache = cache;
        if (string != null && !string.equalsIgnoreCase("baseCache") && !string.equalsIgnoreCase("services/cache/basecache")) {
            String string2 = string;
            if (string.equalsIgnoreCase("services/cache/distributedmap")) {
                string2 = "default";
            }
            dCache = (DCache)cacheInstances.get(string2);
        }
        return dCache;
    }

    public static DCache getConfiguredCache(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfiguredCache() input cacheName=" + string);
        }
        DCache dCache = cache;
        if (string != null && !string.equalsIgnoreCase("baseCache") && !string.equalsIgnoreCase("services/cache/basecache") && (dCache = ServerCache.getCache(string)) == null) {
            WCCMCacheConfig wCCMCacheConfig = cacheService.getCacheInstanceConfig(string);
            if (wCCMCacheConfig == null) {
                Tr.error(tc, "DYNA1004E", new Object[]{string});
                dCache = null;
            } else {
                dCache = ServerCache.createCache(wCCMCacheConfig.cacheName, wCCMCacheConfig);
                if (dCache != null && !wCCMCacheConfig.enableServletSupport) {
                    if (!wCCMCacheConfig.enableLockingSupport && !wCCMCacheConfig.enableNioSupport) {
                        wCCMCacheConfig.distributedObjectCache = new DistributedMapImpl(dCache);
                    } else if (wCCMCacheConfig.enableNioSupport) {
                        wCCMCacheConfig.distributedObjectCache = new DistributedNioMapImpl(dCache);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfiguredCache() output cacheName=" + (dCache != null ? dCache.getCacheName() : "null"));
        }
        return dCache;
    }

    public static DCache createCache(String string, CacheConfig cacheConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCache() cacheName=" + string + " config=" + cacheConfig + " enableReplication=" + cacheConfig.enableCacheReplication + " provider= " + cacheConfig.cacheProviderName);
        }
        DCache dCache = null;
        String string2 = ServerCache.normalizeCacheName(string, cacheConfig);
        cacheConfig.determineCacheProvider();
        if (cacheConfig.isDefaultCacheProvider()) {
            dCache = ServerCache.createDefaultProviderCache(string, cacheConfig);
        } else if (null == (dCache = ServerCache.createAlternateProviderCache(string, cacheConfig, dCache, string2))) {
            dCache = string.equals("baseCache") ? new Cache("baseCache", cacheConfig) : ServerCache.createDefaultProviderCache(string, cacheConfig);
        }
        if (null != dCache) {
            Tr.info(tc, "DYNA1001I", new Object[]{string2});
            Tr.info(tc, "DYNA1071I", new Object[]{cacheConfig.getCacheProviderName()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCache() cache=" + dCache);
        }
        return dCache;
    }

    private static DCache createAlternateProviderCache(String string, CacheConfig cacheConfig, DCache dCache, String string2) {
        boolean bl = false;
        CacheProvider cacheProvider = cacheService.getCacheProvider(cacheConfig.cacheProviderName);
        if (null != cacheProvider) {
            ServerCache.changeCacheNameToNonPrefixed(cacheConfig, string2);
            CoreCache coreCache = cacheProvider.createCache(cacheConfig);
            if (null != coreCache) {
                CacheFeatureSupport cacheFeatureSupport = cacheProvider.getCacheFeatureSupport();
                dCache = new CacheProviderWrapper(cacheConfig, cacheFeatureSupport, coreCache);
                if (!string2.equals("baseCache")) {
                    cacheInstances.put(string2, dCache);
                }
                coreCache.start();
                cacheConfig.cache = dCache;
                cacheConfig.defaultProvider = false;
            } else {
                if (tc.isErrorEnabled()) {
                    Tr.error(tc, "DYNA1066E", new Object[]{cacheConfig.cacheProviderName, cacheConfig.cacheName});
                }
                bl = true;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "ENGLISH ONLY: Cache Provider " + cacheConfig.getCacheProviderName() + " could NOT be loaded");
            }
            bl = true;
        }
        if (bl) {
            cacheConfig.resetProvider();
            dCache = null;
        }
        return dCache;
    }

    private static void changeCacheNameToNonPrefixed(CacheConfig cacheConfig, String string) {
        if (null != cacheConfig.cacheNameNonPrefixed) {
            String string2 = cacheConfig.cacheName = cacheConfig.cacheNameNonPrefixed != null ? cacheConfig.cacheNameNonPrefixed : string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "changeCacheNameToNonPrefixed cacheName " + cacheConfig.cacheName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DCache createDefaultProviderCache(String string, CacheConfig cacheConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDefaultProviderCache()");
        }
        DCache dCache = null;
        Object object = null;
        Object object2 = monitors;
        synchronized (object2) {
            object = monitors.get(string);
            if (object == null) {
                object = new Object();
                monitors.put(string, object);
            }
        }
        object2 = object;
        synchronized (object2) {
            dCache = ServerCache.getCache(string);
            if (dCache == null) {
                cacheConfig.cache = dCache = new Cache(string, cacheConfig);
                dCache.setBatchUpdateDaemon(ServerCache.cacheUnit.batchUpdateDaemon);
                DRSNotificationService dRSNotificationService = null;
                RemoteServices remoteServices = null;
                if (cacheConfig.enableCacheReplication) {
                    try {
                        dRSNotificationService = new DRSNotificationService();
                        remoteServices = new DRSRemoteServices();
                        remoteServices.setNotificationService(dRSNotificationService);
                        dRSNotificationService.setCacheName(string);
                        remoteServices.setCacheName(string);
                        dRSNotificationService.start();
                        remoteServices.start();
                        dRSNotificationService.registerCacheUnit(string, cacheUnit);
                        remoteServices.setCacheUnit(cacheUnit.getUniqueCacheName(), cacheUnit);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.ServerCache.createCache", "219", null);
                        exception.printStackTrace();
                        remoteServices = ServerCache.cacheUnit.remoteServices;
                        cacheConfig.enableCacheReplication = false;
                    }
                } else {
                    remoteServices = ServerCache.cacheUnit.remoteServices;
                }
                dCache.setRemoteServices(remoteServices);
                dCache.setTimeLimitDaemon(ServerCache.cacheUnit.timeLimitDaemon);
                if (cacheConfig.enableCacheReplication && dRSNotificationService != null) {
                    dRSNotificationService.setCacheStatisticsListener(dCache.getCacheStatisticsListener());
                }
                Object object3 = cacheIntancesMonitor;
                synchronized (object3) {
                    cacheInstances.put(string, dCache);
                }
                if (cacheConfig.enableCacheReplication) {
                    cacheService.initNotificationServiceInstance(dRSNotificationService, cacheConfig);
                }
                dCache.start();
            }
        }
        object2 = monitors;
        synchronized (object2) {
            monitors.remove(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDefaultProviderCache()name=" + string + " cache=" + dCache);
        }
        return dCache;
    }

    public static ArrayList getServletCacheInstanceNames() {
        ArrayList arrayList = null;
        if (cacheService != null) {
            arrayList = cacheService.getServletCacheInstanceNames();
        }
        return arrayList;
    }

    public static CacheInstanceInfo[] getCacheInstanceInfo() {
        CacheInstanceInfo[] cacheInstanceInfoArray = null;
        if (cacheService != null) {
            cacheInstanceInfoArray = ((CacheServiceImpl)cacheService).getCacheInstanceInfo();
        }
        return cacheInstanceInfoArray;
    }

    public static int getActiveCacheInstanceCount() {
        return cacheInstances.size();
    }

    private static String normalizeCacheName(String string, CacheConfig cacheConfig) {
        String string2 = string;
        if (string.equalsIgnoreCase("services/cache/basecache")) {
            string2 = "baseCache";
        } else if (string.equalsIgnoreCase("services/cache/distributedmap")) {
            string2 = "default";
        }
        if (!string2.equals(cacheConfig.cacheName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " normalized cacheName=" + string + " does not match with cacheConfig cacheName=" + cacheConfig.cacheName + ". Set to input cacheName.");
            }
            cacheConfig.cacheName = string2;
        }
        return string2;
    }
}

