/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.DistributedMapImpl;
import com.ibm.ws.cache.ExternalCacheServices;
import com.ibm.ws.cache.InvalidationAuditDaemon;
import com.ibm.ws.cache.NotificationService;
import com.ibm.ws.cache.NullNotificationService;
import com.ibm.ws.cache.NullRemoteServices;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.TimeLimitDaemon;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.ffdc.FFDCFilter;

public class StandaloneCache {
    private static TraceComponent tc = Trace.register(Cache.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private String uniqueCacheName;
    private BatchUpdateDaemon batchUpdateDaemon = null;
    private Cache cache = null;
    private ExternalCacheServices externalCacheServices = null;
    private InvalidationAuditDaemon invalidationAuditDaemon = null;
    private NotificationService notificationService = null;
    private RemoteServices remoteServices = null;
    private TimeLimitDaemon timeLimitDaemon = null;
    private static StandaloneCache theCache = null;

    public static synchronized void initialize(CacheConfig cacheConfig) {
        if (theCache == null) {
            theCache = new StandaloneCache();
            theCache.init(cacheConfig);
        }
    }

    public static DistributedMap getMap() {
        return new DistributedMapImpl(ServerCache.cache);
    }

    private void init(CacheConfig cacheConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        try {
            this.uniqueCacheName = cacheConfig.serverNameFQ;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing CacheUnit " + this.uniqueCacheName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "batchUpdateInterval set to " + cacheConfig.batchUpdateInterval);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "timeHoldingInvalidations set to " + cacheConfig.timeHoldingInvalidations);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cacheSprayerName set to " + cacheConfig.cacheSprayerName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "notificationType set to " + cacheConfig.notificationType);
            }
            this.notificationService = new NullNotificationService();
            ServerCache.setSharingPolicy(1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cacheSize set to " + cacheConfig.cacheSize);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cachePriority set to " + cacheConfig.cachePriority);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "maxTimeLimitInSeconds set to " + cacheConfig.maxTimeLimitInSeconds);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "timeGranularityInSeconds set to " + cacheConfig.timeGranularityInSeconds);
            }
            this.batchUpdateDaemon = new BatchUpdateDaemon(cacheConfig.batchUpdateInterval);
            this.cache = new Cache("baseCache", cacheConfig);
            ServerCache.cache = this.cache;
            this.externalCacheServices = new ExternalCacheServices();
            this.remoteServices = new NullRemoteServices();
            this.invalidationAuditDaemon = new InvalidationAuditDaemon(cacheConfig.timeHoldingInvalidations);
            this.timeLimitDaemon = new TimeLimitDaemon(cacheConfig.maxTimeLimitInSeconds, cacheConfig.timeGranularityInSeconds, cacheConfig.lruToDiskTriggerTime);
            this.batchUpdateDaemon.setExternalCacheServices(this.externalCacheServices);
            this.batchUpdateDaemon.setInvalidationAuditDaemon(this.invalidationAuditDaemon);
            this.cache.setBatchUpdateDaemon(this.batchUpdateDaemon);
            this.cache.setRemoteServices(this.remoteServices);
            this.cache.setTimeLimitDaemon(this.timeLimitDaemon);
            this.cache.setDefaultPriority(cacheConfig.cachePriority);
            this.remoteServices.setNotificationService(this.notificationService);
            this.batchUpdateDaemon.start();
            this.cache.start();
            this.externalCacheServices.start();
            this.invalidationAuditDaemon.start();
            this.notificationService.start();
            this.remoteServices.start();
            this.timeLimitDaemon.start();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Registering this cache unit with any other live cache units...");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "succeeded");
            }
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.cache.StandaloneCache.initialize", "640", this);
            throw illegalStateException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.StandaloneCache.initialize", "644", this);
            Tr.error(tc, "dynacache.configerror", exception.getMessage());
            throw new IllegalStateException("Unexpected exception in Configuration.initializeDynacache method.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }
}

