/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.NonSyncHashtable;
import com.ibm.ws.cache.RealTimeDaemon;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class TimeLimitDaemon
extends RealTimeDaemon {
    private static TraceComponent tc = Trace.register(TimeLimitDaemon.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final boolean UNIT_TEST_INACTIVITY = false;
    private static final boolean IS_UNIT_TEST = false;
    private static final int DEFAULT_SIZE_FOR_MEM = 1024;
    private static final int DEFAULT_SIZE_FOR_MEM_DISK = 20480;
    private InvalidationTaskPool taskPool = new InvalidationTaskPool(100);
    private Hashtable cacheInstancesTable = new Hashtable(10);
    private long lastTimeReleaseDiskCachePool = 0L;
    private long lastTimeoutCheckedTime = 0L;
    private int timeoutTriggerTime = 0;
    private int lruToDiskTriggerTime = 0;
    private boolean isLruToDiskRunnning = false;
    private long tcount = 0L;
    private long ccount = 0L;

    public TimeLimitDaemon(int n, int n2, int n3) {
        super(n3);
        this.lruToDiskTriggerTime = n3;
        this.timeoutTriggerTime = n2 * 1000;
        this.isLruToDiskRunnning = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating TimeLimitDaemon - set time granularity to " + n2 + " lruToDiskTriggerTime=" + this.lruToDiskTriggerTime);
            Tr.debug(tc, "\t timeoutTriggerTime: " + this.timeoutTriggerTime);
        }
        this.lastTimeReleaseDiskCachePool = System.currentTimeMillis();
        if (n2 <= 0) {
            throw new IllegalArgumentException("timeGranularityInSeconds must be positive");
        }
    }

    public void start() {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public void wakeUp(long l, long l2) {
        block20: {
            Object object4;
            boolean bl = false;
            try {
                block19: {
                    if (this.lruToDiskTriggerTime != this.timeoutTriggerTime && l2 - this.lastTimeoutCheckedTime < (long)this.timeoutTriggerTime) break block19;
                    this.lastTimeoutCheckedTime = l2;
                    ArrayList<InvalidationData> arrayList = new ArrayList<InvalidationData>();
                    for (Map.Entry entry : this.cacheInstancesTable.entrySet()) {
                        DCache dCache = (DCache)entry.getKey();
                        ExpirationMetaData expirationMetaData = (ExpirationMetaData)entry.getValue();
                        ExpirationMetaData expirationMetaData2 = expirationMetaData;
                        synchronized (expirationMetaData2) {
                            Object object2 = expirationMetaData.timeLimitHeap.minimum();
                            while (object2 != null) {
                                if (((InvalidationTask)object2).expirationTime <= l2) {
                                    object2 = expirationMetaData.timeLimitHeap.deleteMin();
                                    expirationMetaData.expirationTable.remove(((InvalidationTask)object2).id);
                                    arrayList.add(new InvalidationData(((InvalidationTask)object2).id, ((InvalidationTask)object2).isInactivityTimeOut));
                                    ((InvalidationTask)object2).reset();
                                    this.taskPool.add(object2);
                                    object2 = expirationMetaData.timeLimitHeap.minimum();
                                    continue;
                                }
                                object2 = null;
                            }
                        }
                        if (arrayList.size() <= 0) continue;
                        for (Object object2 : arrayList) {
                            dCache.invalidateById(((InvalidationData)object2).id, ((InvalidationData)object2).isInactivityTimeOut ? 6 : 3, false);
                        }
                        arrayList.clear();
                    }
                    this.diskCacheHouseKeeping();
                    bl = true;
                }
                Object var16_13 = null;
                if (this.isLruToDiskRunnning) break block20;
                this.isLruToDiskRunnning = true;
            }
            catch (Throwable throwable) {
                Object var16_15 = null;
                if (!this.isLruToDiskRunnning) {
                    Object object32;
                    this.isLruToDiskRunnning = true;
                    Map map = ServerCache.getCacheInstances();
                    for (Object object32 : map.values()) {
                        CacheConfig cacheConfig = object32.getCacheConfig();
                        if (!cacheConfig.isDefaultCacheProvider() || !bl && cacheConfig.getLruToDiskTriggerPercent() <= 0) continue;
                        object32.trimCache();
                    }
                    if (ServerCache.cache != null && ((CacheConfig)(object32 = ServerCache.cache.getCacheConfig())).isDefaultCacheProvider() && (bl || ((CacheConfig)object32).getLruToDiskTriggerPercent() > 0)) {
                        ServerCache.cache.trimCache();
                    }
                    this.isLruToDiskRunnning = false;
                }
                throw throwable;
            }
            Map map = ServerCache.getCacheInstances();
            for (Object object4 : map.values()) {
                CacheConfig cacheConfig = object4.getCacheConfig();
                if (!cacheConfig.isDefaultCacheProvider() || !bl && cacheConfig.getLruToDiskTriggerPercent() <= 0) continue;
                object4.trimCache();
            }
            if (ServerCache.cache != null && ((CacheConfig)(object4 = ServerCache.cache.getCacheConfig())).isDefaultCacheProvider() && (bl || ((CacheConfig)object4).getLruToDiskTriggerPercent() > 0)) {
                ServerCache.cache.trimCache();
            }
            this.isLruToDiskRunnning = false;
            {
                break block20;
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.TimeLimitDaemon.wakeUp", "152", this);
                    throwable.printStackTrace();
                    Object var16_14 = null;
                    if (!this.isLruToDiskRunnning) {
                        Object object52;
                        this.isLruToDiskRunnning = true;
                        Map map2 = ServerCache.getCacheInstances();
                        for (Object object52 : map2.values()) {
                            CacheConfig cacheConfig = object52.getCacheConfig();
                            if (!cacheConfig.isDefaultCacheProvider() || !bl && cacheConfig.getLruToDiskTriggerPercent() <= 0) continue;
                            object52.trimCache();
                        }
                        if (ServerCache.cache != null && ((CacheConfig)(object52 = ServerCache.cache.getCacheConfig())).isDefaultCacheProvider() && (bl || ((CacheConfig)object52).getLruToDiskTriggerPercent() > 0)) {
                            ServerCache.cache.trimCache();
                        }
                        this.isLruToDiskRunnning = false;
                    }
                }
            }
        }
    }

    private void diskCacheHouseKeeping() {
        boolean bl = false;
        if (System.currentTimeMillis() - this.lastTimeReleaseDiskCachePool > 3600000L) {
            bl = true;
            this.lastTimeReleaseDiskCachePool = System.currentTimeMillis();
        }
        String string2 = null;
        DCache dCache = null;
        dCache = ServerCache.getCache(null);
        if (dCache != null && dCache.getCacheConfig().isDefaultCacheProvider()) {
            if (dCache.isDiskInvalidationBufferFull()) {
                dCache.invokeDiskCleanup(false);
            }
            if (bl) {
                dCache.releaseDiskCacheUnusedPools();
            }
        }
        for (String string2 : ServerCache.getCacheInstances().keySet()) {
            dCache = ServerCache.getCache(string2);
            if (dCache == null || !dCache.getCacheConfig().isDefaultCacheProvider()) continue;
            if (dCache.isDiskInvalidationBufferFull()) {
                dCache.invokeDiskCleanup(false);
            }
            if (!bl) continue;
            dCache.releaseDiskCacheUnusedPools();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueHasChanged(DCache dCache, Object object, long l, int n) {
        ExpirationMetaData expirationMetaData;
        long l2;
        if (l <= 0L && n <= 0) {
            throw new IllegalArgumentException("expirationTime or inactivity must be positive");
        }
        this.traceDebug("valueHasChanged()", " expirationTime=" + l + " inactivity=" + n);
        boolean bl = false;
        if (n > 0 && ((l2 = System.currentTimeMillis() + (long)(n * 1000)) < l || l <= 0L)) {
            l = l2;
            bl = true;
        }
        if ((expirationMetaData = (ExpirationMetaData)this.cacheInstancesTable.get(dCache)) == null) {
            this.traceDebug("valueHasChanged()", "----CATASTROPHIC ERROR TLD NOT WORKING---");
            return;
        }
        ExpirationMetaData expirationMetaData2 = expirationMetaData;
        synchronized (expirationMetaData2) {
            InvalidationTask invalidationTask = (InvalidationTask)expirationMetaData.expirationTable.get(object);
            if (invalidationTask == null) {
                invalidationTask = (InvalidationTask)this.taskPool.remove();
                invalidationTask.id = object;
                expirationMetaData.expirationTable.put(object, invalidationTask);
            } else {
                expirationMetaData.timeLimitHeap.delete(invalidationTask);
            }
            invalidationTask.expirationTime = l;
            invalidationTask.isInactivityTimeOut = bl;
            expirationMetaData.timeLimitHeap.insert(invalidationTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueWasRemoved(DCache dCache, Object object) {
        ExpirationMetaData expirationMetaData = (ExpirationMetaData)this.cacheInstancesTable.get(dCache);
        if (expirationMetaData == null) {
            this.traceDebug("valueWasRemoved()", "----CATASTROPHIC ERROR TLD NOT WORKING---");
            return;
        }
        ExpirationMetaData expirationMetaData2 = expirationMetaData;
        synchronized (expirationMetaData2) {
            InvalidationTask invalidationTask = (InvalidationTask)expirationMetaData.expirationTable.remove(object);
            if (invalidationTask != null) {
                expirationMetaData.timeLimitHeap.delete(invalidationTask);
                invalidationTask.reset();
                this.taskPool.add(invalidationTask);
            }
        }
    }

    public void valueWasAccessed(DCache dCache, Object object, long l, int n) {
        this.valueHasChanged(dCache, object, l, n);
    }

    public void createExpirationMetaData(DCache dCache) {
        ExpirationMetaData expirationMetaData = (ExpirationMetaData)this.cacheInstancesTable.get(dCache);
        if (expirationMetaData == null) {
            int n = 1024;
            if (dCache.getSwapToDisk() && dCache.getCacheConfig().getDiskCachePerformanceLevel() == 3) {
                n = 20480;
            }
            expirationMetaData = new ExpirationMetaData(n);
            this.cacheInstancesTable.put(dCache, expirationMetaData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheCleared(DCache dCache) {
        ExpirationMetaData expirationMetaData = (ExpirationMetaData)this.cacheInstancesTable.get(dCache);
        if (expirationMetaData == null) {
            return;
        }
        ExpirationMetaData expirationMetaData2 = expirationMetaData;
        synchronized (expirationMetaData2) {
            if (!expirationMetaData.expirationTable.isEmpty()) {
                Enumeration enumeration = expirationMetaData.expirationTable.elements();
                while (enumeration.hasMoreElements()) {
                    InvalidationTask invalidationTask = (InvalidationTask)enumeration.nextElement();
                    invalidationTask.reset();
                    this.taskPool.add(invalidationTask);
                }
                expirationMetaData.expirationTable.clear();
                expirationMetaData.timeLimitHeap.clear();
            }
        }
    }

    private void traceDebug(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + " " + string2);
        }
    }

    public static class BinaryHeap {
        private InvalidationTask[] heapArray;
        private int heapSize;

        public BinaryHeap(int n) {
            this.heapArray = new InvalidationTask[n];
            InvalidationTask invalidationTask = new InvalidationTask();
            invalidationTask.expirationTime = Long.MIN_VALUE;
            invalidationTask.index = 0;
            this.heapArray[0] = invalidationTask;
            this.heapSize = 0;
        }

        public synchronized void insert(InvalidationTask invalidationTask) {
            int n = ++this.heapSize;
            this.growIfNec();
            while (invalidationTask.lessThan(this.heapArray[BinaryHeap.parent(n)])) {
                this.heapArray[n] = this.heapArray[BinaryHeap.parent(n)];
                this.heapArray[n].index = n;
                n = BinaryHeap.parent(n);
            }
            this.heapArray[n] = invalidationTask;
            this.heapArray[n].index = n;
        }

        public final InvalidationTask minimum() {
            if (this.isEmpty()) {
                return null;
            }
            return this.heapArray[1];
        }

        public final synchronized InvalidationTask deleteMin() {
            InvalidationTask invalidationTask;
            if (this.isEmpty()) {
                invalidationTask = null;
            } else {
                InvalidationTask invalidationTask2 = this.heapArray[this.heapSize];
                this.heapArray[this.heapSize--] = null;
                if (this.isEmpty()) {
                    invalidationTask = invalidationTask2;
                } else {
                    invalidationTask = this.heapArray[1];
                    this.heapArray[1] = invalidationTask2;
                    this.heapArray[1].index = 1;
                    this.heapify(1);
                }
            }
            return invalidationTask;
        }

        public synchronized void delete(InvalidationTask invalidationTask) {
            int n = this.findKey(invalidationTask);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            this.heapArray[n] = this.heapArray[0];
            this.heapArray[n].index = n;
            this.percolateUp(n);
            this.deleteMin();
            this.heapArray[0].index = 0;
        }

        private int findKey(InvalidationTask invalidationTask) {
            return invalidationTask.index;
        }

        private void percolateUp(int n) {
            while (this.heapArray[n].lessThan(this.heapArray[BinaryHeap.parent(n)])) {
                int n2 = BinaryHeap.parent(n);
                InvalidationTask invalidationTask = this.heapArray[n2];
                this.heapArray[n2] = this.heapArray[n];
                this.heapArray[n2].index = n2;
                this.heapArray[n] = invalidationTask;
                this.heapArray[n].index = n;
                int n3 = n;
                n = n2;
                this.heapify(n3);
            }
        }

        private final void heapify(int n) {
            InvalidationTask invalidationTask = this.heapArray[n];
            while (BinaryHeap.left(n) <= this.heapSize) {
                int n2 = BinaryHeap.left(n);
                if (n2 < this.heapSize && this.heapArray[BinaryHeap.right(n)].lessThan(this.heapArray[n2])) {
                    ++n2;
                }
                if (!this.heapArray[n2].lessThan(invalidationTask)) break;
                this.heapArray[n] = this.heapArray[n2];
                this.heapArray[n].index = n;
                n = n2;
            }
            this.heapArray[n] = invalidationTask;
            this.heapArray[n].index = n;
        }

        public final boolean isEmpty() {
            return this.heapSize == 0;
        }

        public final int size() {
            return this.heapSize;
        }

        public final void clear() {
            for (int i = 1; i <= this.heapSize; ++i) {
                this.heapArray[i] = null;
            }
            this.heapSize = 0;
        }

        private static final int parent(int n) {
            return n / 2;
        }

        private static final int left(int n) {
            return 2 * n;
        }

        private static final int right(int n) {
            return 2 * n + 1;
        }

        private void growIfNec() {
            if (this.heapSize + 1 == this.heapArray.length) {
                InvalidationTask[] invalidationTaskArray = this.heapArray;
                this.heapArray = new InvalidationTask[this.heapSize * 2];
                System.arraycopy(invalidationTaskArray, 0, this.heapArray, 0, invalidationTaskArray.length);
            }
        }
    }

    static class InvalidationTaskPool
    extends ObjectPool {
        public InvalidationTaskPool(int n) {
            super("InvalidationTaskPool", n);
        }

        protected Object createObject() {
            return new InvalidationTask();
        }
    }

    public static class InvalidationTask {
        public Object id;
        public long expirationTime;
        public boolean isInactivityTimeOut = false;
        public int index;

        public final boolean lessThan(InvalidationTask invalidationTask) {
            return this.expirationTime < invalidationTask.expirationTime;
        }

        public final boolean equals(InvalidationTask invalidationTask) {
            return this.expirationTime == invalidationTask.expirationTime;
        }

        public final boolean lessThanOrEquals(InvalidationTask invalidationTask) {
            return this.expirationTime <= invalidationTask.expirationTime;
        }

        public final void reset() {
            this.id = null;
            this.expirationTime = -1L;
            this.isInactivityTimeOut = false;
            this.index = -1;
        }
    }

    public static class InvalidationData {
        public Object id;
        public boolean isInactivityTimeOut;

        public InvalidationData(Object object, boolean bl) {
            this.id = object;
            this.isInactivityTimeOut = bl;
        }
    }

    public static class ExpirationMetaData {
        public NonSyncHashtable expirationTable;
        public BinaryHeap timeLimitHeap;

        public ExpirationMetaData(int n) {
            this.expirationTable = new NonSyncHashtable(n);
            this.timeLimitHeap = new BinaryHeap(n);
        }
    }
}

