/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.DiskCachePerformanceKind;
import com.ibm.websphere.models.config.applicationserver.DynamicCache;
import com.ibm.websphere.models.config.applicationserver.EvictionAlgorithmKind;
import com.ibm.websphere.models.config.applicationserver.ExternalCacheGroup;
import com.ibm.websphere.models.config.applicationserver.ExternalCacheGroupMember;
import com.ibm.websphere.models.config.dynacache.CacheInstance;
import com.ibm.websphere.models.config.dynacache.ObjectCacheInstance;
import com.ibm.websphere.models.config.dynacache.ServletCacheInstance;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.drs.DRSSettings;
import com.ibm.ws.cache.drs.ws390.DynacachePlatformHelper;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.util.FieldInitializer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class WCCMCacheConfig
extends CacheConfig {
    private static TraceComponent tc = Trace.register(WCCMCacheConfig.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static boolean assertRanOnce = false;

    public WCCMCacheConfig(Properties properties, CacheConfig cacheConfig, CacheConfig.Environment environment) {
        assert (assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this));
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        this.configSource = 6;
        this.enableServletSupport = false;
        this.cacheName = null;
        this.tempDir = super.fixPath(environment.tmpDir);
        this.propertiesDir = super.fixPath(environment.propDir);
        this.dtdDir = super.fixPath(environment.dtdDir);
        this.serverCellName = environment.serverCellName;
        this.serverNodeName = environment.serverNodeName;
        this.serverServerName = environment.serverServerName;
        this.serverNameFQ = this.serverCellName + "." + this.serverNodeName + "." + this.serverServerName;
        this.cachePriority = cacheConfig.cachePriority;
        this.jspCachePriority = cacheConfig.jspCachePriority;
        this.commandCachePriority = cacheConfig.commandCachePriority;
        this.diskHashBuckets = cacheConfig.diskHashBuckets;
        this.cacheUnits = cacheConfig.cacheUnits;
        this.cacheSize = cacheConfig.cacheSize;
        this.cacheProviderName = cacheConfig.cacheProviderName;
        this.enableCacheReplication = cacheConfig.enableCacheReplication;
        this.replicationType = cacheConfig.replicationType;
        if (cacheConfig.enableCacheReplication && cacheConfig.drss != null) {
            this.drss = (com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings)etoolsCopyUtility.copy((EObject)cacheConfig.drss);
            this.replicationDomain = this.drss.getMessageBrokerDomainName();
        }
        if (this.isZosForceReplicationActive()) {
            this.enableCacheReplication = true;
        }
        this.setBatchUpdateInterval(cacheConfig, cacheConfig.pushFrequency);
        this.enableDiskOffload = false;
        this.flushToDiskOnStop = false;
        this.diskCacheSizeInGB = cacheConfig.diskCacheSizeInGB;
        this.diskCacheSize = cacheConfig.diskCacheSize;
        this.diskCacheEntrySizeInMB = cacheConfig.diskCacheEntrySizeInMB;
        this.diskCachePerformanceLevel = cacheConfig.diskCachePerformanceLevel;
        this.htodCleanupFrequency = cacheConfig.htodCleanupFrequency;
        this.diskCacheEvictionPolicy = cacheConfig.diskCacheEvictionPolicy;
        this.diskCacheHighThreshold = cacheConfig.diskCacheHighThreshold;
        this.diskCacheLowThreshold = cacheConfig.diskCacheLowThreshold;
        this.htodDelayOffloadEntriesLimit = cacheConfig.htodDelayOffloadEntriesLimit;
        this.htodDelayOffloadDepIdBuckets = cacheConfig.htodDelayOffloadDepIdBuckets;
        this.htodDelayOffloadTemplateBuckets = cacheConfig.htodDelayOffloadTemplateBuckets;
        super.overrideCacheConfig(properties);
        this._passedInProperties.putAll(properties);
        if (this.enableServletSupport) {
            this.configSource = 5;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + " super.replicationType: " + this.replicationType);
        }
        this.defaultShareType = this.convertReplicationType(this.replicationType);
        Set<Object> set = properties.keySet();
        for (String string : set) {
            if (!string.contains("replicationType")) continue;
            this.defaultShareType = this.replicationType;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, this.cacheName + " replication type overriden from the properties file ");
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.cacheName + " super.defaultShareType: " + this.defaultShareType);
        }
        String string = this.notificationType = this.enableCacheReplication ? "drs" : "unicast";
        if (this.enableCacheReplication) {
            this.cacheSprayerName = "com.ibm.ws.cache.drs.DRSCacheSprayer";
            Object object = cacheConfig.drss;
            if (object == null) {
                object = new DRSSettings();
            }
            this.drss = (com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings)etoolsCopyUtility.copy((EObject)object);
            if (this.isZosForceReplicationActive()) {
                this.drss.setMessageBrokerDomainName(this.getZosReplicationDomainName());
                this.replicationType = this.getZosForceReplicationType();
                this.defaultShareType = this.convertReplicationType(this.replicationType);
            } else {
                this.drss.setMessageBrokerDomainName(this.replicationDomain);
            }
        }
        assert (super.verifyConfig());
    }

    private void setBatchUpdateInterval(Object object, int n) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "setBatchUpdateInterval", new Object[]{object});
        }
        if (object != null) {
            this.pushFrequency = n;
        }
        if (this.pushFrequency < 1) {
            this.pushFrequency = 1;
        }
        this.batchUpdateInterval = this.batchUpdateMilliseconds != -1 ? this.batchUpdateMilliseconds : this.pushFrequency * 1000;
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setBatchUpdateInterval", new Integer(this.batchUpdateInterval));
        }
    }

    public WCCMCacheConfig(DynamicCache dynamicCache, CacheConfig.Environment environment) {
        assert (assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this));
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        this.configSource = 1;
        this.enableServletSupport = true;
        this.cacheName = "baseCache";
        this.tempDir = super.fixPath(environment.tmpDir);
        this.propertiesDir = super.fixPath(environment.propDir);
        this.dtdDir = super.fixPath(environment.dtdDir);
        this.serverCellName = environment.serverCellName;
        this.serverNodeName = environment.serverNodeName;
        this.serverServerName = environment.serverServerName;
        this.serverNameFQ = this.serverCellName + "." + this.serverNodeName + "." + this.serverServerName;
        this.cachePriority = dynamicCache.getDefaultPriority();
        this.jspCachePriority = dynamicCache.getDefaultPriority();
        this.commandCachePriority = dynamicCache.getDefaultPriority() + 2;
        this.diskHashBuckets = dynamicCache.getHashSize();
        this.cacheSize = dynamicCache.getCacheSize();
        this.enableCacheReplication = dynamicCache.isEnableCacheReplication();
        this.replicationType = dynamicCache.getReplicationType().getValue();
        this.defaultShareType = this.convertReplicationType(this.replicationType);
        ServerCache.setSharingPolicy(this.defaultShareType);
        if (this.isZosForceReplicationActive()) {
            this.enableCacheReplication = true;
        }
        String string = this.notificationType = this.enableCacheReplication ? "drs" : "unicast";
        if (this.enableCacheReplication) {
            this.cacheSprayerName = "com.ibm.ws.cache.drs.DRSCacheSprayer";
            Object object = dynamicCache.getCacheReplication();
            if (object == null) {
                object = new DRSSettings();
            }
            this.drss = (com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings)etoolsCopyUtility.copy((EObject)object);
            if (this.isZosForceReplicationActive()) {
                this.drss.setMessageBrokerDomainName(this.getZosReplicationDomainName());
                this.replicationType = this.getZosForceReplicationType();
                this.defaultShareType = this.convertReplicationType(this.replicationType);
            }
        }
        this.setBatchUpdateInterval(dynamicCache, dynamicCache.getPushFrequency());
        ServerCache.setPushFrequency(this.pushFrequency);
        this.enableDiskOffload = dynamicCache.isEnableDiskOffload();
        if (dynamicCache.getDiskOffloadLocation() != null) {
            this.diskOffloadLocation = dynamicCache.getDiskOffloadLocation();
        }
        this.flushToDiskOnStop = dynamicCache.isFlushToDiskOnStop();
        this.diskCacheSizeInGB = dynamicCache.getDiskCacheSizeInGB();
        this.diskCacheSize = dynamicCache.getDiskCacheSizeInEntries();
        this.diskCacheEntrySizeInMB = dynamicCache.getDiskCacheEntrySizeInMB();
        this.diskCachePerformanceLevel = this.convertDiskCachePerformanceLevel(dynamicCache.getDiskCachePerformanceLevel().getName());
        this.htodCleanupFrequency = dynamicCache.getDiskCacheCleanupFrequency();
        if (dynamicCache.getDiskCacheEvictionPolicy() != null) {
            this.diskCacheEvictionPolicy = this.convertDiskCacheEvitionPolicy(dynamicCache.getDiskCacheEvictionPolicy().getAlgorithm().getName());
            this.diskCacheHighThreshold = dynamicCache.getDiskCacheEvictionPolicy().getHighThreshold();
            this.diskCacheLowThreshold = dynamicCache.getDiskCacheEvictionPolicy().getLowThreshold();
        }
        if (this.diskCachePerformanceLevel == 2 && dynamicCache.getDiskCacheCustomPerformanceSettings() != null) {
            this.htodDelayOffloadEntriesLimit = dynamicCache.getDiskCacheCustomPerformanceSettings().getMaxBufferedCacheIdsPerMetaEntry();
            this.htodDelayOffloadDepIdBuckets = dynamicCache.getDiskCacheCustomPerformanceSettings().getMaxBufferedDependencyIds();
            this.htodDelayOffloadTemplateBuckets = dynamicCache.getDiskCacheCustomPerformanceSettings().getMaxBufferedTemplates();
        }
        for (ExternalCacheGroup externalCacheGroup : dynamicCache.getCacheGroups()) {
            CacheConfig.ExternalCacheGroup externalCacheGroup2 = new CacheConfig.ExternalCacheGroup();
            externalCacheGroup2.name = externalCacheGroup.getName();
            externalCacheGroup2.type = externalCacheGroup.getType().getValue();
            externalCacheGroup2.members = new ArrayList();
            for (ExternalCacheGroupMember externalCacheGroupMember : externalCacheGroup.getMembers()) {
                CacheConfig.ExternalCacheGroupMember externalCacheGroupMember2 = new CacheConfig.ExternalCacheGroupMember();
                externalCacheGroupMember2.address = externalCacheGroupMember.getAddress();
                externalCacheGroupMember2.beanName = externalCacheGroupMember.getAdapterBeanName();
                externalCacheGroup2.members.add(externalCacheGroupMember2);
            }
            this.externalGroups.add(externalCacheGroup2);
        }
        FieldInitializer.initFromSystemProperties(this);
        super.overrideCacheConfig(null);
        this._passedInProperties.putAll(System.getProperties());
        assert (super.verifyConfig());
    }

    public WCCMCacheConfig(CacheInstance cacheInstance, CacheConfig.Environment environment) {
        Object object;
        EtoolsCopyUtility etoolsCopyUtility;
        assert (assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this));
        EtoolsCopyUtility etoolsCopyUtility2 = new EtoolsCopyUtility();
        this.configSource = 2;
        this.enableServletSupport = false;
        this.cacheName = cacheInstance.getJndiName();
        this.tempDir = super.fixPath(environment.tmpDir);
        this.propertiesDir = super.fixPath(environment.propDir);
        this.dtdDir = super.fixPath(environment.dtdDir);
        this.serverCellName = environment.serverCellName;
        this.serverNodeName = environment.serverNodeName;
        this.serverServerName = environment.serverServerName;
        this.serverNameFQ = this.serverCellName + "." + this.serverNodeName + "." + this.serverServerName;
        this.cachePriority = cacheInstance.getDefaultPriority();
        this.jspCachePriority = cacheInstance.getDefaultPriority();
        this.commandCachePriority = cacheInstance.getDefaultPriority() + 2;
        this.diskHashBuckets = cacheInstance.getHashSize();
        this.cacheSize = cacheInstance.getCacheSize();
        this.enableCacheReplication = cacheInstance.isEnableCacheReplication();
        this.replicationType = cacheInstance.getReplicationType().getValue();
        this.defaultShareType = this.convertReplicationType(this.replicationType);
        if (this.isZosForceReplicationActive()) {
            this.enableCacheReplication = true;
        }
        String string = this.notificationType = this.enableCacheReplication ? "drs" : "unicast";
        if (this.enableCacheReplication) {
            this.cacheSprayerName = "com.ibm.ws.cache.drs.DRSCacheSprayer";
            etoolsCopyUtility = new EtoolsCopyUtility();
            object = cacheInstance.getCacheReplication();
            if (object == null) {
                object = new DRSSettings();
            }
            this.drss = (com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings)etoolsCopyUtility2.copy((EObject)object);
            if (this.isZosForceReplicationActive()) {
                this.drss.setMessageBrokerDomainName(this.getZosReplicationDomainName());
                this.replicationType = this.getZosForceReplicationType();
                this.defaultShareType = this.convertReplicationType(this.replicationType);
            }
        }
        this.setBatchUpdateInterval(cacheInstance, cacheInstance.getPushFrequency());
        this.enableDiskOffload = cacheInstance.isEnableDiskOffload();
        if (cacheInstance.getDiskOffloadLocation() != null) {
            this.diskOffloadLocation = cacheInstance.getDiskOffloadLocation();
        }
        this.flushToDiskOnStop = cacheInstance.isFlushToDiskOnStop();
        this.diskCacheSizeInGB = cacheInstance.getDiskCacheSizeInGB();
        this.diskCacheSize = cacheInstance.getDiskCacheSizeInEntries();
        this.diskCacheEntrySizeInMB = cacheInstance.getDiskCacheEntrySizeInMB();
        this.diskCachePerformanceLevel = this.convertDiskCachePerformanceLevel(cacheInstance.getDiskCachePerformanceLevel().getName());
        this.htodCleanupFrequency = cacheInstance.getDiskCacheCleanupFrequency();
        if (cacheInstance.getDiskCacheEvictionPolicy() != null) {
            this.diskCacheEvictionPolicy = this.convertDiskCacheEvitionPolicy(cacheInstance.getDiskCacheEvictionPolicy().getAlgorithm().getName());
            this.diskCacheHighThreshold = cacheInstance.getDiskCacheEvictionPolicy().getHighThreshold();
            this.diskCacheLowThreshold = cacheInstance.getDiskCacheEvictionPolicy().getLowThreshold();
        }
        if (this.diskCachePerformanceLevel == 2 && cacheInstance.getDiskCacheCustomPerformanceSettings() != null) {
            this.htodDelayOffloadEntriesLimit = cacheInstance.getDiskCacheCustomPerformanceSettings().getMaxBufferedCacheIdsPerMetaEntry();
            this.htodDelayOffloadDepIdBuckets = cacheInstance.getDiskCacheCustomPerformanceSettings().getMaxBufferedDependencyIds();
            this.htodDelayOffloadTemplateBuckets = cacheInstance.getDiskCacheCustomPerformanceSettings().getMaxBufferedTemplates();
        }
        if (cacheInstance instanceof ServletCacheInstance) {
            this.enableServletSupport = true;
            this.configSource = 3;
        }
        if (cacheInstance instanceof ObjectCacheInstance) {
            this.useListenerContext = ((ObjectCacheInstance)cacheInstance).isUseListenerContext();
            this.disableDependencyId = ((ObjectCacheInstance)cacheInstance).isDisableDependencyId();
            this.enableReplicationAcks = false;
            this.enableNioSupport = false;
            this.configSource = 4;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config before custom properties:", "" + this);
        }
        etoolsCopyUtility = cacheInstance.getPropertySet();
        object = new Properties();
        boolean bl = false;
        if (etoolsCopyUtility == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attention: Custom property set is null");
            }
        } else {
            for (J2EEResourceProperty j2EEResourceProperty : etoolsCopyUtility.getResourceProperties()) {
                String string2 = j2EEResourceProperty.getName();
                String string3 = j2EEResourceProperty.getValue();
                ((Properties)object).put(string2, string3);
                if (string2.startsWith("com.ibm.ws.cache.CacheConfig.")) {
                    string2 = string2.substring("com.ibm.ws.cache.CacheConfig.".length());
                    string2 = this.getClass().getName() + "." + string2;
                    ((Properties)object).put(string2, string3);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Attention: Custom property found: " + string2 + "/" + string3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Properties: " + object);
            }
            FieldInitializer.initFromSystemProperties(this, (Properties)object);
            if (!this.cacheProviderName.equals("default")) {
                bl = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Config after  custom properties:", "" + this);
            }
        }
        FieldInitializer.initFromSystemProperties(this);
        if (!bl) {
            this.restoreDynacacheProviderDefaults();
        }
        super.overrideCacheConfig(null);
        this._passedInProperties.putAll(object);
        this._passedInProperties.putAll(System.getProperties());
        assert (super.verifyConfig());
    }

    private int convertReplicationType(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            default: {
                assert (false) : "Unknown replicationType";
                break;
            }
        }
        return n2;
    }

    private int convertDiskCachePerformanceLevel(String string) {
        int n = 1;
        if (string.equals(DiskCachePerformanceKind.LOW_LITERAL.getName())) {
            n = 0;
        } else if (string.equals(DiskCachePerformanceKind.BALANCED_LITERAL.getName())) {
            n = 1;
        } else if (string.equals(DiskCachePerformanceKind.CUSTOM_LITERAL.getName())) {
            n = 2;
        } else if (string.equals(DiskCachePerformanceKind.HIGH_LITERAL.getName())) {
            n = 3;
        }
        return n;
    }

    private int convertDiskCacheEvitionPolicy(String string) {
        int n = 0;
        if (string.equals(EvictionAlgorithmKind.NONE_LITERAL.getName())) {
            n = 0;
        } else if (string.equals(EvictionAlgorithmKind.RANDOM_LITERAL.getName())) {
            n = 1;
        } else if (string.equals(EvictionAlgorithmKind.SIZE_LITERAL.getName())) {
            n = 2;
        }
        return n;
    }

    private boolean isZosForceReplicationActive() {
        if (!DynacachePlatformHelper.isZOSBaseServer()) {
            return false;
        }
        return DynacachePlatformHelper.isBaseServerReplicationEnabled();
    }

    private String getZosReplicationDomainName() {
        return "Dynacache_Base_Server_Domain";
    }

    private int getZosForceReplicationType() {
        return DynacachePlatformHelper.getZOSBaseServerReplicationType();
    }

    public String getCacheProviderName() {
        return this.cacheProviderName;
    }

    void restoreDynacacheProviderDefaults() {
        if (this.restoreDynacacheDefaults && this.cacheProviderName != "default") {
            this.cacheProviderName = "default";
            this.enableCacheReplication = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OVERRIDING Object Grid configuration defaults for " + this.cacheName);
            }
        }
    }
}

