/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.command.CacheableCommand;
import com.ibm.websphere.command.CommandIdGenerator;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.CacheId;
import com.ibm.ws.cache.config.CacheProcessor;
import com.ibm.ws.cache.config.Component;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.Field;
import com.ibm.ws.cache.config.Invalidation;
import com.ibm.ws.cache.config.Method;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;

public class CommandCacheProcessor
extends CacheProcessor {
    private static TraceComponent tc = Trace.register(CommandCacheProcessor.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    protected CacheableCommand command;
    int sharingPolicy;

    public String getBaseName() {
        return this.command.getClass().getName();
    }

    public void reset(ConfigEntry configEntry) {
        super.reset(configEntry);
        if (configEntry != null) {
            this.sharingPolicy = configEntry.sharingPolicy;
        }
    }

    public void setCacheableCommand(CacheableCommand cacheableCommand) {
        this.command = cacheableCommand;
    }

    protected Object getComponentValue(Component component2) {
        Object object = null;
        if (component2.idMethod != null) {
            object = this.processMethod(component2.idMethod, this.command);
        } else if (component2.idField != null) {
            object = this.processField(component2.idField, this.command);
        } else if (component2.type.equals("method")) {
            component2.idMethod = new Method();
            component2.idMethod.name = component2.id;
            component2.idMethod.index = component2.index;
            object = this.processMethod(component2.idMethod, this.command);
        } else if (component2.type.equals("field")) {
            component2.idField = new Field();
            component2.idField.name = component2.id;
            component2.idField.index = component2.index;
            object = this.processField(component2.idField, this.command);
        } else {
            Tr.error(tc, "DYNA0038E", new Object[]{component2.type, this.command.getClass().getName()});
        }
        if (object != null) {
            if (component2.method != null) {
                object = this.processMethod(component2.method, object);
            } else if (component2.field != null) {
                object = this.processField(component2.field, object);
            }
        }
        return object;
    }

    public int getSharingPolicy() {
        return this.sharingPolicy;
    }

    protected String processIdGenerator(CacheId cacheId) {
        if (cacheId.idGeneratorImpl == null) {
            try {
                Class<?> clazz = Class.forName(cacheId.idGenerator, true, Thread.currentThread().getContextClassLoader());
                cacheId.idGeneratorImpl = clazz.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.CommandCacheProcessor.processIdGenerator", "121", this);
                Tr.error(tc, "dynacache.idgeneratorerror", new Object[]{cacheId.idGenerator});
            }
        }
        if (this.groupIds == null) {
            this.groupIds = new ArrayList();
        }
        return ((CommandIdGenerator)cacheId.idGeneratorImpl).getId(this.command, this.groupIds);
    }

    protected void processMetaDataGenerator(CacheId cacheId) {
        Tr.error(tc, "DYNA0039E");
    }

    protected String[] processInvalidationGenerator(Invalidation invalidation) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Commands do not support custom invalidation generating classes.");
        }
        return null;
    }
}

