/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.command;

import com.ibm.websphere.command.CacheableCommand;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.command.CommandStoragePolicy;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;

public class SerializedCommandStorage
implements CommandStoragePolicy {
    private static final long serialVersionUID = 3990461887543683654L;

    public Serializable prepareForCache(CacheableCommand cacheableCommand) {
        try {
            return SerializationUtility.serialize(cacheableCommand);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.command.SerializedCommandStorage.prepareForCache", "51", this);
            exception.printStackTrace();
            throw new IllegalStateException("serialization exception");
        }
    }

    public CacheableCommand prepareForCacheAccess(Serializable serializable, DCache dCache, EntryInfo entryInfo) {
        if (serializable == null) {
            return null;
        }
        if (!(serializable instanceof byte[])) {
            throw new IllegalStateException("inputObject is of type: " + serializable.getClass());
        }
        byte[] byArray = (byte[])serializable;
        Serializable serializable2 = null;
        try {
            serializable2 = SerializationUtility.deserialize(byArray);
            return (CacheableCommand)serializable2;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.cache.command.SerializedCommandStorage.prepareForCacheAccess", "80", this);
            throw new IllegalStateException("deserialized object is of type " + serializable2.getClass());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.command.SerializedCommandStorage.prepareForCacheAccess", "84", this);
            exception.printStackTrace();
            throw new IllegalStateException("deserialization exception");
        }
    }
}

