/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.Component;
import com.ibm.ws.cache.config.Property;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;

public class CacheId {
    protected static TraceComponent tc = Trace.register(CacheId.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public int timeout;
    public int inactivity;
    public int priority;
    public String idGenerator;
    public String metaDataGenerator;
    public HashMap properties;
    public Component[] components;
    public Object idGeneratorImpl;
    public Object metaDataGeneratorImpl;
    public Object[] processorData = null;

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("timeout          : " + this.timeout);
        printWriter.println("inactivity       : " + this.inactivity);
        printWriter.println("priority         : " + this.priority);
        printWriter.println("idGenerator      : " + this.idGenerator);
        printWriter.println("metaDataGenerator: " + this.metaDataGenerator);
        printWriter.println("properties       : " + this.properties);
        for (int i = 0; this.components != null && i < this.components.length; ++i) {
            printWriter.println("Component " + i);
            printWriter.println(this.components[i]);
        }
        return stringWriter.toString();
    }

    public String fancyFormat(int n) {
        int n2;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("timeout          : " + this.timeout);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("inactivity       : " + this.inactivity);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("priority         : " + this.priority);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("idGenerator      : " + this.idGenerator);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("metaDataGenerator: " + this.metaDataGenerator);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        for (n2 = 0; this.properties != null && n2 < this.properties.size(); ++n2) {
            for (int i = n; i > 0; --i) {
                printWriter.print("\t");
            }
            printWriter.println("property " + n2 + ":");
            Iterator iterator = this.properties.values().iterator();
            while (iterator.hasNext()) {
                printWriter.println(((Property)iterator.next()).fancyFormat(n + 1));
            }
        }
        for (n2 = 0; this.components != null && n2 < this.components.length; ++n2) {
            for (int i = n; i > 0; --i) {
                printWriter.print("\t");
            }
            printWriter.println("Component " + n2 + ":");
            printWriter.println(this.components[n2].fancyFormat(n + 1));
        }
        return stringWriter.toString();
    }

    public Object clone() {
        CacheId cacheId = new CacheId();
        cacheId.timeout = this.timeout;
        cacheId.inactivity = this.inactivity;
        cacheId.priority = this.priority;
        cacheId.idGenerator = this.idGenerator;
        cacheId.metaDataGenerator = this.metaDataGenerator;
        if (this.properties != null) {
            cacheId.properties = new HashMap(this.properties.size());
            for (Object k : this.properties.keySet()) {
                cacheId.properties.put(k, ((Property)this.properties.get(k)).clone());
            }
        }
        if (this.components != null) {
            cacheId.components = new Component[this.components.length];
            for (int i = 0; i < this.components.length; ++i) {
                cacheId.components[i] = (Component)this.components[i].clone();
            }
        }
        if (this.processorData != null) {
            cacheId.processorData = new Object[this.processorData.length];
            for (int i = 0; i < this.processorData.length; ++i) {
                cacheId.processorData[i] = this.processorData[i];
            }
        }
        return cacheId;
    }
}

