/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.EntryInfo;
import com.ibm.websphere.command.CacheableCommand;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.SerializationUtility;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.CacheId;
import com.ibm.ws.cache.config.Component;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.DependencyId;
import com.ibm.ws.cache.config.Field;
import com.ibm.ws.cache.config.Invalidation;
import com.ibm.ws.cache.config.Method;
import com.ibm.ws.cache.config.NotValue;
import com.ibm.ws.cache.config.Property;
import com.ibm.ws.cache.config.Range;
import com.ibm.ws.cache.config.Value;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class CacheProcessor {
    private static TraceComponent tc = Trace.register(CacheProcessor.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final String PROPERTY_SHARING_POLICY = "sharing-policy";
    public static final String PROPERTY_SHARINGPOLICY = "sharingpolicy";
    public static final String PROPERTY_PERSIST_TO_DISK = "persist-to-disk";
    public static final String PROPERTY_DELAY_INVALIDATIONS = "delay-invalidations";
    public static final String PROPERTY_TIMEOUT = "timeout";
    public static final String PROPERTY_INACTIVITY = "inactivity";
    public static final String PROPERTY_PRIORITY = "priority";
    public static final String PROPERTY_DO_NOT_CACHE = "do-not-cache";
    protected static final int SLOT_SHARINGPOLICY = 0;
    protected static final int SLOT_TIMEOUT = 1;
    protected static final int SLOT_PRIORITY = 2;
    protected static final int SLOT_PERSIST_TO_DISK = 3;
    protected static final int SLOT_INACTIVITY = 4;
    protected static final int SLOT_DO_NOT_CACHE = 5;
    protected static final int BASE_SLOTS = 6;
    protected boolean cacheable = false;
    protected StringBuffer id = new StringBuffer();
    protected ArrayList groupIds = null;
    protected ArrayList invalidationIds = null;
    protected ConfigEntry configEntry;
    protected boolean delayInvalidations = false;
    protected int timeout = -1;
    protected int inactivity = -1;
    protected int priority = -1;
    protected int sharingPolicy = -1;
    protected boolean persistToDisk = true;
    protected CacheId cacheIdForMetaDataGenerator = null;
    protected boolean doNotCache = false;
    protected static final Object[] emptyArgs = new Object[0];

    public CacheProcessor() {
    }

    public CacheProcessor(ConfigEntry configEntry) {
        this.configEntry = configEntry;
    }

    public void reset(ConfigEntry configEntry) {
        this.cacheable = false;
        this.id = new StringBuffer();
        this.groupIds = null;
        this.invalidationIds = null;
        this.configEntry = configEntry;
        this.delayInvalidations = false;
        this.timeout = -1;
        this.inactivity = -1;
        this.priority = -1;
        this.persistToDisk = true;
        this.sharingPolicy = configEntry != null ? configEntry.sharingPolicy : -1;
        this.doNotCache = false;
    }

    public boolean preProcess(ConfigEntry configEntry) {
        Property property;
        String string;
        boolean bl = true;
        if (configEntry.processorData == null) {
            configEntry.processorData = new Object[6];
        }
        String string2 = string = (property = (Property)configEntry.properties.get(PROPERTY_PERSIST_TO_DISK)) != null ? property.value : null;
        if (string != null) {
            string = string.trim();
            configEntry.processorData[3] = new Boolean(string);
        }
        String string3 = string = (property = (Property)configEntry.properties.get(PROPERTY_DO_NOT_CACHE)) != null ? property.value : null;
        if (string != null) {
            configEntry.processorData[5] = new Boolean(string);
        }
        for (int i = 0; i < configEntry.cacheIds.length; ++i) {
            bl &= this.preProcess(configEntry.cacheIds[i]);
        }
        return bl;
    }

    public boolean preProcess(CacheId cacheId) {
        if (cacheId.processorData == null) {
            cacheId.processorData = new Object[6];
        }
        if (cacheId.properties != null) {
            String string;
            Property property = (Property)cacheId.properties.get(PROPERTY_SHARING_POLICY);
            String string2 = string = property != null ? property.value : null;
            if (string == null) {
                string = (String)cacheId.properties.get(PROPERTY_SHARINGPOLICY);
            }
            if (string != null) {
                if (string.equalsIgnoreCase("none")) {
                    cacheId.processorData[0] = new Integer(1);
                } else if (string.equalsIgnoreCase("pull")) {
                    cacheId.processorData[0] = new Integer(3);
                } else if (string.equalsIgnoreCase("push")) {
                    cacheId.processorData[0] = new Integer(2);
                } else if (string.equalsIgnoreCase("both")) {
                    cacheId.processorData[0] = new Integer(4);
                }
            }
            if ((property = (Property)cacheId.properties.get(PROPERTY_TIMEOUT)) != null) {
                string = property.value;
            }
            if (string != null) {
                cacheId.processorData[1] = new Integer(string);
            }
            if ((property = (Property)cacheId.properties.get(PROPERTY_INACTIVITY)) != null && (string = property.value) != null) {
                cacheId.processorData[4] = new Integer(string);
            }
            if ((property = (Property)cacheId.properties.get(PROPERTY_PRIORITY)) != null) {
                string = property.value;
            }
            if (string != null) {
                cacheId.processorData[2] = new Integer(string);
            }
            if ((property = (Property)cacheId.properties.get(PROPERTY_DO_NOT_CACHE)) != null && (string = property.value) != null) {
                cacheId.processorData[5] = new Boolean(string);
            }
        }
        return true;
    }

    public void processCacheIdProperties(CacheId cacheId) {
        if (cacheId.processorData[0] != null) {
            this.sharingPolicy = (Integer)cacheId.processorData[0];
        }
        if (cacheId.processorData[1] != null) {
            this.timeout = (Integer)cacheId.processorData[1];
        }
        if (cacheId.processorData[4] != null) {
            this.inactivity = (Integer)cacheId.processorData[4];
        }
        if (cacheId.processorData[2] != null) {
            this.priority = (Integer)cacheId.processorData[2];
        }
        if (cacheId.processorData[5] != null) {
            this.doNotCache = (Boolean)cacheId.processorData[5];
        }
    }

    public void processConfigEntryProperties() {
        if (this.configEntry.processorData[3] != null) {
            this.persistToDisk = (Boolean)this.configEntry.processorData[3];
        }
        if (this.configEntry.processorData[5] != null) {
            this.doNotCache = (Boolean)this.configEntry.processorData[5];
        }
    }

    protected abstract Object getComponentValue(Component var1);

    public String getBaseName() {
        return this.configEntry.name;
    }

    public boolean execute() {
        int n;
        this.cacheable = false;
        if (this.configEntry.cacheIds != null) {
            for (n = 0; !this.cacheable && n < this.configEntry.cacheIds.length; ++n) {
                this.id.append(this.getBaseName());
                this.cacheable = this.processCacheId(this.configEntry.cacheIds[n]);
                if (this.cacheable) continue;
                this.id.setLength(0);
            }
        }
        if (this.configEntry.dependencyIds != null) {
            for (n = 0; n < this.configEntry.dependencyIds.length; ++n) {
                this.processDependencyId(this.configEntry.dependencyIds[n]);
            }
        }
        if (this.configEntry.className.equalsIgnoreCase("command")) {
            Property property = (Property)this.configEntry.properties.get(PROPERTY_DELAY_INVALIDATIONS);
            if (property != null && "true".equalsIgnoreCase(property.value)) {
                this.delayInvalidations = true;
            }
        } else {
            this.setInvalidationIds();
        }
        return this.cacheable;
    }

    public String getId() {
        if (this.cacheable) {
            return this.id.toString();
        }
        return null;
    }

    public ArrayList getGroupIds() {
        return this.groupIds;
    }

    public ArrayList getInvalidationIds() {
        return this.invalidationIds;
    }

    public int getSharingPolicy() {
        return this.sharingPolicy;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getInactivity() {
        return this.inactivity;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setEntryInfo(EntryInfo entryInfo) {
        entryInfo.setId(this.getId());
        entryInfo.addTemplate(this.getBaseName());
        if (this.cacheable) {
            entryInfo.setSharingPolicy(this.getSharingPolicy());
            entryInfo.setPersistToDisk(this.persistToDisk);
            entryInfo.setTimeLimit(this.getTimeout());
            entryInfo.setInactivity(this.getInactivity());
            if (this.getPriority() > 0) {
                entryInfo.setPriority(this.getPriority());
            }
            if (this.groupIds != null) {
                for (int i = 0; i < this.groupIds.size(); ++i) {
                    entryInfo.addDataId((String)this.groupIds.get(i));
                }
            }
            if (this.cacheIdForMetaDataGenerator != null) {
                this.processMetaDataGenerator(this.cacheIdForMetaDataGenerator);
            }
        }
    }

    public void setInvalidationIds() {
        if (this.configEntry.invalidations != null) {
            for (int i = 0; i < this.configEntry.invalidations.length; ++i) {
                this.processInvalidation(this.configEntry.invalidations[i]);
            }
        }
    }

    protected boolean processCacheId(CacheId cacheId) {
        boolean bl = true;
        if (cacheId.idGenerator != null) {
            String string = this.processIdGenerator(cacheId);
            if (string == null) {
                bl = false;
            } else {
                this.id.append(':');
                this.id.append(string);
            }
        } else if (cacheId.components != null) {
            for (int i = 0; bl && i < cacheId.components.length; ++i) {
                bl = this.processComponent(cacheId.components[i], null, null, cacheId.components[i].required);
            }
        }
        if (bl) {
            this.priority = cacheId.priority;
            this.timeout = cacheId.timeout;
            this.inactivity = cacheId.inactivity;
            this.cacheIdForMetaDataGenerator = null;
            if (cacheId.metaDataGenerator != null) {
                this.cacheIdForMetaDataGenerator = cacheId;
            }
            this.processConfigEntryProperties();
            this.processCacheIdProperties(cacheId);
        }
        return bl;
    }

    protected abstract String processIdGenerator(CacheId var1);

    protected abstract void processMetaDataGenerator(CacheId var1);

    protected abstract String[] processInvalidationGenerator(Invalidation var1);

    protected boolean processComponent(Component component2, StringBuffer stringBuffer, ArrayList arrayList, boolean bl) {
        Object object;
        Object object2;
        boolean bl2 = false;
        Object[] objectArray = this.getComponentValue(component2);
        String string = null;
        if (objectArray != null) {
            int n;
            if (component2.iType == 11 || component2.iType == 0 || component2.iType == 1) {
                if (objectArray instanceof Collection) {
                    objectArray = ((Collection)objectArray).toArray();
                }
                if (objectArray instanceof Object[] && ((Object[])(object2 = objectArray)).length > 0) {
                    object = new StringBuffer();
                    for (n = 0; n < ((Object[])object2).length; ++n) {
                        if (object2[n] == null) continue;
                        ((StringBuffer)object).append(object2[n]);
                        ((StringBuffer)object).append(",");
                    }
                    string = ((StringBuffer)object).substring(0, ((StringBuffer)object).length() - 1);
                }
            }
            if (string == null) {
                string = objectArray.toString();
            }
            if (string != null) {
                Range range;
                int n2;
                bl2 = true;
                if (component2.values != null && component2.values.size() != 0 || component2.valueRanges != null && component2.valueRanges.size() != 0) {
                    Value value2;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    if (component2.values != null && component2.values.size() != 0 && (value2 = (Value)component2.values.get(string)) != null) {
                        bl3 = true;
                    }
                    try {
                        n = Integer.valueOf(string);
                        if (component2.valueRanges != null && component2.valueRanges.size() != 0) {
                            for (n2 = 0; n2 < component2.valueRanges.size(); ++n2) {
                                range = (Range)component2.valueRanges.get(n2);
                                if (range.low > n || n > range.high) continue;
                                bl4 = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        bl4 = false;
                    }
                    boolean bl5 = bl2 = bl3 || bl4;
                }
                if (component2.notValues != null && component2.notValues.size() != 0 || component2.notValueRanges != null && component2.notValueRanges.size() != 0) {
                    NotValue notValue;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    if (component2.notValues != null && component2.notValues.size() != 0 && (notValue = (NotValue)component2.notValues.get(string)) != null) {
                        bl6 = true;
                    }
                    try {
                        n = Integer.valueOf(string);
                        if (component2.notValueRanges != null && component2.notValueRanges.size() != 0) {
                            for (n2 = 0; n2 < component2.notValueRanges.size(); ++n2) {
                                range = (Range)component2.notValueRanges.get(n2);
                                if (range.low > n || n > range.high) continue;
                                bl7 = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        bl7 = false;
                    }
                    bl2 = bl2 && !bl6 && !bl7;
                }
            }
        } else {
            boolean bl8 = bl2 = !bl;
        }
        if (bl2 && string != null) {
            if (stringBuffer == null) {
                this.id.append(':');
                if (component2.id == null || component2.id.equals("")) {
                    component2.id = component2.type;
                }
                this.id.append(component2.id);
                if (!component2.ignoreValue) {
                    this.id.append('=');
                    this.id.append(string);
                }
            } else if (!component2.ignoreValue) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(':');
                }
                stringBuffer.append(string);
                object2 = null;
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object2 = (String)arrayList.get(i);
                        object2 = (String)object2 + ":" + string;
                        arrayList.set(i, object2);
                    }
                }
            }
        }
        if (!bl2 && ((CacheConfig)(object = (object2 = ServerCache.getCache(this.configEntry.instanceName)).getCacheConfig())).isUse602RequiredAttrCompatibility() && !bl) {
            boolean bl9 = bl2 = !bl;
        }
        if (tc.isDebugEnabled() && !bl2) {
            Tr.debug(tc, "reason comp.id=" + component2.id + " result=" + bl2 + " compValue=" + string);
        }
        return bl2;
    }

    protected void processDependencyId(DependencyId dependencyId) {
        if (dependencyId != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(dependencyId.baseName);
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = true;
            for (int i = 0; bl && i < dependencyId.components.length; ++i) {
                Object[] objectArray;
                String string = stringBuffer.toString();
                bl = this.processComponent(dependencyId.components[i], stringBuffer, arrayList, dependencyId.components[i].required);
                if (!dependencyId.components[i].multipleIds || dependencyId.components[i].iType != 11 && dependencyId.components[i].iType != 0 && dependencyId.components[i].iType != 1) continue;
                Object[] objectArray2 = this.getComponentValue(dependencyId.components[i]);
                if (objectArray2 instanceof Collection) {
                    objectArray2 = ((Collection)objectArray2).toArray();
                }
                if (!(objectArray2 instanceof Object[]) || (objectArray = objectArray2).length <= 0) continue;
                String string2 = null;
                for (int j = 0; j < objectArray.length; ++j) {
                    if (objectArray[j] == null) continue;
                    string2 = string + ":" + objectArray[j].toString();
                    arrayList.add(string2);
                }
            }
            if (bl) {
                if (this.groupIds == null) {
                    this.groupIds = new ArrayList();
                }
                this.groupIds.add(stringBuffer.toString());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.groupIds.add((String)iterator.next());
                }
            }
        }
    }

    protected void processInvalidation(Invalidation invalidation) {
        block8: {
            block9: {
                if (invalidation == null) break block8;
                if (invalidation.invalidationGenerator == null) break block9;
                String[] stringArray = this.processInvalidationGenerator(invalidation);
                if (stringArray == null) break block8;
                if (this.invalidationIds == null) {
                    this.invalidationIds = new ArrayList();
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = "";
                    string = invalidation.baseName != null && !invalidation.baseName.equals("") ? invalidation.baseName + ":" + stringArray[i] : stringArray[i];
                    this.invalidationIds.add(string);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "InvalidationGenerator - id=" + string);
                }
                break block8;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(invalidation.baseName);
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = true;
            for (int i = 0; bl && i < invalidation.components.length; ++i) {
                Object[] objectArray;
                String string = stringBuffer.toString();
                bl = this.processComponent(invalidation.components[i], stringBuffer, arrayList, invalidation.components[i].required);
                if (!invalidation.components[i].multipleIds || invalidation.components[i].iType != 11 && invalidation.components[i].iType != 0 && invalidation.components[i].iType != 1) continue;
                Object[] objectArray2 = this.getComponentValue(invalidation.components[i]);
                if (objectArray2 instanceof Collection) {
                    objectArray2 = ((Collection)objectArray2).toArray();
                }
                if (!(objectArray2 instanceof Object[]) || (objectArray = objectArray2).length <= 0) continue;
                String string2 = null;
                for (int j = 0; j < objectArray.length; ++j) {
                    if (objectArray[j] == null) continue;
                    string2 = string + ":" + objectArray[j].toString();
                    arrayList.add(string2);
                }
            }
            if (bl) {
                if (this.invalidationIds == null) {
                    this.invalidationIds = new ArrayList();
                }
                this.invalidationIds.add(stringBuffer.toString());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.invalidationIds.add((String)iterator.next());
                }
            }
        }
    }

    protected Object processMethod(Method method2, Object object) {
        Object object2;
        block18: {
            block17: {
                if (object == null) {
                    return null;
                }
                if (method2.methodImpl == null) {
                    try {
                        method2.methodImpl = object.getClass().getMethod(method2.name, null);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.CacheProcessor.processMethod", "275", this);
                        Tr.error(tc, "DYNA0033E", new Object[]{method2.name, object.getClass().getName(), exception.getMessage()});
                        if (!tc.isDebugEnabled()) break block17;
                        Tr.debug(tc, "Exception", exception);
                    }
                }
            }
            object2 = null;
            try {
                object2 = method2.methodImpl.invoke(object, emptyArgs);
            }
            catch (RuntimeException runtimeException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception", runtimeException);
                }
                try {
                    byte[] byArray = SerializationUtility.serialize((CacheableCommand)object);
                    object = (CacheableCommand)SerializationUtility.deserialize(byArray);
                    method2.methodImpl = object.getClass().getMethod(method2.name, null);
                    object2 = method2.methodImpl.invoke(object, emptyArgs);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.CacheProcessor.processMethod", "284", this);
                    Tr.error(tc, "DYNA0034E", new Object[]{method2.name, object.getClass().getName(), exception.getMessage()});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception", exception);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.CacheProcessor.processMethod", "284", this);
                Tr.error(tc, "DYNA0034E", new Object[]{method2.name, object.getClass().getName(), exception.getMessage()});
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "Exception", exception);
            }
        }
        if (method2.method != null) {
            object2 = this.processMethod(method2.method, object2);
        } else if (method2.field != null) {
            object2 = this.processField(method2.field, object2);
        }
        if (method2.index > -1) {
            if (object2 instanceof Collection) {
                object2 = ((Collection)object2).toArray();
            }
            if (object2 instanceof Object[] && ((Object[])object2).length > method2.index) {
                object2 = object2[method2.index];
            }
        }
        return object2;
    }

    protected Object processField(Field field, Object object) {
        Object object2;
        block13: {
            block12: {
                if (object == null) {
                    return null;
                }
                if (field.fieldImpl == null) {
                    try {
                        field.fieldImpl = object.getClass().getField(field.name);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.CacheProcessor.processField", "301", this);
                        Tr.error(tc, "DYNA0035E", new Object[]{field.name, object.getClass().getName(), exception.getMessage()});
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug(tc, "Exception", exception);
                    }
                }
            }
            object2 = null;
            try {
                object2 = field.fieldImpl.get(object);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.CacheProcessor.processField", "310", this);
                Tr.error(tc, "DYNA0036E", new Object[]{field.name, object.getClass().getName(), exception.getMessage()});
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Exception", exception);
            }
        }
        if (field.method != null) {
            object2 = this.processMethod(field.method, object2);
        } else if (field.field != null) {
            object2 = this.processField(field.field, object2);
        }
        if (field.index > -1) {
            if (object2 instanceof Collection) {
                object2 = ((Collection)object2).toArray();
            }
            if (object2 instanceof Object[] && ((Object[])object2).length > field.index) {
                object2 = object2[field.index];
            }
        }
        return object2;
    }

    public boolean isDelayInvalidations() {
        return this.delayInvalidations;
    }

    public boolean getDoNotCache() {
        return this.doNotCache;
    }
}

