/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.Field;
import com.ibm.ws.cache.config.Method;
import com.ibm.ws.cache.config.NotValue;
import com.ibm.ws.cache.config.Range;
import com.ibm.ws.cache.config.Value;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Component {
    private static TraceComponent tc = Trace.register(Component.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public String type;
    public String id;
    public boolean ignoreValue;
    public boolean multipleIds;
    public Method method;
    public Field field;
    public int index = -1;
    public boolean required;
    public HashMap values;
    public HashMap notValues;
    public ArrayList valueRanges;
    public ArrayList notValueRanges;
    public int iType;
    public Method idMethod;
    public Field idField;
    public static final int METHOD = 0;
    public static final int FIELD = 1;
    public static final int SESSION = 2;
    public static final int PARAMETER = 3;
    public static final int COOKIE = 4;
    public static final int HEADER = 5;
    public static final int LOCALE = 6;
    public static final int SOAP_ACTION = 7;
    public static final int SERVICE_OPERATION = 8;
    public static final int SERVICE_OPERATION_PARAMETER = 9;
    public static final int SOAP_ENVELOPE = 10;
    public static final int ATTRIBUTE = 11;
    public static final int PATH_INFO = 12;
    public static final int SERVLET_PATH = 13;
    public static final int PARAMETER_LIST = 14;
    public static final int OPERATION = 15;
    public static final int PART = 16;
    public static final int WSDL_SERVICE = 17;
    public static final int WSDL_PORT = 18;
    public static final int SOAP_HEADER_ENTRY = 19;
    public static final int REQUEST_TYPE = 20;
    public static final int TILES_ATTRIBUTE = 21;
    public static final int PORTLET_SESSION = 22;
    public static final int PORTLET_WINDOW_ID = 23;
    public static final int PORTLET_MODE = 24;
    public static final int PORTLET_WINDOW_STATE = 25;
    public static final int SESSION_ID = 26;

    public void validate() {
        if (this.type.equalsIgnoreCase("method")) {
            this.iType = 0;
        } else if (this.type.equalsIgnoreCase("field")) {
            this.iType = 1;
        } else if (this.type.equalsIgnoreCase("session")) {
            this.iType = 2;
        } else if (this.type.equalsIgnoreCase("parameter")) {
            this.iType = 3;
        } else if (this.type.equalsIgnoreCase("cookie")) {
            this.iType = 4;
        } else if (this.type.equalsIgnoreCase("header")) {
            this.iType = 5;
        } else if (this.type.equalsIgnoreCase("locale")) {
            this.iType = 6;
        } else if (this.type.equalsIgnoreCase("SOAPAction")) {
            this.iType = 7;
        } else if (this.type.equalsIgnoreCase("serviceOperation")) {
            this.iType = 8;
        } else if (this.type.equalsIgnoreCase("serviceOperationParameter")) {
            this.iType = 9;
        } else if (this.type.equalsIgnoreCase("SOAPEnvelope")) {
            this.iType = 10;
        } else if (this.type.equalsIgnoreCase("attribute")) {
            this.iType = 11;
        } else if (this.type.equalsIgnoreCase("pathInfo")) {
            this.iType = 12;
        } else if (this.type.equalsIgnoreCase("servletpath")) {
            this.iType = 13;
        } else if (this.type.equalsIgnoreCase("parameter-list")) {
            this.iType = 14;
        } else if (this.type.equalsIgnoreCase("operation")) {
            this.iType = 15;
        } else if (this.type.equalsIgnoreCase("part")) {
            this.iType = 16;
        } else if (this.type.equalsIgnoreCase("WSDLServiceName")) {
            this.iType = 17;
        } else if (this.type.equalsIgnoreCase("WSDLPortName")) {
            this.iType = 18;
        } else if (this.type.equalsIgnoreCase("SOAPHeaderEntry")) {
            this.iType = 19;
        } else if (this.type.equalsIgnoreCase("requestType")) {
            this.iType = 20;
        } else if (this.type.equalsIgnoreCase("tiles_attribute")) {
            this.iType = 21;
        } else if (this.type.equalsIgnoreCase("portletSession")) {
            this.iType = 22;
        } else if (this.type.equalsIgnoreCase("portletWindowId")) {
            this.iType = 23;
        } else if (this.type.equalsIgnoreCase("portletMode")) {
            this.iType = 24;
        } else if (this.type.equalsIgnoreCase("portletWindowState")) {
            this.iType = 25;
        } else if (this.type.equalsIgnoreCase("sessionId")) {
            this.iType = 26;
        } else {
            Tr.error(tc, "DYNA0049E", new Object[]{this.type});
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("type       : " + this.type);
        printWriter.println("id         : " + this.id);
        printWriter.println("ignoreValue: " + this.ignoreValue);
        printWriter.println("mutipleIds : " + this.multipleIds);
        printWriter.println("method     : " + this.method);
        printWriter.println("index  : " + this.index);
        printWriter.println("required   : " + this.required);
        printWriter.println("values     : " + this.values);
        printWriter.println("not-values : " + this.notValues);
        printWriter.println("value ranges     : " + this.valueRanges);
        printWriter.println("not-value ranges : " + this.notValueRanges);
        return stringWriter.toString();
    }

    public String fancyFormat(int n) {
        int n2;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("id         : " + this.id);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("type       : " + this.type);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("ignoreValue: " + this.ignoreValue);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("multipleIds   : " + this.multipleIds);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("method     : " + this.method);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("index  : " + this.index);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("required   : " + this.required);
        if (this.values != null && this.values.size() > 0) {
            for (n2 = n; n2 > 0; --n2) {
                printWriter.print("\t");
            }
            printWriter.println("value        : " + this.values);
            Iterator iterator = this.values.values().iterator();
            while (iterator.hasNext()) {
                printWriter.println(((Value)iterator.next()).fancyFormat(n + 1));
            }
        }
        if (this.notValues != null && this.notValues.size() > 0) {
            for (int i = n; i > 0; --i) {
                printWriter.print("\t");
            }
            printWriter.println("not-value    : " + this.notValues);
            Iterator iterator = this.notValues.values().iterator();
            while (iterator.hasNext()) {
                printWriter.println(((NotValue)iterator.next()).fancyFormat(n + 1));
            }
        }
        if (this.valueRanges != null && this.valueRanges.size() > 0) {
            for (int i = n; i > 0; --i) {
                printWriter.print("\t");
            }
            printWriter.println("value ranges     : " + this.valueRanges);
            Iterator iterator = this.valueRanges.iterator();
            while (iterator.hasNext()) {
                printWriter.println(((Range)iterator.next()).fancyFormat(n + 1));
            }
        }
        if (this.notValueRanges != null && this.notValueRanges.size() > 0) {
            for (int i = n; i > 0; --i) {
                printWriter.print("\t");
            }
            printWriter.println("not-value ranges : " + this.notValueRanges);
            Iterator iterator = this.notValueRanges.iterator();
            while (iterator.hasNext()) {
                printWriter.println(((Range)iterator.next()).fancyFormat(n + 1));
            }
        }
        return stringWriter.toString();
    }

    public void getESIComponent(StringBuffer stringBuffer) {
        if (this.required) {
            if (this.ignoreValue) {
                stringBuffer.append("<").append(this.id);
                stringBuffer.append(">");
                this.getESIValues(stringBuffer);
            } else {
                stringBuffer.append(this.id);
                this.getESIValues(stringBuffer);
            }
        } else if (!this.required) {
            stringBuffer.append("[");
            if (this.ignoreValue) {
                stringBuffer.append("<").append(this.id);
                stringBuffer.append(">");
                this.getESIValues(stringBuffer);
            } else {
                stringBuffer.append(this.id);
                this.getESIValues(stringBuffer);
            }
            stringBuffer.append("]");
        }
    }

    public void getESIValues(StringBuffer stringBuffer) {
        if (this.values != null && this.values.size() > 0) {
            stringBuffer.append("={");
            Iterator iterator = this.values.values().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((Value)iterator.next()).value);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.append("}");
        } else if (this.notValues != null && this.notValues.size() > 0) {
            stringBuffer.append("={");
            Iterator iterator = this.notValues.values().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((NotValue)iterator.next()).notValue);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.append("}");
        }
    }

    public Object clone() {
        Iterator<Object> iterator;
        Component component2 = new Component();
        component2.type = this.type;
        component2.iType = this.iType;
        component2.id = this.id;
        component2.ignoreValue = this.ignoreValue;
        component2.multipleIds = this.multipleIds;
        component2.required = this.required;
        if (this.method != null) {
            component2.method = (Method)this.method.clone();
        }
        if (this.field != null) {
            component2.field = (Field)this.field.clone();
        }
        component2.index = this.index;
        if (this.values != null) {
            component2.values = new HashMap();
            for (Object k : this.values.keySet()) {
                component2.values.put(k, ((Value)this.values.get(k)).clone());
            }
        }
        if (this.notValues != null) {
            component2.notValues = new HashMap();
            for (Object k : this.notValues.keySet()) {
                component2.notValues.put(k, ((NotValue)this.notValues.get(k)).clone());
            }
        }
        if (this.valueRanges != null) {
            component2.valueRanges = new ArrayList();
            if (this.valueRanges != null) {
                component2.valueRanges = new ArrayList();
                iterator = this.valueRanges.iterator();
                while (iterator.hasNext()) {
                    component2.valueRanges.add(((Range)iterator.next()).clone());
                }
            }
        }
        if (this.notValueRanges != null) {
            component2.notValueRanges = new ArrayList();
            if (this.notValueRanges != null) {
                component2.notValueRanges = new ArrayList();
                iterator = this.notValueRanges.iterator();
                while (iterator.hasNext()) {
                    component2.notValueRanges.add(((Range)iterator.next()).clone());
                }
            }
        }
        return component2;
    }
}

