/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.CacheHandler;
import com.ibm.ws.cache.config.CacheProcessor;
import com.ibm.ws.cache.config.ConfigChangeListener;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.ConfigErrorHandler;
import com.ibm.ws.cache.config.ConfigFileEntry;
import com.ibm.ws.cache.config.RuleHandler;
import com.ibm.ws.cache.servlet.ServletCacheEngine;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.util.PortletContainerAccessHelper;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.xml.ParserFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.utils.XMLReaderManager;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ConfigManager
implements AlarmListener {
    private static TraceComponent tc = Trace.register(ConfigManager.class, "WebSphere Cache", "com.ibm.ws.cache.resources.dynacache");
    static final String CACHE_SPEC = "cachespec.xml";
    static final String CACHE_SPEC_DTD = "cachespec.dtd";
    static String propertiesDir = "";
    private SAXParser jaxpParser = null;
    private ArrayList globalCacheInstances = new ArrayList();
    private ArrayList globalCacheEntries = new ArrayList();
    private ArrayList legacyCacheEntries = new ArrayList();
    private ArrayList configListeners = new ArrayList();
    private HashMap cacheEntries = new HashMap();
    private HashMap configFiles = new HashMap();
    private HashMap potentialConfigFiles = new HashMap();
    private HashMap EJBConfigFiles = new HashMap();
    private int counter = 0;
    private int reloadInterval = -1;
    private HashMap entryCache = new HashMap();
    private MultiProcessorPool processorPool = new MultiProcessorPool();
    private HashMap jaxRpcClientConfigEntries = new HashMap(1);
    private HashMap servletConfigEntries = new HashMap();
    private HashMap portletConfigEntries = new HashMap();
    private static ConfigManager instance = new ConfigManager();

    public static ConfigManager getInstance() {
        return instance;
    }

    protected ConfigManager() {
    }

    public synchronized void addConfigChangeListener(ConfigChangeListener configChangeListener) {
        this.configListeners.add(configChangeListener);
    }

    public synchronized void removeConfigChangeListener(ConfigChangeListener configChangeListener) {
        this.configListeners.remove(configChangeListener);
    }

    public synchronized void fireChangedEvent() {
        int n = this.configListeners.size();
        for (int i = 0; i < n; ++i) {
            ((ConfigChangeListener)this.configListeners.get(i)).configChanged();
        }
    }

    public void setReloadInterval(int n) {
        if (this.reloadInterval == -1) {
            this.reloadInterval = n;
            AlarmManager.create(n, this, null);
        }
    }

    public static void setPropertiesDirectory(String string) {
        propertiesDir = string;
        if (!propertiesDir.endsWith(File.separator)) {
            propertiesDir = propertiesDir + File.separator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        ++this.counter;
        HashMap hashMap = this.configFiles;
        synchronized (hashMap) {
            this.checkConfig();
        }
        if (this.counter == 6) {
            hashMap = this.potentialConfigFiles;
            synchronized (hashMap) {
                this.checkPotentialConfig();
            }
            hashMap = this.EJBConfigFiles;
            synchronized (hashMap) {
                this.checkEJBJarConfig();
            }
            this.counter = 0;
        }
        AlarmManager.create(this.reloadInterval, this, null);
    }

    protected void checkConfig() {
        Iterator iterator = this.configFiles.values().iterator();
        while (iterator.hasNext()) {
            ConfigFileEntry configFileEntry = (ConfigFileEntry)iterator.next();
            try {
                if (configFileEntry.lastModified == configFileEntry.configFile.lastModified()) continue;
                if (configFileEntry.configFile.exists()) {
                    if (this.loadConfig(configFileEntry.fileName, configFileEntry.isWarFile, configFileEntry.isModule, configFileEntry.appName, configFileEntry.appContext)) continue;
                    iterator.remove();
                    continue;
                }
                this.potentialConfigFiles.put(configFileEntry.fileName, configFileEntry);
                iterator.remove();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.checkConfig", "110", this);
                iterator.remove();
            }
        }
    }

    protected void checkPotentialConfig() {
        Iterator iterator = this.potentialConfigFiles.values().iterator();
        while (iterator.hasNext()) {
            ConfigFileEntry configFileEntry = (ConfigFileEntry)iterator.next();
            if (!configFileEntry.configFile.exists()) continue;
            this.configFiles.put(configFileEntry.fileName, configFileEntry);
            iterator.remove();
            try {
                if (this.loadConfig(configFileEntry.fileName, configFileEntry.isWarFile, configFileEntry.isModule, configFileEntry.appName, configFileEntry.appContext)) continue;
                this.configFiles.remove(configFileEntry.fileName);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.checkConfig", "110", this);
                this.configFiles.remove(configFileEntry.fileName);
            }
        }
    }

    protected void checkEJBJarConfig() {
        Iterator iterator = this.EJBConfigFiles.values().iterator();
        while (iterator.hasNext()) {
            ConfigFileEntry configFileEntry = (ConfigFileEntry)iterator.next();
            try {
                if (configFileEntry.lastModified == configFileEntry.configFile.lastModified()) continue;
                if (configFileEntry.configFile.exists()) {
                    this.loadEJBJarConfig(configFileEntry.fileName, configFileEntry.appName, configFileEntry.appContext);
                    continue;
                }
                iterator.remove();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.checkConfig", "110", this);
                iterator.remove();
            }
        }
    }

    public void addLegacyCacheEntry(ConfigEntry configEntry) {
        if (this.preProcessEntry(configEntry)) {
            this.globalCacheEntries.add(configEntry);
            this.legacyCacheEntries.add(configEntry);
            if (configEntry != null) {
                Iterator iterator = configEntry.allNames.iterator();
                while (iterator.hasNext()) {
                    String string;
                    ConfigEntry configEntry2 = (ConfigEntry)configEntry.clone();
                    configEntry2.name = string = (String)iterator.next();
                    this.servletConfigEntries.put(string, configEntry2);
                }
            }
        }
    }

    public ConfigEntry getJaxRpcConfigEntry(String string) {
        return (ConfigEntry)this.jaxRpcClientConfigEntries.get(string);
    }

    public ConfigEntry getServletCacheEntry(Object object, String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getServletCacheEntry()" + string + " " + string2);
        }
        Class<?> clazz = object.getClass();
        String string3 = clazz.getName() + ".class";
        ConfigEntry configEntry = null;
        if (string != null) {
            configEntry = (ConfigEntry)this.servletConfigEntries.get(string);
        }
        if (configEntry == null) {
            String string4 = string2 == null ? string3 : string2 + "/" + string3;
            configEntry = (ConfigEntry)this.servletConfigEntries.get(string4);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "using config entry: " + configEntry);
        }
        return configEntry;
    }

    public ConfigEntry getPortletCacheEntry(Object object, String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPortletCacheEntry()" + string + " " + string2);
        }
        ConfigEntry configEntry = null;
        if (string != null) {
            String string3 = PortletContainerAccessHelper.getPortletURI((String)string2, (String)string);
            configEntry = (ConfigEntry)this.portletConfigEntries.get(string3);
            if (configEntry == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no cache policy matched ... trying default portlet policy");
                }
                configEntry = (ConfigEntry)this.portletConfigEntries.get("*");
            }
            if (configEntry != null) {
                configEntry.name = string3;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "using config entry: " + configEntry);
        }
        return configEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigEntry getCacheEntry(Object object, String string, String string2) {
        Class<?> clazz;
        String string3;
        ConfigEntry configEntry;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCacheEntry()" + string + " " + string2);
        }
        if ((configEntry = (ConfigEntry)this.entryCache.get(string3 = (clazz = object.getClass()).getName() + (string != null ? string : "null") + (string2 != null ? string2 : "null"))) == null) {
            String string4;
            String string5 = clazz.getName() + ".class";
            String string6 = string4 = string2 == null ? string5 : string2 + "/" + string5;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Searching config entries for 1of2" + string);
                Tr.debug(tc, "Searching config entries for 2of2" + string4);
            }
            for (int i = 0; i < this.globalCacheEntries.size() && configEntry == null; ++i) {
                ConfigEntry configEntry2 = (ConfigEntry)this.globalCacheEntries.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking " + configEntry2.className + " " + configEntry2.name + ": " + configEntry2.allNames);
                }
                if (!configEntry2.allNames.contains(string) && !configEntry2.allNames.contains(string4)) continue;
                configEntry = (ConfigEntry)configEntry2.clone();
                HashMap hashMap = this.entryCache;
                synchronized (hashMap) {
                    this.entryCache.put(string3, configEntry);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Config Entry cached using key " + string3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using config entry: " + configEntry);
            }
        }
        return configEntry;
    }

    public ConfigEntry getCacheEntry(Object object, String string) {
        return this.getCacheEntry(object, string, null);
    }

    public CacheProcessor getCacheProcessor(ConfigEntry configEntry) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCacheProcessor");
        }
        if (configEntry == null) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "iClassName = " + configEntry.iClassName);
        }
        CacheProcessor cacheProcessor = configEntry.iClassName == 5 || configEntry.iClassName == 6 ? (CacheProcessor)this.processorPool.pools[1].remove() : (CacheProcessor)this.processorPool.pools[configEntry.iClassName].remove();
        cacheProcessor.reset(configEntry);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCacheProcessor: " + cacheProcessor);
        }
        return cacheProcessor;
    }

    public void returnCacheProcessor(CacheProcessor cacheProcessor) {
        if (cacheProcessor.configEntry.iClassName == 5 || cacheProcessor.configEntry.iClassName == 6) {
            this.processorPool.pools[1].add(cacheProcessor);
        } else {
            this.processorPool.pools[cacheProcessor.configEntry.iClassName].add(cacheProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadConfig(String string, boolean bl, boolean bl2, String string2, HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfig()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loading cache config file from: " + string + "isWarFile=" + bl + " isModule=" + bl2 + " appName=" + string2);
        }
        String string3 = string;
        File file = new File(string);
        if (file.isDirectory()) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            string3 = bl ? string + "WEB-INF/cachespec.xml" : string + "META-INF/cachespec.xml";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "325 - fileName=" + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "327 - configFileName=" + string3);
        }
        HashMap hashMap2 = this.configFiles;
        synchronized (hashMap2) {
            HashMap hashMap3 = this.potentialConfigFiles;
            synchronized (hashMap3) {
                ConfigFileEntry configFileEntry = (ConfigFileEntry)this.configFiles.get(string);
                if (configFileEntry == null) {
                    configFileEntry = (ConfigFileEntry)this.potentialConfigFiles.get(string);
                }
                if (configFileEntry == null) {
                    configFileEntry = new ConfigFileEntry();
                    configFileEntry.configFile = new File(string3);
                    configFileEntry.fileName = string;
                    configFileEntry.lastModified = 0L;
                    configFileEntry.isModule = bl2;
                    configFileEntry.isJarFile = file.isFile() && bl2;
                    configFileEntry.isWarFile = bl;
                    configFileEntry.appContext = hashMap;
                    if (!configFileEntry.configFile.exists()) {
                        this.potentialConfigFiles.put(string, configFileEntry);
                        return false;
                    }
                    this.configFiles.put(string, configFileEntry);
                }
                if (!configFileEntry.configFile.exists()) {
                    this.potentialConfigFiles.put(string, configFileEntry);
                    this.configFiles.remove(string);
                    return false;
                }
                if (this.potentialConfigFiles.get(string) != null) {
                    this.configFiles.put(string, configFileEntry);
                    this.potentialConfigFiles.remove(string);
                }
                if (configFileEntry.lastModified != configFileEntry.configFile.lastModified()) {
                    configFileEntry.lastModified = configFileEntry.configFile.lastModified();
                    CacheHandler cacheHandler = new CacheHandler(string2, hashMap);
                    try {
                        XMLReader xMLReader = null;
                        try {
                            xMLReader = XMLReaderManager.getInstance().getXMLReader();
                            xMLReader.setFeature("http://xml.org/sax/features/validation", true);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "401", this);
                        }
                        RuleHandler ruleHandler = new RuleHandler();
                        ruleHandler.addRule("cache", cacheHandler);
                        xMLReader.setContentHandler(ruleHandler);
                        xMLReader.setErrorHandler(new ConfigErrorHandler(string3));
                        xMLReader.setEntityResolver(new CacheSpecEntityResolver());
                        cacheHandler.setFilename(string3);
                        xMLReader.parse(string3);
                        this.updateCacheInstances(configFileEntry, cacheHandler, string3);
                        this.updateEntries(configFileEntry, cacheHandler, string3);
                    }
                    catch (SAXParseException sAXParseException) {
                        FFDCFilter.processException((Throwable)sAXParseException, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "295", this);
                        String string4 = sAXParseException.getMessage();
                        String string5 = Integer.toString(sAXParseException.getLineNumber());
                        String string6 = Integer.toString(sAXParseException.getColumnNumber());
                        Tr.error(tc, "DYNA0045E", new Object[]{string4, string, string5, string6});
                        Tr.error(tc, "DYNA0043E", new Object[]{string + " (" + string3 + ")"});
                        System.out.println("SAXParseException loading cache entries from " + string + " (" + string3 + ")" + ": " + sAXParseException.getMessage() + " at line " + string5 + " coloumn " + string6);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "dynacache config error", sAXParseException);
                        }
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "303", this);
                        Tr.error(tc, "DYNA0046E", new Object[]{iOException.getMessage(), string});
                        Tr.error(tc, "DYNA0043E", new Object[]{string + " (" + string3 + ")"});
                        System.out.println("IOException loading cache entries from " + string + " (" + string3 + ")" + ": " + iOException.getMessage());
                        ArrayList arrayList = cacheHandler.getEntries();
                        if (arrayList != null) {
                            for (ConfigEntry configEntry : arrayList) {
                                System.out.println("configEntry:" + configEntry.toString());
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "dynacache config error", iOException);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "308", this);
                        Tr.error(tc, "DYNA0043E", new Object[]{string + " (" + string3 + ")"});
                        System.out.println("Exception loading cache entries from " + string + " (" + string3 + ")" + ": " + exception.getMessage());
                        ArrayList arrayList = cacheHandler.getEntries();
                        if (arrayList != null) {
                            for (ConfigEntry configEntry : arrayList) {
                                System.out.println("configEntry:" + configEntry.toString());
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "dynacache config error", exception);
                        }
                    }
                    finally {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "loadConfig()  fileName=" + string + " configFileName=" + string3);
                        }
                    }
                }
            }
        }
        return true;
    }

    private void cleanStreams(ZipFile zipFile, InputStream inputStream) {
        try {
            if (null != inputStream) {
                inputStream.close();
            }
            if (null != zipFile) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            Tr.error(tc, "dynacache error: Could Not close zip file streams", iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadEJBJarConfig(String string) {
        ConfigFileEntry configFileEntry;
        HashMap hashMap = this.EJBConfigFiles;
        synchronized (hashMap) {
            configFileEntry = (ConfigFileEntry)this.EJBConfigFiles.remove(string);
        }
        if (configFileEntry != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed Config File Entry: " + configFileEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadEJBJarConfig(String string, String string2, HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadEJBJarConfig");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loading cache config file from: " + string + " appName=" + string2);
        }
        HashMap hashMap2 = this.EJBConfigFiles;
        synchronized (hashMap2) {
            block26: {
                Iterator iterator;
                Object object;
                XMLReader xMLReader;
                InputStream inputStream;
                ZipFile zipFile;
                CacheHandler cacheHandler;
                ConfigFileEntry configFileEntry;
                block25: {
                    configFileEntry = (ConfigFileEntry)this.EJBConfigFiles.get(string);
                    if (configFileEntry == null) {
                        configFileEntry = new ConfigFileEntry();
                        configFileEntry.configFile = new File(string);
                        configFileEntry.fileName = string;
                        configFileEntry.lastModified = 0L;
                        configFileEntry.isModule = true;
                        configFileEntry.isJarFile = true;
                        configFileEntry.isWarFile = false;
                        configFileEntry.appContext = hashMap;
                        this.EJBConfigFiles.put(string, configFileEntry);
                    }
                    if (configFileEntry.configFile.isDirectory()) {
                        this.EJBConfigFiles.remove(string);
                        return false;
                    }
                    if (!configFileEntry.configFile.exists()) {
                        this.EJBConfigFiles.remove(string);
                        return false;
                    }
                    if (configFileEntry.lastModified == configFileEntry.configFile.lastModified()) return true;
                    configFileEntry.lastModified = configFileEntry.configFile.lastModified();
                    cacheHandler = new CacheHandler(string2, hashMap);
                    zipFile = null;
                    inputStream = null;
                    xMLReader = null;
                    try {
                        xMLReader = XMLReaderManager.getInstance().getXMLReader();
                        xMLReader.setFeature("http://xml.org/sax/features/validation", true);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "549", this);
                    }
                    object = new RuleHandler();
                    ((RuleHandler)object).addRule("cache", cacheHandler);
                    xMLReader.setContentHandler((ContentHandler)object);
                    xMLReader.setErrorHandler(new ConfigErrorHandler(string));
                    xMLReader.setEntityResolver(new CacheSpecEntityResolver());
                    zipFile = new ZipFile(string);
                    iterator = zipFile.getEntry(configFileEntry.isWarFile ? "WEB-INF/cachespec.xml" : "META-INF/cachespec.xml");
                    if (iterator != null) break block25;
                    zipFile.close();
                    boolean bl = false;
                    this.cleanStreams(zipFile, inputStream);
                    if (!tc.isEntryEnabled()) return bl;
                    Tr.exit(tc, "loadEJBJarConfig");
                    return bl;
                }
                try {
                    cacheHandler.setFilename(configFileEntry.fileName + (configFileEntry.isWarFile ? "WEB-INF/cachespec.xml" : "META-INF/cachespec.xml"));
                    inputStream = zipFile.getInputStream((ZipEntry)((Object)iterator));
                    xMLReader.parse(new InputSource(inputStream));
                    inputStream.close();
                    zipFile.close();
                    this.updateCacheInstances(configFileEntry, cacheHandler, string);
                    this.updateEntries(configFileEntry, cacheHandler, string);
                    this.cleanStreams(zipFile, inputStream);
                }
                catch (SAXParseException sAXParseException) {
                    FFDCFilter.processException((Throwable)sAXParseException, "com.ibm.ws.cache.config.ConfigManager.loadEJBJarConfig", "295", this);
                    object = sAXParseException.getMessage();
                    iterator = Integer.toString(sAXParseException.getLineNumber());
                    String string3 = Integer.toString(sAXParseException.getColumnNumber());
                    Tr.error(tc, "DYNA0045E", new Object[]{object, string, iterator, string3});
                    Tr.error(tc, "DYNA0043E", new Object[]{string});
                    System.out.println("SAXParseException loading cache entries from " + string + ": " + sAXParseException.getMessage() + " at line " + iterator + " coloumn " + string3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dynacache config error", sAXParseException);
                    }
                    this.cleanStreams(zipFile, inputStream);
                    if (!tc.isEntryEnabled()) return true;
                    Tr.exit(tc, "loadEJBJarConfig");
                    break block26;
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.config.ConfigManager.loadEJBJarConfig", "303", this);
                        Tr.error(tc, "DYNA0046E", new Object[]{iOException.getMessage(), string});
                        Tr.error(tc, "DYNA0043E", new Object[]{string});
                        System.out.println("IOException loading cache entries from " + string + ": " + iOException.getMessage());
                        object = cacheHandler.getEntries();
                        if (object != null) {
                            iterator = ((ArrayList)object).iterator();
                            while (iterator.hasNext()) {
                                ConfigEntry configEntry = (ConfigEntry)iterator.next();
                                System.out.println("configEntry:" + configEntry.toString());
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "dynacache config error", iOException);
                        }
                        this.cleanStreams(zipFile, inputStream);
                        if (!tc.isEntryEnabled()) return true;
                        Tr.exit(tc, "loadEJBJarConfig");
                        break block26;
                        catch (Exception exception) {
                            try {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.loadEJBJarConfig", "308", this);
                                Tr.error(tc, "DYNA0043E", new Object[]{string});
                                System.out.println("Exception loading cache entries from " + string + ": " + exception.getMessage());
                                object = cacheHandler.getEntries();
                                if (object != null) {
                                    iterator = ((ArrayList)object).iterator();
                                    while (iterator.hasNext()) {
                                        ConfigEntry configEntry = (ConfigEntry)iterator.next();
                                        System.out.println("configEntry:" + configEntry.toString());
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "dynacache config error", exception);
                                }
                                this.cleanStreams(zipFile, inputStream);
                            }
                            catch (Throwable throwable) {
                                this.cleanStreams(zipFile, inputStream);
                                if (!tc.isEntryEnabled()) throw throwable;
                                Tr.exit(tc, "loadEJBJarConfig");
                                throw throwable;
                            }
                            if (!tc.isEntryEnabled()) return true;
                            Tr.exit(tc, "loadEJBJarConfig");
                        }
                    }
                }
                if (!tc.isEntryEnabled()) return true;
                Tr.exit(tc, "loadEJBJarConfig");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntries(ConfigFileEntry configFileEntry, CacheHandler cacheHandler, String string) {
        Object object3;
        Object object2;
        configFileEntry.configEntries = cacheHandler.getEntries();
        Iterator<Object> iterator = configFileEntry.configEntries.iterator();
        while (iterator.hasNext()) {
            object2 = (ConfigEntry)iterator.next();
            if (!this.preProcessEntry((ConfigEntry)object2)) {
                iterator.remove();
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cache policy:" + object2);
            }
            try {
                if (!((ConfigEntry)object2).className.equalsIgnoreCase("static") && !((ConfigEntry)object2).name.endsWith("com.ibm.ws.webcontainer.servlet.SimpleFileServlet.class")) continue;
                object3 = null;
                if (configFileEntry.appContext != null && (object3 = (String)configFileEntry.appContext.get("servlet")) != null) {
                    if (((String)object3).endsWith("/") && ((String)object3).length() > 2) {
                        object3 = ((String)object3).substring(0, ((String)object3).length() - 2);
                    }
                    ServletCacheEngine.addStaticContentPolicy((String)object3);
                }
                if (object3 != null) continue;
                int n = ((ConfigEntry)object2).name.indexOf("/", 1);
                if (n == -1) {
                    ServletCacheEngine.addStaticContentPolicy("/");
                    continue;
                }
                object3 = ((ConfigEntry)object2).name.substring(0, n);
                if (!((String)object3).startsWith("/")) {
                    object3 = "/" + (String)object3;
                }
                ServletCacheEngine.addStaticContentPolicy((String)object3);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.checkConfig", "110", this);
            }
        }
        object2 = new ArrayList();
        for (Object object3 : this.configFiles.values()) {
            if (((ConfigFileEntry)object3).configEntries == null) continue;
            ((ArrayList)object2).addAll(((ConfigFileEntry)object3).configEntries);
        }
        for (Object object3 : this.EJBConfigFiles.values()) {
            if (((ConfigFileEntry)object3).configEntries == null) continue;
            ((ArrayList)object2).addAll(((ConfigFileEntry)object3).configEntries);
        }
        ((ArrayList)object2).addAll(this.legacyCacheEntries);
        object3 = null;
        HashMap<String, ConfigEntry> hashMap = null;
        HashMap<String, ConfigEntry> hashMap2 = null;
        for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
            String string2;
            ConfigEntry configEntry;
            ConfigEntry configEntry2 = (ConfigEntry)((ArrayList)object2).get(i);
            if (configEntry2.iClassName == 4) {
                if (object3 == null) {
                    object3 = new HashMap<String, ConfigEntry>(10);
                }
                if (configEntry2 == null) continue;
                iterator = configEntry2.allNames.iterator();
                while (iterator.hasNext()) {
                    configEntry = (ConfigEntry)configEntry2.clone();
                    configEntry.name = string2 = (String)iterator.next();
                    ((HashMap)object3).put(string2, configEntry);
                }
                continue;
            }
            if (configEntry2.iClassName == 1 || configEntry2.iClassName == 3 || configEntry2.iClassName == 5) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, ConfigEntry>();
                }
                if (configEntry2 == null) continue;
                iterator = configEntry2.allNames.iterator();
                while (iterator.hasNext()) {
                    configEntry = (ConfigEntry)configEntry2.clone();
                    configEntry.name = string2 = (String)iterator.next();
                    hashMap.put(string2, configEntry);
                }
                continue;
            }
            if (configEntry2.iClassName != 6) continue;
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, ConfigEntry>();
            }
            if (configEntry2 == null) continue;
            iterator = configEntry2.allNames.iterator();
            while (iterator.hasNext()) {
                configEntry = (ConfigEntry)configEntry2.clone();
                configEntry.name = string2 = (String)iterator.next();
                hashMap2.put(string2, configEntry);
            }
        }
        if (object3 == null) {
            this.jaxRpcClientConfigEntries.clear();
        } else {
            this.jaxRpcClientConfigEntries = object3;
        }
        if (hashMap == null) {
            this.servletConfigEntries.clear();
        } else {
            this.servletConfigEntries = hashMap;
        }
        if (hashMap2 == null) {
            this.portletConfigEntries.clear();
        } else {
            this.portletConfigEntries = hashMap2;
        }
        this.globalCacheEntries = object2;
        HashMap hashMap3 = this.entryCache;
        synchronized (hashMap3) {
            this.entryCache.clear();
        }
        this.fireChangedEvent();
        Tr.info(tc, "DYNA0047I", new Object[]{string});
    }

    private void updateCacheInstances(ConfigFileEntry configFileEntry, CacheHandler cacheHandler, String string) {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCacheInstance");
        }
        configFileEntry.cacheInstances = cacheHandler.getInstances();
        for (Object object2 : configFileEntry.cacheInstances) {
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "cache instance:" + object2);
        }
        object2 = new ArrayList();
        for (ConfigFileEntry configFileEntry2 : this.configFiles.values()) {
            if (configFileEntry2.cacheInstances == null) continue;
            ((ArrayList)object2).addAll(configFileEntry2.cacheInstances);
        }
        for (ConfigFileEntry configFileEntry2 : this.EJBConfigFiles.values()) {
            if (configFileEntry2.cacheInstances == null) continue;
            ((ArrayList)object2).addAll(configFileEntry2.cacheInstances);
        }
        this.globalCacheInstances = object2;
        this.fireChangedEvent();
        Tr.info(tc, "DYNA0062I", new Object[]{string});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCacheInstance");
        }
    }

    public ArrayList getCacheInstances() {
        return this.globalCacheInstances;
    }

    public ArrayList getEntries() {
        return this.globalCacheEntries;
    }

    public ArrayList getCacheEntries(String string) {
        ArrayList<ConfigEntry> arrayList = new ArrayList<ConfigEntry>();
        Iterator iterator = this.globalCacheEntries.iterator();
        if (string == null) {
            while (iterator.hasNext()) {
                ConfigEntry configEntry = (ConfigEntry)iterator.next();
                if (configEntry.instanceName != null) continue;
                arrayList.add(configEntry);
            }
        } else {
            while (iterator.hasNext()) {
                ConfigEntry configEntry = (ConfigEntry)iterator.next();
                if (configEntry.instanceName == null || !configEntry.instanceName.equals(string)) continue;
                arrayList.add(configEntry);
            }
        }
        return arrayList;
    }

    protected boolean preProcessEntry(ConfigEntry configEntry) {
        boolean bl = true;
        if (configEntry.className.equalsIgnoreCase("servlet")) {
            configEntry.iClassName = 1;
        } else if (configEntry.className.equalsIgnoreCase("command")) {
            configEntry.iClassName = 2;
        } else if (configEntry.className.equalsIgnoreCase("webservice")) {
            configEntry.iClassName = 3;
        } else if (configEntry.className.equalsIgnoreCase("JAXRPCClient")) {
            configEntry.iClassName = 4;
        } else if (configEntry.className.equalsIgnoreCase("static")) {
            configEntry.iClassName = 5;
        } else if (configEntry.className.equalsIgnoreCase("portlet")) {
            configEntry.iClassName = 6;
        } else {
            Tr.error(tc, "DYNA0050E", new Object[]{configEntry.className, "class"});
            bl = false;
        }
        if (bl) {
            CacheProcessor cacheProcessor = this.getCacheProcessor(configEntry);
            bl = cacheProcessor.preProcess(configEntry);
            this.returnCacheProcessor(cacheProcessor);
        }
        return bl;
    }

    private SAXParser newSAXParser() {
        SAXParser sAXParser;
        block7: {
            SAXParserFactory sAXParserFactory = null;
            sAXParser = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigManager.newSAXParser()");
            }
            try {
                sAXParserFactory = ParserFactory.newSAXParserFactory();
                sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
                sAXParser = sAXParserFactory.newSAXParser();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                FFDCFilter.processException((Throwable)parserConfigurationException, "com.ibm.ws.cache.config.ConfigManager.newSAXParser", "314", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ConfigManager: ParserConfigurationException in newSAXParser()");
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                FFDCFilter.processException((Throwable)sAXNotRecognizedException, "com.ibm.ws.cache.config.ConfigManager.newSAXParser", "317", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ConfigManager: SAXNotRecognizedException in newSAXParser()");
                }
            }
            catch (SAXException sAXException) {
                FFDCFilter.processException((Throwable)sAXException, "com.ibm.ws.cache.config.ConfigManager.newSAXParser", "320", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "ConfigManager: SAXException in newSAXParser()");
            }
        }
        return sAXParser;
    }

    static class MultiProcessorPool {
        CacheProcessorPool[] pools = new CacheProcessorPool[16];

        MultiProcessorPool() {
            this.addPool(1, "com.ibm.ws.cache.servlet.FragmentCacheProcessor");
            this.addPool(3, "com.ibm.ws.cache.servlet.WebServicesCacheProcessor");
            this.addPool(4, "com.ibm.ws.cache.webservices.client.JAXRPCCacheProcessor");
            this.addPool(2, "com.ibm.ws.cache.command.CommandCacheProcessor");
        }

        public void addPool(int n, String string) {
            try {
                this.pools[n] = new CacheProcessorPool(100, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.MultiProcessorPool", "402", this);
            }
        }
    }

    static class CacheProcessorPool
    extends ObjectPool {
        Class myClass;

        public CacheProcessorPool(int n, String string) {
            super("CommandCacheProcessorPool", n);
            try {
                this.myClass = ConfigManager.class.getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.cache.config.ConfigManager.CacheProcessorPool", "378", this);
            }
        }

        protected Object createObject() {
            try {
                return this.myClass.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.CacheProcessorPool", "382", this);
                return null;
            }
        }

        public boolean add(CacheProcessor cacheProcessor) {
            cacheProcessor.reset(null);
            return super.add(cacheProcessor);
        }
    }

    static class CacheSpecEntityResolver
    implements EntityResolver {
        CacheSpecEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            try {
                String string3 = propertiesDir + ConfigManager.CACHE_SPEC_DTD;
                return new InputSource(new FileReader(string3));
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.config.ConfigManager.resolveEntity", "332", this);
                return null;
            }
        }
    }
}

