/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.drs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheUnit;
import com.ibm.ws.cache.IdObject;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.RealTimeDaemon;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.devmon.Monitor;
import com.ibm.ws.cache.drs.DRSNotificationService;
import com.ibm.ws.cache.drs.DRSPushPullTable;
import com.ibm.ws.cache.drs.ws390.DynacachePlatformHelper;
import com.ibm.ws.cache.intf.CacheStatisticsListener;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.drs.DRSAnnounceRenounceListener;
import com.ibm.wsspi.drs.DRSCacheMsg;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSEventObject;
import com.ibm.wsspi.drs.DRSJvmId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class DRSMessageListener
implements DRSCacheMsgListener,
DRSAnnounceRenounceListener {
    private static TraceComponent tc = Trace.register(DRSMessageListener.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static boolean assertRanOnce = false;
    private static final boolean IS_UNIT_TEST = false;
    private Monitor monitor = null;
    private static CacheUnit cacheUnit = null;
    private String cacheName = null;
    private DCache cache = null;
    private boolean isDRSCongested = false;
    private boolean isDRSReady = false;
    private DRSPushPullTable pushPullTable = null;
    protected CacheStatisticsListener cacheStatisticsListener = null;
    protected BatchUpdateDaemon batchUpdateDaemon;
    private BatchUpdateList batchUpdateList;

    public boolean isDRSReady() {
        return this.isDRSReady;
    }

    public boolean isDRSCongested() {
        return this.isDRSCongested;
    }

    private DRSMessageListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSMessageListener(CacheUnit cacheUnit, DCache dCache) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSMessageListener() - CTOR cacheName=" + (dCache != null ? dCache.getCacheName() : "null"));
        }
        assert (assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this));
        assert (cacheUnit != null);
        assert (dCache != null);
        assert (dCache.getCacheName() != null);
        if (!$assertionsDisabled) {
            if (DRSMessageListener.cacheUnit != null) {
                if (DRSMessageListener.cacheUnit != cacheUnit) {
                    throw new AssertionError();
                }
            }
        }
        CacheUnit cacheUnit2 = DRSMessageListener.cacheUnit != null ? DRSMessageListener.cacheUnit : cacheUnit;
        synchronized (cacheUnit2) {
            this.cache = dCache;
            DRSMessageListener.cacheUnit = cacheUnit;
            this.cacheName = dCache.getCacheName();
        }
        this.pushPullTable = new DRSPushPullTable(this.cacheName, this);
        this.batchUpdateDaemon = new BatchUpdateDaemon(1000);
        this.batchUpdateDaemon.start();
        this.batchUpdateList = new BatchUpdateList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DRSMessageListener() - CTOR " + this);
        }
    }

    public void event(DRSEventObject dRSEventObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "event()");
        }
        int n = dRSEventObject.getEvent();
        switch (n) {
            case 5: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "event() cacheName=" + this.cacheName + " event=SERVER_REMOVED");
                }
                this.pushPullTable.removeDownedEntries((LinkedList)dRSEventObject.getSource());
                break;
            }
            case 3: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "event() cacheName=" + this.cacheName + " event=IS_CONGESTED");
                }
                this.isDRSCongested = true;
                break;
            }
            case 4: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "event() cacheName=" + this.cacheName + " event=NOT_CONGESTED");
                }
                this.isDRSCongested = false;
                this.cache.getCacheConfig().setDRSDisabled(false);
                break;
            }
            case 2: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "event() cacheName=" + this.cacheName + " event=REPLICATION_DOWN");
                }
                this.isDRSReady = false;
                break;
            }
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "event() cacheName=" + this.cacheName + " event=REPLICATION_UP");
                }
                this.isDRSReady = true;
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "event() cacheName=" + this.cacheName + " Unknown DRS Event");
                }
                assert (false) : "Unknown DRS Event";
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "event() " + this);
        }
    }

    public void processDRSCacheMsgEvent(EventObject eventObject) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processDRSCacheMsgEvent() event=" + eventObject);
        }
        assert (false);
    }

    public void createEntry(Object object, Object object2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createEntry() cacheName=" + this.cacheName + " entryKey=" + object);
        }
        assert (false);
    }

    public void createEntryProp(Object object, Object object2, Object object3) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createEntryProp() cacheName=" + this.cacheName + " entryKey=" + object);
        }
        assert (false);
    }

    public void updateEntry(Object object, Object object2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updateEntry cacheName=" + this.cacheName + " entryKey=" + object);
        }
        assert (false);
    }

    public void updateEntryProp(Object object, Object object2, Object object3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateEntryProp() cacheName=" + this.cacheName + " entryKey=" + object + " propKey=" + object2);
        }
        long l = System.currentTimeMillis();
        Short s = (Short)object2;
        short s2 = s;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updateEntryProp() - operation key " + s2);
        }
        switch (s2) {
            case 13: {
                CacheEntry cacheEntry = (CacheEntry)object3;
                cacheEntry.processDrsInbound(l);
                cacheUnit.setEntry(this.cacheName, cacheEntry);
                break;
            }
            case 1: {
                ArrayList arrayList;
                HashMap hashMap;
                HashMap hashMap2 = (HashMap)object3;
                String string = (String)hashMap2.get(DRSNotificationService.cacheIdObj);
                HashMap hashMap3 = (HashMap)hashMap2.get(DRSNotificationService.invaIDsObj);
                if (hashMap3 == null) {
                    hashMap3 = new HashMap(0);
                }
                if ((hashMap = (HashMap)hashMap2.get(DRSNotificationService.invalTemplsObj)) == null) {
                    hashMap = new HashMap(0);
                }
                if ((arrayList = (ArrayList)hashMap2.get(DRSNotificationService.pushesObj)) == null) {
                    arrayList = new ArrayList(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateEntryProp() pushEntryEvents " + arrayList);
                }
                for (Object object4 : arrayList) {
                    assert (object4 instanceof CacheEntry);
                    assert (((CacheEntry)object4).getSharingPolicy() == 2);
                    ((CacheEntry)object4).processDrsInbound(l);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateEntryProp() invalidateIdEvents " + hashMap3);
                }
                if (hashMap3.size() > 0) {
                    Serializable serializable = new HashSet();
                    for (Map.Entry entry : hashMap3.entrySet()) {
                        Object k = entry.getKey();
                        InvalidateByIdEvent invalidateByIdEvent = (InvalidateByIdEvent)entry.getValue();
                        if (invalidateByIdEvent.getId() != null) {
                            invalidateByIdEvent.source = 2;
                            this.cacheStatisticsListener.remoteInvalidationNotifications(invalidateByIdEvent.getId());
                            continue;
                        }
                        ((HashSet)serializable).add(k);
                    }
                    if (((HashSet)serializable).size() > 0) {
                        Object object4;
                        object4 = ((HashSet)serializable).iterator();
                        while (object4.hasNext()) {
                            Object e2 = object4.next();
                            hashMap3.remove(e2);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "updateEntryProp() invalidateIdEventsSize=" + hashMap3.size() + " invalidateIdEventsNullSize=" + ((HashSet)serializable).size());
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateEntryProp() invalidateTemplateEvents " + hashMap);
                }
                for (Serializable serializable : hashMap.values()) {
                    ((InvalidateByTemplateEvent)serializable).source = 2;
                    this.cacheStatisticsListener.remoteInvalidationNotifications(((InvalidateByTemplateEvent)serializable).getTemplate());
                    if (!((InvalidateByTemplateEvent)serializable).isCacheCommand_Clear()) continue;
                    this.clearPushPullTable();
                }
                if (DynacachePlatformHelper.isZOS()) {
                    Tr.debug(tc, "updateEntryProp() Updating batch update list");
                    this.batchUpdateList.updateList(hashMap3, hashMap, arrayList);
                    break;
                }
                cacheUnit.batchUpdate(string, hashMap3, hashMap, arrayList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateEntryProp() " + this);
        }
    }

    public Object getEntry(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEntry() cacheName=" + this.cacheName + " entryKey=" + object);
        }
        Object object2 = ((IdObject)object).getId();
        CacheEntry cacheEntry = null;
        boolean bl = false;
        cacheEntry = cacheUnit.getEntry(this.cacheName, object2, bl);
        if (cacheEntry != null) {
            cacheEntry.finish();
        }
        if (cacheEntry != null && !cacheEntry.prepareForSerialization()) {
            cacheEntry = null;
        }
        if (cacheEntry != null) {
            cacheEntry.processDrsOutbound();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEntry() cacheEntry=" + cacheEntry + "id=" + (cacheEntry != null ? cacheEntry.id : "null") + " " + this);
        }
        return cacheEntry;
    }

    public Object getEntryProp(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEntryProp() cacheName=" + this.cacheName + " entryKey=" + object + " propKey=" + object2);
        }
        assert (false);
        return null;
    }

    public void removeEntry(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEntry() entryKey=" + object);
        }
    }

    public void clearPushPullTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearPushPullTable()before clear - PushPullTableSize=" + this.pushPullTable.size());
        }
        this.pushPullTable.clear();
    }

    public void removeEntryProp(Object object, Object object2, Object object3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEntryProp() cacheName=" + this.cacheName + " entryKey=" + object + " propKey=" + object2);
        }
        assert (false);
    }

    public boolean entryIDExists(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "entryIDExists() cacheName=" + this.cacheName + " entryKey=" + object);
        }
        assert (false);
        return false;
    }

    public boolean propIDExists(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propIDExists() cacheName=" + this.cacheName + " entryKey=" + object + " propKey=" + object2);
        }
        assert (false);
        return false;
    }

    public void asyncAck(DRSCacheMsg dRSCacheMsg, DRSCacheMsg dRSCacheMsg2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "asyncAck() cacheName=" + this.cacheName + " DRSCacheMsg in " + dRSCacheMsg + " out=" + dRSCacheMsg2);
        }
        assert (false);
    }

    public void nowThePrimary(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nowThePrimary() cacheName=" + this.cacheName + " partitionId" + l);
        }
    }

    public void nowThePrimary(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nowThePrimary() cacheName=" + this.cacheName + " Identity" + identity);
        }
    }

    public Object processQueryRequest(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processQueryRequest() cacheName=" + this.cacheName + " key=" + object);
        }
        assert (false);
        return null;
    }

    public void queryResp(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryResp() cacheName=" + this.cacheName + " resp=" + object);
        }
        assert (false);
    }

    public void response(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "response() cacheName=" + this.cacheName + " response=" + object);
        }
        assert (false);
    }

    public Object broadcast(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "broadcast() cacheName=" + this.cacheName + " key=" + object);
        }
        assert (false);
        return null;
    }

    public void announceEntries(ArrayList arrayList, DRSJvmId dRSJvmId) {
        this.pushPullTable.announceEntries(arrayList, dRSJvmId);
    }

    public void renounceEntries(ArrayList arrayList) {
        this.pushPullTable.renounceEntries(arrayList);
    }

    public Object getEntry(Object object, DRSJvmId dRSJvmId) {
        return this.getEntry(object);
    }

    public DRSPushPullTable getPushPullTable() {
        return this.pushPullTable;
    }

    public class BatchUpdateDaemon
    extends RealTimeDaemon {
        public BatchUpdateDaemon(int n) {
            super(n);
        }

        public void start() {
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void wakeUp(long l, long l2) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "BatchUpdateDaemon wakeUp: _invalidateIdEvents[" + ((DRSMessageListener)DRSMessageListener.this).batchUpdateList._invalidateIdEvents.size() + "]" + " _invalidateTemplateEvents[" + ((DRSMessageListener)DRSMessageListener.this).batchUpdateList._invalidateTemplateEvents.size() + "]" + " _pushEntryEvents[" + ((DRSMessageListener)DRSMessageListener.this).batchUpdateList._pushEntryEvents.size() + "]");
            }
            BatchUpdateList batchUpdateList = DRSMessageListener.this.batchUpdateList;
            synchronized (batchUpdateList) {
                cacheUnit.batchUpdate(DRSMessageListener.this.cacheName, ((DRSMessageListener)DRSMessageListener.this).batchUpdateList._invalidateIdEvents, ((DRSMessageListener)DRSMessageListener.this).batchUpdateList._invalidateTemplateEvents, ((DRSMessageListener)DRSMessageListener.this).batchUpdateList._pushEntryEvents);
                ((DRSMessageListener)DRSMessageListener.this).batchUpdateList._invalidateIdEvents.clear();
                ((DRSMessageListener)DRSMessageListener.this).batchUpdateList._invalidateTemplateEvents.clear();
                ((DRSMessageListener)DRSMessageListener.this).batchUpdateList._pushEntryEvents.clear();
            }
        }
    }

    public class BatchUpdateList {
        HashMap _invalidateIdEvents;
        HashMap _invalidateTemplateEvents;
        ArrayList _pushEntryEvents;

        public BatchUpdateList() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "BatchUpdateList CTOR");
            }
            this._invalidateIdEvents = new HashMap();
            this._invalidateTemplateEvents = new HashMap();
            this._pushEntryEvents = new ArrayList();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "BatchUpdateList CTOR");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateList(HashMap hashMap, HashMap hashMap2, ArrayList arrayList) {
            BatchUpdateList batchUpdateList = this;
            synchronized (batchUpdateList) {
                this._invalidateIdEvents.putAll(hashMap);
                this._invalidateTemplateEvents.putAll(hashMap2);
                this._pushEntryEvents.addAll(arrayList);
            }
        }
    }
}

