/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.drs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.command.CacheableCommand;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheUnit;
import com.ibm.ws.cache.IdObject;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.NotificationService;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.devmon.Monitor;
import com.ibm.ws.cache.drs.DRSMessageListener;
import com.ibm.ws.cache.drs.ws390.DynacacheDRSBootstrapMsgImpl;
import com.ibm.ws.cache.intf.CacheStatisticsListener;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.drs.DRSBootstrap;
import com.ibm.wsspi.drs.DRSBootstrapMsg;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSJvmId;
import com.ibm.wsspi.drs.exception.DRSCongestedException;
import com.ibm.wsspi.drs.exception.DRSNotReadyException;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DRSNotificationService
implements NotificationService,
DRSBootstrap {
    private static final long serialVersionUID = -3271165947086877873L;
    private static TraceComponent tc = Trace.register(DRSNotificationService.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static boolean assertRanOnce = false;
    private static final boolean IS_UNIT_TEST = false;
    private static final Integer INTEGER_BOOTSTRAP_PUSH_PULL = new Integer(257461);
    private Monitor monitor = null;
    private static Object bootstrapLock = new Object();
    private CacheUnit cacheUnit = null;
    protected CacheStatisticsListener cacheStatisticsListener = null;
    private String uniqueCacheName = null;
    private String cacheName = null;
    private DRSDataXfer ddx = null;
    private DRSMessageListener drsMessageListener = null;
    private boolean startCompleted = false;
    public static final short drsBatchUpdate = 1;
    public static final Short drsBatchUpdateObj = new Short(1);
    public static final short drsAddExternal = 2;
    public static final Short drsAddExternalObj = new Short(2);
    public static final short drsRemoveExternal = 3;
    public static final Short drsRemoveExternalObj = new Short(3);
    public static final short drsRegisterCU = 4;
    public static final Short drsRegisterCUObj = new Short(4);
    public static final short invaIDs = 5;
    public static final Short invaIDsObj = new Short(5);
    public static final short invalTempls = 6;
    public static final Short invalTemplsObj = new Short(6);
    public static final short pushes = 7;
    public static final Short pushesObj = new Short(7);
    public static final short cacheIdInt = 15;
    public static final Short cacheIdObj = new Short(15);
    public static final short getDynaEntry = 8;
    public static final Short getDynaEntryObj = new Short(8);
    public static final short getDynaCmd = 9;
    public static final Short getDynaCmdObj = new Short(9);
    public static final short groupId = 10;
    public static final Short groupIdObj = new Short(10);
    public static final short address = 11;
    public static final Short addressObj = new Short(11);
    public static final short beanName = 12;
    public static final Short beanNameObj = new Short(12);
    public static final short drsSetEntry = 13;
    public static final Short drsSetEntryObj = new Short(13);
    public static final short drsCacheAlias = 16;
    public static final Short drsCacheAliasObj = new Short(16);

    public DRSNotificationService() {
        assert (assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this));
    }

    public void setCacheName(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setCacheName() cacheName=" + string);
        }
        this.cacheName = string;
    }

    public void setCacheStatisticsListener(CacheStatisticsListener cacheStatisticsListener) {
        this.cacheStatisticsListener = cacheStatisticsListener;
        if (null != this.drsMessageListener) {
            this.drsMessageListener.cacheStatisticsListener = cacheStatisticsListener;
        }
    }

    public void setDRSMessageListener(DRSMessageListener dRSMessageListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDRSMessageListener() setDRSMessageListener=" + dRSMessageListener);
        }
        this.drsMessageListener = dRSMessageListener;
        this.drsMessageListener.cacheStatisticsListener = this.cacheStatisticsListener;
    }

    public boolean isDRSReady() {
        return this.drsMessageListener.isDRSReady();
    }

    public boolean isDRSCongested() {
        return this.drsMessageListener.isDRSCongested();
    }

    public void registerCacheUnit(String string, CacheUnit cacheUnit) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerCacheUnit() uniqueCacheName=" + string);
        }
        if (!this.startCompleted) {
            throw new IllegalStateException("DRS NS is not ready");
        }
        this.cacheUnit = cacheUnit;
        this.uniqueCacheName = string;
    }

    public void start() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "start() cacheName=" + this.cacheName);
        }
        assert (this.cacheName != null) : "cacheName is null";
        this.startCompleted = true;
    }

    private void pubMsg(Object object, Object object2, Object object3) {
        block9: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pubMsg() partKey=" + object + "key=" + object2);
            }
            try {
                this.updateEntryProp(object, object2, object3);
            }
            catch (DRSCongestedException dRSCongestedException) {
                try {
                    Thread.sleep(250L);
                    this.updateEntryProp(object, object2, object3);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "256", this);
                    interruptedException.printStackTrace();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pubMsg() FFDC exception logged");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "264", this);
                    exception.printStackTrace();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pubMsg() FFDC exception logged");
                    }
                }
            }
            catch (DRSNotReadyException dRSNotReadyException) {
                FFDCFilter.processException((Throwable)dRSNotReadyException, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "271", this);
                dRSNotReadyException.printStackTrace();
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "pubMsg() FFDC exception logged");
            }
        }
    }

    public void batchUpdate(HashMap hashMap, HashMap hashMap2, ArrayList arrayList, ArrayList arrayList2, CacheUnit cacheUnit) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "batchUpdate() cacheName=" + this.cacheName + " invalidateIdEvents.size()=" + hashMap.size() + " invalidateTemplateEvents.size()=" + hashMap2.size() + " pushEntryEvents.size()=" + arrayList.size() + " aliasEntryEvents.size()=" + arrayList2.size());
        }
        if (!this.startCompleted) {
            throw new IllegalStateException("DRS NS is not ready");
        }
        ArrayList<Externalizable> arrayList3 = new ArrayList<Externalizable>();
        ArrayList arrayList4 = null;
        HashSet hashSet = new HashSet();
        DCache dCache = ServerCache.getCache(this.cacheName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "batchUpdate() hasPushPullEntries=" + dCache.hasPushPullEntries());
        }
        if (hashMap.size() > 0) {
            HashMap hashMap3 = new HashMap();
            for (Iterator iterator : hashMap.values()) {
                if (!this.shouldFilterTimeOutInvalidation(dCache, ((InvalidateByIdEvent)((Object)iterator)).causeOfInvalidation) && !this.shouldFilterLRUInvalidation(dCache, ((InvalidateByIdEvent)((Object)iterator)).causeOfInvalidation)) {
                    if (!((InvalidateByIdEvent)((Object)iterator)).prepareForSerialization()) continue;
                    if (((InvalidateByIdEvent)((Object)iterator)).getId() instanceof String) {
                        hashMap3.put(((InvalidateByIdEvent)((Object)iterator)).getId(), iterator);
                        continue;
                    }
                    hashMap3.put(((InvalidateByIdEvent)((Object)iterator)).getSerializedId(), iterator);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "batchUpdate() invalidation event filtered id=" + ((InvalidateByIdEvent)((Object)iterator)).getId() + " cause=" + ((InvalidateByIdEvent)((Object)iterator)).causeOfInvalidation);
            }
            hashMap = hashMap3;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Iterator iterator;
            iterator = (CacheEntry)arrayList.get(i);
            Externalizable externalizable = new IdObject(((CacheEntry)((Object)iterator)).getIdObject());
            externalizable.setClassLoaderType(dCache.getCacheConfig().isUseServerClassLoader());
            int n2 = ((CacheEntry)((Object)iterator)).getSharingPolicy();
            assert (n2 != 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "batchUpdate() CE=" + iterator + "shareType=" + n2);
            }
            if (n2 != 4 && n2 != 3) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "batchUpdate() - announce CacheEntry " + externalizable);
            }
            arrayList3.add(externalizable);
            Enumeration enumeration = ((CacheEntry)((Object)iterator)).getAliasList();
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "batchUpdate() - announce AliasEntry " + e2);
                }
                IdObject idObject = new IdObject(e2);
                idObject.setClassLoaderType(dCache.getCacheConfig().isUseServerClassLoader());
                arrayList3.add(idObject);
            }
            hashSet.add(iterator);
        }
        if (hashSet.size() > 0) {
            arrayList.removeAll(hashSet);
        }
        String string = this.uniqueCacheName;
        for (Externalizable externalizable : arrayList) {
            if (!(externalizable instanceof CacheEntry)) continue;
            ((CacheEntry)externalizable).processDrsOutbound();
        }
        for (Externalizable externalizable : arrayList2) {
            ((CacheEntry)externalizable).processDrsOutbound();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "batchUpdate() pushPullEntries_Announce=" + arrayList3);
        }
        if (arrayList3.size() > 0) {
            this.announceEntries(arrayList3);
        }
        arrayList4 = dCache.hasPushPullEntries() ? this.buildRenounceList(hashMap, hashMap2) : new ArrayList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "batchUpdate() pushPullEntries_Renounce=" + arrayList4);
        }
        if (arrayList4.size() > 0) {
            this.renounceEntries(arrayList4);
        }
        if (hashMap.size() > 0) {
            this.publishInvalidateEventsToDRS(dCache, string, invaIDsObj, hashMap);
        }
        if (hashMap2.size() > 0) {
            this.publishInvalidateEventsToDRS(dCache, string, invalTemplsObj, hashMap2);
        }
        if (arrayList.size() > 0) {
            this.publishPushEventsToDRS(dCache, string, pushesObj, arrayList);
        }
        if (arrayList2.size() > 0) {
            this.publishPushEventsToDRS(dCache, string, drsCacheAliasObj, arrayList2);
        }
    }

    private void publishPushEventsToDRS(DCache dCache, Object object, Short s, List list) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "publishPushEventsToDRS", new Object[]{dCache.getCacheName(), this.getDRSEventToString(s), String.valueOf(list.size())});
        }
        HashMap<Short, Object> hashMap = new HashMap<Short, Object>(4);
        Iterator iterator = list.iterator();
        int n = this.getWindowSize(dCache, dCache.getCacheConfig().getEntryWindow(), dCache.getCacheConfig().getPercentageWindow());
        ArrayList arrayList = new ArrayList(n);
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 != null) {
                arrayList.add(e2);
            }
            if (arrayList.size() < n && iterator.hasNext()) continue;
            hashMap.put(cacheIdObj, this.cacheName);
            hashMap.put(invaIDsObj, new HashMap(0));
            hashMap.put(invalTemplsObj, new HashMap(0));
            hashMap.put(s, arrayList);
            if (s.equals(pushesObj)) {
                hashMap.put(drsCacheAliasObj, new ArrayList(0));
            } else {
                hashMap.put(pushesObj, new ArrayList(0));
            }
            this.pubMsg(object, drsBatchUpdateObj, hashMap);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " SENT: " + arrayList.size());
            }
            arrayList.clear();
            hashMap.clear();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "publishBatchedEventsToDRS");
        }
    }

    private void publishInvalidateEventsToDRS(DCache dCache, Object object, Short s, Map map) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "publishInvalidateEventsToDRS", new Object[]{dCache.getCacheName(), this.getDRSEventToString(s), String.valueOf(map.size())});
        }
        HashMap<Short, Object> hashMap = new HashMap<Short, Object>(4);
        Iterator iterator = map.keySet().iterator();
        int n = this.getWindowSize(dCache, dCache.getCacheConfig().getInvalidateEntryWindow(), dCache.getCacheConfig().getInvalidatePercentageWindow());
        HashMap hashMap2 = new HashMap(n);
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k != null) {
                hashMap2.put(k, map.get(k));
            }
            if (hashMap2.size() < n && iterator.hasNext()) continue;
            hashMap.put(cacheIdObj, this.cacheName);
            hashMap.put(s, hashMap2);
            if (s.equals(invaIDsObj)) {
                hashMap.put(invalTemplsObj, new HashMap(0));
            } else {
                hashMap.put(invaIDsObj, new HashMap(0));
            }
            hashMap.put(pushesObj, new ArrayList(0));
            hashMap.put(drsCacheAliasObj, new ArrayList(0));
            this.pubMsg(object, drsBatchUpdateObj, hashMap);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " SENT: " + hashMap2.size());
            }
            hashMap2.clear();
            hashMap.clear();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "publishInvalidateEventsToDRS");
        }
    }

    private int getWindowSize(DCache dCache, int n, int n2) {
        int n3;
        if (n <= 0) {
            n = 50;
        }
        if (n2 <= 0) {
            n = 2;
        }
        if ((n3 = dCache.getNumberCacheEntriesUnsynchronized() * n2 / 100) <= 1) {
            n3 = n2;
        }
        if (n3 > n) {
            n3 = n;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " windowSize: " + n3);
        }
        return n3;
    }

    private String getDRSEventToString(Short s) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (s) {
            case 5: {
                stringBuffer.append("DRSNotificationService.invaIDs");
                break;
            }
            case 6: {
                stringBuffer.append("DRSNotificationService.invalTempls");
                break;
            }
            case 7: {
                stringBuffer.append("DRSNotificationService.pushes");
                break;
            }
            case 16: {
                stringBuffer.append("DRSNotificationService.drsCacheAlias");
                break;
            }
            default: {
                stringBuffer.append(s.shortValue());
            }
        }
        return stringBuffer.toString();
    }

    private ArrayList buildRenounceList(HashMap hashMap, HashMap hashMap2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DCache dCache = ServerCache.getCache(this.cacheName);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Externalizable externalizable : hashMap.values()) {
            if (!((InvalidateByIdEvent)externalizable).isInvokeDRSRenounce()) continue;
            object4 = ((InvalidateByIdEvent)externalizable).getId();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "buildRenounceList() will renounce CacheEntry " + object4);
            }
            object3 = new IdObject(object4);
            ((IdObject)object3).setClassLoaderType(dCache.getCacheConfig().isUseServerClassLoader());
            arrayList.add(object3);
            object2 = dCache.getCacheIdsByDependency(object4);
            if (null == object2) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                object4 = object.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "buildRenounceList() will renounce depId " + object4);
                }
                IdObject idObject = new IdObject(object4);
                idObject.setClassLoaderType(dCache.getCacheConfig().isUseServerClassLoader());
                arrayList.add(idObject);
            }
        }
        for (Externalizable externalizable : hashMap2.values()) {
            object4 = ((InvalidateByTemplateEvent)externalizable).getTemplate();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "buildRenounceList() will renounce CacheEntries for template " + (String)object4 + " - isCacheCommand_Clear=" + ((InvalidateByTemplateEvent)externalizable).isCacheCommand_Clear());
            }
            if (((InvalidateByTemplateEvent)externalizable).isCacheCommand_Clear()) {
                this.drsMessageListener.clearPushPullTable();
                continue;
            }
            object3 = dCache.getCacheIdsByTemplate((String)object4);
            if (null == object3) continue;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object4 = (String)object2.next();
                object = new IdObject(object4);
                ((IdObject)object).setClassLoaderType(dCache.getCacheConfig().isUseServerClassLoader());
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public void createEntry(Object object, Object object2) throws DRSCongestedException, DRSNotReadyException {
        this.ddx.createEntry(object, object2);
    }

    public void createEntryProp(Object object, Object object2, Object object3) throws DRSCongestedException, DRSNotReadyException {
        this.ddx.createEntryProp(object, object2, object3);
    }

    public void updateEntry(Object object, Object object2) throws DRSCongestedException, DRSNotReadyException {
        this.ddx.updateEntry(object, object2);
    }

    public void updateEntryProp(Object object, Object object2, Object object3) throws DRSCongestedException, DRSNotReadyException {
        if (object3 instanceof CacheEntry) {
            ((CacheEntry)object3).processDrsOutbound();
        }
        if (object instanceof CacheableCommand) {
            object = ((CacheableCommand)object).getId();
        }
        this.ddx.updateEntryProp(object, object2, object3);
    }

    public Object getEntryProp(Object object, Object object2) throws DRSCongestedException, DRSNotReadyException {
        assert (false);
        return this.ddx.getEntryProp(object2, object);
    }

    public Object getEntry(Object object) throws DRSCongestedException, DRSNotReadyException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEntry()cacheName=" + this.cacheName + " - id=" + object + " id instanceof IdObject=" + (object instanceof IdObject));
        }
        Object object2 = null;
        DCache dCache = ServerCache.getCache(this.cacheName);
        IdObject idObject = new IdObject(object);
        idObject.setClassLoaderType(dCache.getCacheConfig().isUseServerClassLoader());
        DRSJvmId dRSJvmId = this.drsMessageListener.getPushPullTable().getJvmId(idObject);
        if (null != dRSJvmId) {
            object2 = this.ddx.getEntry(idObject, dRSJvmId);
            this.drsMessageListener.getPushPullTable().renounceEntry(idObject);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEntry() Warning: Object not found in pushPullTable.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEntry()cacheName=" + this.cacheName + " - o=" + object2 + " o instanceof CacheEntry=" + (object2 instanceof CacheEntry));
        }
        return object2;
    }

    public void removeEntry(Object object) throws DRSCongestedException, DRSNotReadyException {
        this.ddx.removeEntry(object);
    }

    public void removeEntryProp(Object object, Object object2, Object object3) throws DRSCongestedException, DRSNotReadyException {
        this.ddx.removeEntryProp(object2, object, object3);
    }

    public boolean entryIDExists(Object object) throws DRSCongestedException, DRSNotReadyException {
        return this.ddx.entryIDExists(object);
    }

    public long getInstanceId() {
        return this.ddx.getInstanceId();
    }

    public void setDDX(DRSDataXfer dRSDataXfer) {
        this.ddx = dRSDataXfer;
    }

    public long getPartition(Object object) {
        return this.ddx.getPartition(object);
    }

    public Identity getWLMIdentity(Object object) {
        return this.ddx.getWLMIdentity(object);
    }

    public boolean shouldPull(Object object) {
        IdObject idObject = new IdObject(object);
        idObject.setClassLoaderType(ServerCache.getCache(this.cacheName).getCacheConfig().isUseServerClassLoader());
        boolean bl = this.drsMessageListener.getPushPullTable().shouldPull(idObject);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "shouldPull() - id=" + object + " = " + bl);
        }
        return bl;
    }

    public void announceEntries(ArrayList arrayList) {
        block6: {
            try {
                this.ddx.announceEntries(arrayList);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "announceEntries() - complete. list=" + arrayList);
                    for (int i = 0; i != arrayList.size(); ++i) {
                        if (arrayList.get(i) instanceof IdObject) continue;
                        Tr.debug(tc, "announceEntries() WARNING - Key is not an instance of IdObject!!! key=" + arrayList.get(i));
                    }
                }
            }
            catch (DRSCongestedException dRSCongestedException) {
                FFDCFilter.processException((Throwable)dRSCongestedException, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "648", this);
                dRSCongestedException.printStackTrace();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "announceEntries() FFDC exception logged");
                }
            }
            catch (DRSNotReadyException dRSNotReadyException) {
                FFDCFilter.processException((Throwable)dRSNotReadyException, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "655", this);
                dRSNotReadyException.printStackTrace();
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "announceEntries() FFDC exception logged");
            }
        }
    }

    public void renounceEntries(ArrayList arrayList) {
        block6: {
            try {
                this.ddx.renounceEntries(arrayList);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "renounceEntries() - complete. list=" + arrayList);
                    for (int i = 0; i != arrayList.size(); ++i) {
                        if (arrayList.get(i) instanceof IdObject) continue;
                        Tr.debug(tc, "renounceEntries() WARNING - Key is not an instance of IdObject!!! key=" + arrayList.get(i));
                    }
                }
                this.drsMessageListener.getPushPullTable().renounceEntries(arrayList);
            }
            catch (DRSCongestedException dRSCongestedException) {
                FFDCFilter.processException((Throwable)dRSCongestedException, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "682", this);
                dRSCongestedException.printStackTrace();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "renounceEntries() FFDC exception logged");
                }
            }
            catch (DRSNotReadyException dRSNotReadyException) {
                FFDCFilter.processException((Throwable)dRSNotReadyException, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "689", this);
                dRSNotReadyException.printStackTrace();
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "renounceEntries() FFDC exception logged");
            }
        }
    }

    public int getPushPullTableSize() {
        return this.drsMessageListener.getPushPullTable().size();
    }

    public void bootstrapRequest(DRSBootstrapMsg dRSBootstrapMsg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleBootstrapRequest(DRSBootstrapMsg dRSBootstrapMsg) {
        Object object;
        HashMap hashMap;
        int n;
        DCache dCache;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleBootstrapRequest() cacheName=" + this.cacheName);
        }
        if (!(dCache = ServerCache.getCache(this.cacheName)).getCacheConfig().isDRSBootstrapEnabled()) {
            if (!tc.isDebugEnabled()) return;
            Tr.debug(tc, "handleBootstrapRequest() Boostrapping is disabled for cache instance " + this.cacheName);
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleBootstrapRequest() cache size = " + dCache.getNumberCacheEntriesUnsynchronized());
            Tr.debug(tc, "handleBootstrapRequest() isSolicit = " + dRSBootstrapMsg.isSolicit());
        }
        HashMap<Integer, Cloneable> hashMap2 = new HashMap<Integer, Cloneable>(3);
        if (dRSBootstrapMsg.isSolicit()) {
            dRSBootstrapMsg.setComponentData(hashMap2);
            return;
        }
        Enumeration enumeration = dCache.getAllIds();
        Vector<Object> vector = new Vector<Object>();
        Vector<IdObject> vector2 = new Vector<IdObject>();
        int n2 = dCache.getNumberCacheEntries();
        if (n2 == 0) {
            n = 0;
        } else {
            n = n2 * dCache.getCacheConfig().getPercentageWindow() / 100;
            if (n <= 1) {
                n = 1;
            }
            if (n > dCache.getCacheConfig().getEntryWindow()) {
                n = dCache.getCacheConfig().getEntryWindow();
            }
        }
        while (enumeration.hasMoreElements()) {
            int n3;
            hashMap = (HashMap)enumeration.nextElement();
            object = this.cacheUnit.getEntry(this.cacheName, hashMap, false);
            if (object != null) {
                n3 = ((CacheEntry)object).getSharingPolicy();
                if (n3 == 4 || n3 == 3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "handleBootstrapRequest() adding push-pull entry " + hashMap + " to pushpull ce vector ");
                    }
                    IdObject idObject = new IdObject(hashMap);
                    idObject.setClassLoaderType(dCache.getCacheConfig().isUseServerClassLoader());
                    vector2.addElement(idObject);
                    ((CacheEntry)object).finish();
                }
                if (n3 == 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "handleBootstrapRequest() adding push entry " + hashMap + " to push ce vector ");
                    }
                    vector.addElement(object);
                }
            }
            if (enumeration.hasMoreElements() && vector2.size() + vector.size() < n) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handleBootstrapRequest() number of push entries = " + vector.size());
                Tr.debug(tc, "handleBootstrapRequest() number of push pull entries = " + vector2.size());
                Tr.debug(tc, "handleBootstrapRequest() window size = " + n);
            }
            if (vector.size() <= 0 && vector2.size() <= 0) continue;
            if (vector.size() > 0) {
                hashMap2.put(new Integer(2), vector);
            }
            if (vector2.size() > 0) {
                hashMap2.put(new Integer(4), vector2);
            }
            dRSBootstrapMsg.setComponentData(hashMap2);
            try {
                Object object2 = bootstrapLock;
                synchronized (object2) {
                    this.ddx.generateBootstrapResponse(dRSBootstrapMsg);
                    vector2.clear();
                    hashMap2.clear();
                }
            }
            catch (DRSNotReadyException dRSNotReadyException) {
                FFDCFilter.processException((Throwable)dRSNotReadyException, "com.ibm.ws.cache.drs.DRSNotificationService.handleBootstrapRequest", "809", this);
                dRSNotReadyException.printStackTrace();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "handleBootstrapRequest() FFDC exception logged");
                continue;
                catch (DRSCongestedException dRSCongestedException) {
                    try {
                        long l = 30000L;
                        for (long l2 = 5000L; this.isDRSCongested() && l2 < l; l2 = 2L * l2) {
                            Thread.sleep(l2);
                        }
                        Object object3 = bootstrapLock;
                        synchronized (object3) {
                            this.ddx.generateBootstrapResponse(dRSBootstrapMsg);
                            vector2.clear();
                            hashMap2.clear();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.cache.drs.DRSNotificationService.handleBootstrapRequest", "827", this);
                        interruptedException.printStackTrace();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "handleBootstrapRequest() FFDC exception logged");
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.drs.DRSNotificationService.handleBootstrapRequest", "834", this);
                        exception.printStackTrace();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "handleBootstrapRequest() FFDC exception logged");
                        }
                        for (int i = 0; i < vector.size(); ++i) {
                            object = (CacheEntry)vector.elementAt(i);
                            ((CacheEntry)object).finish();
                        }
                        vector.clear();
                        break;
                    }
                    for (n3 = 0; n3 < vector.size(); ++n3) {
                        object = (CacheEntry)vector.elementAt(n3);
                        ((CacheEntry)object).finish();
                    }
                    vector.clear();
                    continue;
                }
                finally {
                    for (n3 = 0; n3 < vector.size(); ++n3) {
                        object = (CacheEntry)vector.elementAt(n3);
                        ((CacheEntry)object).finish();
                    }
                    vector.clear();
                    continue;
                }
            }
            for (n3 = 0; n3 < vector.size(); ++n3) {
                object = (CacheEntry)vector.elementAt(n3);
                ((CacheEntry)object).finish();
            }
            vector.clear();
        }
        hashMap = null;
        if (dRSBootstrapMsg instanceof DynacacheDRSBootstrapMsgImpl) {
            hashMap = this.drsMessageListener.getPushPullTable().getTableClone();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handleBootstrapRequest() Got " + hashMap.size() + " elements from pushPullTable.");
            }
            if (hashMap.size() == 0) {
                hashMap = null;
            }
        }
        if (hashMap == null) return;
        hashMap2.put(INTEGER_BOOTSTRAP_PUSH_PULL, hashMap);
        dRSBootstrapMsg.setComponentData(hashMap2);
        try {
            object = bootstrapLock;
            synchronized (object) {
                this.ddx.generateBootstrapResponse(dRSBootstrapMsg);
                hashMap2.clear();
                return;
            }
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            FFDCFilter.processException((Throwable)dRSNotReadyException, "com.ibm.ws.cache.drs.DRSNotificationService.handleBootstrapRequest", "875", this);
            dRSNotReadyException.printStackTrace();
            if (!tc.isDebugEnabled()) return;
            Tr.debug(tc, "handleBootstrapRequest() FFDC exception logged");
            return;
        }
        catch (DRSCongestedException dRSCongestedException) {
            try {
                Thread.sleep(1000L);
                Object object4 = bootstrapLock;
                synchronized (object4) {
                    this.ddx.generateBootstrapResponse(dRSBootstrapMsg);
                    hashMap2.clear();
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.cache.drs.DRSNotificationService.handleBootstrapRequest", "889", this);
                interruptedException.printStackTrace();
                if (!tc.isDebugEnabled()) return;
                Tr.debug(tc, "handleBootstrapRequest() FFDC exception logged");
                return;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.drs.DRSNotificationService.handleBootstrapRequest", "895", this);
                exception.printStackTrace();
                if (!tc.isDebugEnabled()) return;
                Tr.debug(tc, "handleBootstrapRequest() FFDC exception logged");
            }
        }
    }

    public void bootstrapResponse(DRSBootstrapMsg dRSBootstrapMsg) {
        HashMap hashMap;
        ArrayList arrayList;
        int n;
        HashMap hashMap2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bootstrapResponse() cacheName=" + this.cacheName);
        }
        if (null == (hashMap2 = (HashMap)dRSBootstrapMsg.getComponentData())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bootstrapResponse() cacheName=" + this.cacheName + " Exit. componentData is null.");
            }
            return;
        }
        Vector vector = (Vector)hashMap2.get(new Integer(2));
        int n2 = 0;
        if (vector != null) {
            n2 = vector.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bootstrapResponse() number of push entries = " + n2);
            }
            for (n = 0; n < n2; ++n) {
                arrayList = vector.elementAt(n);
                if (arrayList instanceof CacheEntry) {
                    CacheEntry cacheEntry = (CacheEntry)((Object)arrayList);
                    this.cacheUnit.setEntry(this.cacheName, cacheEntry);
                    assert (cacheEntry.getSharingPolicy() == 2);
                    continue;
                }
                assert (false) : "Can only bootstrap CEs";
            }
        }
        n = n2;
        arrayList = new ArrayList();
        vector = (Vector)hashMap2.get(new Integer(4));
        n2 = 0;
        if (vector != null) {
            n2 = vector.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bootstrapResponse() number of pushpull entries = " + n2);
            }
            for (int i = 0; i < n2; ++i) {
                Object e2 = vector.elementAt(i);
                if (e2 instanceof IdObject) {
                    IdObject idObject = (IdObject)e2;
                    arrayList.add(idObject);
                    continue;
                }
                assert (false) : "Can only bootstrap IdObjects";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bootstrapResponse() For SHARED_PUSH_PULL, v.size=" + vector.size() + " pushPullKeys.size=" + arrayList.size());
            }
        }
        if (0 < arrayList.size()) {
            DRSJvmId dRSJvmId = dRSBootstrapMsg.getJvmId();
            if (null != dRSJvmId) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "bootstrapResponse() JvmId = " + dRSJvmId);
                }
                this.drsMessageListener.getPushPullTable().announceEntries(arrayList, dRSJvmId);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bootstrapResponse() Ignoring announce entries because no jvmID was specified.");
            }
        }
        if ((hashMap = (HashMap)hashMap2.get(INTEGER_BOOTSTRAP_PUSH_PULL)) != null) {
            this.drsMessageListener.getPushPullTable().addEntries(hashMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bootstrapResponse() cacheName=" + this.cacheName + " inbound bootstrap of " + n + " push entrie(s), " + n2 + " pushPull entrie(s), and " + (null == hashMap ? "0" : "" + hashMap.size()) + " pushPullTableClone entrie(s).");
        }
    }

    public void queryReq(Object object) {
        assert (false);
    }

    public boolean shouldFilterTimeOutInvalidation(DCache dCache, int n) {
        boolean bl = false;
        if (n == 3 && dCache.getCacheConfig().isFilterTimeOutInvalidation()) {
            bl = true;
        }
        return bl;
    }

    public boolean shouldFilterLRUInvalidation(DCache dCache, int n) {
        boolean bl = false;
        if (n == 2 && dCache.getCacheConfig().isFilterLRUInvalidation()) {
            bl = true;
        }
        return bl;
    }
}

