/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.drs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.IdObject;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.drs.DRSMessageListener;
import com.ibm.wsspi.drs.DRSJvmId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class DRSPushPullTable {
    private static TraceComponent tc = Trace.register(DRSPushPullTable.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private HashMap pushPullTable = new HashMap();
    private Integer pushPullLock = new Integer(823);
    private String cacheName = null;
    private DRSMessageListener drsMessageListener = null;

    public DRSPushPullTable(String string, DRSMessageListener dRSMessageListener) {
        this.cacheName = string == null ? "Unknown" : string;
        this.drsMessageListener = dRSMessageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announceEntries(ArrayList arrayList, DRSJvmId dRSJvmId) {
        String string = "DRSPushPullTable.announceEntries/" + this.cacheName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        if (arrayList == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit - entryKeyList = null.");
            }
            return;
        }
        if (dRSJvmId == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit - jvmId = null.");
            }
            return;
        }
        if (arrayList.size() < 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit - entryKeyList is empty.");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Current table size = " + this.pushPullTable.size());
            Tr.debug(tc, string + "EntryKeyList contains " + arrayList.size() + " entries");
            Tr.debug(tc, string + "JvmId = " + dRSJvmId.toString());
        }
        Integer n = this.pushPullLock;
        synchronized (n) {
            for (int i = 0; i < arrayList.size(); ++i) {
                IdObject idObject = (IdObject)arrayList.get(i);
                if (tc.isDebugEnabled()) {
                    try {
                        String string2 = "" + idObject;
                        Tr.debug(tc, string + "Adding entry(" + i + ")=" + string2 + " to pushPullTable");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.pushPullTable.put(idObject, dRSJvmId);
                this.drsMessageListener.cacheStatisticsListener.remoteUpdateNotifications(idObject.id);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "New table size = " + this.pushPullTable.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renounceEntries(ArrayList arrayList) {
        String string = "DRSPushPullTable.renounceEntries/" + this.cacheName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        if (arrayList == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit - entryKeyList = null.");
            }
            return;
        }
        if (arrayList.size() < 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit - entryKeyList is empty.");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Current table size = " + this.pushPullTable.size());
        }
        Integer n = this.pushPullLock;
        synchronized (n) {
            for (int i = 0; i < arrayList.size(); ++i) {
                IdObject idObject = (IdObject)arrayList.get(i);
                this.pushPullTable.remove(idObject);
                if (!tc.isDebugEnabled()) continue;
                try {
                    String string2 = "" + idObject;
                    Tr.debug(tc, string + " Removed idObject=" + string2);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "New table size = " + this.pushPullTable.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renounceEntry(IdObject idObject) {
        String string = "DRSPushPullTable.renounceEntry/" + this.cacheName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. idObject=" + idObject);
        }
        int n = 0;
        Integer n2 = this.pushPullLock;
        synchronized (n2) {
            this.pushPullTable.remove(idObject);
            n = this.pushPullTable.size();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. size=" + this.pushPullTable.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        String string = "DRSPushPullTable.clear/" + this.cacheName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        Integer n = this.pushPullLock;
        synchronized (n) {
            this.pushPullTable.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Integer n = this.pushPullLock;
        synchronized (n) {
            return this.pushPullTable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSJvmId getJvmId(IdObject idObject) {
        Object object;
        String string = "DRSPushPullTable.getJvmId/" + this.cacheName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        DRSJvmId dRSJvmId = null;
        if (idObject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit - idObject = null.");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Current table size = " + this.pushPullTable.size());
            try {
                object = "" + idObject;
                Tr.debug(tc, string + "idObject = " + (String)object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        object = this.pushPullLock;
        synchronized (object) {
            dRSJvmId = (DRSJvmId)this.pushPullTable.get(idObject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit rc = " + (dRSJvmId == null ? "null" : dRSJvmId.toString()));
        }
        return dRSJvmId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldPull(IdObject idObject) {
        Object object;
        String string = "DRSPushPullTable.shouldPull/" + this.cacheName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        boolean bl = false;
        if (idObject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + "Exit - idObject = null.");
            }
            return bl;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Current table size = " + this.pushPullTable.size());
            try {
                object = "" + idObject;
                Tr.debug(tc, string + "idObject = " + (String)object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        object = this.pushPullLock;
        synchronized (object) {
            bl = this.pushPullTable.containsKey(idObject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - rc = " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumEntries() {
        String string = "DRSPushPullTable.getNumEntries/" + this.cacheName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        int n = -1;
        Integer n2 = this.pushPullLock;
        synchronized (n2) {
            n = this.pushPullTable.size();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - rc = " + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getTableClone() {
        String string = "DRSPushPullTable.getTableClone/" + this.cacheName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        HashMap hashMap = null;
        Integer n = this.pushPullLock;
        synchronized (n) {
            hashMap = (HashMap)this.pushPullTable.clone();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit.");
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntries(HashMap hashMap) {
        int n;
        int n2;
        String string = "DRSPushPullTable.addEntries/" + this.cacheName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        Integer n3 = this.pushPullLock;
        synchronized (n3) {
            n2 = this.pushPullTable.size();
            this.pushPullTable.putAll(hashMap);
            n = this.pushPullTable.size();
        }
        this.drsMessageListener.cacheStatisticsListener.remoteUpdateNotifications(n - n2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. numBefore=" + n2 + " numAfter=" + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Integer n = this.pushPullLock;
        synchronized (n) {
            stringBuffer.append("DRSPushPullTable.cacheName=").append(this.cacheName);
            stringBuffer.append("DRSPushPullTable.size=").append(this.pushPullTable.size());
            for (IdObject idObject : this.pushPullTable.keySet()) {
                DRSJvmId dRSJvmId = (DRSJvmId)this.pushPullTable.get(idObject);
                stringBuffer.append("\nidObject=").append(idObject).append("\njvmId=").append(dRSJvmId);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownedEntries(LinkedList linkedList) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "removeDownedEntries", linkedList);
        }
        int n = 0;
        if (this.pushPullTable != null && this.pushPullTable.size() != 0 && 0 < linkedList.size()) {
            Integer n2 = this.pushPullLock;
            synchronized (n2) {
                Object[] objectArray = this.pushPullTable.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    boolean bl;
                    Object v;
                    Object object = objectArray[i];
                    if (null == object || !((v = this.pushPullTable.get(object)) instanceof DRSJvmId) || !(bl = ((DRSJvmId)v).matchMembers(linkedList))) continue;
                    this.pushPullTable.remove(object);
                    ++n;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed " + n + "entries from pushPullTable");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "removeDownedEntries");
        }
    }
}

